/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.commodity.busi.SkuPublishOnShelfService;
import com.cgd.commodity.busi.bo.SkuPublishOnShelfReqBO;
import com.cgd.commodity.busi.bo.SkuPublishOnShelfRspBO;
import com.cgd.commodity.busi.vo.SkuHandOffShelfVO;
import com.cgd.commodity.busi.vo.SkuPublishOnShelfVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuOnShelveLog;
import com.cgd.workflow.bo.BpmStartBatchReqBO;
import com.cgd.workflow.bo.BpmStartBatchRspBO;
import com.cgd.workflow.bo.BpmStartBatchVO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.busin.service.BpmStartBatchBusinService;
import com.ohaotian.commodity.busi.distribute.extend.SkuPublishOnShelfExtService;
import com.ohaotian.commodity.busi.distribute.extend.bo.SkuPublishOnShelfExtReqBO;
import com.ohaotian.commodity.busi.distribute.extend.bo.SkuPublishOnShelfExtRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SkuPublishOnShelfServiceImpl
implements SkuPublishOnShelfService {
    private static final Logger logger = LoggerFactory.getLogger(SkuPublishOnShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private BpmStartBatchBusinService bpmStartBatchBusinService;
    @Autowired
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    @Autowired
    private SkuPublishOnShelfExtService skuPublishOnShelfExtService;

    public SkuPublishOnShelfRspBO skuPublishOnShelf(SkuPublishOnShelfReqBO skuPublishOnShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u670d\u52a1\u5165\u53c2\uff1a" + skuPublishOnShelfReqBO.toString());
        }
        if (null == skuPublishOnShelfReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SkuPublishOnShelfRspBO rsp = new SkuPublishOnShelfRspBO();
        try {
            List skus = skuPublishOnShelfReqBO.getSkus();
            LinkedList<BpmStartReqBO> bpmStartReqBOS = new LinkedList<BpmStartReqBO>();
            BpmStartReqBO bpmStartReqBO = null;
            HashMap<String, Object> variables = null;
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            Map<String, Object> resultMap = null;
            Sku sku = null;
            SkuPublishOnShelfExtReqBO skuPublishOnShelfExtReqBO = new SkuPublishOnShelfExtReqBO();
            ArrayList<Long> skuIdList = new ArrayList<Long>();
            for (SkuPublishOnShelfVO value : skuPublishOnShelfReqBO.getSkus()) {
                skuIdList.add(value.getSkuId());
            }
            skuPublishOnShelfExtReqBO.setSupplierId(((SkuPublishOnShelfVO)skuPublishOnShelfReqBO.getSkus().get(0)).getSupplierId());
            skuPublishOnShelfExtReqBO.setSkuIds(skuIdList);
            SkuPublishOnShelfExtRspBO skuPublishOnShelfExtRspBO = this.skuPublishOnShelfExtService.skuPublishOnShelfExt(skuPublishOnShelfExtReqBO);
            if (null != skuPublishOnShelfExtRspBO && !skuPublishOnShelfExtRspBO.getPicExit().booleanValue()) {
                throw new BusinessException(null, "\u5546\u54c1\u56fe\u7247\u5fc5\u586b");
            }
            rsp.setExtJsonString(JSON.toJSONString((Object)((Object)skuPublishOnShelfExtRspBO)));
            HashMap<Long, Sku> skuIdAndSkuMap = new HashMap<Long, Sku>();
            if (skus != null && skus.size() > 0) {
                for (SkuPublishOnShelfVO vo : skus) {
                    sku = this.skuMapper.selectBySkuIdAndSupplier(vo.getSkuId(), vo.getSupplierId());
                    if (sku == null) {
                        throw new BusinessException(null, "\u5546\u54c1[" + vo.getSkuId() + "]\u4e0d\u5b58\u5728");
                    }
                    if (this.skuOnShelveLogMapper.checkSkuApproveOnWay(vo.getSkuId(), vo.getSupplierId()) > 0) {
                        throw new BusinessException(null, "\u5546\u54c1[" + vo.getSkuId() + "]\u72b6\u6001\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c");
                    }
                    if (sku.getSkuStatus() != null && sku.getSkuStatus() != 0 && sku.getSkuStatus() != 3) {
                        throw new BusinessException(null, "\u5546\u54c1[" + vo.getSkuId() + "]\u72b6\u6001\u975e\u8349\u7a3f\u3001\u9a73\u56de\u72b6\u6001");
                    }
                    skuIdAndSkuMap.put(vo.getSkuId(), sku);
                    bpmStartReqBO = new BpmStartReqBO();
                    variables = new HashMap<String, Object>();
                    bpmStartReqBO.setApplyerId(skuPublishOnShelfReqBO.getUserId());
                    bpmStartReqBO.setBusinessTitle("\u8349\u7a3f\u3001\u9a73\u56de\u91cd\u65b0\u53d1\u5e03\u4e0a\u67b6\u5ba1\u6279");
                    bpmStartReqBO.setBusinessType("10");
                    bpmStartReqBO.setBusinessId(String.valueOf(vo.getSkuId()));
                    bpmStartReqBO.setDetailUrl("11");
                    bpmStartReqBO.setStartFlag("1");
                    variables.put("supplierId", vo.getSupplierId());
                    variables.put("userId", skuPublishOnShelfReqBO.getUserId());
                    variables.put("skuId", vo.getSkuId());
                    variables.put("approveType", "10");
                    variables.put("agreementId", skuPublishOnShelfReqBO.getAgreementId());
                    variables.put("agrLocation", sku.getSkuLocation());
                    variables.put("userName", skuPublishOnShelfReqBO.getUserName());
                    resultMap = this.skuMapper.selectById(vo.getSkuId(), vo.getSupplierId());
                    variables.put("agreementSkuId", resultMap.get("AGREEMENT_SKU_ID"));
                    bpmStartReqBO.setVariables(variables);
                    bpmStartReqBOS.add(bpmStartReqBO);
                    resultMap.put("SUPPLIER_ID", vo.getSupplierId());
                    map.put(String.valueOf(vo.getSkuId()), resultMap);
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4fe1\u606f\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bpmStartReqBOS.size() > 0) {
                BpmStartBatchReqBO bpmStartBatchReqBO = new BpmStartBatchReqBO();
                bpmStartBatchReqBO.setBpmStartReqBOS(bpmStartReqBOS);
                bpmStartBatchReqBO.setUserId(skuPublishOnShelfReqBO.getUserId());
                BpmStartBatchRspBO bpmStartBatchRspBO = this.bpmStartBatchBusinService.bpmStartBatch(bpmStartBatchReqBO);
                if (bpmStartBatchRspBO == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:\u65e0\u5e94\u7b54\uff01");
                }
                if (!"0000".equals(bpmStartBatchRspBO.getRespCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:" + bpmStartBatchRspBO.getRespDesc());
                }
                List bpmStartBatchVOs = bpmStartBatchRspBO.getBpmStartBatchVOs();
                if (bpmStartBatchVOs.size() > 0) {
                    ArrayList<SkuOnShelveLog> logs = new ArrayList<SkuOnShelveLog>();
                    SkuOnShelveLog skuOnShelveLog = null;
                    Byte approveType = 0;
                    Byte isDelete = 0;
                    Date createTime = new Date();
                    Map resMap = null;
                    Long agreementId = 0L;
                    Long agreementSkuId = 0L;
                    Long supplierId = 0L;
                    SkuHandOffShelfVO skuHandOffShelfVO = new SkuHandOffShelfVO();
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    for (BpmStartBatchVO resvo : bpmStartBatchVOs) {
                        Long businessId = resvo.getBusinessId();
                        String procinstId = resvo.getProcinstId();
                        skuOnShelveLog = new SkuOnShelveLog();
                        skuOnShelveLog.setProcInstlId(procinstId);
                        skuOnShelveLog.setSkuId(businessId);
                        skuOnShelveLog.setApproveType(approveType);
                        skuOnShelveLog.setIsDelete(isDelete);
                        resMap = (Map)map.get(String.valueOf(businessId));
                        if (resMap != null) {
                            if (null != resMap.get("AGREEMENT_ID")) {
                                agreementId = (Long)resMap.get("AGREEMENT_ID");
                            }
                            if (null != resMap.get("AGREEMENT_SKU_ID")) {
                                agreementSkuId = (Long)resMap.get("AGREEMENT_SKU_ID");
                            }
                            supplierId = (Long)resMap.get("SUPPLIER_ID");
                        }
                        skuOnShelveLog.setAgreementId(agreementId);
                        skuOnShelveLog.setAgreementSkuId(agreementSkuId);
                        skuOnShelveLog.setSkuLocation(Byte.valueOf(((Sku)skuIdAndSkuMap.get(businessId)).getSkuLocation().toString()));
                        skuOnShelveLog.setSupplierId(supplierId);
                        skuOnShelveLog.setCreateLoginId(skuPublishOnShelfReqBO.getUserId());
                        skuOnShelveLog.setCreateLoginName(skuPublishOnShelfReqBO.getUserName());
                        skuOnShelveLog.setCreateTime(createTime);
                        logs.add(skuOnShelveLog);
                        skuIds.add(businessId);
                    }
                    skuHandOffShelfVO.setSupplierId(supplierId);
                    skuHandOffShelfVO.setSkuIds(skuIds);
                    this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_PUSHING, skuPublishOnShelfReqBO.getUserId(), skuHandOffShelfVO);
                    this.skuOnShelveLogMapper.batchSkuOnShelveLog(logs);
                } else if (bpmStartBatchVOs == null || bpmStartBatchVOs != null && bpmStartBatchVOs.size() == 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u672a\u8fd4\u56de\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\uff01");
                }
            }
            rsp.setFailCount(Integer.valueOf(0));
            rsp.setRespDesc("\u53d1\u5e03\u4e0a\u67b6\u6210\u529f");
            rsp.setSuccessCount(Integer.valueOf(skus.size()));
            rsp.setTotalCount(Integer.valueOf(skus.size()));
            return rsp;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u51fa\u9519\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u5931\u8d25");
        }
    }
}

