/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.ohaotian.commodity.busi.SkuAuditService;
import com.ohaotian.commodity.busi.bo.SkuAuditReqBO;
import com.ohaotian.commodity.intfce.bo.SkuAuditBatchReqBO;
import com.ohaotian.commodity.intfce.bo.SkuAuditBatchRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class SkuAuditServiceImpl
implements SkuAuditService {
    private static final Logger log = LoggerFactory.getLogger(SkuAuditServiceImpl.class);
    private DoTaskCompleteBusinService doTaskCompleteBusinService;

    public SkuAuditBatchRspBO skuAuditOperation(SkuAuditReqBO skuAuditReqBO) {
        if (skuAuditReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u53c2\u6570\u3010skuAuditReqBO\u3011\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((CharSequence)skuAuditReqBO.getSeqFlowId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u53c2\u6570\u3010seqFlowId\u3011\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((CharSequence)skuAuditReqBO.getOperateName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u53c2\u3010operateName\u3011\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((CharSequence)skuAuditReqBO.getBusinessType())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u53c2\u3010businessType\u3011\u5fc5\u586b");
        }
        if (skuAuditReqBO.getUserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237\u6ca1\u6709\u767b\u5f55");
        }
        SkuAuditBatchRspBO rspBO = new SkuAuditBatchRspBO();
        List skuList = skuAuditReqBO.getSkus();
        int totalCount = skuList.size();
        int successCount = 0;
        int errorCount = 0;
        log.info("**************************\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u5ba1\u6279\u5f00\u59cb*************");
        log.info("**************************\u5165\u53c2\uff1a*************" + skuAuditReqBO.toString());
        try {
            for (SkuAuditBatchReqBO audit : skuList) {
                if (StringUtils.isNotEmpty((CharSequence)audit.getTaskId()) && audit.getSupplierId() != null) {
                    DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                    doTaskCompleteReqBo.setBusinessType(skuAuditReqBO.getBusinessType());
                    doTaskCompleteReqBo.setSeqFlowId(skuAuditReqBO.getSeqFlowId());
                    doTaskCompleteReqBo.setTaskId(audit.getTaskId());
                    doTaskCompleteReqBo.setOperateName(skuAuditReqBO.getOperateName());
                    doTaskCompleteReqBo.setUserId(skuAuditReqBO.getUserId());
                    HashMap<String, Object> variable = new HashMap<String, Object>();
                    variable.put("userId", skuAuditReqBO.getUserId());
                    variable.put("supplierId", audit.getSupplierId());
                    variable.put("comment", skuAuditReqBO.getComment());
                    variable.put("opinion", skuAuditReqBO.getOpinion());
                    String commentJson = "{\"comment\":\"" + skuAuditReqBO.getComment() + "\",\"opinion\":\"" + skuAuditReqBO.getOpinion() + "\"}";
                    doTaskCompleteReqBo.setComment(commentJson);
                    doTaskCompleteReqBo.setVariable(variable);
                    log.info("----->>>>>>\u5de5\u4f5c\u6d41\u5165\u53c2\uff1a----------->>>>>>>>>>" + doTaskCompleteReqBo.toString());
                    RspBusiBaseBO obj = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                    com.ohaotian.plugin.base.bo.RspBusiBaseBO doTaskComplete = new com.ohaotian.plugin.base.bo.RspBusiBaseBO();
                    BeanUtils.copyProperties((Object)obj, (Object)doTaskComplete);
                    if (doTaskComplete.getRespCode().equals("0000")) {
                        ++successCount;
                        continue;
                    }
                    ++errorCount;
                    continue;
                }
                ++errorCount;
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("\u5931\u8d25");
            log.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u5ba1\u6838\u63a5\u53e3\u670d\u52a1\u5931\u8d25:" + e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u63a5\u53e3\u670d\u52a1\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setTotalCount(Integer.valueOf(totalCount));
        rspBO.setSuccessCount(Integer.valueOf(successCount));
        rspBO.setErrorCount(Integer.valueOf(errorCount));
        return rspBO;
    }

    public void setDoTaskCompleteBusinService(DoTaskCompleteBusinService doTaskCompleteBusinService) {
        this.doTaskCompleteBusinService = doTaskCompleteBusinService;
    }
}

