/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.DelCommodityCatalogService;
import com.cgd.commodity.busi.bo.catalog.BusiDelCommodityCatalogReqBO;
import com.cgd.commodity.busi.bo.catalog.BusiDelCommodityCatalogRspBO;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelCommodityCatalogServiceImpl
implements DelCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private CommodityTypeMapper commodityTypeMapper;

    public BusiDelCommodityCatalogRspBO delCommodityCatalog(BusiDelCommodityCatalogReqBO busiDelCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7c7b\u76ee\u4fe1\u606f\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiDelCommodityCatalogReqBO.toString());
        }
        BusiDelCommodityCatalogRspBO rsp = new BusiDelCommodityCatalogRspBO();
        try {
            List<Long> isUpperCatalogId = this.commodityGuideCatalogMapper.isUpperCatalogId(busiDelCommodityCatalogReqBO.getGuideCatalogIdList());
            if (isUpperCatalogId != null && isUpperCatalogId.size() > 0) {
                rsp.setRespDesc("\u5931\u8d25");
                rsp.setRespCode("8888");
                rsp.setIsSuccess(Boolean.valueOf(false));
                rsp.setResultMsg("\u7c7b\u76ee\u4e2d\u542b\u6709\u5b50\u7c7b\u76ee,\u4e0d\u80fd\u5220\u9664!");
                return rsp;
            }
            List<Long> isHaveCommodityType = this.commodityTypeMapper.isHaveCommodityType(busiDelCommodityCatalogReqBO.getGuideCatalogIdList());
            if (isHaveCommodityType != null && isHaveCommodityType.size() > 0) {
                rsp.setRespDesc("\u5931\u8d25");
                rsp.setRespCode("8888");
                rsp.setIsSuccess(Boolean.valueOf(false));
                rsp.setResultMsg("\u7c7b\u76ee\u4e2d\u542b\u6709\u5546\u54c1\u7c7b\u578b,\u4e0d\u80fd\u5220\u9664!");
                return rsp;
            }
            for (Long guideCatalogId : busiDelCommodityCatalogReqBO.getGuideCatalogIdList()) {
                CommodityGuideCatalog befCatalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(guideCatalogId);
                this.commodityGuideCatalogMapper.updateCataLogViewOrderForDel(befCatalog.getGuideCatalogId(), befCatalog.getCatalogLevel(), befCatalog.getChannelId(), befCatalog.getUpperCatalogId(), befCatalog.getViewOrder());
            }
            this.commodityGuideCatalogMapper.deleteByGuideCatalogIdList(busiDelCommodityCatalogReqBO.getGuideCatalogIdList());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
            rsp.setIsSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u4e2d\u542b\u6709\u5b50\u7c7b\u76ee\u6216\u5546\u54c1\u7c7b\u578b,\u4e0d\u80fd\u5220\u9664!" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7c7b\u76ee\u4e2d\u542b\u6709\u5b50\u7c7b\u76ee\u6216\u5546\u54c1\u7c7b\u578b,\u4e0d\u80fd\u5220\u9664!");
        }
        return rsp;
    }

    public void setCommodityTypeMapper(CommodityTypeMapper commodityTypeMapper) {
        this.commodityTypeMapper = commodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

