/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.commodity.busi.vo.SkuSpecGropVO;
import com.cgd.commodity.busi.vo.SkuSpecRspVO;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.CommodityPropGrpMapper;
import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.CommodityPropGrp;
import com.cgd.commodity.po.EMdmMaterial;
import com.cgd.commodity.po.SkuSpec;
import com.gd.commodity.busi.QrySkuDetailService;
import com.gd.commodity.busi.bo.skupa.QrySkuDetailReqBO;
import com.gd.commodity.busi.bo.skupa.QrySkuDetailRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAddPricePropVO;
import com.gd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaRspVO;
import com.gd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.gd.commodity.dao.AgreementAddPricePropMapper;
import com.gd.commodity.dao.SkuMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.po.SupplierAgreement;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QrySkuDetailServiceImpl
implements QrySkuDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuSpecMapper skuSpecMapper;
    private CommodityPropGrpMapper commodityPropGrpMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;
    private EMdmMaterialMapper eMdmMaterialMapper;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public void setAgrAdjustPriceFormulaMapper(AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper) {
        this.agrAdjustPriceFormulaMapper = agrAdjustPriceFormulaMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuSpecMapper(SkuSpecMapper skuSpecMapper) {
        this.skuSpecMapper = skuSpecMapper;
    }

    public void setCommodityPropGrpMapper(CommodityPropGrpMapper commodityPropGrpMapper) {
        this.commodityPropGrpMapper = commodityPropGrpMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public QrySkuDetailRspBO qrySkuDetail(QrySkuDetailReqBO qrySkuDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuDetailReqBO.toString());
        }
        if (null == qrySkuDetailReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qrySkuDetailReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u7f16\u7801[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("supplierId", qrySkuDetailReqBO.getSupplierId());
            paramMap.put("skuId", qrySkuDetailReqBO.getSkuId());
            QrySkuDetailRspBO qrySkuDetailRspBO = this.skuMapper.selectSkuInfoById(paramMap);
            CommodityMeasure commodityMeasure = this.commodityMeasureMapper.selectByName(qrySkuDetailRspBO.getMeasureName());
            if (null != commodityMeasure) {
                qrySkuDetailRspBO.setMeasureType(commodityMeasure.getMeasureType());
            }
            if (null != qrySkuDetailRspBO) {
                EMdmMaterial eMdmMaterial;
                SupplierAgreement supplierAgreement;
                if (null == qrySkuDetailReqBO.getUserId()) {
                    qrySkuDetailRspBO.setAgreementPrice(null);
                    qrySkuDetailRspBO.setMemberPrice(null);
                    qrySkuDetailRspBO.setSalePrice(null);
                }
                List<SkuSpec> skuSpecs = this.qrySkuSpec(qrySkuDetailReqBO);
                ArrayList<SkuSpecGropVO> skuSpecGrops = new ArrayList<SkuSpecGropVO>();
                if (!skuSpecs.isEmpty()) {
                    List<CommodityPropGrp> commodityPropGrps = this.qryCommodityPropGrpBat(skuSpecs);
                    for (CommodityPropGrp commodityPropGrp : commodityPropGrps) {
                        SkuSpecGropVO skuSpecGropVO = new SkuSpecGropVO();
                        skuSpecGropVO.setCommodityPropGrpId(commodityPropGrp.getCommodityPropGrpId());
                        skuSpecGropVO.setCommodityPropGrpName(commodityPropGrp.getCommodityPropGrpName());
                        ArrayList<SkuSpecRspVO> newSkuSpecs = new ArrayList<SkuSpecRspVO>();
                        for (SkuSpec skuSpec : skuSpecs) {
                            if (!commodityPropGrp.getCommodityPropGrpId().equals(skuSpec.getCommodityPropGrpId())) continue;
                            SkuSpecRspVO skuSpecRspVO = new SkuSpecRspVO();
                            skuSpecRspVO.setCommoditySpecId(skuSpec.getCommoditySpecId());
                            skuSpecRspVO.setPropName(skuSpec.getPropName());
                            skuSpecRspVO.setPropShowName(skuSpec.getPropShowName());
                            skuSpecRspVO.setPropValue(skuSpec.getPropValue());
                            skuSpecRspVO.setPropValueListId(skuSpec.getPropValueListId());
                            skuSpecRspVO.setSkuSpecId(skuSpec.getSkuSpecId());
                            newSkuSpecs.add(skuSpecRspVO);
                        }
                        skuSpecGropVO.setSkuSpecs(newSkuSpecs);
                        skuSpecGrops.add(skuSpecGropVO);
                    }
                }
                qrySkuDetailRspBO.setSkuSpecGrops(skuSpecGrops);
                if (null != qrySkuDetailRspBO.getAgreementId() && null != (supplierAgreement = this.supplierAgreementMapper.selectById(qrySkuDetailRspBO.getAgreementId(), qrySkuDetailRspBO.getSupplierId()))) {
                    qrySkuDetailRspBO.setAgreementStatus(supplierAgreement.getAgreementStatus());
                    qrySkuDetailRspBO.setAdjustPrice(supplierAgreement.getAdjustPrice());
                    qrySkuDetailRspBO.setAdjustPriceFormula(supplierAgreement.getAdjustPriceFormula());
                    qrySkuDetailRspBO.setIsAdjustPriceFormula(supplierAgreement.getIsAdjustPriceFormula());
                    qrySkuDetailRspBO.setIsModifyBuyPrice(supplierAgreement.getIsModifyBuyPrice());
                    qrySkuDetailRspBO.setAgrAdjustPriceFormulaId(supplierAgreement.getAdjustPriceFormulaId());
                    qrySkuDetailRspBO.setAgrAdjustPriceFormulaName(supplierAgreement.getAdjustPriceFormulaName());
                    qrySkuDetailRspBO.setAgrAdjustPriceFormulaValue(supplierAgreement.getAdjustPriceFormulaValue());
                }
                if (null != qrySkuDetailRspBO.getAgreementSkuId()) {
                    SupplierAgreementSku supplierAgreementSku = this.supplierAgreementSkuMapper.selectById(qrySkuDetailRspBO.getAgreementSkuId(), qrySkuDetailRspBO.getSupplierId());
                    if (null != supplierAgreementSku) {
                        qrySkuDetailRspBO.setMarkupRate(supplierAgreementSku.getMarkupRate());
                        if (null != supplierAgreementSku.getSupplyCycle()) {
                            qrySkuDetailRspBO.setSupplyCycle(supplierAgreementSku.getSupplyCycle());
                        }
                    }
                    List<AgrAdjustPriceFormulaRspVO> agrAdjustPriceFormulas = this.agrAdjustPriceFormulaMapper.selectByAgrSkuIdAndSupId(qrySkuDetailRspBO.getAgreementSkuId(), qrySkuDetailRspBO.getSupplierId());
                    qrySkuDetailRspBO.setAgrAdjustPriceFormulas(agrAdjustPriceFormulas);
                }
                if (null != qrySkuDetailRspBO.getMaterialId() && null != (eMdmMaterial = this.eMdmMaterialMapper.selectByMaterialCode(qrySkuDetailRspBO.getMaterialId()))) {
                    qrySkuDetailRspBO.setMaterialName(eMdmMaterial.getMaterialName());
                }
                if (null != qrySkuDetailRspBO.getAgreementSkuId()) {
                    List<AgrAddPricePropVO> agrAddPriceProps = this.agreementAddPricePropMapper.selectDetailById(qrySkuDetailRspBO.getAgreementId(), qrySkuDetailRspBO.getSupplierId());
                    qrySkuDetailRspBO.setAgrAddPriceProps(agrAddPriceProps);
                }
                return qrySkuDetailRspBO;
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u6839\u636esupplier[" + qrySkuDetailReqBO.getSupplierId() + "]\u548cskuId[" + qrySkuDetailReqBO.getSkuId() + "]\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<SkuSpec> qrySkuSpec(QrySkuDetailReqBO qrySkuDetailReqBO) {
        try {
            HashMap<String, Object> skuIdAndSupplierId = new HashMap<String, Object>();
            skuIdAndSupplierId.put("skuId", qrySkuDetailReqBO.getSkuId());
            skuIdAndSupplierId.put("supplierId", qrySkuDetailReqBO.getSupplierId());
            return this.skuSpecMapper.selectSpecBySkuIdAndSupplierId(skuIdAndSupplierId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u89c4\u683c\u51fa\u9519\uff1a" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u67e5\u8be2\u5546\u54c1\u89c4\u683c\u51fa\u9519");
        }
    }

    private List<CommodityPropGrp> qryCommodityPropGrpBat(List<SkuSpec> skuSpecs) {
        try {
            ArrayList<Long> commodityPropGrpIds = new ArrayList<Long>();
            for (SkuSpec skuSpec : skuSpecs) {
                commodityPropGrpIds.add(skuSpec.getCommodityPropGrpId());
            }
            return this.commodityPropGrpMapper.qryCommodityPropGrpByIds(commodityPropGrpIds);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u6839\u636eID\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u5c5e\u6027\u7ec4\u51fa\u9519\uff1a" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636eID\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u5c5e\u6027\u7ec4\u51fa\u9519");
        }
    }
}

