/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.ohaotian.commodity.atom.GenerateCommodityPicSeqService;
import com.ohaotian.commodity.atom.GenerateCommoditySeqService;
import com.ohaotian.commodity.atom.GeneratePASkuSeqService;
import com.ohaotian.commodity.atom.GeneratePropValueListSeqService;
import com.ohaotian.commodity.atom.GenerateSkuPicSeqService;
import com.ohaotian.commodity.atom.GenerateSkuSpecSeqService;
import com.ohaotian.commodity.atom.bo.GenerateCommodityPicSeqRspBO;
import com.ohaotian.commodity.atom.bo.GenerateCommoditySeqRspBO;
import com.ohaotian.commodity.atom.bo.GeneratePASkuSeqRspBO;
import com.ohaotian.commodity.atom.bo.GeneratePropValueListSeqRspBO;
import com.ohaotian.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.ohaotian.commodity.atom.bo.GenerateSkuSpecSeqRspBO;
import com.ohaotian.commodity.busi.CreatePASkuService;
import com.ohaotian.commodity.busi.bo.supply.CreatePASkuReqBO;
import com.ohaotian.commodity.busi.bo.supply.CreatePASkuRspBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.constant.SupplyConstant;
import com.ohaotian.commodity.busi.vo.supply.CreatePASkuPicVO;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.commodity.dao.CommodityMapper;
import com.ohaotian.commodity.dao.CommodityPicMapper;
import com.ohaotian.commodity.dao.CommodityPropDefMapper;
import com.ohaotian.commodity.dao.CommodityPropGrpMapper;
import com.ohaotian.commodity.dao.CommodityTypeMapper;
import com.ohaotian.commodity.dao.EMdmMaterialMapper;
import com.ohaotian.commodity.dao.PropValueListMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.commodity.dao.po.Commodity;
import com.ohaotian.commodity.dao.po.CommodityPic;
import com.ohaotian.commodity.dao.po.CommodityPropDef;
import com.ohaotian.commodity.dao.po.CommodityPropGrp;
import com.ohaotian.commodity.dao.po.CommodityType;
import com.ohaotian.commodity.dao.po.EMdmMaterial;
import com.ohaotian.commodity.dao.po.PropValueList;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuOnShelveLog;
import com.ohaotian.commodity.dao.po.SkuPic;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.commodity.dao.po.SkuSyncExceptionLog;
import com.ohaotian.commodity.dao.po.SupplierAgreement;
import com.ohaotian.commodity.dao.po.SupplierAgreementSku;
import com.ohaotian.commodity.intfce.bo.PropValueListConsumerBO;
import com.ohaotian.commodity.intfce.bo.SkuSyncExceptionLogBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CreatePASkuServiceImpl
implements CreatePASkuService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePASkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private GeneratePASkuSeqService generatePASkuSeqService;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private EMdmMaterialMapper eMdmMaterialMapper;
    private GenerateCommoditySeqService generateCommoditySeqService;
    private GenerateCommodityPicSeqService generateCommodityPicSeqService;
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    private SkuMapper skuMapper;
    private CommodityMapper commodityMapper;
    private CommodityPicMapper commodityPicMapper;
    private SkuPicMapper skuPicMapper;
    private SkuSpecMapper skuSpecMapper;
    private SkuPriceMapper skuPriceMapper;
    private BpmStartBusinService bpmStartBusinService;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private CommodityTypeMapper commodityTypeMapper;
    private CommodityPropGrpMapper commodityPropGrpMapper;
    private CommodityPropDefMapper commodityPropDefMapper;
    private PropValueListMapper propValueListMapper;
    private GeneratePropValueListSeqService generatePropValueListSeqService;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="propValueListInstServiceProducer")
    private ProxyMessageProducer propValueListInstServiceProducer;
    @Resource(name="skuSyncExceptionLogInstProducer")
    private ProxyMessageProducer skuSyncExceptionLogInstProducer;

    public void setGeneratePropValueListSeqService(GeneratePropValueListSeqService generatePropValueListSeqService) {
        this.generatePropValueListSeqService = generatePropValueListSeqService;
    }

    public void setPropValueListMapper(PropValueListMapper propValueListMapper) {
        this.propValueListMapper = propValueListMapper;
    }

    public void setCommodityPropDefMapper(CommodityPropDefMapper commodityPropDefMapper) {
        this.commodityPropDefMapper = commodityPropDefMapper;
    }

    public void setCommodityPropGrpMapper(CommodityPropGrpMapper commodityPropGrpMapper) {
        this.commodityPropGrpMapper = commodityPropGrpMapper;
    }

    public void setCommodityTypeMapper(CommodityTypeMapper commodityTypeMapper) {
        this.commodityTypeMapper = commodityTypeMapper;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setGeneratePASkuSeqService(GeneratePASkuSeqService generatePASkuSeqService) {
        this.generatePASkuSeqService = generatePASkuSeqService;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public void setGenerateCommoditySeqService(GenerateCommoditySeqService generateCommoditySeqService) {
        this.generateCommoditySeqService = generateCommoditySeqService;
    }

    public void setGenerateCommodityPicSeqService(GenerateCommodityPicSeqService generateCommodityPicSeqService) {
        this.generateCommodityPicSeqService = generateCommodityPicSeqService;
    }

    public void setGenerateSkuPicSeqService(GenerateSkuPicSeqService generateSkuPicSeqService) {
        this.generateSkuPicSeqService = generateSkuPicSeqService;
    }

    public void setGenerateSkuSpecSeqService(GenerateSkuSpecSeqService generateSkuSpecSeqService) {
        this.generateSkuSpecSeqService = generateSkuSpecSeqService;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityMapper(CommodityMapper commodityMapper) {
        this.commodityMapper = commodityMapper;
    }

    public void setCommodityPicMapper(CommodityPicMapper commodityPicMapper) {
        this.commodityPicMapper = commodityPicMapper;
    }

    public void setSkuPicMapper(SkuPicMapper skuPicMapper) {
        this.skuPicMapper = skuPicMapper;
    }

    public void setSkuSpecMapper(SkuSpecMapper skuSpecMapper) {
        this.skuSpecMapper = skuSpecMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setBpmStartBusinService(BpmStartBusinService bpmStartBusinService) {
        this.bpmStartBusinService = bpmStartBusinService;
    }

    public CreatePASkuRspBO createPASku(CreatePASkuReqBO createPASkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + createPASkuReqBO.toString());
        }
        CreatePASkuRspBO createPASkuRspBO = new CreatePASkuRspBO();
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(createPASkuReqBO.getAgreementId(), createPASkuReqBO.getSupplierId());
            SupplierAgreementSku supplierAgreementSku = this.supplierAgreementSkuMapper.selectById(createPASkuReqBO.getAgreementSkuId(), createPASkuReqBO.getSupplierId());
            EMdmMaterial eMdmMaterial = this.eMdmMaterialMapper.selectByPrimaryKey(createPASkuReqBO.getMaterialId());
            List<Map<String, Object>> propMap = null;
            CommodityType commodityType = null;
            if (null != eMdmMaterial) {
                propMap = this.eMdmMaterialMapper.qryPropNameAndValue(eMdmMaterial.getSysId(), eMdmMaterial.getCatalogId(), createPASkuReqBO.getMaterialId());
                if (null != eMdmMaterial.getCatalogId()) {
                    commodityType = this.commodityTypeMapper.selectByCatalogId(eMdmMaterial.getCatalogId());
                }
            }
            if (null != supplierAgreement && null != supplierAgreementSku && null != eMdmMaterial) {
                GeneratePASkuSeqRspBO generatePASkuSeqRspBO = this.generatePASkuSeqService.generatePASkuSeq();
                GenerateCommoditySeqRspBO generateCommoditySeqRspBO = this.generateCommoditySeqService.generateCommoditySeq();
                Sku sku = this.initSku(createPASkuReqBO, supplierAgreement, supplierAgreementSku, eMdmMaterial, generateCommoditySeqRspBO, generatePASkuSeqRspBO, commodityType);
                Commodity commodity = this.initCommodity(createPASkuReqBO, supplierAgreement, supplierAgreementSku, generateCommoditySeqRspBO, sku, commodityType);
                this.initSkuPrice(sku, createPASkuReqBO, supplierAgreementSku);
                this.initSkuPic(commodity, generatePASkuSeqRspBO, createPASkuReqBO);
                this.initSkuSpec(propMap, commodity, sku, createPASkuReqBO, supplierAgreementSku, commodityType, eMdmMaterial);
                if (0 == createPASkuReqBO.getOperateType().intValue()) {
                    this.skuOnShelveApprove(createPASkuReqBO, sku.getSkuId(), supplierAgreement);
                }
                createPASkuRspBO.setSkuId(generatePASkuSeqRspBO.getSkuId());
                createPASkuRspBO.setSupplierId(createPASkuReqBO.getSupplierId());
                createPASkuRspBO.setIsSuccess(Boolean.valueOf(true));
                createPASkuRspBO.setResltMsg("\u5546\u54c1\u751f\u6210\u6210\u529f");
            } else {
                String errorMsg = "\u534f\u8bae\u6216\u8005\u4e3b\u6570\u636e\u4e0d\u5b58\u5728";
                this.sendMsgForSkuSyncExceptionLog(createPASkuReqBO, errorMsg);
                createPASkuRspBO.setIsSuccess(Boolean.valueOf(false));
                createPASkuRspBO.setResltMsg(errorMsg);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            createPASkuRspBO.setIsSuccess(Boolean.valueOf(false));
            createPASkuRspBO.setResltMsg(e.getMessage());
            String string = "";
        }
        return createPASkuRspBO;
    }

    private Sku initSku(CreatePASkuReqBO createPASkuReqBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, EMdmMaterial eMdmMaterial, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, GeneratePASkuSeqRspBO generatePASkuSeqRspBO, CommodityType commodityType) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(generatePASkuSeqRspBO.getSkuId());
            sku.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
            sku.setSupplierId(createPASkuReqBO.getSupplierId());
            sku.setSupplierName(supplierAgreement.getSupplierName());
            sku.setVendorId(supplierAgreement.getVendorId());
            sku.setVendorName(supplierAgreement.getVendorName());
            if (!StringUtils.isEmpty((Object)supplierAgreementSku.getMaterialId())) {
                sku.setMaterialId(Long.parseLong(supplierAgreementSku.getMaterialId()));
            } else {
                sku.setMaterialId(eMdmMaterial.getMaterialCode());
            }
            sku.setSkuLongName(eMdmMaterial.getLongDesc());
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setMeasureId(supplierAgreementSku.getMeasureId());
            sku.setMeasureName(supplierAgreementSku.getMeasureName());
            sku.setPreDeliverDay(supplierAgreementSku.getSupplyCycle());
            sku.setMfgSku(eMdmMaterial.getMainModel());
            if (null != commodityType.getCommodityTypeId()) {
                sku.setCommodityTypeId(commodityType.getCommodityTypeId());
            } else {
                sku.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
            }
            sku.setSkuLocation((int)supplierAgreement.getAgrLocation());
            sku.setSkuName(createPASkuReqBO.getSkuName());
            if (!createPASkuReqBO.getSkuPics().isEmpty()) {
                for (CreatePASkuPicVO createPASkuPicVO : createPASkuReqBO.getSkuPics()) {
                    if (null == createPASkuPicVO.getIsPrimary() || 1 != createPASkuPicVO.getIsPrimary()) continue;
                    sku.setSkuMainPicUrl(createPASkuPicVO.getSkuPicUrl());
                    break;
                }
            }
            sku.setSkuDetail(createPASkuReqBO.getSkuDetail());
            String packageParam = this.initPackageParam(createPASkuReqBO);
            sku.setPackParam(packageParam);
            sku.setOnShelveWay(createPASkuReqBO.getOnShelveWay().intValue());
            if (2 == createPASkuReqBO.getOnShelveWay().intValue()) {
                if (null != createPASkuReqBO.getPreOnShelveDay()) {
                    sku.setPreOnShelveDay(createPASkuReqBO.getPreOnShelveDay());
                }
                if (null != createPASkuReqBO.getOnShelveTime()) {
                    sku.setOnShelveTime(createPASkuReqBO.getOnShelveTime());
                }
            }
            if (0 == createPASkuReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_PUSHING);
            }
            if (1 == createPASkuReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_DRAFT);
            }
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setIsSupplierAgreement(Constant.IS_NOT_SUPPLIER_AGREEMENT);
            sku.setCreateLoginId(createPASkuReqBO.getUserId());
            sku.setCreateTime(new Date());
            sku.setIsDelete(Constant.IS_DELETE);
            this.skuMapper.insertSelective(sku);
            return sku;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1sku\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u5931\u8d25");
        }
    }

    private String initPackageParam(CreatePASkuReqBO createPASkuReqBO) {
        JSONObject json = new JSONObject();
        if (!StringUtils.isEmpty((Object)createPASkuReqBO.getPackParamLong())) {
            json.put("packParamLong", (Object)createPASkuReqBO.getPackParamLong());
        } else {
            json.put("packParamLong", null);
        }
        if (!StringUtils.isEmpty((Object)createPASkuReqBO.getPackParamWide())) {
            json.put("packParamWide", (Object)createPASkuReqBO.getPackParamWide());
        } else {
            json.put("packParamWide", null);
        }
        if (!StringUtils.isEmpty((Object)createPASkuReqBO.getPackParamHigh())) {
            json.put("packParamHigh", (Object)createPASkuReqBO.getPackParamHigh());
        } else {
            json.put("packParamHigh", null);
        }
        if (!StringUtils.isEmpty((Object)createPASkuReqBO.getPackParamWeight())) {
            json.put("packParamWeight", (Object)createPASkuReqBO.getPackParamWeight());
        } else {
            json.put("packParamWeight", null);
        }
        if (!StringUtils.isEmpty((Object)createPASkuReqBO.getPackParamList())) {
            json.put("packParamList", (Object)createPASkuReqBO.getPackParamList());
        } else {
            json.put("packParamList", null);
        }
        return json.toJSONString();
    }

    private Commodity initCommodity(CreatePASkuReqBO createPASkuReqBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, Sku sku, CommodityType commodityType) {
        try {
            Commodity newCommodity = new Commodity();
            Commodity commodity = this.commodityMapper.selectByTypeIdAndSupplierId(commodityType.getCommodityTypeId(), supplierAgreement.getSupplierId());
            if (null == commodity) {
                newCommodity.setCommodityCode(String.valueOf(sku.getSkuId()));
                newCommodity.setCommodityLocation(new Long(1L));
                if (null != commodityType.getCommodityTypeId()) {
                    newCommodity.setCommodityTypeId(commodityType.getCommodityTypeId());
                } else {
                    newCommodity.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
                }
                newCommodity.setSupplierId(supplierAgreement.getSupplierId());
                newCommodity.setSupplierName(supplierAgreement.getSupplierName());
                newCommodity.setCreateLoginId(createPASkuReqBO.getUserId());
                newCommodity.setCreateTime(new Date());
                newCommodity.setIsDelete(Constant.IS_DELETE);
                newCommodity.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
                newCommodity.setSupplierShopId(supplierAgreement.getSupplierId());
                this.commodityMapper.insertSelective(newCommodity);
                this.initCommodityPic(newCommodity, createPASkuReqBO);
                return newCommodity;
            }
            return commodity;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SPU\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\uff08SPU\uff09\u5931\u8d25");
        }
    }

    private void initCommodityPic(Commodity commodity, CreatePASkuReqBO createPASkuReqBO) {
        try {
            GenerateCommodityPicSeqRspBO generateCommodityPicSeqRspBO = this.generateCommodityPicSeqService.generateCommodityPicSeq();
            CommodityPic commodityPic = new CommodityPic();
            commodityPic.setCommodityPicId(generateCommodityPicSeqRspBO.getCommodityPicId());
            commodityPic.setCommodityId(commodity.getCommodityId());
            if (!createPASkuReqBO.getSkuPics().isEmpty()) {
                for (CreatePASkuPicVO createPASkuPicVO : createPASkuReqBO.getSkuPics()) {
                    if (1 != createPASkuPicVO.getIsPrimary()) continue;
                    commodityPic.setCommodityPicUrl(createPASkuPicVO.getSkuPicUrl());
                    break;
                }
            }
            commodityPic.setSupplierId(createPASkuReqBO.getSupplierId());
            commodityPic.setCreateLoginId(createPASkuReqBO.getUserId());
            commodityPic.setCreateTime(new Date());
            commodityPic.setIsDelete(Constant.IS_DELETE);
            this.commodityPicMapper.insertSelective(commodityPic);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5546\u54c1SPU\u56fe\u7247\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1SPU\u56fe\u7247\u5931\u8d25");
        }
    }

    private void initSkuPrice(Sku sku, CreatePASkuReqBO createPASkuReqBO, SupplierAgreementSku supplierAgreementSku) {
        try {
            SkuPrice skuPrice = new SkuPrice();
            skuPrice.setSkuId(sku.getSkuId());
            skuPrice.setAgreementId(createPASkuReqBO.getAgreementId());
            skuPrice.setAgreementSkuId(createPASkuReqBO.getAgreementSkuId());
            skuPrice.setAgreementPrice(supplierAgreementSku.getBuyPrice());
            skuPrice.setSalePrice(supplierAgreementSku.getSalePrice());
            skuPrice.setMemberPrice(supplierAgreementSku.getSalePrice());
            if (null != createPASkuReqBO.getMarketPrice()) {
                skuPrice.setMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)createPASkuReqBO.getMarketPrice()));
            }
            skuPrice.setSupplierId(createPASkuReqBO.getSupplierId());
            skuPrice.setCreateLoginId(createPASkuReqBO.getUserId());
            skuPrice.setCreateTime(new Date());
            skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
            skuPrice.setIsDelete(Constant.IS_DELETE);
            this.skuPriceMapper.insert(skuPrice);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25");
        }
    }

    private void initSkuPic(Commodity commodity, GeneratePASkuSeqRspBO generatePASkuSeqRspBO, CreatePASkuReqBO createPASkuReqBO) {
        try {
            if (!createPASkuReqBO.getSkuPics().isEmpty()) {
                ArrayList<SkuPic> skuPics = new ArrayList<SkuPic>();
                for (CreatePASkuPicVO createPASkuPicVO : createPASkuReqBO.getSkuPics()) {
                    GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                    SkuPic skuPic = new SkuPic();
                    skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                    skuPic.setCommodityId(commodity.getCommodityId());
                    skuPic.setSkuId(generatePASkuSeqRspBO.getSkuId());
                    skuPic.setSkuPicUrl(createPASkuPicVO.getSkuPicUrl());
                    skuPic.setSupplierId(createPASkuReqBO.getSupplierId());
                    skuPic.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuPic.setCreateTime(new Date());
                    skuPic.setIsDelete(Constant.IS_DELETE);
                    skuPic.setRemark(createPASkuPicVO.getRemark());
                    if (null != createPASkuPicVO.getPicOrder()) {
                        skuPic.setPicOrder(createPASkuPicVO.getPicOrder().intValue());
                    }
                    if (null != createPASkuPicVO.getIsPrimary()) {
                        skuPic.setIsPrimary(createPASkuPicVO.getIsPrimary().intValue());
                    }
                    skuPics.add(skuPic);
                }
                if (skuPics != null) {
                    this.skuPicMapper.insertSkuPicBatch(skuPics);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316SKU\u56fe\u7247\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u56fe\u7247\u5931\u8d25");
        }
    }

    private void initSkuSpec(List<Map<String, Object>> propMaps, Commodity commodity, Sku sku, CreatePASkuReqBO createPASkuReqBO, SupplierAgreementSku supplierAgreementSku, CommodityType commodityType, EMdmMaterial eMdmMaterial) {
        try {
            List<CommodityPropGrp> commodityPropGrps = null;
            if (null != commodityType) {
                commodityPropGrps = this.commodityPropGrpMapper.qryPowerByTypeId(commodityType.getCommodityTypeId());
            }
            ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
            if (null != propMaps && !propMaps.isEmpty()) {
                for (Map<String, Object> map : propMaps) {
                    String propName = (String)map.get("propName");
                    if (StringUtils.isEmpty((Object)propName)) continue;
                    SkuSpec skuSpec = new SkuSpec();
                    GenerateSkuSpecSeqRspBO generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuReqBO.getSupplierId());
                    CommodityPropDef commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName(propName);
                    if (null == commodityPropDef) continue;
                    skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    skuSpec.setPropName((String)map.get("propName"));
                    skuSpec.setPropShowName((String)map.get("propName"));
                    PropValueList propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), propName, (String)map.get("propValue"));
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    } else {
                        skuSpec.setPropValueListId((Long)map.get("propValueId"));
                    }
                    skuSpec.setPropValue((String)map.get("propValue"));
                    skuSpec.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    skuSpecs.add(skuSpec);
                }
            } else if (null != supplierAgreementSku) {
                PropValueList propValueList;
                CommodityPropDef commodityPropDef;
                GenerateSkuSpecSeqRspBO generateSkuSpecRspBo;
                SkuSpec skuSpec;
                String model = supplierAgreementSku.getModel();
                String figure = supplierAgreementSku.getFigure();
                String spec = supplierAgreementSku.getSpec();
                String texture = supplierAgreementSku.getTexture();
                if (!StringUtils.isEmpty((Object)model)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u578b\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u578b\u53f7");
                    skuSpec.setPropShowName("\u578b\u53f7");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u578b\u53f7", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)figure)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u56fe\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u56fe\u53f7");
                    skuSpec.setPropShowName("\u56fe\u53f7");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u56fe\u53f7", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)spec)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u89c4\u683c"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u89c4\u683c");
                    skuSpec.setPropShowName("\u89c4\u683c");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u89c4\u683c", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)texture)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u6750\u8d28"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u6750\u8d28");
                    skuSpec.setPropShowName("\u6750\u8d28");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u6750\u8d28", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(createPASkuReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
            }
            if (skuSpecs != null && skuSpecs.size() > 0) {
                this.skuSpecMapper.insertSkuSpecBatch(skuSpecs);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25");
        }
    }

    private void sendMsgForSkuSyncExceptionLog(CreatePASkuReqBO createPASkuReqBO, String errorMsg) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setSkuName(createPASkuReqBO.getSkuName());
            skuSyncExceptionLog.setExtSkuId(null);
            skuSyncExceptionLog.setSkuLocation(1);
            skuSyncExceptionLog.setSupplierId(createPASkuReqBO.getSupplierId());
            skuSyncExceptionLog.setCreateLoginId(createPASkuReqBO.getUserId());
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            this.skuSyncExceptionLogInstProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuSyncInsertTopicName(), this.topicConfig.getSkuSyncInsertTagName(), JSONObject.toJSONString((Object)skuSyncExceptionLogBO)));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }

    private void skuOnShelveApprove(CreatePASkuReqBO createPASkuReqBO, Long skuId, SupplierAgreement supplierAgreement) {
        try {
            BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
            bpmStartReqBO.setBusinessTitle("\u521b\u5efa\u5546\u54c1\u5e76\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setBusinessType("10");
            bpmStartReqBO.setBusinessId(String.valueOf(skuId));
            bpmStartReqBO.setDetailUrl("\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setApplyerId(createPASkuReqBO.getUserId());
            bpmStartReqBO.setStartFlag("1");
            bpmStartReqBO.setUserId(createPASkuReqBO.getUserId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("supplierId", createPASkuReqBO.getSupplierId());
            variables.put("userId", createPASkuReqBO.getUserId());
            variables.put("skuId", skuId);
            variables.put("approveType", "10");
            variables.put("agreementId", createPASkuReqBO.getAgreementId());
            variables.put("agrLocation", supplierAgreement.getAgrLocation());
            variables.put("userName", createPASkuReqBO.getUserName());
            variables.put("agreementSkuId", createPASkuReqBO.getAgreementSkuId());
            bpmStartReqBO.setVariables(variables);
            BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
            if (!"0000".equals(bpmStart.getRespCode())) {
                logger.info("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1" + bpmStart.getRespDesc());
                throw new Exception(bpmStart.getRespDesc());
            }
            ArrayList<SkuOnShelveLog> skuOnShelveLogs = new ArrayList<SkuOnShelveLog>();
            SkuOnShelveLog skuOnShelveLog = new SkuOnShelveLog();
            skuOnShelveLog.setProcInstlId(bpmStart.getProcInstId());
            skuOnShelveLog.setSkuId(skuId);
            skuOnShelveLog.setAgreementId(createPASkuReqBO.getAgreementId());
            skuOnShelveLog.setAgreementSkuId(createPASkuReqBO.getAgreementSkuId());
            skuOnShelveLog.setSupplierId(createPASkuReqBO.getSupplierId());
            skuOnShelveLog.setApproveType(SupplyConstant.APPROVE_ON_SHELF_TYPE);
            skuOnShelveLog.setApproveStatus(SupplyConstant.APPROVE_STATUS_START);
            skuOnShelveLog.setApproveResult(SupplyConstant.APPROVE_SUB_TYPE);
            skuOnShelveLog.setCreateLoginId(createPASkuReqBO.getUserId());
            skuOnShelveLog.setCreateLoginName(createPASkuReqBO.getUserName());
            skuOnShelveLog.setCreateTime(new Date());
            skuOnShelveLog.setIsDelete(Constant.IS_DELETE.byteValue());
            skuOnShelveLog.setSkuLocation(supplierAgreement.getAgrLocation());
            skuOnShelveLogs.add(skuOnShelveLog);
            this.skuOnShelveLogMapper.batchSkuOnShelveLog(skuOnShelveLogs);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25" + e);
            throw new BusinessException(null, "\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25");
        }
    }

    private PropValueList initPropValueList(Long commodityPropDefId, String propName, String propValue) {
        try {
            PropValueList propValueList = new PropValueList();
            propValueList.setCommodityPropDefId(commodityPropDefId);
            propValueList.setPropCode(propName);
            propValueList.setPropValue(propValue);
            PropValueList oldPropValueList = this.propValueListMapper.selectByValue(propValueList);
            if (null == oldPropValueList && null != propValue) {
                GeneratePropValueListSeqRspBO generatePropValueListSeqRspBO = this.generatePropValueListSeqService.generatePropValueListSeq();
                oldPropValueList = new PropValueList();
                oldPropValueList.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                PropValueListConsumerBO propValueListConsumerBO = new PropValueListConsumerBO();
                propValueListConsumerBO.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                propValueListConsumerBO.setCommodityPropDefId(commodityPropDefId);
                propValueListConsumerBO.setPropCode(propName);
                propValueListConsumerBO.setPropValue(propValue);
                propValueListConsumerBO.setCreateTime(new Date());
                propValueListConsumerBO.setIsDelete(Byte.valueOf(Constant.IS_DELETE.byteValue()));
                this.propValueListInstServiceProducer.sendOneway(new ProxyMessage(this.topicConfig.getPropValueListTopicName(), this.topicConfig.getPropValueListTagName(), JSONObject.toJSONString((Object)propValueListConsumerBO)));
            }
            return oldPropValueList;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25");
        }
    }
}

