/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.vo.SkuSpecRspVO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.ohaotian.commodity.busi.distribute.web.QrySaleAgrSkusService;
import com.ohaotian.commodity.busi.distribute.web.bo.QrySaleAgrSkusReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.QrySaleAgrSkusRspBO;
import com.ohaotian.commodity.busi.exhibit.web.extend.QueryTelephonesByUidsExtService;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qrySaleAgrSkusService")
public class QrySaleAgrSkusServiceImpl
implements QrySaleAgrSkusService {
    private static final Logger logger = LoggerFactory.getLogger(QrySaleAgrSkusService.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    private QueryTelephonesByUidsExtService queryTelephonesByUidsExtService;
    public static final String PROP_NAME_MODEL = "\u578b\u53f7";
    public static final String PROP_NAME_SPEC = "\u89c4\u683c";

    public RspPageBO<QrySaleAgrSkusRspBO> qrySaleAgrSkus(QrySaleAgrSkusReqBO qrySaleAgrSkusReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5728\u552e\u5546\u54c1\u6e05\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySaleAgrSkusReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        rspPageBO.setRespCode("0000");
        rspPageBO.setRespDesc("\u6210\u529f");
        Long supplierId = null;
        if ("0".equals(qrySaleAgrSkusReqBO.getProtalOrManage())) {
            SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoByUserIdReqBO.setUserId(qrySaleAgrSkusReqBO.getUserId());
            supplierId = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO).getCompId();
        }
        qrySaleAgrSkusReqBO.setSupplierId(supplierId);
        List<SkuSpec> skuSpecList = null;
        if (StringUtils.isNotBlank((CharSequence)qrySaleAgrSkusReqBO.getModel())) {
            SkuSpecRspVO skuSpecParam = new SkuSpecRspVO();
            skuSpecParam.setSupplierId(supplierId);
            skuSpecParam.setPropName(PROP_NAME_MODEL);
            skuSpecParam.setPropValue(qrySaleAgrSkusReqBO.getModel());
            skuSpecList = this.skuSpecMapper.selectByPropAndSupplierId(skuSpecParam);
            if (skuSpecList == null || skuSpecList.isEmpty()) {
                rspPageBO.setPageNo(qrySaleAgrSkusReqBO.getPageNo());
                rspPageBO.setRecordsTotal(0);
                rspPageBO.setRows(new ArrayList());
                rspPageBO.setTotal(0);
                return rspPageBO;
            }
        }
        ArrayList<Long> skuIds = null;
        HashMap<Long, String> skuIdAndModelMap = null;
        if (skuSpecList != null && skuSpecList.size() > 0) {
            skuIds = new ArrayList<Long>();
            skuIdAndModelMap = new HashMap<Long, String>();
            for (SkuSpec skuSpec : skuSpecList) {
                if (skuIds.contains(skuSpec.getSkuId())) continue;
                skuIds.add(skuSpec.getSkuId());
                skuIdAndModelMap.put(skuSpec.getSkuId(), skuSpec.getPropValue());
            }
        }
        qrySaleAgrSkusReqBO.setSkuIdList(skuIds);
        Page page = new Page(qrySaleAgrSkusReqBO.getPageNo(), qrySaleAgrSkusReqBO.getPageSize());
        List<QrySaleAgrSkusRspBO> qrySaleAgrSkusRspBOList = this.skuMapper.selectSaleAgrSku((Page<QrySaleAgrSkusReqBO>)page, qrySaleAgrSkusReqBO);
        if (qrySaleAgrSkusRspBOList != null && qrySaleAgrSkusRspBOList.size() > 0) {
            List<SupplierAgreement> supplierAgreementList;
            HashMap<Long, QrySaleAgrSkusRspBO> skuMap = new HashMap<Long, QrySaleAgrSkusRspBO>();
            ArrayList<Long> skuIdList = new ArrayList<Long>();
            for (QrySaleAgrSkusRspBO qrySaleAgrSkusRspBO : qrySaleAgrSkusRspBOList) {
                if (skuIdAndModelMap != null) {
                    qrySaleAgrSkusRspBO.setModel((String)skuIdAndModelMap.get(qrySaleAgrSkusRspBO.getSkuId()));
                }
                skuIdList.add(qrySaleAgrSkusRspBO.getSkuId());
                skuMap.put(qrySaleAgrSkusRspBO.getSkuId(), qrySaleAgrSkusRspBO);
            }
            List<SkuPrice> skuPriceList = this.skuPriceMapper.selectBySkuIdsAndSupplierId(skuIdList, null);
            ArrayList<Long> agreementIdList = new ArrayList<Long>();
            if (skuPriceList != null && skuPriceList.size() > 0) {
                for (SkuPrice skuPrice : skuPriceList) {
                    QrySaleAgrSkusRspBO qrySaleAgrSkusRspBO = (QrySaleAgrSkusRspBO)skuMap.get(skuPrice.getSkuId());
                    qrySaleAgrSkusRspBO.setAgreementId(skuPrice.getAgreementId());
                    qrySaleAgrSkusRspBO.setAgreementSkuId(skuPrice.getAgreementSkuId());
                    try {
                        qrySaleAgrSkusRspBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getSalePrice()));
                        qrySaleAgrSkusRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getAgreementPrice()));
                    }
                    catch (Exception e) {
                        logger.error("\u91d1\u989d\u8f6c\u6362\u51fa\u9519\uff1a", (Throwable)e);
                    }
                    if (agreementIdList.contains(skuPrice.getAgreementId())) continue;
                    agreementIdList.add(skuPrice.getAgreementId());
                }
            }
            SkuSpecRspVO skuSpecParam = new SkuSpecRspVO();
            ArrayList<String> propNameList = new ArrayList<String>();
            if (skuIdAndModelMap == null) {
                propNameList.add(PROP_NAME_MODEL);
            }
            propNameList.add(PROP_NAME_SPEC);
            skuSpecParam.setPropNameList(propNameList);
            skuSpecParam.setSkuIdList(skuIdList);
            skuSpecList = this.skuSpecMapper.selectByPropAndSupplierId(skuSpecParam);
            if (skuSpecList != null && skuSpecList.size() > 0) {
                for (SkuSpec skuSpec : skuSpecList) {
                    QrySaleAgrSkusRspBO qrySaleAgrSkusRspBO = (QrySaleAgrSkusRspBO)skuMap.get(skuSpec.getSkuId());
                    if (PROP_NAME_MODEL.equals(skuSpec.getPropName())) {
                        qrySaleAgrSkusRspBO.setModel(skuSpec.getPropValue());
                    }
                    if (!PROP_NAME_SPEC.equals(skuSpec.getPropName())) continue;
                    qrySaleAgrSkusRspBO.setSpec(skuSpec.getPropValue());
                }
            }
            if (agreementIdList.size() > 0 && (supplierAgreementList = this.supplierAgreementMapper.selectByIdsAndReqBO(agreementIdList, qrySaleAgrSkusReqBO)) != null && supplierAgreementList.size() > 0) {
                HashMap<Long, SupplierAgreement> supplierAgreementMap = new HashMap<Long, SupplierAgreement>();
                ArrayList<Long> userIds = new ArrayList<Long>(supplierAgreementList.size());
                for (SupplierAgreement supplierAgreement : supplierAgreementList) {
                    supplierAgreementMap.put(supplierAgreement.getAgreementId(), supplierAgreement);
                    userIds.add(supplierAgreement.getProducerId());
                }
                Map telephoneMap = this.queryTelephonesByUidsExtService.queryTelephonesByUid(userIds);
                for (QrySaleAgrSkusRspBO qrySaleAgrSkusRspBO : qrySaleAgrSkusRspBOList) {
                    SupplierAgreement supplierAgreement = (SupplierAgreement)supplierAgreementMap.get(qrySaleAgrSkusRspBO.getAgreementId());
                    if (supplierAgreement == null) continue;
                    if (telephoneMap != null && !telephoneMap.isEmpty()) {
                        qrySaleAgrSkusRspBO.setTelephone((String)telephoneMap.get(supplierAgreement.getProducerId()));
                    }
                    qrySaleAgrSkusRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    qrySaleAgrSkusRspBO.setAgreementName(supplierAgreement.getAgreementName());
                    qrySaleAgrSkusRspBO.setProducerName(supplierAgreement.getProducerName());
                    qrySaleAgrSkusRspBO.setVendorContact(supplierAgreement.getVendorContact());
                    qrySaleAgrSkusRspBO.setVendorPhone(supplierAgreement.getVendorPhone());
                    qrySaleAgrSkusRspBO.setAgreementType(supplierAgreement.getAgreementType());
                    qrySaleAgrSkusRspBO.setUnitAccountName(supplierAgreement.getUnitAccountName());
                    qrySaleAgrSkusRspBO.setUnitAccountId(supplierAgreement.getUnitAccountId());
                    qrySaleAgrSkusRspBO.setVendorDepartmentId(supplierAgreement.getVendorDepartmentId());
                    qrySaleAgrSkusRspBO.setVendorDepartmentName(supplierAgreement.getVendorDepartmentName());
                }
            }
        }
        rspPageBO.setRows(qrySaleAgrSkusRspBOList);
        rspPageBO.setPageNo(page.getPageNo());
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        return rspPageBO;
    }
}

