/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuApproveLogListService;
import com.cgd.commodity.busi.bo.supply.BusiQrySkuApproveLogListReqBO;
import com.cgd.commodity.busi.bo.supply.BusiQrySkuApproveLogListRspBO;
import com.cgd.commodity.dao.SkuChangeInfoMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SkuPicChangeMapper;
import com.cgd.commodity.po.SkuInfoChange;
import com.cgd.commodity.po.SkuPicChange;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.ohaotian.commodity.busi.bo.TaskCountBO;
import com.ohaotian.commodity.dao.SkuChangeApprTaskMapper;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QrySkuApproveLogListServiceImpl
implements QrySkuApproveLogListService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuApproveLogListServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    private SkuChangeInfoMapper skuChangeInfoMapper;
    @Autowired
    private SkuPicChangeMapper skuPicChangeMapper;
    @Autowired
    private SkuChangeApprTaskMapper skuChangeApprTaskMapper;

    public RspPageBO<BusiQrySkuApproveLogListRspBO> qrySkuApproveLogList(BusiQrySkuApproveLogListReqBO busiQrySkuApproveLogListReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b9e\u73b0\u5165\u53c2\uff1a" + busiQrySkuApproveLogListReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Long supplierId = busiQrySkuApproveLogListReqBO.getSupplierId();
            List<Object> list = new ArrayList();
            Page page = new Page(busiQrySkuApproveLogListReqBO.getPageNo(), busiQrySkuApproveLogListReqBO.getPageSize());
            list = this.skuOnShelveLogMapper.selectBySkuApproveLog((Page<Map<String, Object>>)page, busiQrySkuApproveLogListReqBO, supplierId);
            ArrayList<Long> skuIdList = new ArrayList<Long>();
            ArrayList<String> procInstIds = new ArrayList<String>();
            for (BusiQrySkuApproveLogListRspBO busiQrySkuApproveLogListRspBO : list) {
                skuIdList.add(busiQrySkuApproveLogListRspBO.getSkuId());
                procInstIds.add(busiQrySkuApproveLogListRspBO.getProcInstlId());
            }
            List<TaskCountBO> taskCountBOS = this.skuChangeApprTaskMapper.queryTaskCountByProcInstIds(procInstIds);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (TaskCountBO value : taskCountBOS) {
                hashMap.put(value.getProcInstId(), value.getCountNumber());
            }
            List<SkuInfoChange> skuChangeInfoList = this.skuChangeInfoMapper.queryAllChangeInfo(busiQrySkuApproveLogListReqBO.getAgreementId(), skuIdList);
            List<SkuPicChange> skuPicChangeList = this.skuPicChangeMapper.queryBySupplierId(busiQrySkuApproveLogListReqBO.getAgreementId(), skuIdList);
            list = this.replaceSkuChangeInfo(list, skuChangeInfoList, skuPicChangeList, hashMap);
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(list);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
        }
        catch (BusinessException e) {
            logger.error("\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + (Object)((Object)e));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private List<BusiQrySkuApproveLogListRspBO> replaceSkuChangeInfo(List<BusiQrySkuApproveLogListRspBO> list, List<SkuInfoChange> skuChangeInfoList, List<SkuPicChange> skuPicChangeList, Map<String, Integer> taskCountMap) {
        HashMap<Long, SkuInfoChange> map = new HashMap<Long, SkuInfoChange>();
        if (skuChangeInfoList != null && skuChangeInfoList.size() > 0) {
            for (SkuInfoChange skuInfoChange : skuChangeInfoList) {
                map.put(skuInfoChange.getSkuId(), skuInfoChange);
            }
        }
        HashMap<Long, SkuPicChange> picMap = new HashMap<Long, SkuPicChange>();
        if (skuPicChangeList != null && skuPicChangeList.size() > 0) {
            for (SkuPicChange skuPicChange : skuPicChangeList) {
                picMap.put(skuPicChange.getSkuId(), skuPicChange);
            }
        }
        for (BusiQrySkuApproveLogListRspBO busiQrySkuApproveLogListRspBO : list) {
            SkuPicChange skuPicChange = (SkuPicChange)picMap.get(busiQrySkuApproveLogListRspBO.getSkuId());
            SkuInfoChange skuInfoChange = (SkuInfoChange)map.get(busiQrySkuApproveLogListRspBO.getSkuId());
            if (skuInfoChange != null) {
                busiQrySkuApproveLogListRspBO.setSkuName(skuInfoChange.getSkuName());
                busiQrySkuApproveLogListRspBO.setInfoChangeId(skuInfoChange.getChangeId());
            }
            if (null != skuPicChange) {
                busiQrySkuApproveLogListRspBO.setPicChangeId(skuPicChange.getChangeId());
            }
            if (null == taskCountMap || !Integer.valueOf(1).equals(taskCountMap.get(busiQrySkuApproveLogListRspBO.getProcInstlId()))) continue;
            busiQrySkuApproveLogListRspBO.setCreateTime(null);
        }
        return list;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }
}

