/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuByAgrService;
import com.cgd.commodity.busi.bo.QrySkuByAgrReqBO;
import com.cgd.commodity.busi.bo.QrySkuByAgrRspBO;
import com.cgd.commodity.busi.vo.QrySkuAgrAddPriceRspVO;
import com.cgd.commodity.busi.vo.QrySkuAgrRspVO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuByAgrServiceImpl
implements QrySkuByAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuByAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public QrySkuByAgrRspBO qrySkuByAgr(QrySkuByAgrReqBO qrySkuByAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuByAgrReqBO.toString());
        }
        if (null == qrySkuByAgrReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (qrySkuByAgrReqBO.getSkuIds().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SKUID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<QrySkuAgrRspVO> skuAgrs = this.qrySku(qrySkuByAgrReqBO);
            ArrayList<QrySkuAgrRspVO> newSkuAgrs = new ArrayList<QrySkuAgrRspVO>();
            if (!skuAgrs.isEmpty()) {
                List allSkuIds = qrySkuByAgrReqBO.getSkuIds();
                for (QrySkuAgrRspVO qrySkuAgrRspVO : skuAgrs) {
                    if (allSkuIds.contains(qrySkuAgrRspVO.getSkuId())) {
                        allSkuIds.remove(qrySkuAgrRspVO.getSkuId());
                    }
                    qrySkuAgrRspVO = this.qryAgr(qrySkuAgrRspVO);
                    newSkuAgrs.add(qrySkuAgrRspVO);
                }
                QrySkuByAgrRspBO qrySkuByAgrRspBO = new QrySkuByAgrRspBO();
                qrySkuByAgrRspBO.setSupplierId(qrySkuByAgrReqBO.getSupplierId());
                if (!newSkuAgrs.isEmpty()) {
                    qrySkuByAgrRspBO.setSupplierName(((QrySkuAgrRspVO)newSkuAgrs.get(0)).getSupplierName());
                }
                if (null != qrySkuByAgrReqBO.getUserId()) {
                    qrySkuByAgrRspBO.setIsLogin(Boolean.valueOf(true));
                    qrySkuByAgrRspBO.setSkuAgrs(newSkuAgrs);
                } else {
                    qrySkuByAgrRspBO.setIsLogin(Boolean.valueOf(false));
                    ArrayList<QrySkuAgrRspVO> newTSkuAgrs = new ArrayList<QrySkuAgrRspVO>();
                    for (QrySkuAgrRspVO qrySkuAgrRspVO : newSkuAgrs) {
                        qrySkuAgrRspVO.setAgreementPrice(null);
                        qrySkuAgrRspVO.setMemberPrice(null);
                        qrySkuAgrRspVO.setSalePrice(null);
                        newTSkuAgrs.add(qrySkuAgrRspVO);
                        qrySkuByAgrRspBO.setSkuAgrs(newTSkuAgrs);
                    }
                }
                qrySkuByAgrRspBO.setResultMsg(this.noExitSkuId(allSkuIds));
                return qrySkuByAgrRspBO;
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QrySkuAgrRspVO> qrySku(QrySkuByAgrReqBO qrySkuByAgrReqBO) throws Exception {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("supplierId", qrySkuByAgrReqBO.getSupplierId());
            paramMap.put("skuIds", qrySkuByAgrReqBO.getSkuIds());
            return this.skuMapper.selectSkuInfoBySupAgrSkuIds(paramMap);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3001\u4ef7\u683c\u3001\u89c4\u683c\u5931\u8d25\uff1a" + e);
            throw new Exception("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3001\u4ef7\u683c\u3001\u89c4\u683c\u5931\u8d25" + e);
        }
    }

    private String noExitSkuId(List<Long> skuIds) {
        StringBuffer sb = new StringBuffer();
        if (!skuIds.isEmpty()) {
            sb.append("[");
            for (int i = 0; i < skuIds.size(); ++i) {
                if (i == skuIds.size() - 1) {
                    sb.append(skuIds.get(i));
                    continue;
                }
                sb.append(skuIds.get(i)).append(",");
            }
            sb.append("]");
            return "\u5546\u54c1" + sb.toString() + "\u4e0d\u5b58\u5728";
        }
        return null;
    }

    private QrySkuAgrRspVO qryAgr(QrySkuAgrRspVO qrySkuAgrRspVO) throws Exception {
        try {
            QrySkuAgrAddPriceRspVO qrySkuAgrAddPriceRspVO = this.supplierAgreementMapper.qryAgrAndAddPriceById(qrySkuAgrRspVO.getAgreementId(), qrySkuAgrRspVO.getSupplierId());
            if (null != qrySkuAgrAddPriceRspVO) {
                qrySkuAgrRspVO.setAgr(qrySkuAgrAddPriceRspVO.getAgr());
                qrySkuAgrRspVO.setAgreementId(qrySkuAgrAddPriceRspVO.getAgreementId());
                qrySkuAgrRspVO.setAgreementName(qrySkuAgrAddPriceRspVO.getAgreementName());
                qrySkuAgrRspVO.setAgreementSrc(qrySkuAgrAddPriceRspVO.getAgreementSrc());
                qrySkuAgrRspVO.setAgreementStatus(qrySkuAgrAddPriceRspVO.getAgreementStatus());
                qrySkuAgrRspVO.setAgreementType(qrySkuAgrAddPriceRspVO.getAgreementType());
                qrySkuAgrRspVO.setEntAgreementCode(qrySkuAgrAddPriceRspVO.getEntAgreementCode());
                qrySkuAgrRspVO.setIsDispatch(qrySkuAgrAddPriceRspVO.getIsDispatch());
                qrySkuAgrRspVO.setPlaAgreementCode(qrySkuAgrAddPriceRspVO.getPlaAgreementCode());
                qrySkuAgrRspVO.setSkuAgrAddPriceProps(qrySkuAgrAddPriceRspVO.getSkuAgrAddPriceProps());
                qrySkuAgrRspVO.setTaxRate(qrySkuAgrAddPriceRspVO.getTaxRate());
                if (qrySkuAgrAddPriceRspVO.getAgrLocation() != null) {
                    qrySkuAgrRspVO.setSkuLocation(Integer.valueOf(qrySkuAgrAddPriceRspVO.getAgrLocation().intValue()));
                }
            }
            return qrySkuAgrRspVO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25\uff1a" + e);
            throw new Exception("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25" + e);
        }
    }
}

