/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuSaleAreaService;
import com.cgd.commodity.busi.bo.QrySkuSaleAreaReqBO;
import com.cgd.commodity.busi.bo.QrySkuSaleAreaRspBO;
import com.cgd.commodity.busi.vo.AgreementVO;
import com.cgd.commodity.busi.vo.QrySkuSaleAreaRspVO;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuSaleAreaServiceImpl
implements QrySkuSaleAreaService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuSaleAreaServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuPriceMapper skuPriceMapper;
    private AgreementScopeMapper agreementScopeMapper;

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public QrySkuSaleAreaRspBO qrySkuSaleArea(QrySkuSaleAreaReqBO qrySkuSaleAreaReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuSaleAreaReqBO.toString());
        }
        if (null == qrySkuSaleAreaReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != qrySkuSaleAreaReqBO.getSkuIds()) {
            if (qrySkuSaleAreaReqBO.getSkuIds().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1SKUID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1SKUID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List skuIds = qrySkuSaleAreaReqBO.getSkuIds();
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(skuIds, qrySkuSaleAreaReqBO.getSupplierId());
            if (null != skuPrices) {
                QrySkuSaleAreaRspVO qrySkuSaleAreaRspVO;
                ArrayList<QrySkuSaleAreaRspVO> qrySkuSaleAreaRspVOs = new ArrayList<QrySkuSaleAreaRspVO>();
                List<AgreementVO> agreementVOs = this.qryAgreementScope(skuPrices, qrySkuSaleAreaReqBO);
                for (SkuPrice skuPrice : skuPrices) {
                    qrySkuSaleAreaRspVO = new QrySkuSaleAreaRspVO();
                    qrySkuSaleAreaRspVO.setSkuId(skuPrice.getSkuId());
                    ArrayList<AgreementVO> agreements = new ArrayList<AgreementVO>();
                    if (null != agreementVOs) {
                        for (AgreementVO agreementVO : agreementVOs) {
                            if (StringUtils.isEmpty((Object)skuPrice.getAgreementId()) || !agreementVO.getAgreementId().equals(skuPrice.getAgreementId())) continue;
                            agreements.add(agreementVO);
                        }
                    }
                    qrySkuSaleAreaRspVO.setAgreements(agreements);
                    qrySkuSaleAreaRspVOs.add(qrySkuSaleAreaRspVO);
                    skuIds.remove(skuPrice.getSkuId());
                }
                if (!skuIds.isEmpty()) {
                    for (Long skuId : skuIds) {
                        qrySkuSaleAreaRspVO = new QrySkuSaleAreaRspVO();
                        qrySkuSaleAreaRspVO.setSkuId(skuId);
                        qrySkuSaleAreaRspVO.setResultMsg("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728[" + skuId + "]\u5546\u54c1");
                        qrySkuSaleAreaRspVOs.add(qrySkuSaleAreaRspVO);
                    }
                }
                QrySkuSaleAreaRspBO qrySkuSaleAreaRspBO = new QrySkuSaleAreaRspBO();
                qrySkuSaleAreaRspBO.setSkuSaleAreas(qrySkuSaleAreaRspVOs);
                return qrySkuSaleAreaRspBO;
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u67e5\u8be2\u5546\u54c1\u534f\u8bae\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<AgreementVO> qryAgreementScope(List<SkuPrice> skuPrices, QrySkuSaleAreaReqBO qrySkuSaleAreaReqBO) {
        try {
            ArrayList<Long> agreementIds = new ArrayList<Long>();
            for (SkuPrice skuPrice : skuPrices) {
                agreementIds.add(skuPrice.getAgreementId());
            }
            HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
            paramMap.put("supplierId", qrySkuSaleAreaReqBO.getSupplierId());
            paramMap.put("agreementIds", agreementIds);
            return this.agreementScopeMapper.selectByIds(paramMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9500\u552e\u8303\u56f4\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u534f\u8bae\u53ca\u8303\u56f4\u51fa\u9519\uff1a" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u67e5\u8be2\u534f\u8bae\u53ca\u8303\u56f4\u51fa\u9519");
        }
    }
}

