/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.gd.commodity.busi.UpdateMarkupRateBySelectService;
import com.gd.commodity.busi.bo.agreement.UpdateMarkupRateBySelectReqBO;
import com.gd.commodity.busi.bo.agreement.UpdateMarkupRateBySelectRspBO;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMarkupRateBySelectServiceImpl
implements UpdateMarkupRateBySelectService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateMarkupRateBySelectServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public UpdateMarkupRateBySelectRspBO updateMarkupRateBySelect(UpdateMarkupRateBySelectReqBO updateMarkupRateBySelectReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\u9009\u4e2d\u660e\u7ec6\u8bbe\u7f6e\uff09\u5165\u53c2\uff1a" + updateMarkupRateBySelectReqBO.toString());
        }
        if (null == updateMarkupRateBySelectReqBO.getAgreementSkuIds() || updateMarkupRateBySelectReqBO.getAgreementSkuIds().size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6279\u91cf\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\u8bf7\u9009\u4e2d\u4e00\u6761\u534f\u8bae\u660e\u7ec6");
        }
        UpdateMarkupRateBySelectRspBO updateMarkupRateBySelectRspBO = new UpdateMarkupRateBySelectRspBO();
        try {
            Double markupRate = updateMarkupRateBySelectReqBO.getMarkupRate();
            Long supplierId = updateMarkupRateBySelectReqBO.getSupplierId();
            ArrayList<SupplierAgreementSku> supplierAgreementSkuList = new ArrayList<SupplierAgreementSku>();
            DecimalFormat df = new DecimalFormat("#.0000");
            for (Long supplierAgreementSkuId : updateMarkupRateBySelectReqBO.getAgreementSkuIds()) {
                SupplierAgreementSku supplierAgreementSku = this.supplierAgreementSkuMapper.selectByPrimaryKey(supplierAgreementSkuId, supplierId);
                supplierAgreementSku.setMarkupRate(markupRate);
                supplierAgreementSku.setSupplierId(supplierId);
                supplierAgreementSku.setSalePrice(Math.round((double)supplierAgreementSku.getBuyPrice().longValue() * (1.0 + Double.valueOf(df.format(markupRate / 100.0)))));
                supplierAgreementSku.setSalePriceSum(Math.round((double)supplierAgreementSku.getBuyPriceSum().longValue() * (1.0 + Double.valueOf(df.format(markupRate / 100.0)))));
                supplierAgreementSkuList.add(supplierAgreementSku);
            }
            if (supplierAgreementSkuList.size() > 0) {
                this.supplierAgreementSkuMapper.updateBySupplierAgreementSkuList(supplierAgreementSkuList);
            }
            updateMarkupRateBySelectRspBO.setIsSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            updateMarkupRateBySelectRspBO.setIsSuccess(Boolean.valueOf(false));
            logger.error("UpdateMarkupRateBySelectServiceImpl========>\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\u9009\u4e2d\u660e\u7ec6\u8bbe\u7f6e\uff09\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\u9009\u4e2d\u660e\u7ec6\u8bbe\u7f6e\uff09\u4e1a\u52a1\u670d\u52a1\u5b9e\u73b0\u51fa\u9519");
        }
        return updateMarkupRateBySelectRspBO;
    }
}

