/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.controller;

import com.cgd.commodity.busi.QrySupplySkuByAgrSkuIdService;
import com.cgd.commodity.busi.QryWaitAgrSkuService;
import com.cgd.commodity.busi.bo.supply.QrySupplySkuByAgrSkuIdReqBO;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuReqBO;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuRspBO;
import com.gd.commodity.busi.QryAgrInfoByAgrIdService;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoByAgrIdReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoByAgrIdRspBO;
import com.ohaotian.commodity.busi.distribute.web.CreatePASkuFromExcelService;
import com.ohaotian.commodity.busi.distribute.web.ExportPubSkusService;
import com.ohaotian.commodity.busi.distribute.web.QryLongDescBatchService;
import com.ohaotian.commodity.busi.distribute.web.bo.AgrDetailBO;
import com.ohaotian.commodity.busi.distribute.web.bo.CreatePASkuFromExcelReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.CreatePASkuFromExcelRspBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusRspBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusRspVO;
import com.ohaotian.commodity.busi.distribute.web.bo.FailMaterialBO;
import com.ohaotian.commodity.busi.distribute.web.bo.QryLongDescBatchBO;
import com.ohaotian.commodity.busi.distribute.web.bo.QryLongDescBatchReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.QryLongDescBatchRspBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"exportOrImport"})
public class DistributeController {
    private static final Logger logger = LogManager.getLogger(DistributeController.class);
    @Resource
    private QryWaitAgrSkuService qryWaitAgrSkuService;
    @Resource
    private QrySupplySkuByAgrSkuIdService qrySupplySkuByAgrSkuIdService;
    @Resource
    private QryAgrInfoByAgrIdService qryAgrInfoByAgrIdService;
    @Resource
    private CreatePASkuFromExcelService createPASkuFromExcelService;
    @Resource
    private ExportPubSkusService exportPubSkusService;
    @Resource
    private QryLongDescBatchService qryLongDescBatchService;

    @RequestMapping(value={"/exportWaitAgrDetails"}, method={RequestMethod.GET})
    public void exportWaitAgrDetails(HttpServletRequest request, HttpServletResponse response) {
        String sheetName = "\u5f85\u53d1\u5e03\u534f\u8bae\u660e\u7ec6\u5217\u8868";
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            String agreementIdStr = request.getParameter("agreementId");
            String supplierIdStr = request.getParameter("supplierId");
            if (agreementIdStr == null || agreementIdStr.length() == 0) {
                this.respMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u534f\u8bae\u53f7(agreementId)");
                return;
            }
            if (supplierIdStr == null || supplierIdStr.length() == 0) {
                this.respMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u94fa\u8d27\u5546(supplierId)");
                return;
            }
            Long agreementId = Long.parseLong(agreementIdStr);
            Long supplierId = Long.parseLong(supplierIdStr);
            ArrayList<String> waitAgrSkusHeads = new ArrayList<String>(Arrays.asList("\u7f16\u53f7", "\u5355\u4f4d\u540d\u79f0", "\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7", "\u7269\u6599\u7f16\u7801", "\u7269\u6599\u540d\u79f0", "\u578b\u53f7", "\u89c4\u683c", "\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7", "\u6750\u8d28", "\u54c1\u724c", "\u751f\u4ea7\u5382\u5bb6", "\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u4ecb\u7ecd-\u5382\u5bb6", "\u5546\u54c1\u4ecb\u7ecd-\u5546\u54c1\u63cf\u8ff0", "\u957f", "\u5bbd", "\u9ad8", "\u91cd\u91cf", "\u5305\u88c5\u6e05\u5355", "\u662f\u5426\u5c55\u793a\u5305\u88c5\u5355\u4f4d", "\u5305\u88c5\u89c4\u683c", "\u5305\u88c5\u5355\u4f4d", "\u5355\u4f4d\u6362\u7b97\u503c", "\u7ed3\u7b97\u5355\u4f4d(\u53ea\u8bfb)"));
            HSSFFont font = workbook.createFont();
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            font.setFontHeightInPoints((short)11);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
            HSSFSheet sheet = workbook.createSheet(sheetName);
            HSSFRow row = this.addRowTitle(sheet, waitAgrSkusHeads, workbook);
            QryWaitAgrSkuReqBO qryWaitAgrSkuReqBO = new QryWaitAgrSkuReqBO();
            qryWaitAgrSkuReqBO.setAgreementId(agreementId);
            qryWaitAgrSkuReqBO.setSupplierId(supplierId);
            qryWaitAgrSkuReqBO.setPageNo(Integer.valueOf(1));
            qryWaitAgrSkuReqBO.setPageSize(Integer.valueOf(5000));
            RspPageBO resultPage = this.qryWaitAgrSkuService.qryWaitAgrSku(qryWaitAgrSkuReqBO);
            List result = resultPage.getRows();
            QryAgrInfoByAgrIdReqBO qryAgrInfoByAgrIdReqBO = new QryAgrInfoByAgrIdReqBO();
            qryAgrInfoByAgrIdReqBO.setAgreementId(agreementId);
            qryAgrInfoByAgrIdReqBO.setSupplierId(supplierId);
            QryAgrInfoByAgrIdRspBO qryAgrInfoByAgrIdRspBO = this.qryAgrInfoByAgrIdService.qryAgrInfoByAgrId(qryAgrInfoByAgrIdReqBO);
            QryLongDescBatchReqBO qryLongDescBatchReqBO = new QryLongDescBatchReqBO();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            for (QryWaitAgrSkuRspBO qryWaitAgrSkuRspBO : result) {
                if (materialIds.contains(Long.valueOf(qryWaitAgrSkuRspBO.getMaterialId()))) continue;
                materialIds.add(Long.valueOf(qryWaitAgrSkuRspBO.getMaterialId()));
            }
            qryLongDescBatchReqBO.setMaterialIds(materialIds);
            QryLongDescBatchRspBO qryLongDescBatchRspBO = this.qryLongDescBatchService.qryLongDescBatch(qryLongDescBatchReqBO);
            HashMap<Long, String> materialIdMap = new HashMap<Long, String>();
            for (QryLongDescBatchBO qryLongDescBatchBO : qryLongDescBatchRspBO.getQryLongDescBatchBOS()) {
                materialIdMap.put(qryLongDescBatchBO.getMaterialCode(), qryLongDescBatchBO.getLongDesc());
            }
            for (int i = 0; i < result.size(); ++i) {
                QrySupplySkuByAgrSkuIdReqBO qrySupplySkuByAgrSkuIdReqBO = new QrySupplySkuByAgrSkuIdReqBO();
                String skuName = "\u3010" + ((QryWaitAgrSkuRspBO)result.get(i)).getBrandName() + "\u3011" + (String)materialIdMap.get(Long.valueOf(((QryWaitAgrSkuRspBO)result.get(i)).getMaterialId()));
                row = sheet.createRow(i + 10);
                for (int j = 0; j < waitAgrSkusHeads.size(); ++j) {
                    HSSFCell cell = row.createCell(j);
                    if (j == 0) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getAgreementSkuId().toString());
                    }
                    if (j == 1) {
                        cell.setCellValue(qryAgrInfoByAgrIdRspBO.getSupplierName());
                    }
                    if (j == 2) {
                        cell.setCellValue(qryAgrInfoByAgrIdRspBO.getEntAgreementCode());
                    }
                    if (j == 3) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getMaterialId());
                    }
                    if (j == 4) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getMaterialName());
                    }
                    if (j == 5) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getModel());
                    }
                    if (j == 6) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getSpec());
                    }
                    if (j == 7) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getFigure());
                    }
                    if (j == 8) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getTexture());
                    }
                    if (j == 9) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getBrandName());
                    }
                    if (j == 10) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getManufacturer());
                    }
                    if (j == 11) {
                        cell.setCellValue(skuName);
                    }
                    if (j == 23) {
                        cell.setCellValue(((QryWaitAgrSkuRspBO)result.get(i)).getMeasureName());
                    }
                    cell.setCellStyle(style);
                }
            }
            try {
                String fileNameStr = "\u3010" + qryAgrInfoByAgrIdRspBO.getEntAgreementCode() + "\u3011" + qryAgrInfoByAgrIdRspBO.getAgreementName() + "\u534f\u8bae\u5546\u54c1\u6536\u96c6\u6a21\u677f";
                String fileName = new String(fileNameStr.getBytes("gb2312"), "ISO8859-1");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                response.setContentType("application/x-download;charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
                ServletOutputStream os = response.getOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                byte[] b = new byte[1024];
                while (bais.read(b) > 0) {
                    os.write(b);
                }
                bais.close();
                os.flush();
                os.close();
                workbook.close();
                logger.info("\u6210\u529f\u5bfc\u51faExcel");
            }
            catch (IOException e) {
                logger.error("\u751f\u6210Excel IO\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u5931\u8d25", (Throwable)e);
        }
    }

    @RequestMapping(value={"/importSkuInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CreatePASkuFromExcelRspBO importSkuInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="hwFile") MultipartFile file) {
        CreatePASkuFromExcelRspBO rspInfo = new CreatePASkuFromExcelRspBO();
        String agreementIdStr = request.getParameter("agreementId");
        String supplierIdStr = request.getParameter("supplierId");
        if (agreementIdStr == null || agreementIdStr.length() == 0) {
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u534f\u8baeId(agreementId)");
            return rspInfo;
        }
        if (supplierIdStr == null || supplierIdStr.length() == 0) {
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9asupplierId(supplierId)");
            return rspInfo;
        }
        String filename = "";
        String fileType = "";
        if (file != null) {
            filename = file.getOriginalFilename();
        }
        if (file == null) {
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
            return rspInfo;
        }
        int xlsIdx = filename.toLowerCase().lastIndexOf(".xls");
        int xlsxIdx = filename.toLowerCase().lastIndexOf(".xlsx");
        if (xlsIdx > 0 && filename.length() - xlsIdx == 4) {
            fileType = "xls";
        } else if (xlsxIdx > 0 && filename.length() - xlsIdx == 5) {
            fileType = "xlsx";
        } else {
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("Excel\u6587\u4ef6\u540d" + filename + "\u4e0d\u5408\u6cd5\uff0c\u6269\u5c55\u540d\u5fc5\u987b\u4e3axls\u6216\u8005xlsx");
            return rspInfo;
        }
        Long agreementId = Long.parseLong(agreementIdStr);
        Long supplierId = Long.parseLong(supplierIdStr);
        InputStream is = null;
        try {
            is = file.getInputStream();
        }
        catch (IOException e) {
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
            return rspInfo;
        }
        return this.skuInfoInit(is, fileType, filename, agreementId, supplierId, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CreatePASkuFromExcelRspBO skuInfoInit(InputStream is, String fileType, String fileName, Long agreementId, Long supplierId, HttpServletRequest request, HttpServletResponse response) {
        CreatePASkuFromExcelRspBO rspInfo = new CreatePASkuFromExcelRspBO();
        Boolean failFlag = false;
        HSSFWorkbook workbook = null;
        try {
            if (fileType.equals("xls")) {
                workbook = new HSSFWorkbook(is);
            } else if (fileType.equals("xlsx")) {
                workbook = new XSSFWorkbook(is);
            }
            if (workbook.getNumberOfSheets() != 1) {
                rspInfo.setRespCode("8888");
                rspInfo.setRespDesc("\u6570\u636eExcel\u6587\u4ef6" + fileName + "\u672a\u5305\u542b\u9884\u671f\u76841\u4e2asheet\u9875");
                CreatePASkuFromExcelRspBO createPASkuFromExcelRspBO = rspInfo;
                return createPASkuFromExcelRspBO;
            }
            CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO = new CreatePASkuFromExcelReqBO();
            createPASkuFromExcelReqBO.setAgreementId(agreementId);
            createPASkuFromExcelReqBO.setSupplierId(supplierId);
            ArrayList<AgrDetailBO> agrDetails = new ArrayList<AgrDetailBO>();
            ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
            ArrayList<FailMaterialBO> failMaterialBOS = new ArrayList<FailMaterialBO>();
            Sheet sheet = workbook.getSheetAt(0);
            Integer maxRowNum = 1010;
            if (sheet.getLastRowNum() < maxRowNum) {
                maxRowNum = sheet.getLastRowNum() + 1;
            }
            for (int rowNum = 10; rowNum < maxRowNum; ++rowNum) {
                FailMaterialBO failMaterialBO;
                FailMaterialBO failMaterialBO2;
                Row row = sheet.getRow(rowNum);
                String skuDetail = "";
                if (null == row) continue;
                AgrDetailBO agrDetailBO = new AgrDetailBO();
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(0)))) {
                    agrDetailBO.setAgreementSkuId(Long.valueOf(Long.parseLong(this.getValue(row.getCell(0)))));
                    agreementSkuIds.add(Long.parseLong(this.getValue(row.getCell(0))));
                } else {
                    failMaterialBO2 = new FailMaterialBO();
                    failMaterialBO2.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u534f\u8bae\u660e\u7ec6ID\u4e3a\u7a7a");
                    failMaterialBOS.add(failMaterialBO2);
                    failFlag = true;
                }
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(3)))) {
                    agrDetailBO.setMaterialId(Long.valueOf(Long.parseLong(this.getValue(row.getCell(3)))));
                } else {
                    failMaterialBO2 = new FailMaterialBO();
                    failMaterialBO2.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    failMaterialBOS.add(failMaterialBO2);
                    failFlag = true;
                }
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(11)))) {
                    agrDetailBO.setSkuName(this.getValue(row.getCell(11)));
                } else {
                    failMaterialBO2 = new FailMaterialBO();
                    failMaterialBO2.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
                    failMaterialBOS.add(failMaterialBO2);
                    failFlag = true;
                }
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(12)))) {
                    skuDetail = this.getValue(row.getCell(12));
                } else {
                    failMaterialBO2 = new FailMaterialBO();
                    failMaterialBO2.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5546\u54c1\u4ecb\u7ecd-\u5382\u5bb6\u4e3a\u7a7a");
                    failMaterialBOS.add(failMaterialBO2);
                    failFlag = true;
                }
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(13)))) {
                    skuDetail = "<p>" + skuDetail + "<br/><br/>" + this.getValue(row.getCell(13)) + "</p>";
                } else {
                    failMaterialBO2 = new FailMaterialBO();
                    failMaterialBO2.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5546\u54c1\u4ecb\u7ecd-\u5546\u54c1\u63cf\u8ff0\u4e3a\u7a7a");
                    failMaterialBOS.add(failMaterialBO2);
                    failFlag = true;
                }
                String reg = "^[0-9]+(.[0-9]{1,6})?$";
                if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(19)))) {
                    if (this.getValue(row.getCell(19)).equals("\u662f")) {
                        failMaterialBO = new FailMaterialBO();
                        agrDetailBO.setIsShowSpec(Integer.valueOf(1));
                        if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(20)))) {
                            agrDetailBO.setWarenum(this.getValue(row.getCell(20)));
                        } else {
                            failMaterialBO.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5305\u88c5\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                            failMaterialBOS.add(failMaterialBO);
                            failFlag = true;
                        }
                        if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(21)))) {
                            agrDetailBO.setWarenum(this.getValue(row.getCell(21)));
                        } else {
                            failMaterialBO.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5305\u88c5\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                            failMaterialBOS.add(failMaterialBO);
                            failFlag = true;
                        }
                        if (!StringUtils.isEmpty((Object)this.getValue(row.getCell(22))) && this.getValue(row.getCell(22)).matches(reg)) {
                            agrDetailBO.setSettlerate(this.getValue(row.getCell(22)));
                        } else {
                            failMaterialBO.setFailDesc("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (rowNum + 1) + "\u884c\u5546\u54c1\u7684\u5355\u4f4d\u6362\u7b97\u503c\u8d85\u51fa6\u4f4d\u5c0f\u6570\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u540e\u5bfc\u5165\u3002");
                            failMaterialBOS.add(failMaterialBO);
                            failFlag = true;
                        }
                    }
                } else {
                    failMaterialBO = new FailMaterialBO();
                    failMaterialBO.setFailDesc("\u7b2c" + (rowNum + 1) + "\u884c\u662f\u5426\u5c55\u793a\u5305\u88c5\u5355\u4f4d\u4e3a\u7a7a,\u8bf7\u586b\u662f\u6216\u5426\uff0c\u4e3a\u5426\u662f\u540e\u9762\u6570\u636e\u4e0d\u505a\u5904\u7406");
                    failMaterialBOS.add(failMaterialBO);
                    failFlag = true;
                }
                if (failFlag.booleanValue()) continue;
                agrDetailBO.setSkuDetail(skuDetail);
                agrDetailBO.setPackParamLong(this.getValue(row.getCell(14)));
                agrDetailBO.setPackParamWide(this.getValue(row.getCell(15)));
                agrDetailBO.setPackParamHigh(this.getValue(row.getCell(16)));
                agrDetailBO.setPackParamWeight(this.getValue(row.getCell(17)));
                agrDetailBO.setPackParamList(this.getValue(row.getCell(18)));
                agrDetails.add(agrDetailBO);
            }
            if (failFlag.booleanValue()) {
                rspInfo.setFailMaterials(failMaterialBOS);
                rspInfo.setTotalCount(sheet.getLastRowNum() - 10);
                rspInfo.setRespCode("8888");
                rspInfo.setRespDesc("\u5931\u8d25");
                CreatePASkuFromExcelRspBO createPASkuFromExcelRspBO = rspInfo;
                return createPASkuFromExcelRspBO;
            }
            createPASkuFromExcelReqBO.setAgreementSkuIds(agreementSkuIds);
            createPASkuFromExcelReqBO.setAgrDetails(agrDetails);
            CreatePASkuFromExcelRspBO createPASkuFromExcelRspBO = this.createPASkuFromExcelService.createPASkuFromExcel(createPASkuFromExcelReqBO);
            return createPASkuFromExcelRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u6279\u91cf\u5bfc\u5165\uff1a" + e);
            rspInfo.setRespCode("8888");
            rspInfo.setRespDesc("\u5bfc\u5165\u5931\u8d25");
            CreatePASkuFromExcelRspBO createPASkuFromExcelRspBO = rspInfo;
            return createPASkuFromExcelRspBO;
        }
        finally {
            try {
                is.close();
                workbook.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getValue(Cell cell) {
        DecimalFormat df = new DecimalFormat("0");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String val = null;
        if (null != cell) {
            switch (cell.getCellType()) {
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        val = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    val = df.format(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    val = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    val = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    val = cell.getStringCellValue();
                    break;
                }
                case 5: {
                    val = "\u9519\u8bef";
                    break;
                }
                case 2: {
                    try {
                        val = String.valueOf(cell.getStringCellValue());
                    }
                    catch (IllegalStateException e) {
                        val = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                default: {
                    val = cell.getRichStringCellValue() == null ? null : cell.getRichStringCellValue().toString();
                }
            }
        }
        return val;
    }

    private void respMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getColor(HSSFWorkbook workbook) {
        String color = "C0C0C0";
        int r = Integer.parseInt(color.substring(0, 2), 16);
        int g = Integer.parseInt(color.substring(2, 4), 16);
        int b = Integer.parseInt(color.substring(4, 6), 16);
        HSSFPalette palette = workbook.getCustomPalette();
        palette.setColorAtIndex((short)9, (byte)r, (byte)g, (byte)b);
        return 9;
    }

    private HSSFRow addRowTitle(HSSFSheet sheet, List<String> agrSkusHeads, HSSFWorkbook workbook) throws Exception {
        try {
            HSSFCell cell;
            for (int i = 0; i < 9; ++i) {
                HSSFRow row = sheet.createRow(i);
                cell = row.createCell(0);
                HSSFCellStyle style = workbook.createCellStyle();
                HSSFFont font = workbook.createFont();
                font.setFontHeightInPoints((short)11);
                font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                style.setFont((Font)font);
                style.setVerticalAlignment((short)1);
                if (i == 0) {
                    cell.setCellValue("\u6a21\u677f\u4f7f\u7528\u6ce8\u610f\u4e8b\u9879:");
                }
                if (i == 1) {
                    cell.setCellValue("1)\u6570\u636e\u5f55\u5165\u6ce8\u610f\u4e8b\u9879:");
                }
                if (i == 2) {
                    cell.setCellValue("\u7ea2\u8272\u5b57\u4f53\u8868\u5934\u4e3a\u5fc5\u586b\u9879\uff1b");
                }
                if (i == 3) {
                    cell.setCellValue("\u6700\u591a\u652f\u63011000\u6761\u660e\u7ec6\u534f\u8bae\u5f55\u5165\uff1b");
                }
                if (i == 4) {
                    cell.setCellValue("2) \u64cd\u4f5c\u6ce8\u610f\u4e8b\u9879:\u5982\u91c7\u7528\u590d\u5236\u7c98\u8d34\u7684\u65b9\u5f0f\u7f16\u8f91\u6a21\u677f\u6dfb\u52a0\u6570\u636e\uff0c\u8bf7\u91c7\u7528\u201c\u590d\u5236--\u9f20\u6807\u53f3\u952e--\u9009\u62e9\u6027\u7c98\u8d34--\u6570\u503c\u6216unicode\u6587\u672c\u201d,\u5982\u6b64\u64cd\u4f5c\uff0c\u5bfc\u5165\u65f6\u51fa\u73b0\u683c\u5f0f\u9519\u8bef\u7684\u884c\u5c06\u51cf\u5c11\u3002");
                }
                if (i == 5) {
                    cell.setCellValue("3) \u8868\u5934\u4e2d\u7070\u8272\u90e8\u5206\uff0c\u4e0d\u53ef\u4fee\u6539\u3002");
                }
                if (i == 6) {
                    cell.setCellValue("4) \u5bfc\u5165\u65f6\uff0c\u201c\u5546\u54c1\u4ecb\u7ecd-\u5382\u5bb6\u201d\u3001\u201c\u5546\u54c1\u4ecb\u7ecd-\u5546\u54c1\u63cf\u8ff0\u201d\u4e3a\u5fc5\u586b\u3002");
                }
                if (i == 7) {
                    cell.setCellValue("5) \u5546\u54c1\u4ecb\u7ecd-\u5382\u5bb6\u6700\u591a\u652f\u6301\u4e24\u767e\u4e2a\u6c49\u5b57\u3002");
                }
                if (i == 8) {
                    cell.setCellValue("6) \u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u4f7f\u7528\u6ce8\u610f\u4e8b\u9879\u5185\u5bb9,\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\u3002");
                }
                if (i == 2 || i == 3 || i == 8) {
                    font.setColor((short)10);
                } else {
                    font.setColor((short)Short.MAX_VALUE);
                }
                cell.setCellStyle((CellStyle)style);
            }
            HSSFRow row = sheet.createRow(9);
            for (int i = 0; i < agrSkusHeads.size(); ++i) {
                cell = row.createCell(i);
                cell.setCellValue(agrSkusHeads.get(i));
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                HSSFFont cellFont = workbook.createFont();
                cellFont.setBoldweight((short)700);
                cellFont.setColor((short)Short.MAX_VALUE);
                cellFont.setFontHeightInPoints((short)11);
                cellFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                cellStyle.setFont((Font)cellFont);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderTop((short)1);
                cellStyle.setBorderRight((short)1);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                if (i < 11) {
                    cellStyle.setFillPattern((short)1);
                    cellStyle.setFillForegroundColor((short)this.getColor(workbook));
                }
                if (i == 12 || i == 13 || i == 19) {
                    cellFont.setColor((short)10);
                }
                cell.setCellStyle((CellStyle)cellStyle);
            }
            return row;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
            throw new Exception("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
        }
    }

    @RequestMapping(value={"/exportPubSkus"}, method={RequestMethod.GET})
    public void exportPubSkus(HttpServletRequest request, HttpServletResponse response) {
        String sheetName = "\u5546\u54c1\u6807\u8bc6\u4fe1\u606f";
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            String agreementIdStr = request.getParameter("agreementId");
            String supplierIdStr = request.getParameter("supplierId");
            if (agreementIdStr == null || agreementIdStr.length() == 0) {
                this.respMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u534f\u8bae\u53f7(agreementId)");
                return;
            }
            if (supplierIdStr == null || supplierIdStr.length() == 0) {
                this.respMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u94fa\u8d27\u5546(supplierId)");
                return;
            }
            Long agreementId = Long.parseLong(agreementIdStr);
            Long supplierId = Long.parseLong(supplierIdStr);
            ArrayList<String> pubSkusHeads = new ArrayList<String>(Arrays.asList("\u5355\u4f4d\u540d\u79f0", "\u5e73\u53f0\u534f\u8bae\u7f16\u53f7", "\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7", "\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u7f16\u7801", "\u578b\u53f7", "\u7f16\u53f7"));
            HSSFFont font = workbook.createFont();
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            font.setFontHeightInPoints((short)11);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
            HSSFSheet sheet = workbook.createSheet(sheetName);
            HSSFRow row = this.addPubRowTitle(sheet, pubSkusHeads, workbook);
            ExportPubSkusReqBO exportPubSkusReqBO = new ExportPubSkusReqBO();
            exportPubSkusReqBO.setAgreementId(agreementId);
            exportPubSkusReqBO.setSupplierId(supplierId);
            ExportPubSkusRspBO exportPubSkusRspBO = this.exportPubSkusService.exportPubSkus(exportPubSkusReqBO);
            for (int i = 0; i < exportPubSkusRspBO.getExportPubSkusRspVOS().size(); ++i) {
                ExportPubSkusRspVO exportPubSkusRspVO = (ExportPubSkusRspVO)exportPubSkusRspBO.getExportPubSkusRspVOS().get(i);
                row = sheet.createRow(i + 1);
                for (int j = 0; j < pubSkusHeads.size(); ++j) {
                    HSSFCell cell = row.createCell(j);
                    if (j == 0) {
                        cell.setCellValue(exportPubSkusRspVO.getSupplierName());
                    }
                    if (j == 1) {
                        cell.setCellValue(exportPubSkusRspVO.getPlaAgreementCode());
                    }
                    if (j == 2) {
                        cell.setCellValue(exportPubSkusRspVO.getEntAgreementCode());
                    }
                    if (j == 3) {
                        cell.setCellValue(exportPubSkusRspVO.getSkuName());
                    }
                    if (j == 4) {
                        cell.setCellValue(exportPubSkusRspVO.getSkuId().toString());
                    }
                    if (j == 5) {
                        cell.setCellValue(exportPubSkusRspVO.getModel());
                    }
                    if (j == 6) {
                        cell.setCellValue((double)exportPubSkusRspVO.getAgreementSkuId().longValue());
                    }
                    cell.setCellStyle(style);
                }
            }
            try {
                String fileNameStr = "\u3010" + exportPubSkusRspBO.getEntAgreementCode() + "\u3011" + exportPubSkusRspBO.getAgreementName() + "\u5546\u54c1\u6807\u8bc6\u7801";
                String fileName = new String(fileNameStr.getBytes("gb2312"), "ISO8859-1");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                response.setContentType("application/x-download;charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
                ServletOutputStream os = response.getOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                byte[] b = new byte[1024];
                while (bais.read(b) > 0) {
                    os.write(b);
                }
                bais.close();
                os.flush();
                os.close();
                workbook.close();
                logger.info("\u6210\u529f\u5bfc\u51faExcel");
            }
            catch (IOException e) {
                logger.error("\u751f\u6210Excel IO\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u5931\u8d25", (Throwable)e);
        }
    }

    private HSSFRow addPubRowTitle(HSSFSheet sheet, List<String> pubSkusHeads, HSSFWorkbook workbook) throws Exception {
        try {
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < pubSkusHeads.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellValue(pubSkusHeads.get(i));
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                HSSFFont cellFont = workbook.createFont();
                cellFont.setBoldweight((short)700);
                cellFont.setColor((short)Short.MAX_VALUE);
                cellFont.setFontHeightInPoints((short)11);
                cellFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                cellStyle.setFont((Font)cellFont);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderTop((short)1);
                cellStyle.setBorderRight((short)1);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setFillForegroundColor((short)this.getColor(workbook));
                cell.setCellStyle((CellStyle)cellStyle);
            }
            return row;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
            throw new Exception("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
        }
    }
}

