/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.web.controller;

import com.ohaotian.commodity.busi.web.QueryOnOffShelveElecSkuService;
import com.ohaotian.commodity.busi.web.QuerySkuApproveListService;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuRspBO;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListRspBO;
import com.ohaotian.commodity.common.user.UserInfo;
import com.ohaotian.plugin.base.bo.RspPageBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"exportOrImport"})
public class ExportElecSkuController {
    private static final Logger logger = LogManager.getLogger(ExportElecSkuController.class);
    @Resource
    private QuerySkuApproveListService querySkuApproveListService;
    @Resource
    private QueryOnOffShelveElecSkuService queryOnOffShelveElecSkuService;

    @RequestMapping(value={"reportWaitApproveSku"}, method={RequestMethod.GET})
    @ResponseBody
    public void reportWaitApproveSku(HttpServletRequest request, HttpServletResponse response) {
        String sheetName = "\u5f85\u4e0a\u67b6\u5546\u54c1\u5ba1\u6838\u5217\u8868";
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            ArrayList<String> waitAgrSkusHeads = new ArrayList<String>(Arrays.asList("\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u5206\u7c7b", "\u54c1\u724c", "\u6765\u6e90\u7535\u5546", "\u5ba1\u6838\u72b6\u6001", "\u5546\u54c1\u72b6\u6001", "\u5546\u54c1\u7f16\u53f7", "\u5916\u90e8\u5546\u54c1\u7f16\u53f7", "\u5e02\u573a\u4ef7", "\u534f\u8bae\u4ef7", "\u6298\u6263\u7387(%)", "\u53d1\u5e03\u65f6\u95f4", "\u4e0a\u67b6\u65f6\u95f4", "\u4e0b\u67b6\u65f6\u95f4"));
            HSSFFont font = workbook.createFont();
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            font.setFontHeightInPoints((short)11);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
            HSSFSheet sheet = workbook.createSheet(sheetName);
            HSSFRow row = this.addRowTitle(sheet, waitAgrSkusHeads, workbook);
            QueryWaitApproveSkuListReqBO reqBO = new QueryWaitApproveSkuListReqBO();
            SecurityContext ctx = SecurityContextHolder.getContext();
            Authentication auth = ctx.getAuthentication();
            Object user = auth.getPrincipal();
            UserInfo userInfo = new UserInfo();
            BeanUtils.copyProperties((Object)user, (Object)userInfo);
            reqBO.setAcceptId(userInfo.getUid().toString());
            reqBO.setPageNo(1);
            reqBO.setPageSize(5000);
            RspPageBO resultPage = this.querySkuApproveListService.queryWaitApproveSkuList(reqBO);
            List result = resultPage.getRows();
            int i = 0;
            while (i < result.size()) {
                row = sheet.createRow(i + 1);
                int j = 0;
                while (j < waitAgrSkusHeads.size()) {
                    HSSFCell cell = row.createCell(j);
                    if (j == 0) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getSkuName());
                    }
                    if (j == 1) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getCommodityTypeName());
                    }
                    if (j == 2) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getBrandName());
                    }
                    if (j == 3) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getSupplierId().toString());
                    }
                    if (j == 4) {
                        cell.setCellValue((double)((QueryWaitApproveSkuListRspBO)result.get(i)).getApproveStatus().byteValue());
                    }
                    if (j == 5) {
                        cell.setCellValue((double)((QueryWaitApproveSkuListRspBO)result.get(i)).getSkuStatus().intValue());
                    }
                    if (j == 6) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getSkuId().toString());
                    }
                    if (j == 7 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getExtSkuId() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getExtSkuId().toString());
                    }
                    if (j == 8 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getMarketPrice() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getMarketPrice().toString());
                    }
                    if (j == 9 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getAgrPrice() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getAgrPrice().toString());
                    }
                    if (j == 10 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getDiscountRate() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getDiscountRate().toString());
                    }
                    if (j == 11 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getCreateTime() != null) {
                        cell.setCellValue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((QueryWaitApproveSkuListRspBO)result.get(i)).getCreateTime()));
                    }
                    if (j == 12 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getOnApproveTime() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getOnApproveTime());
                    }
                    if (j == 13 && ((QueryWaitApproveSkuListRspBO)result.get(i)).getOffApproveTime() != null) {
                        cell.setCellValue(((QueryWaitApproveSkuListRspBO)result.get(i)).getOffApproveTime());
                    }
                    cell.setCellStyle(style);
                    ++j;
                }
                ++i;
            }
            try {
                String fileNameStr = "\u5546\u54c1\u5f85\u5ba1\u6838\u5217\u8868\u5bfc\u51fa\u6a21\u677f";
                String fileName = new String(fileNameStr.getBytes("gb2312"), "ISO8859-1");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                response.setContentType("application/x-download;charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
                ServletOutputStream os = response.getOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                byte[] b = new byte[1024];
                while (bais.read(b) > 0) {
                    os.write(b);
                }
                bais.close();
                os.flush();
                os.close();
                workbook.close();
                logger.info("\u6210\u529f\u5bfc\u51faExcel");
            }
            catch (IOException e) {
                logger.error("\u751f\u6210Excel IO\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u5931\u8d25", (Throwable)e);
        }
    }

    @RequestMapping(value={"/reportOnOffShelveElecSku"}, method={RequestMethod.GET})
    public void reportOnOffShelveElecSku(HttpServletRequest request, HttpServletResponse response) {
        String skuStatus = request.getParameter("skuStatus");
        String sheetName = "";
        if (Byte.valueOf(skuStatus) == 2) {
            sheetName = "\u4e0a\u67b6\u5546\u54c1\u5217\u8868";
        }
        if (Byte.valueOf(skuStatus) == 4 || Byte.valueOf(skuStatus) == 5) {
            sheetName = "\u4e0b\u67b6\u5546\u54c1\u5217\u8868";
        }
        if (Byte.valueOf(skuStatus) == 3) {
            sheetName = "\u9a73\u56de\u5546\u54c1\u5217\u8868";
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            ArrayList<String> waitAgrSkusHeads = new ArrayList<String>(Arrays.asList("\u5546\u54c1\u540d\u79f0", "\u5546\u54c1\u5206\u7c7b", "\u54c1\u724c", "\u6765\u6e90\u7535\u5546", "\u5ba1\u6838\u72b6\u6001", "\u5546\u54c1\u72b6\u6001", "\u5546\u54c1\u7f16\u53f7", "\u5916\u90e8\u5546\u54c1\u7f16\u53f7", "\u5e02\u573a\u4ef7", "\u534f\u8bae\u4ef7", "\u6298\u6263\u7387\uff08%\uff09", "\u53d1\u5e03\u65f6\u95f4", "\u4e0a\u67b6\u65f6\u95f4", "\u4e0b\u67b6\u65f6\u95f4"));
            HSSFFont font = workbook.createFont();
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            font.setFontHeightInPoints((short)11);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
            HSSFSheet sheet = workbook.createSheet(sheetName);
            HSSFRow row = this.addRowTitle(sheet, waitAgrSkusHeads, workbook);
            QueryOnOffShelveElecSkuReqBO skuReqBO = new QueryOnOffShelveElecSkuReqBO();
            RspPageBO queryOnOffShelveElecSku = null;
            try {
                skuReqBO.setPageNo(1);
                skuReqBO.setPageSize(5000);
                queryOnOffShelveElecSku = this.queryOnOffShelveElecSkuService.queryOnOffShelveElecSku(skuReqBO);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5df2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u670d\u52a1\u51fa\u9519", (Throwable)e);
            }
            List rows = queryOnOffShelveElecSku.getRows();
            int i = 0;
            while (i < rows.size()) {
                row = sheet.createRow(i + 1);
                int j = 0;
                while (j < waitAgrSkusHeads.size()) {
                    HSSFCell cell = row.createCell(j);
                    if (j == 0) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getSkuName());
                    }
                    if (j == 1) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getCommodityTypeName());
                    }
                    if (j == 2) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getBrandName());
                    }
                    if (j == 3) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getSupplierName());
                    }
                    if (j == 4 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getApproveStatus() != null) {
                        cell.setCellValue((double)((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getApproveStatus().byteValue());
                    }
                    if (j == 5) {
                        cell.setCellValue((double)((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getSkuStatus().intValue());
                    }
                    if (j == 6 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getSkuId() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getSkuId().toString());
                    }
                    if (j == 7 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getExtSkuId() != null && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getExtSkuId() != "") {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getExtSkuId().toString());
                    }
                    if (j == 8 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getMarketPrice() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getMarketPrice().toString());
                    }
                    if (j == 9 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getAgrPrice() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getAgrPrice().toString());
                    }
                    if (j == 10 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getDiscountRate() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getDiscountRate().doubleValue());
                    }
                    if (j == 11) {
                        cell.setCellValue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getCreateTime()));
                    }
                    if (j == 12 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getOnApproveTime() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getOnApproveTime());
                    }
                    if (j == 13 && ((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getOffApproveTime() != null) {
                        cell.setCellValue(((QueryOnOffShelveElecSkuRspBO)rows.get(i)).getOffApproveTime());
                    }
                    cell.setCellStyle(style);
                    ++j;
                }
                ++i;
            }
            try {
                String fileNameStr = "";
                if (Byte.valueOf(skuStatus) == 2) {
                    fileNameStr = "\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u6a21\u677f";
                }
                if (Byte.valueOf(skuStatus) == 4 || Byte.valueOf(skuStatus) == 5) {
                    fileNameStr = "\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u6a21\u677f";
                }
                if (Byte.valueOf(skuStatus) == 3) {
                    fileNameStr = "\u9a73\u56de\u5546\u54c1\u5217\u8868\u6a21\u677f";
                }
                String fileName = new String(fileNameStr.getBytes("gb2312"), "ISO8859-1");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                response.setContentType("application/x-download;charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
                ServletOutputStream os = response.getOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                byte[] b = new byte[1024];
                while (bais.read(b) > 0) {
                    os.write(b);
                }
                bais.close();
                os.flush();
                os.close();
                workbook.close();
                logger.info("\u6210\u529f\u5bfc\u51faExcel");
            }
            catch (IOException e) {
                logger.error("\u751f\u6210Excel IO\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u5931\u8d25", (Throwable)e);
        }
    }

    private HSSFRow addRowTitle(HSSFSheet sheet, List<String> agrSkusHeads, HSSFWorkbook workbook) throws Exception {
        try {
            HSSFRow row = sheet.createRow(0);
            int i = 0;
            while (i < agrSkusHeads.size()) {
                HSSFCell cell = row.createCell(i);
                cell.setCellValue(agrSkusHeads.get(i));
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                HSSFFont cellFont = workbook.createFont();
                cellFont.setBoldweight((short)700);
                cellFont.setColor((short)Short.MAX_VALUE);
                cellFont.setFontHeightInPoints((short)11);
                cellFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                cellStyle.setFont((Font)cellFont);
                cellStyle.setBorderBottom((short)1);
                cellStyle.setBorderLeft((short)1);
                cellStyle.setBorderTop((short)1);
                cellStyle.setBorderRight((short)1);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setFillPattern((short)1);
                cellStyle.setFillForegroundColor((short)this.getColor(workbook));
                cell.setCellStyle((CellStyle)cellStyle);
                ++i;
            }
            return row;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
            throw new Exception("\u751f\u6210Excel\u6807\u9898\u5931\u8d25" + e);
        }
    }

    private int getColor(HSSFWorkbook workbook) {
        String color = "C0C0C0";
        int r = Integer.parseInt(color.substring(0, 2), 16);
        int g = Integer.parseInt(color.substring(2, 4), 16);
        int b = Integer.parseInt(color.substring(4, 6), 16);
        HSSFPalette palette = workbook.getCustomPalette();
        palette.setColorAtIndex((short)9, (byte)r, (byte)g, (byte)b);
        return 9;
    }
}

