/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.XbjPushOrder2PayCenterAtomService;
import com.cgd.order.busi.bo.XbjPushOrder2PayCenterReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.pay.busi.BusiPushPayPurchaseOrderInfoService;
import com.cgd.pay.busi.BusiPushSaleOrderInfoService;
import com.cgd.pay.busi.PayAddTradeServiceFeeService;
import com.cgd.pay.busi.bo.BusiPushPayPurchaseOrderInfoItemReqBO;
import com.cgd.pay.busi.bo.BusiPushPayPurchaseOrderInfoOrderReqBO;
import com.cgd.pay.busi.bo.BusiPushPayPurchaseOrderInfoReqBO;
import com.cgd.pay.busi.bo.BusiPushSaleOrderInfoItemReqBO;
import com.cgd.pay.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.cgd.pay.busi.bo.BusiPushSaleOrderInfoReqBO;
import com.cgd.pay.busi.bo.PayAddTradeServiceFeeReqBO;
import com.cgd.pay.enums.CompanyType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjPushOrder2PayCenterAtomServiceImpl
implements XbjPushOrder2PayCenterAtomService {
    private static final Logger log = LoggerFactory.getLogger(XbjPushOrder2PayCenterAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private BusiPushPayPurchaseOrderInfoService busiPushPayPurchaseOrderInfoService;
    @Autowired
    private BusiPushSaleOrderInfoService busiPushSaleOrderInfoService;
    @Autowired
    private InspectionXbjMapper inspectionXbjMapper;
    @Autowired
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private PayAddTradeServiceFeeService payAddTradeServiceFeeService;

    @Override
    public RspInfoBO push(XbjPushOrder2PayCenterReqBO reqBO) {
        log.info("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        Long inspectionId = reqBO.getInspectionId();
        Long purchaserId = reqBO.getPurchaserId();
        if (inspectionId == null || inspectionId <= 0L) {
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6536\u8d27\u5355\u53f7[inspectionId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u8d27\u5355\u53f7[inspectionId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaserId == null || purchaserId <= 0L) {
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6536\u8d27\u5355\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (isDebugEnabled) {
            log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1astart\uff0c-====------------------");
        }
        try {
            OrderSaleXbjPO orderSale;
            InspectionXbjPO inspection = this.inspectionXbjMapper.getModelById(inspectionId);
            if (inspection == null) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6536\u8d27\u5355[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6536\u8d27\u5355[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
            }
            if (inspection.getPurchaseFee() == null || inspection.getPurchaseFee() <= 0L || inspection.getSaleFee() == null || inspection.getSaleFee() <= 0L) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6536\u8d27\u5355\u7684\u9a8c\u6536\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6536\u8d27\u5355\u7684\u9a8c\u6536\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
            }
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a1\uff0c-====------------------");
            }
            Long purchaseOrderId = inspection.getPurchaseOrderId();
            Long saleOrderId = inspection.getSaleOrderId();
            OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.selectByPrimaryKey(purchaseOrderId);
            if (orderPurchase == null) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355[\u8ba2\u5355\u53f7=" + purchaseOrderId + "]\u3002");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355[\u8ba2\u5355\u53f7=" + purchaseOrderId + "]\u3002");
            }
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a2\uff0c-====-------------orderPurchase.getIsDispatch()-----" + orderPurchase.getIsDispatch());
            }
            if ((orderSale = this.orderSaleXbjMapper.selectByPrimaryKey(saleOrderId)) == null) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355[\u8ba2\u5355\u53f7=" + saleOrderId + "]\u3002");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355[\u8ba2\u5355\u53f7=" + saleOrderId + "]\u3002");
            }
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a3\uff0c-====------------------");
            }
            orderPurchase.setTaxRate(orderPurchase.getTaxRate() == null ? 17L : orderPurchase.getTaxRate());
            BigDecimal taxRateOfOrder = new BigDecimal(orderPurchase.getTaxRate().toString()).divide(new BigDecimal("100"), 2, 4);
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a4-====------------------");
            }
            OrderReceiveItemXbjPO record = new OrderReceiveItemXbjPO();
            record.setInspectionId(inspectionId);
            record.setPurchaserId(purchaserId);
            List<OrderReceiveItemXbjPO> orderReceiveItemList = this.orderReceiveItemXbjMapper.getList(record);
            if (orderReceiveItemList.isEmpty()) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6536\u8d27\u660e\u7ec6[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u6536\u8d27\u660e\u7ec6[\u6536\u8d27\u5355\u53f7=" + inspectionId + "]\u3002");
            }
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a5\uff0c-====------------------");
            }
            if (Constant.IS_DISPATCH_NO.equals(orderPurchase.getIsDispatch())) {
                PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = this.initPayAddServicePO(orderSale, inspection, orderReceiveItemList);
                if (payAddTradeServiceFeeReqBO.getPayMoney().compareTo(BigDecimal.valueOf(0L)) > 0) {
                    try {
                        if (isDebugEnabled) {
                            log.debug("\u5230\u8d27\u9a8c\u6536\u975e\u914d\u9001\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                        }
                        RspBusiBaseBO payAddTradeRspBO = this.payAddTradeServiceFeeService.addTradeServiceFee(payAddTradeServiceFeeReqBO);
                        if (isDebugEnabled) {
                            log.debug("\u5230\u8d27\u9a8c\u6536\u975e\u914d\u9001\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)payAddTradeRspBO));
                        }
                        if (payAddTradeRspBO != null && !"0000".equalsIgnoreCase(payAddTradeRspBO.getRespCode())) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38" + payAddTradeRspBO.getRespDesc());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5230\u8d27\u9a8c\u6536\u975e\u914d\u9001\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38" + e.getMessage());
                    }
                }
                RspInfoBO rspBO = new RspInfoBO();
                rspBO.setRespCode("0000");
                return rspBO;
            }
            BusiPushPayPurchaseOrderInfoReqBO purchaseReqBO = new BusiPushPayPurchaseOrderInfoReqBO();
            BusiPushPayPurchaseOrderInfoOrderReqBO orderInfo = new BusiPushPayPurchaseOrderInfoOrderReqBO();
            ArrayList<BusiPushPayPurchaseOrderInfoItemReqBO> itemList = new ArrayList<BusiPushPayPurchaseOrderInfoItemReqBO>();
            purchaseReqBO.setOrderInfo(orderInfo);
            purchaseReqBO.setItemList(itemList);
            orderInfo.setParentOrderId(orderPurchase.getSaleOrderParentId());
            orderInfo.setOrderId(orderPurchase.getPurchaseOrderId());
            orderInfo.setOrderDate(orderPurchase.getCreateTime());
            orderInfo.setSupplierNo(orderPurchase.getGoodsSupplierId());
            orderInfo.setSupplierName(null);
            orderInfo.setOrderAmt(MoneyUtil.Long2BigDecimal((Long)inspection.getPurchaseFee()));
            orderInfo.setPurchaseNo(orderPurchase.getPurchaserId());
            orderInfo.setPurchaseName(null);
            orderInfo.setPurchaserId(orderPurchase.getPurchaserAccountId());
            orderInfo.setPurchaserName(orderPurchase.getPurchaserAccountName());
            orderInfo.setOrderType(orderPurchase.getSaleOrderBusiType());
            orderInfo.setOperUnitNo(orderPurchase.getProfessionalOrganizationId());
            orderInfo.setOperUnitName(null);
            orderInfo.setPurchaseProjectId(orderPurchase.getPurchaserAccount());
            orderInfo.setSource(orderPurchase.getSaleOrderType() + "");
            orderInfo.setRecvDate(inspection.getCreateTime());
            orderInfo.setInspectionId(inspection.getInspectionId());
            orderInfo.setExtOrderId(orderPurchase.getExtOrderId());
            orderInfo.setPurchaseOrderCode(inspection.getPurchaseOrderCode());
            orderInfo.setPurchaseOrderName(orderPurchase.getPurchaseOrderName());
            orderInfo.setPlaAgreementCode(orderPurchase.getPlaAgreementCode());
            OrderProtocolItemXbjPO orderProtocolItem = new OrderProtocolItemXbjPO();
            orderProtocolItem.setSaleOrderId(saleOrderId);
            orderProtocolItem.setPurchaserId(purchaserId);
            orderProtocolItem = this.orderProtocolItemXbjMapper.getModelBy(orderProtocolItem);
            if (isDebugEnabled) {
                log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a6\uff0c-====------------------");
            }
            if (orderProtocolItem != null) {
                orderInfo.setPlaAgreementCode(orderProtocolItem.getEntAgrementCode());
            }
            List<OrderReceiveItemXbjPO> orderReceiveItemNewList = this.getNewListCountByItemId(orderReceiveItemList);
            for (OrderReceiveItemXbjPO orderReceiveItem : orderReceiveItemNewList) {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u5faa\u73af=" + inspectionId + "]\u3002");
                }
                OrderPurchaseItemXbjPO orderPurchaseItem = this.orderPurchaseItemXbjMapper.getModelById(orderReceiveItem.getPurchaseOrderItemId());
                BusiPushPayPurchaseOrderInfoItemReqBO item = new BusiPushPayPurchaseOrderInfoItemReqBO();
                item.setItemNo(orderReceiveItem.getPurchaseOrderItemId());
                item.setItemName(orderReceiveItem.getMaterialName());
                item.setSpec(orderPurchaseItem.getSpecifications());
                item.setModel(orderPurchaseItem.getModel());
                item.setPurchaseUnitPrice(MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getPurchasingPrice()));
                item.setUnitName(orderReceiveItem.getUnitName());
                item.setQuantity(orderReceiveItem.getPurchaseCount());
                item.setSaleUnitPrice(MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getSellingPrice()));
                item.setSkuId(Long.valueOf(orderReceiveItem.getSkuId()));
                item.setAmount(MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getPurchaseFeeCount()));
                BigDecimal taxRate = null;
                Integer extSkuTax = orderReceiveItem.getExtSkuTax() == null ? 17 : orderReceiveItem.getExtSkuTax();
                taxRate = new BigDecimal(extSkuTax.toString()).divide(new BigDecimal("100"), 2, 4);
                item.setTaxRate(taxRate);
                BigDecimal taxPrice = MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getPurchasingPrice()).divide(BigDecimal.ONE.add(taxRate), 4, 4).multiply(taxRate);
                BigDecimal taxAmt = taxPrice.multiply(orderReceiveItem.getPurchaseCount()).divide(BigDecimal.ONE, 2, 4);
                if (orderReceiveItem.getPurchasingPrice() <= 0L) {
                    if (!isDebugEnabled) continue;
                    log.debug("\u52a0\u4e2a\u4e3a\u91c7\u8d2d\u4ef7\u683c\u4e3a\uff1a" + orderReceiveItem.getPurchasingPrice());
                    log.debug("\u52a0\u4e2a\u4e3a\u9500\u552e\u4ef7\u683c\u4e3a\uff1a" + orderReceiveItem.getSellingPrice());
                    continue;
                }
                item.setTaxAmt(taxAmt);
                item.setUntaxAmt(item.getAmount().subtract(item.getTaxAmt()));
                itemList.add(item);
            }
            RspBusiBaseBO purchaseRspBO = null;
            try {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u5165\u53c2\uff1a" + purchaseReqBO.toString());
                }
                if (itemList.size() > 0) {
                    if (isDebugEnabled) {
                        log.debug("\u52a0\u4e2a\u4e3a\u91c7\u8d2d\u4ef7\u683c\u4e3a\uff1a\u975e\u7a7a\u6570\u636e");
                    }
                    log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a==========busiPushPayPurchaseOrderInfoService==================\u5165\u53c2\u3002" + JSON.toJSONString((Object)purchaseReqBO));
                    purchaseRspBO = this.busiPushPayPurchaseOrderInfoService.add(purchaseReqBO);
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\u3002", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\u3002");
            }
            if (!"0000".equals(purchaseRspBO.getRespCode())) {
                log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\u3002\u54cd\u5e94\u4fe1\u606f\uff1a" + purchaseRspBO.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5931\u8d25\uff1a" + purchaseRspBO.getRespDesc());
            }
            BusiPushSaleOrderInfoReqBO saleReqBO = new BusiPushSaleOrderInfoReqBO();
            BusiPushSaleOrderInfoOrderReqBO orderInfo2 = new BusiPushSaleOrderInfoOrderReqBO();
            ArrayList<BusiPushSaleOrderInfoItemReqBO> itemList2 = new ArrayList<BusiPushSaleOrderInfoItemReqBO>();
            saleReqBO.setOrderInfo(orderInfo2);
            saleReqBO.setItemList(itemList2);
            orderInfo2.setParentOrderId(orderSale.getSaleOrderParentId());
            orderInfo2.setOrderId(orderSale.getSaleOrderId());
            orderInfo2.setOrderDate(orderSale.getCreateTime());
            orderInfo2.setRecvDate(inspection.getCreateTime());
            orderInfo2.setSupplierNo(orderSale.getGoodsSupplierId());
            orderInfo2.setSupplierName(null);
            orderInfo2.setOrderAmt(MoneyUtil.Long2BigDecimal((Long)inspection.getSaleFee()));
            orderInfo2.setPurchaseNo(orderSale.getPurchaserId());
            orderInfo2.setPurchaseName(null);
            orderInfo2.setPurchaserId(orderSale.getPurchaserAccountId());
            orderInfo2.setPurchaserName(orderSale.getPurchaserAccountName());
            orderInfo2.setOperUnitNo(orderSale.getProfessionalOrganizationId());
            orderInfo2.setOperUnitName(null);
            orderInfo2.setPurchaseProjectId(orderSale.getPurchaserAccount());
            orderInfo2.setPurchaseOrderId(orderSale.getPurchaseOrderId());
            orderInfo2.setSource(orderSale.getSaleOrderType() + "");
            orderInfo2.setInspectionId(inspection.getInspectionId());
            orderInfo2.setSaleOrderCode(inspection.getSaleOrderCode());
            orderInfo2.setSaleOrderName(orderSale.getSaleOrderName());
            for (OrderReceiveItemXbjPO orderReceiveItem : orderReceiveItemNewList) {
                OrderSaleItemXbjPO orderSaleItem = this.orderSaleItemXbjMapper.getModelById(orderReceiveItem.getSaleOrderItemId());
                BusiPushSaleOrderInfoItemReqBO item = new BusiPushSaleOrderInfoItemReqBO();
                item.setItemNo(orderReceiveItem.getSaleOrderItemId());
                item.setPurchaseItemNo(orderReceiveItem.getPurchaseOrderItemId());
                item.setSkuId(Long.valueOf(orderReceiveItem.getSkuId()));
                item.setSkuName(orderReceiveItem.getMaterialName());
                item.setSpec(orderSaleItem.getSpecifications());
                item.setModel(orderSaleItem.getModel());
                item.setSaleUnitPrice(MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getSellingPrice()));
                item.setUnitName(orderReceiveItem.getUnitName());
                item.setQuantity(orderReceiveItem.getPurchaseCount());
                BigDecimal taxRate = null;
                Integer extSkuTax = orderReceiveItem.getExtSkuTax() == null ? 17 : orderReceiveItem.getExtSkuTax();
                taxRate = new BigDecimal(extSkuTax.toString()).divide(new BigDecimal("100"), 2, 4);
                if (orderReceiveItem.getSaleFeeCount() <= 0L) {
                    if (!isDebugEnabled) continue;
                    log.debug("\u52a0\u4e2a\u4e3a\u91c7\u8d2d\u4ef7\u683c\u4e3a\uff1a" + orderReceiveItem.getPurchasingPrice());
                    log.debug("\u52a0\u4e2a\u4e3a\u91c7\u8d2d\u4ef7\u683c\u4e3a\uff1a" + orderReceiveItem.getSaleFeeCount());
                    log.debug("\u52a0\u4e2a\u4e3a\u9500\u552e\u4ef7\u683c\u4e3a\uff1a" + orderReceiveItem.getSellingPrice());
                    continue;
                }
                item.setTaxRate(taxRate);
                item.setAmount(MoneyUtil.Long2BigDecimal((Long)orderReceiveItem.getSaleFeeCount()));
                itemList2.add(item);
            }
            RspBusiBaseBO saleRspBO = null;
            try {
                if (isDebugEnabled) {
                    log.debug("\u63a8\u9001\u9500\u552e\u8ba2\u5355\u5165\u53c2\uff1a" + saleReqBO.toString());
                }
                if (itemList2.size() > 0) {
                    if (isDebugEnabled) {
                        log.debug("\u52a0\u4e2a\u4e3a\u91c7\u8d2d\u4ef7\u683c\u4e3a\uff1a\u975e\u7a7a\u6570\u636e");
                    }
                    log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1abusiPushSaleOrderInfoService=================\u5165\u53c2\u3002" + JSON.toJSONString((Object)saleReqBO));
                    saleRspBO = this.busiPushSaleOrderInfoService.add(saleReqBO);
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u63a8\u9001\u9500\u552e\u8ba2\u5355\u5931\u8d25\u3002", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\uff1a\u4ea4\u6613\u5931\u8d25\uff0c\u63a8\u9001\u9500\u552e\u8ba2\u5355\u5931\u8d25\u3002");
            }
            if (!"0000".equals(saleRspBO.getRespCode())) {
                log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u63a8\u9001\u9500\u552e\u8ba2\u5355\u5931\u8d25\u3002\u54cd\u5e94\u4fe1\u606f\uff1a" + saleRspBO.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5931\u8d25\uff1a" + saleRspBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1\u5f02\u5e38");
        }
        if (isDebugEnabled) {
            log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1 \u6700\u540e\u670d\u52a1");
        }
        RspInfoBO rspBO = new RspInfoBO();
        rspBO.setRespCode("0000");
        if (isDebugEnabled) {
            log.debug("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u670d\u52a1 \u6700\u540e\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
        }
        return rspBO;
    }

    private PayAddTradeServiceFeeReqBO initPayAddServicePO(OrderSaleXbjPO orderSaleXbjPO, InspectionXbjPO inspection, List<OrderReceiveItemXbjPO> orderReceiveItemList) {
        PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = new PayAddTradeServiceFeeReqBO();
        try {
            payAddTradeServiceFeeReqBO.setPayOrderNo(inspection.getInspectionId() + "");
            payAddTradeServiceFeeReqBO.setInquiryNo(inspection.getInspectionCode());
            payAddTradeServiceFeeReqBO.setOrderDate(new Date());
            payAddTradeServiceFeeReqBO.setPayOrderName(orderSaleXbjPO.getSaleOrderName());
            OrderProtocolItemXbjPO orderProtocolItemPO = this.orderProtocolItemXbjMapper.queryBySaleOrderId(orderSaleXbjPO.getSaleOrderId());
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (OrderReceiveItemXbjPO orderReceItemPO : orderReceiveItemList) {
                if (orderProtocolItemPO != null && orderProtocolItemPO.getAdjustMechanism() == OrderCenterConstant.ADJUST_PRICE.DURING) {
                    totalAmount = totalAmount.add(MoneyUtil.Long2BigDecimal((Long)orderReceItemPO.getSellingPrice()).multiply(orderReceItemPO.getPurchaseCount()));
                    continue;
                }
                totalAmount = totalAmount.add(MoneyUtil.Long2BigDecimal((Long)orderReceItemPO.getPurchasingPrice()).multiply(orderReceItemPO.getPurchaseCount()));
            }
            payAddTradeServiceFeeReqBO.setOrderTotalMoney(totalAmount);
            BigDecimal payMoney = BigDecimal.ZERO;
            if (orderProtocolItemPO != null) {
                payMoney = new BigDecimal(orderProtocolItemPO.getServiceRate()).divide(new BigDecimal(100)).multiply(totalAmount);
                payAddTradeServiceFeeReqBO.setOperator(orderProtocolItemPO.getProducerId());
            }
            payAddTradeServiceFeeReqBO.setPayMoney(payMoney);
            payAddTradeServiceFeeReqBO.setCompanyType(CompanyType.SUPPLIER);
            payAddTradeServiceFeeReqBO.setSupplierId(orderSaleXbjPO.getGoodsSupplierId());
            payAddTradeServiceFeeReqBO.setOperUnitNo(orderSaleXbjPO.getProfessionalOrganizationId());
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.error("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u521d\u59cb\u5316\u5f02\u5e38:{}", (Throwable)e);
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u521d\u59cb\u5316\u5f02\u5e38:" + e.getMessage());
        }
        return payAddTradeServiceFeeReqBO;
    }

    private List<OrderReceiveItemXbjPO> getNewListCountByItemId(List<OrderReceiveItemXbjPO> oldList) {
        ArrayList<OrderReceiveItemXbjPO> newList = new ArrayList<OrderReceiveItemXbjPO>();
        for (OrderReceiveItemXbjPO oldPO : oldList) {
            boolean flag = false;
            for (OrderReceiveItemXbjPO newPO : newList) {
                if (!newPO.getPurchaseOrderItemId().equals(oldPO.getPurchaseOrderItemId())) continue;
                if (newPO.getPurchaseCount() == null) {
                    newPO.setPurchaseCount(BigDecimal.valueOf(0L));
                }
                if (newPO.getSaleFeeCount() == null) {
                    newPO.setSaleFeeCount(0L);
                }
                newPO.setPurchaseCount(newPO.getPurchaseCount().add(oldPO.getPurchaseCount()));
                newPO.setSaleFeeCount(newPO.getSaleFeeCount() + oldPO.getSaleFeeCount());
                flag = true;
            }
            if (flag) continue;
            newList.add(oldPO);
        }
        return newList;
    }
}

