/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.OrderStatusChangeCheckXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderStatusChangeCheckAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderStatusChangeCheckAtomXbjRspBO;
import com.cgd.order.busi.XbjApprovalRejectBusiService;
import com.cgd.order.busi.bo.XbjOrderConfirmRejectReqBO;
import com.cgd.order.busi.bo.XbjOrderConfirmRejectRspBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjApprovalRejectBusiServiceImpl
implements XbjApprovalRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjApprovalRejectBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderStatusChangeCheckXbjAtomService orderStatusChangeCheckXbjAtomService;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    @Autowired
    QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    DoTaskCompleteBusinService doTaskCompleteBusinService;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderStatusChangeCheckXbjAtomService(OrderStatusChangeCheckXbjAtomService orderStatusChangeCheckXbjAtomService) {
        this.orderStatusChangeCheckXbjAtomService = orderStatusChangeCheckXbjAtomService;
    }

    public XbjOrderConfirmRejectRspBO dealXbjApprovalOrder(XbjOrderConfirmRejectReqBO reqBO) {
        this.validateBOData(reqBO);
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        }
        XbjOrderConfirmRejectRspBO rspBO = new XbjOrderConfirmRejectRspBO();
        List saleOrderIds = reqBO.getSaleOrderIds();
        if (saleOrderIds != null && saleOrderIds.size() > 0) {
            for (int i = 0; i < saleOrderIds.size(); ++i) {
                String saleOrderId = (String)saleOrderIds.get(i);
                reqBO.setSaleOrderId(saleOrderId);
                try {
                    OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
                    orderSaleXbjPO.setSaleOrderId(Long.valueOf(saleOrderId));
                    orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                    if (orderSaleXbjPO == null) {
                        rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                        rspBO.setRespDesc("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                        return rspBO;
                    }
                    this.updateSaleOrderByApproveReject(reqBO, orderSaleXbjPO);
                    Integer isDispatch = orderSaleXbjPO.getIsDispatch();
                    if (Constant.IS_DISPATCH_NO == isDispatch || XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG == orderSaleXbjPO.getSaleOrderPurchaseType() || XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU == orderSaleXbjPO.getSaleOrderPurchaseType()) {
                        OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.getModelById(orderSaleXbjPO.getPurchaseOrderId());
                        if (orderPurchase == null) {
                            rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                            rspBO.setRespDesc("\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
                            return rspBO;
                        }
                        this.updatePurchaseOrderByApproveReject(reqBO, orderPurchase);
                    }
                    OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
                    process.setOrderId(orderSaleXbjPO.getSaleOrderId());
                    process.setBusiType("50");
                    process.setProcessStatus("0");
                    process = this.orderProcessCodeXbjMapper.getModelBy(process);
                    Integer workFlag = XbjOrderConstants.WORK_FLAG.NOPASS;
                    if (process != null) {
                        String processCode = process.getProcessCode();
                        TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                        todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                        todoTaskReqBO.setBusinessType("50");
                        todoTaskReqBO.setProcInstId(processCode);
                        TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                        if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                            DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                            doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                            doTaskCompleteReqBo.setBusinessType("50");
                            doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                            doTaskCompleteReqBo.setSeqFlowId(workFlag + "");
                            if (this.isDebugEnabled) {
                                log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b=============================start");
                            }
                            RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                            log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u8fd4\u56de=============================RSP\uff1a" + doTaskComplete.toString());
                            if (!doTaskComplete.getRespCode().equals("0000")) {
                                rspBO.setRespCode("8888");
                                rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                                if (this.isDebugEnabled) {
                                    log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                                }
                                return rspBO;
                            }
                            if (workFlag == XbjOrderConstants.WORK_FLAG.NOPASS) {
                                process.setProcessStatus("1");
                                this.orderProcessCodeXbjMapper.updateById(process);
                            }
                        } else {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                            if (this.isDebugEnabled) {
                                log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                            }
                        }
                    } else {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6d41\u7a0b\u5b9e\u4f8b");
                    }
                    XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                    orderFlowSheetReqBO.setOrderId(orderSaleXbjPO.getSaleOrderId());
                    orderFlowSheetReqBO.setPurchaserId(orderSaleXbjPO.getPurchaserId());
                    orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
                    orderFlowSheetReqBO.setOrderBusiType("B_12");
                    orderFlowSheetReqBO.setUserId(reqBO.getUserId());
                    orderFlowSheetReqBO.setUserName(reqBO.getUserName());
                    orderFlowSheetReqBO.setArriveTime(orderSaleXbjPO.getCreateTime());
                    orderFlowSheetReqBO.setCompanyName(reqBO.getCompanyName());
                    orderFlowSheetReqBO.setOperRole("\u5ba1\u6838\u5458");
                    orderFlowSheetReqBO.setOperRemark(reqBO.getCancelRemark());
                    if (this.isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u6d41\u7a0b\u8bb0\u5f55\u670d\u52a1\u5165\u53c2:" + orderFlowSheetReqBO.toString());
                    }
                    XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
                    if (this.isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u6d41\u7a0b\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2:" + orderFlowSheetRspBO.toString());
                    }
                    if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
                        if (this.isDebugEnabled) {
                            log.debug("\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5b8c\u6210");
                        }
                        continue;
                    }
                    if (this.isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5f02\u5e38\uff1a" + orderFlowSheetRspBO.getRespDesc());
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5f02\u5e38\uff1a" + orderFlowSheetRspBO.getRespDesc());
                }
                catch (BusinessException e) {
                    log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
                }
                catch (Exception e) {
                    log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
                }
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1:\u9500\u552e\u5355ID\u5217\u8868 \u4e3a\u7a7a\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateBOData(XbjOrderConfirmRejectReqBO XbjOrderConfirmRejectReqBO2) {
        if (XbjOrderConfirmRejectReqBO2 == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (XbjOrderConfirmRejectReqBO2.getSaleOrderIds() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u9500\u552e\u5355ID\u53c2\u6570\u5217\u8868\u3010saleOrderIds\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)XbjOrderConfirmRejectReqBO2.getUserId().toString())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u7528\u6237ID\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void updateSaleOrderByApproveReject(XbjOrderConfirmRejectReqBO orderSaleRejectBusiReqBO, OrderSaleXbjPO orderSale) {
        XbjOrderConfirmRejectRspBO rspBO = new XbjOrderConfirmRejectRspBO();
        OrderStatusChangeCheckAtomXbjReqBO orderStatusChangeCheckAtomReqBO = new OrderStatusChangeCheckAtomXbjReqBO();
        orderStatusChangeCheckAtomReqBO.setNewStatus(8);
        orderStatusChangeCheckAtomReqBO.setOldStatus(0);
        orderStatusChangeCheckAtomReqBO.setOrderBusiType("B_12");
        orderStatusChangeCheckAtomReqBO.setOrderType(Constant.ORDER_TYPE_SALE);
        orderStatusChangeCheckAtomReqBO.setSaleOrderType(Constant.SALE_ORDER_TYPE_ELEC_AREA);
        this.orderStatusChangeCheckXbjAtomService.orderStatusChangeCheck(orderStatusChangeCheckAtomReqBO);
        if (0 != orderSale.getSaleOrderStatus()) {
            if (this.isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355ID\u3010" + orderSaleRejectBusiReqBO.getSaleOrderId() + "\u3011\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u64cd\u4f5c\uff01");
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u64cd\u4f5c\uff01");
        }
        OrderSaleXbjReqBO orderSaleReqBO = new OrderSaleXbjReqBO();
        orderSaleReqBO.setSaleOrderId(orderSale.getSaleOrderId());
        orderSaleReqBO.setPurchaserId(orderSale.getPurchaserId());
        orderSaleReqBO.setGoodsSupplierId(orderSale.getGoodsSupplierId());
        orderSaleReqBO.setSaleOrderStatus(8);
        orderSaleReqBO.setSaleOrderOldStatus(orderSale.getSaleOrderStatus());
        orderSaleReqBO.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        orderSaleReqBO.setPurchaserAccountName(orderSale.getPurchaserAccountName());
        orderSaleReqBO.setOperId(orderSaleRejectBusiReqBO.getUserId() + "");
        orderSaleReqBO.setModifyOprId(orderSaleRejectBusiReqBO.getUserId());
        orderSaleReqBO.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        orderSaleReqBO.setCancelReason("APPROVE_REJECT_CANCEL");
        this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
        this.orderSaleXbjMapper.updateCancelInfo(orderSale.getSaleOrderId(), "APPROVE_REJECT_CANCEL", orderSaleRejectBusiReqBO.getCancelRemark(), new Date(), (long)orderSaleRejectBusiReqBO.getUserId());
    }

    private void updatePurchaseOrderByApproveReject(XbjOrderConfirmRejectReqBO orderSaleRejectBusiReqBO, OrderPurchaseXbjPO orderPurchase) {
        OrderStatusChangeCheckAtomXbjReqBO orderStatusChangeCheckAtomReqBO = new OrderStatusChangeCheckAtomXbjReqBO();
        orderStatusChangeCheckAtomReqBO.setNewStatus(8);
        orderStatusChangeCheckAtomReqBO.setOldStatus(0);
        orderStatusChangeCheckAtomReqBO.setOrderBusiType("B_12");
        orderStatusChangeCheckAtomReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
        orderStatusChangeCheckAtomReqBO.setSaleOrderType(Constant.SALE_ORDER_TYPE_ELEC_AREA);
        OrderStatusChangeCheckAtomXbjRspBO rspBO = this.orderStatusChangeCheckXbjAtomService.orderStatusChangeCheck(orderStatusChangeCheckAtomReqBO);
        OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = new OrderPurchaseStatusChngReqBo();
        orderPurchaseStatusChngReqBo.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
        orderPurchaseStatusChngReqBo.setPurchaserId(orderPurchase.getPurchaserId());
        orderPurchaseStatusChngReqBo.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
        orderPurchaseStatusChngReqBo.setPurchaseOrderStatus(8);
        orderPurchaseStatusChngReqBo.setPurchaseOrderOldStatus(orderPurchase.getPurchaseOrderStatus());
        orderPurchaseStatusChngReqBo.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
        orderPurchaseStatusChngReqBo.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
        orderPurchaseStatusChngReqBo.setOperId(orderSaleRejectBusiReqBO.getUserId() + "");
        orderPurchaseStatusChngReqBo.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
        orderPurchaseStatusChngReqBo.setSaleOrderId(orderPurchase.getSaleOrderId());
        this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
        this.orderPurchaseXbjMapper.updateCancelInfo(orderPurchase.getPurchaseOrderId(), "APPROVE_REJECT_CANCEL", orderSaleRejectBusiReqBO.getCancelRemark(), new Date(), (long)orderSaleRejectBusiReqBO.getUserId());
    }
}

