/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.XbjPushOrder2PayCenterAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.busi.XbjOrderArrivalConfirmBusiService;
import com.cgd.order.busi.XbjShipOrderAcceptCreateBusiService;
import com.cgd.order.busi.bo.OrderReceiveReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjPushOrder2PayCenterReqBO;
import com.cgd.order.busi.bo.XbjShipOrderAcceptCreateBusiReqBO;
import com.cgd.order.busi.bo.XbjShipOrderAcceptCreateBusiRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderAfterSaleXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.intfce.bo.XbjOrderArrivalConfirmIntfceReqBO;
import com.cgd.order.intfce.bo.XbjOrderArrivalConfirmIntfceRspBO;
import com.cgd.order.intfce.bo.XbjReceiveMaterielInfoBO;
import com.cgd.order.po.OrderAfterSaleXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import com.cgd.user.supplier.busi.SelectSupplierInfoByIdBusiService;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdReqBO;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdRspBO;
import com.cgd.user.supplier.documcollect.bo.UpdateDocumentCollectStatusReqBO;
import com.cgd.user.supplier.documcollect.busi.UpdateDocumentCollectStatusBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class XbjOrderArrivalConfirmBusiServiceImpl
implements XbjOrderArrivalConfirmBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderArrivalConfirmBusiServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private SaleOrderStatusCheckXbjService saleOrderStatusCheckXbjService;
    @Autowired
    private OrderAfterSaleXbjMapper orderAfterSaleXbjMapper;
    @Autowired
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    @Autowired
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    @Autowired
    private XbjShipOrderAcceptCreateBusiService xbjShipOrderAcceptCreateBusiService;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private XbjPushOrder2PayCenterAtomService xbjPushOrder2PayCenterAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;
    @Autowired
    private UpdateDocumentCollectStatusBusiService updateDocumentCollectStatusBusiService;
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;

    public XbjOrderArrivalConfirmIntfceRspBO dealXbjOrderArrivalConfirm(XbjOrderArrivalConfirmIntfceReqBO req) {
        XbjOrderArrivalConfirmIntfceRspBO rsp = new XbjOrderArrivalConfirmIntfceRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9a8c\u6536\u6210\u529f");
        try {
            XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
            XbjShipOrderAcceptCreateBusiReqBO xbjShipOrderAcceptCreateBusiReqBO;
            XbjShipOrderAcceptCreateBusiRspBO busiRsp;
            this.dealWithParamVerify(req);
            try {
                if (req.getShipOrderId() != null && !"".equals(req.getShipOrderId())) {
                    OrderShipXbjPO orderShipXbjPO = this.orderShipXbjMapper.getModelById(req.getShipOrderId());
                    if (orderShipXbjPO == null) {
                        if (isDebugEnabled) {
                            logger.debug("\u6839\u636e\u53d1\u8d27\u5355ID\u3010" + req.getShipOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u6570\u636e");
                        }
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u53d1\u8d27\u5355ID\u3010" + req.getShipOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u6570\u636e");
                    }
                    req.setSaleOrderId(orderShipXbjPO.getSaleOrderId());
                }
            }
            catch (BusinessException e) {
                logger.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            catch (Exception e) {
                logger.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01");
            }
            OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO = this.orderSaleXbjAtomService.queryOrderSaleById(req.getSaleOrderId(), req.getPurchaserId());
            if (xbjOrderSaleInfoRspBO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
            }
            if (req.getPurchaserOrderId() == null) {
                req.setPurchaserOrderId(xbjOrderSaleInfoRspBO.getPurchaseOrderId());
            }
            if (XConstant.SALE_ORDER_STATE_TUOTOU.equals(xbjOrderSaleInfoRspBO.getSaleOrderStatus()) || XConstant.SALE_ORDER_STATE_PART_ARRIVED.equals(xbjOrderSaleInfoRspBO.getSaleOrderStatus())) {
                OrderAfterSaleXbjPO orderAfterSaleXbjPO = new OrderAfterSaleXbjPO();
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(OrderCenterConstant.AFTER_SALE.COMPLETE);
                statusList.add(OrderCenterConstant.AFTER_SALE.CANCEL);
                statusList.add(OrderCenterConstant.AFTER_SALE.REQUEST_FALSE);
                orderAfterSaleXbjPO.setStatusList(statusList);
                orderAfterSaleXbjPO.setSaleOrderId(xbjOrderSaleInfoRspBO.getSaleOrderId());
                List<OrderAfterSaleXbjPO> orderAfterSaleList = this.orderAfterSaleXbjMapper.queryByOrderIdAndInStatusCondition(orderAfterSaleXbjPO);
                if (orderAfterSaleList != null && orderAfterSaleList.size() > 0) {
                    if (isDebugEnabled) {
                        logger.debug("\u8ba2\u5355\u53f7\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u5b58\u5728\u9000\u8d27\u4e2d\u8ba2\u5355\uff0c\u65e0\u6cd5\u786e\u8ba4\u6536\u8d27!");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u53f7\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u5b58\u5728\u9000\u8d27\u5355\uff0c\u65e0\u6cd5\u786e\u8ba4\u6536\u8d27!");
                }
                SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq = new SaleOrderStatusCheckXbjReqBO();
                saleOrderStatusCheckReq.setNewSaleOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
                saleOrderStatusCheckReq.setOldSaleOrderStatus(xbjOrderSaleInfoRspBO.getSaleOrderStatus());
                saleOrderStatusCheckReq.setSaleOrderType(xbjOrderSaleInfoRspBO.getSaleOrderType());
                SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckRsp = this.saleOrderStatusCheckXbjService.notifySaleOrderStatus(saleOrderStatusCheckReq);
                if (saleOrderStatusCheckRsp == null || !"0000".equals(saleOrderStatusCheckRsp.getCheckRspCode())) {
                    if (isDebugEnabled) {
                        logger.debug("\u9500\u552e\u8ba2\u5355\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
                }
            }
            this.checkCount(xbjOrderSaleInfoRspBO, req);
            if ("1".equals(req.getCompleteFlag())) {
                this.updateSaleAndPurchaser(req, xbjOrderSaleInfoRspBO);
                RspInfoBO rspBO = this.updateDocumentStatus(xbjOrderSaleInfoRspBO.getSaleOrderId());
                if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
                }
            }
            if ((busiRsp = this.xbjShipOrderAcceptCreateBusiService.createShipOrderAccept(xbjShipOrderAcceptCreateBusiReqBO = this.servOrderAcceptParamInit(req, xbjOrderSaleInfoRspBO))) == null || !"0000".equals(busiRsp.getRespCode())) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:");
            }
            XbjPushOrder2PayCenterReqBO payCenterReqBO = new XbjPushOrder2PayCenterReqBO();
            payCenterReqBO.setInspectionId(xbjShipOrderAcceptCreateBusiReqBO.getInspectionId());
            payCenterReqBO.setPurchaserId(xbjShipOrderAcceptCreateBusiReqBO.getPurchaserId());
            if (isDebugEnabled) {
                logger.debug("\u63a8\u9001\u8ba2\u5355\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u5165\u53c2" + JSON.toJSONString((Object)payCenterReqBO));
            }
            RspInfoBO payCenterRsp = this.xbjPushOrder2PayCenterAtomService.push(payCenterReqBO);
            if (isDebugEnabled) {
                logger.debug("\u63a8\u9001\u8ba2\u5355\u5230\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u51fa\u53c2" + JSON.toJSONString((Object)payCenterRsp));
            }
            if (payCenterRsp == null || !"0000".equals(payCenterRsp.getRespCode())) {
                if (isDebugEnabled) {
                    logger.debug("\u63a8\u9001\u8ba2\u5355\u5f02\u5e381" + JSON.toJSONString((Object)payCenterRsp));
                }
                rsp.setRespCode("8888");
                rsp.setRespDesc(payCenterRsp.getRespDesc());
                if (isDebugEnabled) {
                    logger.debug("\u63a8\u9001\u8ba2\u5355\u5f02\u5e382" + JSON.toJSONString((Object)rsp));
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", payCenterRsp.getRespDesc());
            }
            this.sendMessage(xbjOrderSaleInfoRspBO, req, xbjShipOrderAcceptCreateBusiReqBO.getInspectionCode());
            XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            BeanUtils.copyProperties((Object)req, (Object)xbjOrderFlowSheetReqBO);
            xbjOrderFlowSheetReqBO.setOrderId(req.getSaleOrderId());
            xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_SALE);
            xbjOrderFlowSheetReqBO.setPurchaserId(req.getPurchaserId());
            xbjOrderFlowSheetReqBO.setOrderBusiType("B_19");
            xbjOrderFlowSheetReqBO.setOperRole("\u5e93\u7ba1\u5458");
            xbjOrderFlowSheetReqBO.setUserId(req.getUserId());
            xbjOrderFlowSheetReqBO.setCompanyName(req.getCompanyName());
            xbjOrderFlowSheetReqBO.setUserName(req.getUserName());
            if (isDebugEnabled) {
                logger.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                logger.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            if (isDebugEnabled) {
                logger.debug("\u63a8\u9001\u8ba2\u5355\u5f02\u5e383" + JSON.toJSONString((Object)rsp));
            }
            rsp.setRespCode("8888");
            rsp.setRespDesc(e.getMessage());
            throw new BusinessException(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u63a8\u9001\u8ba2\u5355\u5f02\u5e384" + JSON.toJSONString((Object)rsp));
            }
            logger.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u9a8c\u6536\u5931\u8d25" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38:" + e);
        }
        if (isDebugEnabled) {
            logger.debug("\u63a8\u9001\u8ba2\u5355\u5f02\u5e385" + JSON.toJSONString((Object)rsp));
        }
        return rsp;
    }

    private void dealWithParamVerify(XbjOrderArrivalConfirmIntfceReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPurchaserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u5546\u7f16\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getSaleOrderId()) && StringUtils.isEmpty((Object)req.getShipOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9500\u552e\u8ba2\u5355id[saleOrderId]\u548c\u53d1\u8d27\u5355id[shipOrderId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (req.getReceiveMaterielInfoList() == null || req.getReceiveMaterielInfoList().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u96c6\u5408[receiveMaterielInfoList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (XbjReceiveMaterielInfoBO receiveInfo : req.getReceiveMaterielInfoList()) {
            if (StringUtils.isEmpty((Object)receiveInfo.getShipOrderId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u53d1\u8d27\u5355ID[shipOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)receiveInfo.getReceiveCount()) || receiveInfo.getReceiveCount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u6536\u8d27\u6570\u91cf[receiveCount]\u6709\u8bef\uff01");
            }
            if (!StringUtils.isEmpty((Object)receiveInfo.getPurchaseOrderItemId())) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u660e\u7ec6ID[purchaseOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != req.getAccessoryInfoList() && req.getAccessoryInfoList().size() > 0) {
            List xbjPurchaseAccessoryReqBOList = req.getAccessoryInfoList();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : xbjPurchaseAccessoryReqBOList) {
                if (StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryUrl())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private void checkCount(OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO, XbjOrderArrivalConfirmIntfceReqBO req) {
        OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.queryOrderPurchase(req.getPurchaserOrderId(), req.getPurchaserId());
        BigDecimal sendedCountTotal = new BigDecimal("0");
        BigDecimal checkedCountTotal = new BigDecimal("0");
        BigDecimal nowcheckingCountTotal = new BigDecimal("0");
        BigDecimal waitCheckigCountTotal = new BigDecimal("0");
        List receivefoList = req.getReceiveMaterielInfoList();
        for (XbjReceiveMaterielInfoBO receivefo : receivefoList) {
            OrderShipItemXbjPO shipPo = new OrderShipItemXbjPO();
            shipPo.setPurchaserId(req.getPurchaserId());
            shipPo.setShipOrderId(Long.valueOf(receivefo.getShipOrderId()));
            shipPo.setPurchaseOrderItemId(Long.valueOf(receivefo.getPurchaseOrderItemId()));
            shipPo.setShipItemId(receivefo.getShipItemId());
            OrderShipItemXbjPO shipItemInfo = this.orderShipItemXbjMapper.queryShipItemInfo(shipPo);
            if (shipItemInfo == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u91c7\u8d2d\u660e\u7ec6id\u548c\u53d1\u8d27\u5355ID\u672a\u627e\u5230\u6307\u5b9a\u7684\u53d1\u8d27\u660e\u7ec6");
            }
            BigDecimal sendedCount = shipItemInfo.getPurchaseCount();
            BigDecimal checkedCount = shipItemInfo.getAcceptanceCount();
            BigDecimal nowcheckingCount = receivefo.getReceiveCount();
            if (sendedCount == null) {
                sendedCount = new BigDecimal("0");
            }
            if (checkedCount == null) {
                checkedCount = new BigDecimal("0");
            }
            BigDecimal waitCheckigCount = sendedCount.subtract(checkedCount);
            checkedCountTotal = checkedCountTotal.add(checkedCount);
            nowcheckingCountTotal = nowcheckingCountTotal.add(nowcheckingCount);
            sendedCountTotal = sendedCountTotal.add(sendedCount);
            waitCheckigCountTotal = waitCheckigCountTotal.add(waitCheckigCount);
            BigDecimal checkTotal = nowcheckingCount.add(checkedCount);
            if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.TOTAL_TYPE == orderPurchase.getOrderType()) {
                if (req.getCompleteFlag().equals("1") && nowcheckingCount.compareTo(sendedCount) != 0 && checkTotal.compareTo(sendedCount) != 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
                }
                if (nowcheckingCount.compareTo(sendedCount) <= 0 && checkTotal.compareTo(sendedCount) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf");
            }
            if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.SINGLE_TYPE == orderPurchase.getOrderType()) {
                if (nowcheckingCount.compareTo(waitCheckigCount.multiply(new BigDecimal("1.2"))) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\u76841.2\u500d");
            }
            if (nowcheckingCount.compareTo(sendedCount) <= 0 && checkTotal.compareTo(sendedCount) <= 0) continue;
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf");
        }
        BigDecimal totalCheck = checkedCountTotal.add(nowcheckingCountTotal);
        if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.TOTAL_TYPE == orderPurchase.getOrderType()) {
            if (req.getCompleteFlag().equals("1") && totalCheck.compareTo(sendedCountTotal) != 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
            }
            if (totalCheck.compareTo(sendedCountTotal) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf");
            }
        } else if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.SINGLE_TYPE == orderPurchase.getOrderType()) {
            if (nowcheckingCountTotal.compareTo(waitCheckigCountTotal.multiply(new BigDecimal("1.2"))) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\u76841.2\u500d");
            }
        } else if (totalCheck.compareTo(sendedCountTotal) > 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf");
        }
    }

    private void updateSaleAndPurchaser(XbjOrderArrivalConfirmIntfceReqBO req, OrderSaleInfoXbjRspBO orderSaleInfoXbjRspBO) {
        try {
            OrderSaleXbjReqBO xbjOrderSaleReqBO = new OrderSaleXbjReqBO();
            xbjOrderSaleReqBO.setSaleOrderId(orderSaleInfoXbjRspBO.getSaleOrderId());
            xbjOrderSaleReqBO.setSaleOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
            xbjOrderSaleReqBO.setSaleOrderOldStatus(orderSaleInfoXbjRspBO.getSaleOrderStatus());
            xbjOrderSaleReqBO.setPurchaserId(req.getPurchaserId());
            xbjOrderSaleReqBO.setPurchaserAccountId(orderSaleInfoXbjRspBO.getPurchaserAccountId());
            xbjOrderSaleReqBO.setOperId(req.getUserId().toString());
            xbjOrderSaleReqBO.setProfessionalOrganizationId(orderSaleInfoXbjRspBO.getProfessionalOrganizationId());
            xbjOrderSaleReqBO.setCancelReason(req.getCancelReason());
            xbjOrderSaleReqBO.setGoodsSupplierId(orderSaleInfoXbjRspBO.getGoodsSupplierId());
            xbjOrderSaleReqBO.setModifyOprId(req.getUserId());
            xbjOrderSaleReqBO.setPurchaserAccountName(orderSaleInfoXbjRspBO.getPurchaserAccountName());
            xbjOrderSaleReqBO.setSaleOrderType(orderSaleInfoXbjRspBO.getSaleOrderType());
            this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff01");
        }
        try {
            OrderPurchaseStatusChngReqBo xbjOrderPurchaseStatusChngAtomReqBo = new OrderPurchaseStatusChngReqBo();
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderId(req.getPurchaserOrderId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderOldStatus(orderSaleInfoXbjRspBO.getSaleOrderStatus());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserId(req.getPurchaserId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserAccountId(orderSaleInfoXbjRspBO.getPurchaserAccountId());
            xbjOrderPurchaseStatusChngAtomReqBo.setOperId(req.getUserId().toString());
            xbjOrderPurchaseStatusChngAtomReqBo.setProfessionalOrganizationId(orderSaleInfoXbjRspBO.getProfessionalOrganizationId());
            xbjOrderPurchaseStatusChngAtomReqBo.setSaleOrderId(req.getSaleOrderId());
            xbjOrderPurchaseStatusChngAtomReqBo.setGoodsSupplierId(orderSaleInfoXbjRspBO.getGoodsSupplierId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserAccountName(orderSaleInfoXbjRspBO.getPurchaserAccountName());
            this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(xbjOrderPurchaseStatusChngAtomReqBo);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff01");
        }
    }

    private XbjShipOrderAcceptCreateBusiReqBO servOrderAcceptParamInit(XbjOrderArrivalConfirmIntfceReqBO req, OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO) {
        XbjShipOrderAcceptCreateBusiReqBO xbjShipOrderAcceptCreateBusiReqBO = new XbjShipOrderAcceptCreateBusiReqBO();
        GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.INSPECTION);
        generateOrderIdAndCodeXbjReqBO.setPurchaseOrderId(req.getPurchaserOrderId());
        generateOrderIdAndCodeXbjReqBO.setPurchaseId(req.getPurchaserId());
        generateOrderIdAndCodeXbjReqBO.setSaleOrderId(req.getSaleOrderId());
        GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
        OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.queryOrderPurchase(req.getPurchaserOrderId(), req.getPurchaserId());
        xbjShipOrderAcceptCreateBusiReqBO.setShipOrderId(req.getShipOrderId());
        xbjShipOrderAcceptCreateBusiReqBO.setInspectionId(generateOrderIdAndCodeXbjRspBO.getOrderId());
        xbjShipOrderAcceptCreateBusiReqBO.setInspectionCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaseOrderId(req.getPurchaserOrderId());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaserId(req.getPurchaserId());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaseOrderCode(orderPurchase.getPurchaseOrderCode());
        xbjShipOrderAcceptCreateBusiReqBO.setSaleOrderId(xbjOrderSaleInfoRspBO.getSaleOrderId());
        xbjShipOrderAcceptCreateBusiReqBO.setSaleOrderCode(xbjOrderSaleInfoRspBO.getSaleOrderCode());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
        xbjShipOrderAcceptCreateBusiReqBO.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
        xbjShipOrderAcceptCreateBusiReqBO.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
        xbjShipOrderAcceptCreateBusiReqBO.setOperId(req.getUserId());
        xbjShipOrderAcceptCreateBusiReqBO.setCreateTime(new Date());
        xbjShipOrderAcceptCreateBusiReqBO.setSaleOrderType(xbjOrderSaleInfoRspBO.getSaleOrderType());
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaserAccountOrgId(orderPurchase.getPurchaserAccountOrgId());
        xbjShipOrderAcceptCreateBusiReqBO.setInspectionCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        xbjShipOrderAcceptCreateBusiReqBO.setSaleOrderPurchaseType(orderPurchase.getSaleOrderPurchaseType());
        xbjShipOrderAcceptCreateBusiReqBO.setOrderType(xbjOrderSaleInfoRspBO.getOrderType());
        xbjShipOrderAcceptCreateBusiReqBO.setRemark(req.getCancelReason());
        ArrayList<OrderReceiveReqBO> orderReceiveList = new ArrayList<OrderReceiveReqBO>();
        Long saleFee = 0L;
        Long purchaseFee = 0L;
        for (XbjReceiveMaterielInfoBO receiveInfo : req.getReceiveMaterielInfoList()) {
            OrderReceiveReqBO orderReceiveReqBO = new OrderReceiveReqBO();
            try {
                OrderPurchaseItemXbjPO itemXbjPO = this.orderPurchaseItemXbjMapper.getModelById(Long.valueOf(receiveInfo.getPurchaseOrderItemId()));
                orderReceiveReqBO.setPurchasingPrice(itemXbjPO.getPurchasingPrice());
                orderReceiveReqBO.setSellingPrice(itemXbjPO.getSellingPrice());
                saleFee = receiveInfo.getReceiveCount().multiply(new BigDecimal(itemXbjPO.getSellingPrice())).longValue();
                purchaseFee = receiveInfo.getReceiveCount().multiply(new BigDecimal(itemXbjPO.getPurchasingPrice())).longValue();
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636epurchaseOrderItemId\u67e5\u8be2\u6570\u636e\u62a5\u9519");
            }
            OrderShipItemXbjPO shipPo = new OrderShipItemXbjPO();
            shipPo.setPurchaserId(req.getPurchaserId());
            shipPo.setShipOrderId(Long.valueOf(receiveInfo.getShipOrderId()));
            shipPo.setPurchaseOrderItemId(Long.valueOf(receiveInfo.getPurchaseOrderItemId()));
            OrderShipItemXbjPO shipItemInfo = this.orderShipItemXbjMapper.queryShipItemInfo(shipPo);
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355=================OrderShipItemXbjPO" + JSON.toJSONString((Object)shipItemInfo));
            }
            BeanUtils.copyProperties((Object)shipItemInfo, (Object)orderReceiveReqBO);
            orderReceiveReqBO.setShipItemId(shipItemInfo.getShipItemId());
            orderReceiveReqBO.setInspectionId(xbjShipOrderAcceptCreateBusiReqBO.getInspectionId());
            orderReceiveReqBO.setSaleOrderItemId(shipItemInfo.getSaleOrderItemId());
            orderReceiveReqBO.setPurchaseOrderItemId(shipItemInfo.getPurchaseOrderItemId());
            orderReceiveReqBO.setSaleOrderId(req.getSaleOrderId());
            orderReceiveReqBO.setPurchaseOrderId(req.getPurchaserOrderId());
            orderReceiveReqBO.setPurchaserId(req.getPurchaserId());
            orderReceiveReqBO.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
            orderReceiveReqBO.setPurchaserAccountName(orderPurchase.getPurchaseOrderName());
            orderReceiveReqBO.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
            orderReceiveReqBO.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
            orderReceiveReqBO.setSkuId(shipItemInfo.getSkuId());
            orderReceiveReqBO.setSkuName(shipItemInfo.getSkuName());
            orderReceiveReqBO.setMaterialId(shipItemInfo.getMaterialId());
            orderReceiveReqBO.setMaterialId(shipItemInfo.getMaterialId());
            orderReceiveReqBO.setMaterialCode(shipItemInfo.getMaterialCode());
            orderReceiveReqBO.setMaterialName(shipItemInfo.getMaterialName());
            orderReceiveReqBO.setSpecifications(shipItemInfo.getSpecifications());
            orderReceiveReqBO.setModel(shipItemInfo.getModel());
            orderReceiveReqBO.setFigureNo(shipItemInfo.getFigureNo());
            orderReceiveReqBO.setMaterialQuality(shipItemInfo.getMaterialQuality());
            orderReceiveReqBO.setBrandId(shipItemInfo.getBrandId());
            orderReceiveReqBO.setBrand(shipItemInfo.getBrand());
            orderReceiveReqBO.setManufacturer(shipItemInfo.getManufacturer());
            orderReceiveReqBO.setRecvAddr(shipItemInfo.getRecvAddr());
            orderReceiveReqBO.setPreSendDate(shipItemInfo.getPreSendDate());
            orderReceiveReqBO.setUsedCompany(shipItemInfo.getUsedCompany());
            orderReceiveReqBO.setMaterialClassId(shipItemInfo.getMaterialClassId());
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355==========================orderReceiveReqBO" + JSON.toJSONString((Object)orderReceiveReqBO));
            }
            orderReceiveReqBO.setPurchaseCount(receiveInfo.getReceiveCount());
            orderReceiveReqBO.setShipOrderId(Long.valueOf(receiveInfo.getShipOrderId()));
            orderReceiveList.add(orderReceiveReqBO);
        }
        xbjShipOrderAcceptCreateBusiReqBO.setSaleFee(saleFee);
        xbjShipOrderAcceptCreateBusiReqBO.setPurchaseFee(purchaseFee);
        xbjShipOrderAcceptCreateBusiReqBO.setOrderReceiveList(orderReceiveList);
        xbjShipOrderAcceptCreateBusiReqBO.setAccessoryInfoList(req.getAccessoryInfoList());
        return xbjShipOrderAcceptCreateBusiReqBO;
    }

    private void sendMessage(OrderSaleInfoXbjRspBO orderSale, XbjOrderArrivalConfirmIntfceReqBO req, String inspectionCode) {
        try {
            SelectSupplierInfoByIdReqBO reqBO = new SelectSupplierInfoByIdReqBO();
            reqBO.setSupplierId(orderSale.getGoodsSupplierId());
            SelectSupplierInfoByIdRspBO rspBO = this.selectSupplierInfoByIdBusiService.selectSupplierInfoById(reqBO);
            if (rspBO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5230\u8d27\u9a8c\u6536\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f\uff01");
            }
            logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspBO));
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_SUPPLY_DISPATCH_YES);
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            smsParam.put("purchaseCode", orderSale.getPurchaseOrderCode());
            smsParam.put("purchaseName", orderSale.getSaleOrderName());
            smsParam.put("inspectionCode", inspectionCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setUserId(req.getUserId());
            orderSendMsgBusiReq.setMessageAccount(rspBO.getManagerId() + "");
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            logger.error("\u5230\u8d27\u9a8c\u6536\u7ed9\u4f9b\u5e94\u5546\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO));
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5230\u8d27\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_SUPPLY_DISPATCH_NO);
            smsParam = new HashMap();
            smsParam.put("orderId", orderSale.getSaleOrderCode());
            smsParam.put("orderName", orderSale.getSaleOrderName());
            smsParam.put("inspectionCode", inspectionCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setMessageAccount(orderSale.getDeliveryId() + "");
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            RspInfoBO rspInfoBO1 = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            logger.error("\u5230\u8d27\u9a8c\u6536\u7ed9\u914d\u9001\u4e13\u8d23\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO1));
            if (!"0000".equals(rspInfoBO1.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5230\u8d27\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u5230\u8d27\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
        }
    }

    private RspInfoBO updateDocumentStatus(Long saleOrderId) {
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            UpdateDocumentCollectStatusReqBO updateDocumentCollectStatusReqBO = new UpdateDocumentCollectStatusReqBO();
            updateDocumentCollectStatusReqBO.setDocumentId(saleOrderId);
            updateDocumentCollectStatusReqBO.setDocumentStatus(Integer.valueOf(1));
            updateDocumentCollectStatusReqBO.setBusiType(Integer.valueOf(3));
            logger.error("\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updateDocumentCollectStatusReqBO));
            RspBusiBaseBO rspBusiBO = this.updateDocumentCollectStatusBusiService.updateStatus(updateDocumentCollectStatusReqBO);
            logger.error("\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBusiBO));
            if (rspBusiBO != null && "0000".equals(rspBusiBO.getRespCode())) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u6210\u529f");
            } else {
                rspInfoBO.setRespCode("8888");
                rspInfoBO.setRespDesc("\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
            }
            return rspInfoBO;
        }
        catch (Exception e) {
            logger.error("\u5230\u8d27\u9a8c\u6536\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u9a8c\u6536\u5f02\u5e38\uff0c\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25\uff01");
        }
    }
}

