/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjShipOrderAcceptCreateBusiService;
import com.cgd.order.busi.bo.OrderReceiveReqBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjShipOrderAcceptCreateBusiReqBO;
import com.cgd.order.busi.bo.XbjShipOrderAcceptCreateBusiRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.InspectionShipProXbjMapper;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InspectionShipProXbjPO;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjShipOrderAcceptCreateBusiServiceImpl
implements XbjShipOrderAcceptCreateBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XbjShipOrderAcceptCreateBusiService.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InspectionXbjMapper inspectionXbjMapper;
    @Autowired
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;
    @Autowired
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    @Autowired
    private InspectionShipProXbjMapper inspectionShipProXbjMapper;
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;

    public XbjShipOrderAcceptCreateBusiRspBO createShipOrderAccept(XbjShipOrderAcceptCreateBusiReqBO req) {
        XbjShipOrderAcceptCreateBusiRspBO rsp = new XbjShipOrderAcceptCreateBusiRspBO();
        try {
            InspectionXbjPO inspectionXbjPO = new InspectionXbjPO();
            BeanUtils.copyProperties((Object)req, (Object)inspectionXbjPO);
            this.inspectionXbjMapper.insertInspection(inspectionXbjPO);
            if (isDebugEnabled) {
                logger.debug("\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)req));
            }
            BigDecimal acceptanceCountAll = BigDecimal.ZERO;
            for (OrderReceiveReqBO item : req.getOrderReceiveList()) {
                if (isDebugEnabled) {
                    logger.debug("\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1ITEM\u5165\u53c2" + JSON.toJSONString((Object)item));
                }
                OrderReceiveItemXbjPO orderReceiveItemXbjPO = new OrderReceiveItemXbjPO();
                BeanUtils.copyProperties((Object)item, (Object)orderReceiveItemXbjPO);
                orderReceiveItemXbjPO.setPurchaseFeeCount(inspectionXbjPO.getPurchaseFee());
                orderReceiveItemXbjPO.setSaleFeeCount(inspectionXbjPO.getSaleFee());
                this.orderReceiveItemXbjMapper.insertOrderReceiveItem(orderReceiveItemXbjPO);
                OrderShipItemXbjPO orderShipItemXbjPO = new OrderShipItemXbjPO();
                orderShipItemXbjPO.setPurchaserId(req.getPurchaserId());
                orderShipItemXbjPO.setShipOrderId(item.getShipOrderId());
                orderShipItemXbjPO.setPurchaseOrderItemId(item.getPurchaseOrderItemId());
                OrderShipItemXbjPO orderShipItemInfo = this.orderShipItemXbjMapper.queryShipItemInfo(orderShipItemXbjPO);
                if (orderShipItemInfo.getAcceptanceCount() == null) {
                    orderShipItemInfo.setAcceptanceCount(new BigDecimal("0"));
                }
                BigDecimal count = item.getPurchaseCount().add(orderShipItemInfo.getAcceptanceCount());
                acceptanceCountAll = acceptanceCountAll.add(count);
                orderShipItemXbjPO.setAcceptanceCount(count);
                orderShipItemXbjPO.setShipItemId(item.getShipItemId());
                this.orderShipItemXbjMapper.updateAcceptanceCount(orderShipItemXbjPO);
                OrderShipXbjPO orderShipPO = this.orderShipXbjMapper.getModelById(item.getShipOrderId());
                if (orderShipPO == null) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u53d1\u8d27\u5355ID\u3010" + item.getShipOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u6570\u636e");
                }
                OrderShipXbjPO orderShipXbjPO = new OrderShipXbjPO();
                orderShipXbjPO.setShipOrderId(item.getShipOrderId());
                orderShipXbjPO.setModifyOperId(req.getOperId());
                orderShipXbjPO.setModifyTime(new Date());
                orderShipXbjPO.setInspectionId(req.getInspectionId());
                if (orderShipPO.getArriveTime() == null) {
                    orderShipXbjPO.setArriveTime(new Date());
                }
                this.orderShipXbjMapper.updateOrderShipByShipOrderId(orderShipXbjPO);
                InspectionShipProXbjPO inspectionShipProXbjPO = new InspectionShipProXbjPO();
                inspectionShipProXbjPO.setPurchaserId(req.getPurchaserId());
                inspectionShipProXbjPO.setPurchaserAccountId(item.getPurchaserAccountId());
                inspectionShipProXbjPO.setPurchaserAccountName(item.getPurchaserAccountName());
                inspectionShipProXbjPO.setProfessionalOrganizationId(item.getProfessionalOrganizationId());
                inspectionShipProXbjPO.setGoodsSupplierId(item.getProfessionalOrganizationId());
                inspectionShipProXbjPO.setShipOrderId(item.getShipOrderId());
                inspectionShipProXbjPO.setSkuId(item.getSkuId());
                inspectionShipProXbjPO.setPurchaseCount(item.getPurchaseCount());
                inspectionShipProXbjPO.setInspectionId(req.getInspectionId());
                inspectionShipProXbjPO.setSaleOrderId(req.getSaleOrderId());
                inspectionShipProXbjPO.setCreateTime(new Date());
                this.inspectionShipProXbjMapper.insertInspectionShipPro(inspectionShipProXbjPO);
            }
            if (req.getAccessoryInfoList() != null) {
                for (XbjPurchaseAccessoryReqBO accessoryTemp : req.getAccessoryInfoList()) {
                    AccessoryXbjPO accessory = new AccessoryXbjPO();
                    accessory.setObjectId(req.getInspectionId());
                    accessory.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.INSPECTION);
                    accessory.setOrderCode(req.getInspectionCode());
                    accessory.setPurchaserId(req.getPurchaserId());
                    accessory.setPurchaserAccountId(req.getPurchaserAccountId());
                    accessory.setPurchaserAccountName(req.getPurchaserAccountName());
                    accessory.setProfessionalOrganizationId(String.valueOf(req.getProfessionalOrganizationId()));
                    accessory.setGoodsSupplierId(String.valueOf(req.getGoodsSupplierId()));
                    accessory.setAccessoryId(accessoryTemp.getAccessoryId());
                    accessory.setAccessoryUrl(accessoryTemp.getAccessoryUrl());
                    accessory.setAccessoryName(accessoryTemp.getAccessoryName());
                    accessory.setRemark("\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5b8c\u5de5\u9a8c\u6536\u5355\u9644\u4ef6");
                    accessory.setCreateDate(new Date());
                    this.accessoryXbjMapper.insert(accessory);
                }
            }
            if (req.getShipOrderId() != null && !"".equals(req.getShipOrderId())) {
                BigDecimal sendCountAll = BigDecimal.ZERO;
                BigDecimal acceptCountAll = BigDecimal.ZERO;
                OrderShipItemXbjPO shipPo = new OrderShipItemXbjPO();
                shipPo.setPurchaserId(req.getPurchaserId());
                shipPo.setShipOrderId(req.getShipOrderId());
                List<OrderShipItemXbjPO> shipItemInfos = this.orderShipItemXbjMapper.getList(shipPo);
                if (shipItemInfos != null && shipItemInfos.size() > 0) {
                    for (OrderShipItemXbjPO po : shipItemInfos) {
                        sendCountAll = sendCountAll.add(po.getPurchaseCount());
                        if (po.getAcceptanceCount() == null) continue;
                        acceptCountAll = acceptCountAll.add(po.getAcceptanceCount());
                    }
                }
                logger.error("\u603b\u7684\u53d1\u8d27\u6570\u91cf\u5168\u90e8\uff1a" + sendCountAll);
                logger.error("\u603b\u7684\u9a8c\u6536\u6570\u91cf\u5168\u90e8\uff1a" + acceptCountAll);
                if (acceptCountAll.compareTo(sendCountAll) == 0) {
                    OrderShipXbjPO orderShipXbjPO = new OrderShipXbjPO();
                    orderShipXbjPO.setShipOrderId(req.getShipOrderId());
                    orderShipXbjPO.setShipStatus(XbjOrderConstants.WUZI_SHIP_STATUS_ACCEPT.toString());
                    this.orderShipXbjMapper.updateOrderShipStatusByShipOrderId(orderShipXbjPO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + e);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4e1a\u52a1\u670d\u52a1\uff0c\u8be2\u6bd4\u4ef7\u53d1\u8d27\u9a8c\u6536\u5355\u751f\u6210\u6210\u529f");
        return rsp;
    }
}

