/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.bo.RspListInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.busi.CreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjDistributionRuleBusiService;
import com.cgd.order.busi.bo.XbjDistributionRuleItemBO;
import com.cgd.order.busi.bo.XbjDistributionRuleReqBO;
import com.cgd.order.busi.bo.XbjDistributionRuleRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDistributionItemXbjMapper;
import com.cgd.order.dao.OrderDistributionXbjMapper;
import com.cgd.order.po.OrderDistributionItemXbjPO;
import com.cgd.order.po.OrderDistributionXbjPO;
import com.cgd.user.account.busi.QryEffActInfoByOrgBusiService;
import com.cgd.user.account.busi.bo.AccountInfoBO;
import com.cgd.user.account.busi.bo.QryActInfoByOrgReq;
import com.cgd.user.account.busi.bo.QryActInfoByOrgRsp;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjDistributionRuleBusiServiceImpl
implements XbjDistributionRuleBusiService {
    private static final Logger log = LoggerFactory.getLogger(CreateOrderFlowSheetBusiService.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    OrderDistributionXbjMapper orderDistributionXbjMapper;
    @Autowired
    OrderDistributionItemXbjMapper orderDistributionItemXbjMapper;
    @Autowired
    GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    QryEffActInfoByOrgBusiService qryEffActInfoByOrgBusiService;

    public RspInfoBO createDistributionRule(XbjDistributionRuleReqBO xbjDistributionRuleReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + xbjDistributionRuleReqBO.toString());
        }
        RspInfoBO rsp = new RspInfoBO();
        if (null == xbjDistributionRuleReqBO.getRuleType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u914d\u89c4\u5219\u521b\u5efa/\u7ef4\u62a4\u670d\u52a1\u4e2d\u89c4\u5219\u7ef4\u5ea6[ruleType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjDistributionRuleReqBO.getXbjDistributionRuleItemList()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u914d\u89c4\u5219\u521b\u5efa/\u7ef4\u62a4\u670d\u52a1\u4e2d\u89c4\u5219\u89c4\u5219\u4e32 ruleItemJsom[ruleItemJsom]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (null != xbjDistributionRuleReqBO.getDistributionRuleId()) {
                this.orderDistributionXbjMapper.deleteById(xbjDistributionRuleReqBO.getDistributionRuleId());
                this.orderDistributionItemXbjMapper.deleteById(xbjDistributionRuleReqBO.getDistributionRuleId());
            }
            OrderDistributionXbjPO condition = new OrderDistributionXbjPO();
            condition.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
            List<OrderDistributionXbjPO> ruleList = this.orderDistributionXbjMapper.getList(condition);
            if (ruleList != null || ruleList.size() > 0) {
                for (OrderDistributionXbjPO PO : ruleList) {
                    this.orderDistributionXbjMapper.deleteById(PO.getDistributionRuleId());
                    this.orderDistributionItemXbjMapper.deleteById(PO.getDistributionRuleId());
                }
            }
            GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
            generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.DISTRIBUTION_RULE_SEQ);
            generateOrderIdAndCodeXbjReqBO.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
            GenerateOrderIdAndCodeXbjRspBO rspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
            OrderDistributionXbjPO orderDistributionXbjPO = new OrderDistributionXbjPO();
            orderDistributionXbjPO.setDistributionRuleId(rspBO.getOrderId());
            orderDistributionXbjPO.setDistributionRuleCode(rspBO.getOrderCode());
            orderDistributionXbjPO.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
            orderDistributionXbjPO.setProfessionalOrganizationName(xbjDistributionRuleReqBO.getCompanyName());
            orderDistributionXbjPO.setApplyOrderType("purchase");
            orderDistributionXbjPO.setCreateUserId(xbjDistributionRuleReqBO.getUserId());
            orderDistributionXbjPO.setCreateUserName(xbjDistributionRuleReqBO.getUserName());
            orderDistributionXbjPO.setSaleOrderType(XbjOrderConstants.SALE_ORDER_TYPE_XBJ.toString());
            orderDistributionXbjPO.setRuleType(xbjDistributionRuleReqBO.getRuleType());
            this.orderDistributionXbjMapper.insert(orderDistributionXbjPO);
            for (XbjDistributionRuleItemBO BO : xbjDistributionRuleReqBO.getXbjDistributionRuleItemList()) {
                OrderDistributionItemXbjPO orderDistributionItemXbjPO = new OrderDistributionItemXbjPO();
                orderDistributionItemXbjPO.setBusiScope(BO.getBusiScope());
                orderDistributionItemXbjPO.setRuleType(xbjDistributionRuleReqBO.getRuleType());
                orderDistributionItemXbjPO.setDeliveryId(BO.getDeliveryId());
                orderDistributionItemXbjPO.setDistributionRuleId(rspBO.getOrderId());
                this.orderDistributionItemXbjMapper.insert(orderDistributionItemXbjPO);
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u521b\u5efa/\u7ef4\u62a4\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.error("\u5206\u914d\u89c4\u5219\u521b\u5efa/\u7ef4\u62a4\u5931\u8d25\uff1a", (Throwable)e);
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u521b\u5efa/\u7ef4\u62a4\u5931\u8d25");
            return rsp;
        }
    }

    public XbjDistributionRuleRspBO qryDistributionRule(XbjDistributionRuleReqBO xbjDistributionRuleReqBO) {
        if (isDebugEnabled) {
            log.debug("\u5206\u914d\u89c4\u5219\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + xbjDistributionRuleReqBO.toString());
        }
        XbjDistributionRuleRspBO rsp = new XbjDistributionRuleRspBO();
        if (null == xbjDistributionRuleReqBO.getOrgId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u914d\u89c4\u5219\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u4e2d\u4e13\u4e1a\u516c\u53f8 ID[ProfessionalOrganizationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderDistributionXbjPO condition = new OrderDistributionXbjPO();
        condition.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
        try {
            OrderDistributionXbjPO orderDistributionXbjPO = this.orderDistributionXbjMapper.getModelBy(condition);
            if (orderDistributionXbjPO == null) {
                rsp.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
                rsp.setProfessionalOrganizationName(xbjDistributionRuleReqBO.getOrgName());
                rsp.setApplyOrderType("purchase");
                rsp.setApplyOrderTypeStr("\u91c7\u8d2d\u8ba2\u5355");
                rsp.setSaleOrderTypeStr(" \u8be2\u6bd4\u4ef7");
                rsp.setSaleOrderType(XbjOrderConstants.SALE_ORDER_TYPE_XBJ.toString());
                rsp.setCreateUserId(xbjDistributionRuleReqBO.getUserId().toString());
                rsp.setCreateUserName(xbjDistributionRuleReqBO.getUserName());
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u67e5\u8be2\u6210\u529f");
                return rsp;
            }
            BeanUtils.copyProperties((Object)orderDistributionXbjPO, (Object)rsp);
            if (orderDistributionXbjPO.getCreateUserId() != null) {
                rsp.setCreateUserId(String.valueOf(orderDistributionXbjPO.getCreateUserId()));
            }
            rsp.setCreateDate(com.cgd.order.util.DateUtil.dateToStrLong(orderDistributionXbjPO.getCreateDate()));
            if (rsp.getApplyOrderType().equals("purchase")) {
                rsp.setApplyOrderTypeStr("\u91c7\u8d2d\u8ba2\u5355");
            } else if (rsp.getApplyOrderType().equals("sale")) {
                rsp.setApplyOrderTypeStr(" \u9500\u552e\u8ba2\u5355");
            }
            if (rsp.getSaleOrderType().equals(XbjOrderConstants.SALE_ORDER_TYPE_XBJ.toString())) {
                rsp.setSaleOrderTypeStr(" \u8be2\u6bd4\u4ef7");
            }
            if (orderDistributionXbjPO.getCreateDate() != null) {
                rsp.setCreateDate(DateUtil.dateToStr((Date)orderDistributionXbjPO.getCreateDate()));
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u67e5\u8be2\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u89c4\u5219\u5931\u8d25\uff1a", (Throwable)e);
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u67e5\u8be2\u89c4\u5219\u5931\u8d25");
            return rsp;
        }
    }

    public RspListInfoBO<XbjDistributionRuleItemBO> qryDistributionRuleItemList(XbjDistributionRuleReqBO xbjDistributionRuleReqBO) {
        if (isDebugEnabled) {
            log.debug("\u5206\u914d\u89c4\u5219\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + xbjDistributionRuleReqBO.toString());
        }
        RspListInfoBO rsp = new RspListInfoBO();
        if (null == xbjDistributionRuleReqBO.getDistributionRuleId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u914d\u89c4\u5219\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u4e2d\u89c4\u5219 ID[DistributionRuleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjDistributionRuleReqBO.getRuleType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u914d\u89c4\u5219\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u4e2d\u89c4\u5219 ID[RuleType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OrderDistributionXbjPO condition = new OrderDistributionXbjPO();
            condition.setProfessionalOrganizationId(xbjDistributionRuleReqBO.getCompanyId());
            OrderDistributionXbjPO orderDistributionXbjPO = this.orderDistributionXbjMapper.getModelBy(condition);
            OrderDistributionItemXbjPO conditionItem = new OrderDistributionItemXbjPO();
            conditionItem.setDistributionRuleId(xbjDistributionRuleReqBO.getDistributionRuleId());
            conditionItem.setRuleType(xbjDistributionRuleReqBO.getRuleType());
            List<OrderDistributionItemXbjPO> list = this.orderDistributionItemXbjMapper.getList(conditionItem);
            if (list == null) {
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u65e0\u5bf9\u5e94\u4e13\u4e1a\u673a\u6784\u5206\u914d\u89c4\u5219");
                return rsp;
            }
            ArrayList<XbjDistributionRuleItemBO> rspList = new ArrayList<XbjDistributionRuleItemBO>();
            for (OrderDistributionItemXbjPO PO : list) {
                XbjDistributionRuleItemBO BO = new XbjDistributionRuleItemBO();
                BeanUtils.copyProperties((Object)PO, (Object)BO);
                SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoReqBO.setUserId(BO.getDeliveryId());
                SelectUserInfoByUserIdRspBO deliveryUserRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                if (deliveryUserRsp != null) {
                    BO.setDeliveryName(deliveryUserRsp.getName());
                }
                if (orderDistributionXbjPO.getRuleType().equals("1")) {
                    QryActInfoByOrgReq qryActInfoByOrgReq = new QryActInfoByOrgReq();
                    qryActInfoByOrgReq.setParamOrgId(BO.getBusiScope());
                    QryActInfoByOrgRsp qryActInfoByOrgRsp = this.qryEffActInfoByOrgBusiService.qryEffActInfoByOrg(qryActInfoByOrgReq);
                    if (qryActInfoByOrgRsp.getRespCode().equals("0000") && qryActInfoByOrgRsp.getAccountInfoBOs().size() > 0) {
                        BO.setBusiScopeName(((AccountInfoBO)qryActInfoByOrgRsp.getAccountInfoBOs().get(0)).getPurchaseUnitName());
                    }
                } else if (orderDistributionXbjPO.getRuleType().equals("2")) {
                    SelectUserInfoByUserIdReqBO userInfoReqBO = new SelectUserInfoByUserIdReqBO();
                    userInfoReqBO.setUserId(BO.getBusiScope());
                    SelectUserInfoByUserIdRspBO userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(userInfoReqBO);
                    BO.setBusiScopeName(userRsp.getName());
                }
                rspList.add(BO);
            }
            rsp.setList(rspList);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5206\u914d\u89c4\u5219\u67e5\u8be2\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u89c4\u5219\u5931\u8d25\uff1a", (Throwable)e);
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u67e5\u8be2\u89c4\u5219\u5931\u8d25");
            return rsp;
        }
    }
}

