/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.busi.XbjSupplierQryGoodsReturnListExpBusiService;
import com.cgd.order.busi.bo.XbjAccessoryRspBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.ReturnItemXbjMapper;
import com.cgd.order.dao.ReturnXbjMapper;
import com.cgd.order.intfce.bo.GoodsReturnRspBO;
import com.cgd.order.intfce.bo.XbjSupplierGoodsReturnReqBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.ReturnItemXbjPO;
import com.cgd.order.po.ReturnXbjPO;
import com.cgd.order.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjSupplierQryGoodsReturnListExpBusiServiceImpl
implements XbjSupplierQryGoodsReturnListExpBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSupplierQryGoodsReturnListExpBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private ReturnXbjMapper returnXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private DicDictionaryService dicDictionaryService;
    private ReturnItemXbjMapper returnItemXbjMapper;
    @Autowired
    AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;

    public void setReturnItemXbjMapper(ReturnItemXbjMapper returnItemXbjMapper) {
        this.returnItemXbjMapper = returnItemXbjMapper;
    }

    public void setReturnXbjMapper(ReturnXbjMapper returnXbjMapper) {
        this.returnXbjMapper = returnXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public RspPageBO<GoodsReturnRspBO> selectGoodsReturnListExp(XbjSupplierGoodsReturnReqBO xbjSupplierGoodsReturnReqBO) {
        this.validateParams(xbjSupplierGoodsReturnReqBO);
        RspPageBO rspPage = new RspPageBO();
        ArrayList<GoodsReturnRspBO> returnList = new ArrayList<GoodsReturnRspBO>();
        Map<String, Object> condition = this.getCondition(xbjSupplierGoodsReturnReqBO);
        if (isDebugEnabled) {
            log.debug("\u67e5\u8be2\u6761\u4ef6\u62fc\u63a5:{}", (Object)condition.toString());
        }
        try {
            List<ReturnXbjPO> returnXbjPOS = this.returnXbjMapper.queryListByConditionWithNoPage(condition);
            for (ReturnXbjPO tmpReturnXbjPO : returnXbjPOS) {
                BigDecimal returnCountFee;
                Long purchaseOrderId = tmpReturnXbjPO.getPurchaseOrderId();
                OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndPurchaserId(purchaseOrderId, tmpReturnXbjPO.getPurchaserId());
                if (orderPurchaseXbjPO == null) {
                    orderPurchaseXbjPO = new OrderPurchaseXbjPO();
                }
                GoodsReturnRspBO tmpGoodsReturnRspBO = new GoodsReturnRspBO();
                tmpGoodsReturnRspBO.setGoodsReturnId(this.Long2String(tmpReturnXbjPO.getGoodsReturnId()));
                Integer returnStatus = tmpReturnXbjPO.getReturnStatus();
                tmpGoodsReturnRspBO.setReturnStatus(returnStatus.intValue());
                Map returnStatusMap = this.dicDictionaryService.getValueByCode("RETURN_STATUS");
                if (returnStatusMap != null) {
                    if (isDebugEnabled) {
                        log.debug("\u67e5\u8be2\u6761\u4ef6\u62fc\u63a5:{" + returnStatus + "}" + returnStatusMap.toString());
                    }
                    tmpGoodsReturnRspBO.setReturnStatusStr((String)returnStatusMap.get(returnStatus.toString()));
                }
                ReturnItemXbjPO returnItemXbjPO = new ReturnItemXbjPO();
                returnItemXbjPO.setGoodsReturnId(tmpReturnXbjPO.getGoodsReturnId());
                returnItemXbjPO.setPurchaserId(tmpReturnXbjPO.getPurchaserId());
                List<ReturnItemXbjPO> listReturnItemXbjPO = this.returnItemXbjMapper.getList(returnItemXbjPO);
                if (null != listReturnItemXbjPO && listReturnItemXbjPO.size() > 0) {
                    returnCountFee = BigDecimal.ZERO;
                    for (ReturnItemXbjPO returnItemXbjPO2 : listReturnItemXbjPO) {
                        returnCountFee = returnCountFee.add(returnItemXbjPO2.getReturnCount().multiply(MoneyUtil.Long2BigDecimal((Long)returnItemXbjPO2.getSellingPrice())));
                    }
                } else {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "[\u9000\u8d27\u5355Id:" + tmpReturnXbjPO.getGoodsReturnId() + ",\u8ba2\u5355Id:" + tmpReturnXbjPO.getPurchaserId() + "]\u5bf9\u5e94\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a\uff01");
                }
                tmpGoodsReturnRspBO.setReturnFeeCount(returnCountFee);
                tmpGoodsReturnRspBO.setInspectionId(String.valueOf(tmpReturnXbjPO.getInspectionId()));
                tmpGoodsReturnRspBO.setInspectionCode(tmpReturnXbjPO.getInspectionCode());
                tmpGoodsReturnRspBO.setReturnContactName(tmpReturnXbjPO.getReturnContactName());
                tmpGoodsReturnRspBO.setReturnContactPhone(tmpReturnXbjPO.getReturnContactPhone());
                tmpGoodsReturnRspBO.setGoodsSupplierId(this.Long2String(tmpReturnXbjPO.getGoodsSupplierId()));
                tmpGoodsReturnRspBO.setPurchaseId(this.Long2String(tmpReturnXbjPO.getPurchaserId()));
                tmpGoodsReturnRspBO.setOrderId(this.Long2String(tmpReturnXbjPO.getSaleOrderId()));
                tmpGoodsReturnRspBO.setOrderCode(tmpReturnXbjPO.getSaleOrderCode());
                tmpGoodsReturnRspBO.setFeeCount(MoneyUtil.Long2BigDecimal((Long)tmpReturnXbjPO.getSaleFeeCount()));
                tmpGoodsReturnRspBO.setPurchaseOrderName(orderPurchaseXbjPO.getPurchaseOrderName());
                tmpGoodsReturnRspBO.setPurchaserName(orderPurchaseXbjPO.getPurchaserName());
                tmpGoodsReturnRspBO.setNeedContactName(orderPurchaseXbjPO.getNeedContactName());
                tmpGoodsReturnRspBO.setNeedContactMobile(orderPurchaseXbjPO.getNeedContactMobile());
                tmpGoodsReturnRspBO.setGoodsReturnCode(tmpReturnXbjPO.getGoodsReturnCode());
                tmpGoodsReturnRspBO.setGoodsSupplierName(orderPurchaseXbjPO.getGoodsSupplierName());
                tmpGoodsReturnRspBO.setCreateTime(DateUtil.dateToStrLong(tmpReturnXbjPO.getCreateTime()));
                tmpGoodsReturnRspBO.setReturnReason(tmpReturnXbjPO.getReturnReason());
                tmpGoodsReturnRspBO.setGoodsReturnId(tmpReturnXbjPO.getGoodsReturnId().toString());
                tmpGoodsReturnRspBO.setIsDispatch(orderPurchaseXbjPO.getIsDispatch() + "");
                tmpGoodsReturnRspBO.setSaleOrderType(orderPurchaseXbjPO.getSaleOrderType() + "");
                tmpGoodsReturnRspBO.setRefuseAccessoryList(this.getAccessoryList(tmpReturnXbjPO.getGoodsReturnId()));
                returnList.add(tmpGoodsReturnRspBO);
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2\u5df2\u7533\u8bf7\u9000\u8d27\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u67e5\u8be2\u5df2\u7533\u8bf7\u9000\u8d27\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01");
        }
        rspPage.setRows(returnList);
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspPage;
    }

    private Map<String, Object> getCondition(XbjSupplierGoodsReturnReqBO xbjSupplierGoodsReturnReqBO) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("orderName", xbjSupplierGoodsReturnReqBO.getOrderName());
        condition.put("returnStatus", xbjSupplierGoodsReturnReqBO.getReturnStatus());
        condition.put("orderCreateStartDate", xbjSupplierGoodsReturnReqBO.getOrderCreateStartDate());
        condition.put("orderCreateEndDate", xbjSupplierGoodsReturnReqBO.getOrderCreateEndDate());
        condition.put("goodsReturnCode", xbjSupplierGoodsReturnReqBO.getGoodsReturnCode());
        condition.put("saleOrderTypes", xbjSupplierGoodsReturnReqBO.getSaleOrderType());
        condition.put("goodsSupplierId", xbjSupplierGoodsReturnReqBO.getGoodsSupplierId());
        condition.put("professionalOrganizationId", xbjSupplierGoodsReturnReqBO.getProfessionalOrganizationId());
        condition.put("purchaseId", xbjSupplierGoodsReturnReqBO.getPurchaserId());
        condition.put("tabId", xbjSupplierGoodsReturnReqBO.getTabId());
        condition.put("returnContactName", xbjSupplierGoodsReturnReqBO.getReturnContactName());
        condition.put("inspectionCode", xbjSupplierGoodsReturnReqBO.getInspectionCode());
        if (xbjSupplierGoodsReturnReqBO.getRoleType().equals("purchase")) {
            condition.put("purchaseId", xbjSupplierGoodsReturnReqBO.getCompanyId());
        } else if (xbjSupplierGoodsReturnReqBO.getRoleType().equals("proOrg")) {
            condition.put("professionalOrganizationId", xbjSupplierGoodsReturnReqBO.getCompanyId());
        } else if (xbjSupplierGoodsReturnReqBO.getRoleType().equals("supplier")) {
            condition.put("goodsSupplierId", xbjSupplierGoodsReturnReqBO.getSupId());
        }
        return condition;
    }

    private String Long2String(Long data) {
        String retStr = "";
        if (data != null) {
            retStr = Long.toString(data);
        }
        return retStr;
    }

    private void validateParams(XbjSupplierGoodsReturnReqBO xbjSupplierGoodsReturnReqBO) {
        if (xbjSupplierGoodsReturnReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<XbjAccessoryRspBO> getAccessoryList(Long returnRefuseId) {
        AccessoryXbjPO accessoryXbjPO = new AccessoryXbjPO();
        accessoryXbjPO.setObjectId(returnRefuseId);
        accessoryXbjPO.setObjectType(XConstant.GOODS_RETURN_REFUSE_OBJECT_TYPE);
        List<Object> accessoryXbjPOlist = new ArrayList();
        ArrayList<XbjAccessoryRspBO> accessoryList = new ArrayList<XbjAccessoryRspBO>();
        try {
            accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(accessoryXbjPO.getObjectId(), accessoryXbjPO.getObjectType());
            if (accessoryXbjPOlist != null) {
                for (AccessoryAtomXbjRspBO accessoryAtomXbjRspBO : accessoryXbjPOlist) {
                    XbjAccessoryRspBO xbjAccessoryRspBO = new XbjAccessoryRspBO();
                    xbjAccessoryRspBO.setAccessoryName(accessoryAtomXbjRspBO.getAccessoryName());
                    xbjAccessoryRspBO.setAccessoryId(accessoryAtomXbjRspBO.getId());
                    xbjAccessoryRspBO.setAccessoryUrl(accessoryAtomXbjRspBO.getAccessoryUrl());
                    accessoryList.add(xbjAccessoryRspBO);
                }
            }
            return accessoryList;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u62d2\u7edd\u9000\u8d27\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u62d2\u7edd\u9000\u8d27\u9644\u4ef6\u5f02\u5e38\uff01");
        }
    }
}

