/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspListInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderFlowSheetXbjMapper;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.ReturnXbjMapper;
import com.cgd.order.intfce.XbjQryOrderFlowSheetCommentsIntfceService;
import com.cgd.order.intfce.bo.XbjQryOrderFlowSheetCommentsReqBO;
import com.cgd.order.intfce.bo.XbjQryOrderFlowSheetCommentsRspBO;
import com.cgd.order.intfce.bo.XbjTaskCommentRspBO;
import com.cgd.order.po.OrderFlowSheetXbjPO;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.ReturnXbjPO;
import com.cgd.user.org.busi.QryOrgUpByIDService;
import com.cgd.user.org.busi.bo.QryOrgUpByIDReqBO;
import com.cgd.user.org.busi.bo.QryOrgUpByIDRspBO;
import com.cgd.workflow.bo.NextTasksAndUsersRspBO;
import com.cgd.workflow.bo.QryHistoryCommentsReqBO;
import com.cgd.workflow.bo.QryNextOperateUserReqBO;
import com.cgd.workflow.bo.QueryHistoryCommentsRspBO;
import com.cgd.workflow.bo.TaskCommentRspBO;
import com.cgd.workflow.busin.service.QryNextOperateUserBusinService;
import com.cgd.workflow.busin.service.QueryHistoryCommentsBusinService;
import com.cgd.workflow.busin.service.QueryToTaskBusinService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderFlowSheetCommentsIntfceServiceImpl
implements XbjQryOrderFlowSheetCommentsIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderFlowSheetCommentsIntfceServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderFlowSheetXbjMapper orderFlowSheetXbjMapper;
    private QueryHistoryCommentsBusinService queryHistoryCommentsBusinService;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private ReturnXbjMapper returnXbjMapper;
    @Autowired
    OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    @Autowired
    QueryToTaskBusinService queryToTaskBusinService;
    @Autowired
    QryNextOperateUserBusinService qryNextOperateUserBusinService;
    @Autowired
    OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    QryOrgUpByIDService qryOrgUpByIDService;

    public void setOrderFlowSheetXbjMapper(OrderFlowSheetXbjMapper orderFlowSheetXbjMapper) {
        this.orderFlowSheetXbjMapper = orderFlowSheetXbjMapper;
    }

    public void setQueryHistoryCommentsBusinService(QueryHistoryCommentsBusinService queryHistoryCommentsBusinService) {
        this.queryHistoryCommentsBusinService = queryHistoryCommentsBusinService;
    }

    public RspListInfoBO<XbjQryOrderFlowSheetCommentsRspBO> qryOrderFlowSheetComments(XbjQryOrderFlowSheetCommentsReqBO xbjQryOrderFlowSheetCommentsReqBO) {
        ArrayList<XbjQryOrderFlowSheetCommentsRspBO> XbjQryOrderFlowSheetCommentsRspBOList;
        this.validateBOData(xbjQryOrderFlowSheetCommentsReqBO);
        if (isDebugEnabled) {
            log.debug("\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1\u5165\u53c2" + xbjQryOrderFlowSheetCommentsReqBO);
        }
        RspListInfoBO resultRspListInfoBO = new RspListInfoBO();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("purchaserId", xbjQryOrderFlowSheetCommentsReqBO.getPurchaserId());
        condition.put("orderType", xbjQryOrderFlowSheetCommentsReqBO.getOrderType());
        ArrayList<Long> orderIds = new ArrayList<Long>();
        orderIds.add(xbjQryOrderFlowSheetCommentsReqBO.getOrderId());
        OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
        try {
            if (OrderCenterConstant.ORDER_TYPE.SALE.equals(xbjQryOrderFlowSheetCommentsReqBO.getOrderType())) {
                orderSaleXbjPO.setSaleOrderId(xbjQryOrderFlowSheetCommentsReqBO.getOrderId());
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                if (orderSaleXbjPO == null) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
                }
                orderIds.add(orderSaleXbjPO.getPurchaseOrderId());
                ReturnXbjPO returnPO = new ReturnXbjPO();
                returnPO.setSaleOrderId(xbjQryOrderFlowSheetCommentsReqBO.getOrderId());
                List<ReturnXbjPO> returnPOList = this.returnXbjMapper.getList(returnPO);
                if (returnPOList != null && returnPOList.size() > 0) {
                    for (ReturnXbjPO po : returnPOList) {
                        orderIds.add(po.getGoodsReturnId());
                    }
                }
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u670d\u52a1\u5f02\u5e38");
        }
        condition.put("orderIds", orderIds);
        List<OrderFlowSheetXbjPO> orderFlowSheetXbjPOList = this.orderFlowSheetXbjMapper.selectOrderFlowSheetByCond(condition);
        if (orderFlowSheetXbjPOList != null && orderFlowSheetXbjPOList.size() > 0) {
            XbjQryOrderFlowSheetCommentsRspBO xbjQryNextFlowInfoBO;
            OrderFlowSheetXbjPO orderFlowSheetXbjPO2;
            XbjQryOrderFlowSheetCommentsRspBOList = new ArrayList<XbjQryOrderFlowSheetCommentsRspBO>();
            for (OrderFlowSheetXbjPO orderFlowSheetXbjPO2 : orderFlowSheetXbjPOList) {
                XbjQryOrderFlowSheetCommentsRspBO xbjQryOrderFlowSheetCommentsRspBO = new XbjQryOrderFlowSheetCommentsRspBO();
                this.validateRspBOData(orderFlowSheetXbjPO2, xbjQryOrderFlowSheetCommentsRspBO);
                if (orderFlowSheetXbjPO2.getProCode() != null && orderFlowSheetXbjPO2.getProCode() > 0L) {
                    QryHistoryCommentsReqBO qryHistoryCommentsReqBO = new QryHistoryCommentsReqBO();
                    qryHistoryCommentsReqBO.setProcInstId(String.valueOf(orderFlowSheetXbjPO2.getProCode()));
                    QueryHistoryCommentsRspBO queryHistoryCommentsRspBO = this.queryHistoryCommentsBusinService.queryHistoryComments(qryHistoryCommentsReqBO);
                    if (queryHistoryCommentsRspBO != null && queryHistoryCommentsRspBO.getTaskCommentRspBOs() != null && queryHistoryCommentsRspBO.getTaskCommentRspBOs().size() > 0) {
                        ArrayList<XbjTaskCommentRspBO> xbjTaskCommentRspBOList = new ArrayList<XbjTaskCommentRspBO>();
                        for (TaskCommentRspBO workFlowTaskCommentRspBO : queryHistoryCommentsRspBO.getTaskCommentRspBOs()) {
                            XbjTaskCommentRspBO xbjTaskCommentRspBO = new XbjTaskCommentRspBO();
                            BeanUtils.copyProperties((Object)workFlowTaskCommentRspBO, (Object)xbjTaskCommentRspBO);
                            xbjTaskCommentRspBOList.add(xbjTaskCommentRspBO);
                        }
                        xbjQryOrderFlowSheetCommentsRspBO.setTaskCommentRspBOs(xbjTaskCommentRspBOList);
                    }
                }
                XbjQryOrderFlowSheetCommentsRspBOList.add(xbjQryOrderFlowSheetCommentsRspBO);
            }
            if (XConstant.SALE_ORDER_STATE_TO_EXAMINE.equals(orderSaleXbjPO.getSaleOrderStatus())) {
                xbjQryNextFlowInfoBO = new XbjQryOrderFlowSheetCommentsRspBO();
                xbjQryNextFlowInfoBO.setBusiType("\u8ba2\u5355\u5ba1\u6279");
                xbjQryNextFlowInfoBO.setBusiName("-");
                if (orderSaleXbjPO.getSaleOrderMoney() > XbjOrderConstants.SALE_ORDER_PRICE) {
                    xbjQryNextFlowInfoBO.setPost("\u5206\u5b50\u516c\u53f8\u91c7\u8d2d\u4e1a\u52a1\u4e3b\u7ba1");
                    QryOrgUpByIDReqBO qryOrgUpByIDReqBO = new QryOrgUpByIDReqBO();
                    qryOrgUpByIDReqBO.setAutoId(orderSaleXbjPO.getPurchaserId());
                    QryOrgUpByIDRspBO idBO = this.qryOrgUpByIDService.qryOrgUpByID(qryOrgUpByIDReqBO);
                    if (idBO == null) {
                        throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", idBO.getRespDesc());
                    }
                    log.error("\u8c03\u7528\u5de5\u4f5c\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u6d41\u51fa\u53c2:" + JSON.toJSONString((Object)idBO));
                    xbjQryNextFlowInfoBO.setOperCompName(idBO.getTitle());
                } else {
                    xbjQryNextFlowInfoBO.setPost("\u5ba1\u6838\u5458");
                    xbjQryNextFlowInfoBO.setOperCompName(orderSaleXbjPO.getProfessionalOrganizationName());
                }
                xbjQryNextFlowInfoBO.setOperName(this.getNextFlowUsers(orderSaleXbjPO.getSaleOrderId(), "50"));
                orderFlowSheetXbjPO2 = this.getLastRecode(xbjQryOrderFlowSheetCommentsReqBO.getOrderId(), xbjQryOrderFlowSheetCommentsReqBO.getOrderType());
                if (orderFlowSheetXbjPO2 != null) {
                    xbjQryNextFlowInfoBO.setArriveTime(orderFlowSheetXbjPO2.getOperTime());
                }
                XbjQryOrderFlowSheetCommentsRspBOList.add(xbjQryNextFlowInfoBO);
            } else if (XConstant.SALE_ORDER_STATE_RECHECK.equals(orderSaleXbjPO.getSaleOrderStatus())) {
                xbjQryNextFlowInfoBO = new XbjQryOrderFlowSheetCommentsRspBO();
                xbjQryNextFlowInfoBO.setBusiType("\u8ba2\u5355\u590d\u6838");
                xbjQryNextFlowInfoBO.setBusiName("-");
                if (XbjOrderConstants.IS_DISPATCH_NO.equals(orderSaleXbjPO.getIsDispatch())) {
                    xbjQryNextFlowInfoBO.setPost("\u5ba1\u6838\u5458");
                } else if (XbjOrderConstants.IS_DISPATCH_YES.equals(orderSaleXbjPO.getIsDispatch())) {
                    xbjQryNextFlowInfoBO.setPost("\u914d\u9001\u7ecf\u7406");
                }
                xbjQryNextFlowInfoBO.setOperCompName(orderSaleXbjPO.getProfessionalOrganizationName());
                xbjQryNextFlowInfoBO.setOperName(this.getNextFlowUsers(orderSaleXbjPO.getSaleOrderId(), "51"));
                orderFlowSheetXbjPO2 = this.getLastRecode(xbjQryOrderFlowSheetCommentsReqBO.getOrderId(), xbjQryOrderFlowSheetCommentsReqBO.getOrderType());
                if (orderFlowSheetXbjPO2 != null) {
                    xbjQryNextFlowInfoBO.setArriveTime(orderFlowSheetXbjPO2.getOperTime());
                }
                XbjQryOrderFlowSheetCommentsRspBOList.add(xbjQryNextFlowInfoBO);
            } else {
                OrderPurchaseXbjPO orderPurchaseXbjPO = null;
                try {
                    orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelById(orderSaleXbjPO.getPurchaseOrderId());
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38");
                }
                if (orderPurchaseXbjPO != null && XbjOrderConstants.PURCHASE_ORDER_MAINTAIN_APPROVING.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
                    XbjQryOrderFlowSheetCommentsRspBO xbjQryNextFlowInfoBO2 = new XbjQryOrderFlowSheetCommentsRspBO();
                    xbjQryNextFlowInfoBO2.setBusiType("\u8ba2\u5355\u7ef4\u62a4\u5f85\u5ba1\u6279");
                    xbjQryNextFlowInfoBO2.setBusiName("-");
                    xbjQryNextFlowInfoBO2.setPost("\u914d\u9001\u7ecf\u7406");
                    xbjQryNextFlowInfoBO2.setOperCompName(orderSaleXbjPO.getProfessionalOrganizationName());
                    xbjQryNextFlowInfoBO2.setOperName(this.getNextFlowUsers(orderSaleXbjPO.getSaleOrderId(), "51"));
                    OrderFlowSheetXbjPO orderFlowSheetXbjPO3 = this.getLastRecode(xbjQryOrderFlowSheetCommentsReqBO.getOrderId(), xbjQryOrderFlowSheetCommentsReqBO.getOrderType());
                    if (orderFlowSheetXbjPO3 != null) {
                        xbjQryNextFlowInfoBO2.setArriveTime(orderFlowSheetXbjPO3.getOperTime());
                    }
                    XbjQryOrderFlowSheetCommentsRspBOList.add(xbjQryNextFlowInfoBO2);
                }
            }
        } else {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u7684\u6d41\u7a0b\u8bb0\u5f55\u4e3a\u7a7a");
        }
        resultRspListInfoBO.setList(XbjQryOrderFlowSheetCommentsRspBOList);
        resultRspListInfoBO.setRespCode("0000");
        resultRspListInfoBO.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u6210\u529f");
        return resultRspListInfoBO;
    }

    private void validateRspBOData(OrderFlowSheetXbjPO orderFlowSheetXbjPO, XbjQryOrderFlowSheetCommentsRspBO xbjQryOrderFlowSheetCommentsRspBO) {
        xbjQryOrderFlowSheetCommentsRspBO.setId(String.valueOf(orderFlowSheetXbjPO.getId()));
        xbjQryOrderFlowSheetCommentsRspBO.setPurchaserId(String.valueOf(orderFlowSheetXbjPO.getPurchaserId()));
        xbjQryOrderFlowSheetCommentsRspBO.setPurchaserAccountId(String.valueOf(orderFlowSheetXbjPO.getPurchaserAccountId()));
        xbjQryOrderFlowSheetCommentsRspBO.setProfessionalOrganizationId(String.valueOf(orderFlowSheetXbjPO.getProfessionalOrganizationId()));
        xbjQryOrderFlowSheetCommentsRspBO.setGoodsSupplierId(String.valueOf(orderFlowSheetXbjPO.getGoodsSupplierId()));
        xbjQryOrderFlowSheetCommentsRspBO.setOrderId(String.valueOf(orderFlowSheetXbjPO.getOrderId()));
        xbjQryOrderFlowSheetCommentsRspBO.setOrderType(orderFlowSheetXbjPO.getOrderType());
        xbjQryOrderFlowSheetCommentsRspBO.setOperTime(orderFlowSheetXbjPO.getOperTime());
        xbjQryOrderFlowSheetCommentsRspBO.setOperName(orderFlowSheetXbjPO.getOperName());
        xbjQryOrderFlowSheetCommentsRspBO.setOperDeptName(orderFlowSheetXbjPO.getOperDeptName());
        xbjQryOrderFlowSheetCommentsRspBO.setOperCompName(orderFlowSheetXbjPO.getOperCompName());
        xbjQryOrderFlowSheetCommentsRspBO.setOperId(String.valueOf(orderFlowSheetXbjPO.getOperId()));
        xbjQryOrderFlowSheetCommentsRspBO.setOperDeptId(String.valueOf(orderFlowSheetXbjPO.getOperDeptId()));
        xbjQryOrderFlowSheetCommentsRspBO.setOperCompId(String.valueOf(orderFlowSheetXbjPO.getOperCompId()));
        Map valueByCode = this.dicDictionaryService.getValueByCode("ORDER_BUSI_TYPE");
        if (valueByCode != null) {
            String busiTypeStr = (String)valueByCode.get(orderFlowSheetXbjPO.getBusiType());
            if (busiTypeStr != null && !"".equals(busiTypeStr)) {
                xbjQryOrderFlowSheetCommentsRspBO.setBusiType(busiTypeStr);
            } else {
                xbjQryOrderFlowSheetCommentsRspBO.setBusiType(orderFlowSheetXbjPO.getBusiType());
            }
        }
        xbjQryOrderFlowSheetCommentsRspBO.setBusiName(orderFlowSheetXbjPO.getBusiName());
        xbjQryOrderFlowSheetCommentsRspBO.setProCode(String.valueOf(orderFlowSheetXbjPO.getProCode()));
        xbjQryOrderFlowSheetCommentsRspBO.setArriveTime(orderFlowSheetXbjPO.getArriveTime());
        xbjQryOrderFlowSheetCommentsRspBO.setPost(orderFlowSheetXbjPO.getOperRole());
        xbjQryOrderFlowSheetCommentsRspBO.setOperReamrk(orderFlowSheetXbjPO.getOperReamrk());
    }

    private void validateBOData(XbjQryOrderFlowSheetCommentsReqBO xbjQryOrderFlowSheetCommentsReqBO) {
        if (null == xbjQryOrderFlowSheetCommentsReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQryOrderFlowSheetCommentsReqBO.getOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQryOrderFlowSheetCommentsReqBO.getOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQryOrderFlowSheetCommentsReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u91c7\u8d2d\u5355\u4f4dID[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String getNextFlowUsers(Long saleOrderId, String busiType) {
        String resultName = "";
        OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
        process.setOrderId(saleOrderId);
        process.setBusiType(busiType);
        process.setProcessStatus("0");
        try {
            process = this.orderProcessCodeXbjMapper.getModelBy(process);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u6d41\u7a0b\u5173\u7cfb\u8868\u5f02\u5e38", (Throwable)e);
        }
        if (process != null) {
            String taskId = this.queryToTaskBusinService.queryToDoTasksByProcInstId(process.getProcessCode());
            log.error("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u67e5\u8be2\u4efb\u52a1ID\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)taskId));
            if (!"".equals(taskId) && taskId != null) {
                List userMap;
                QryNextOperateUserReqBO qryNextOperateUserReqBO = new QryNextOperateUserReqBO();
                qryNextOperateUserReqBO.setTaskId(taskId);
                log.error("\u67e5\u8be2\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5165\u53c2\uff1a" + taskId);
                NextTasksAndUsersRspBO nextTasksAndUsersRspBO = this.qryNextOperateUserBusinService.qryNextOperateUser(qryNextOperateUserReqBO);
                log.error("\u67e5\u8be2\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)nextTasksAndUsersRspBO));
                if (nextTasksAndUsersRspBO != null && (userMap = nextTasksAndUsersRspBO.getUserInfos()).size() > 0) {
                    for (int i = 0; i < userMap.size(); ++i) {
                        Map mapTmp = (Map)userMap.get(i);
                        resultName = resultName + mapTmp.get("name");
                        if (i >= userMap.size() - 1) continue;
                        resultName = resultName + ",";
                    }
                }
            }
        }
        return resultName;
    }

    private OrderFlowSheetXbjPO getLastRecode(Long orderId, Integer orderType) {
        OrderSaleXbjPO orderSaleXbjPO;
        OrderFlowSheetXbjPO orderFlowSheetXbjPO = null;
        HashMap<String, Object> condition = new HashMap<String, Object>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        orderIds.add(orderId);
        if (OrderCenterConstant.ORDER_TYPE.SALE.equals(orderType)) {
            orderSaleXbjPO = new OrderSaleXbjPO();
            orderSaleXbjPO.setSaleOrderId(orderId);
            try {
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38");
            }
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
            }
            orderIds.add(orderSaleXbjPO.getPurchaseOrderId());
        } else if (OrderCenterConstant.ORDER_TYPE.PURCHASE.equals(orderType)) {
            orderSaleXbjPO = new OrderSaleXbjPO();
            orderSaleXbjPO.setPurchaseOrderId(orderId);
            try {
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38");
            }
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
            }
            orderIds.add(orderSaleXbjPO.getSaleOrderId());
        }
        condition.put("orderIds", orderIds);
        List<OrderFlowSheetXbjPO> orderFlowSheetXbjPOList = this.orderFlowSheetXbjMapper.selectOrderFlowSheetByCond(condition);
        if (orderFlowSheetXbjPOList != null && orderFlowSheetXbjPOList.size() > 0) {
            orderFlowSheetXbjPO = orderFlowSheetXbjPOList.get(0);
            return orderFlowSheetXbjPO;
        }
        return orderFlowSheetXbjPO;
    }
}

