/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.dao.OrderAfterSaleXbjMapper;
import com.cgd.order.dao.OrderFlowSheetXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderAfterSaleXbjPO;
import com.cgd.order.po.OrderFlowSheetXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjCreateOrderFlowSheetAtomServiceImpl
implements XbjCreateOrderFlowSheetAtomService {
    private static final Logger log = LoggerFactory.getLogger(XbjCreateOrderFlowSheetAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderFlowSheetXbjMapper orderFlowSheetXbjMapper;
    @Autowired
    private OrderAfterSaleXbjMapper orderAfterSaleXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderFlowSheetXbjMapper(OrderFlowSheetXbjMapper orderFlowSheetXbjMapper) {
        this.orderFlowSheetXbjMapper = orderFlowSheetXbjMapper;
    }

    public void setOrderAfterSaleXbjMapper(OrderAfterSaleXbjMapper orderAfterSaleXbjMapper) {
        this.orderAfterSaleXbjMapper = orderAfterSaleXbjMapper;
    }

    @Override
    public XbjOrderFlowSheetRspBO createOrderFlowSheet(XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + xbjOrderFlowSheetReqBO.toString());
        }
        XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO = new XbjOrderFlowSheetRspBO();
        xbjOrderFlowSheetRspBO.setRespCode("0000");
        xbjOrderFlowSheetRspBO.setRespDesc("\u6210\u529f");
        try {
            String busiName;
            Map<String, String> purchaserOrderMode;
            if (null == xbjOrderFlowSheetReqBO.getOrderId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8ba2\u5355Id[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == xbjOrderFlowSheetReqBO.getPurchaserId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1PurchaserId[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == xbjOrderFlowSheetReqBO.getOrderType()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == xbjOrderFlowSheetReqBO.getOrderBusiType() || "".equals(xbjOrderFlowSheetReqBO.getOrderBusiType())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u7c7b\u578b[busiType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderFlowSheetXbjPO xbjOrderFlowSheet = new OrderFlowSheetXbjPO();
            xbjOrderFlowSheet.setOrderId(xbjOrderFlowSheetReqBO.getOrderId());
            xbjOrderFlowSheet.setOrderType(xbjOrderFlowSheetReqBO.getOrderType());
            if (xbjOrderFlowSheetReqBO.getOrgId() != null) {
                xbjOrderFlowSheet.setOperDeptId(xbjOrderFlowSheetReqBO.getOrgId());
            }
            if (xbjOrderFlowSheetReqBO.getOrgName() != null && !"".equals(xbjOrderFlowSheetReqBO.getOrgName())) {
                xbjOrderFlowSheet.setOperDeptName(xbjOrderFlowSheetReqBO.getOrgName());
            }
            if (xbjOrderFlowSheetReqBO.getUserName() != null && !"".equals(xbjOrderFlowSheetReqBO.getUserName())) {
                xbjOrderFlowSheet.setOperName(xbjOrderFlowSheetReqBO.getUserName());
            }
            if (xbjOrderFlowSheetReqBO.getCompanyId() != null) {
                xbjOrderFlowSheet.setOperCompId(xbjOrderFlowSheetReqBO.getCompanyId());
            }
            if (xbjOrderFlowSheetReqBO.getCompanyName() != null && !"".equals(xbjOrderFlowSheetReqBO.getCompanyName())) {
                xbjOrderFlowSheet.setOperCompName(xbjOrderFlowSheetReqBO.getCompanyName());
            }
            if (xbjOrderFlowSheetReqBO.getUserId() != null) {
                xbjOrderFlowSheet.setOperId(xbjOrderFlowSheetReqBO.getUserId());
            }
            if (!StringUtils.isEmpty((CharSequence)xbjOrderFlowSheetReqBO.getOperRemark())) {
                xbjOrderFlowSheet.setOperReamrk(xbjOrderFlowSheetReqBO.getOperRemark());
            }
            if (!StringUtils.isEmpty((CharSequence)xbjOrderFlowSheetReqBO.getOperRole())) {
                xbjOrderFlowSheet.setOperRole(xbjOrderFlowSheetReqBO.getOperRole());
            }
            if (!("B_19".equals(xbjOrderFlowSheetReqBO.getOrderBusiType()) || "B_18".equals(xbjOrderFlowSheetReqBO.getOrderBusiType()) || "B_8".equals(xbjOrderFlowSheetReqBO.getOrderBusiType()))) {
                if (xbjOrderFlowSheetReqBO.getArriveTime() != null) {
                    xbjOrderFlowSheet.setArriveTime(xbjOrderFlowSheetReqBO.getArriveTime());
                } else {
                    OrderSaleXbjPO orderSaleXbjPO;
                    HashMap<String, Object> condition = new HashMap<String, Object>();
                    ArrayList<Long> orderIds = new ArrayList<Long>();
                    orderIds.add(xbjOrderFlowSheetReqBO.getOrderId());
                    if (OrderCenterConstant.ORDER_TYPE.SALE.equals(xbjOrderFlowSheetReqBO.getOrderType())) {
                        orderSaleXbjPO = new OrderSaleXbjPO();
                        orderSaleXbjPO.setSaleOrderId(xbjOrderFlowSheetReqBO.getOrderId());
                        orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                        if (orderSaleXbjPO == null) {
                            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
                        }
                        orderIds.add(orderSaleXbjPO.getPurchaseOrderId());
                    } else if (OrderCenterConstant.ORDER_TYPE.PURCHASE.equals(xbjOrderFlowSheetReqBO.getOrderType())) {
                        orderSaleXbjPO = new OrderSaleXbjPO();
                        orderSaleXbjPO.setPurchaseOrderId(xbjOrderFlowSheetReqBO.getOrderId());
                        orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                        if (orderSaleXbjPO == null) {
                            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6d41\u7a0b\u8bb0\u5f55\u548c\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u7ec4\u5408\u670d\u52a1 \u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
                        }
                        orderIds.add(orderSaleXbjPO.getSaleOrderId());
                    }
                    condition.put("orderIds", orderIds);
                    List<OrderFlowSheetXbjPO> orderFlowSheetXbjPOList = this.orderFlowSheetXbjMapper.selectOrderFlowSheetByCond(condition);
                    if (orderFlowSheetXbjPOList != null && orderFlowSheetXbjPOList.size() > 0) {
                        OrderFlowSheetXbjPO orderFlowSheetXbjPO = orderFlowSheetXbjPOList.get(0);
                        xbjOrderFlowSheet.setArriveTime(orderFlowSheetXbjPO.getOperTime());
                    }
                }
            }
            if (Constant.ORDER_TYPE_SALE == xbjOrderFlowSheetReqBO.getOrderType()) {
                OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO = this.queryOrderSale(xbjOrderFlowSheetReqBO);
                if (xbjOrderSaleInfoRspBO != null) {
                    xbjOrderFlowSheet.setProfessionalOrganizationId(xbjOrderSaleInfoRspBO.getProfessionalOrganizationId());
                    xbjOrderFlowSheet.setPurchaserAccountId(xbjOrderSaleInfoRspBO.getPurchaserAccountId());
                    xbjOrderFlowSheet.setPurchaserId(xbjOrderSaleInfoRspBO.getPurchaserId());
                    xbjOrderFlowSheet.setGoodsSupplierId(xbjOrderSaleInfoRspBO.getGoodsSupplierId());
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636esaleOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
            if (Constant.ORDER_TYPE_PURCHASE == xbjOrderFlowSheetReqBO.getOrderType()) {
                OrderPurchaseXbjPO xbjOrderPurchase = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndPurchaserId(xbjOrderFlowSheetReqBO.getOrderId(), xbjOrderFlowSheetReqBO.getPurchaserId());
                if (xbjOrderPurchase != null) {
                    xbjOrderFlowSheet.setProfessionalOrganizationId(xbjOrderPurchase.getProfessionalOrganizationId());
                    xbjOrderFlowSheet.setPurchaserAccountId(xbjOrderPurchase.getPurchaserAccountId());
                    xbjOrderFlowSheet.setPurchaserId(xbjOrderPurchase.getPurchaserId());
                    xbjOrderFlowSheet.setGoodsSupplierId(xbjOrderPurchase.getGoodsSupplierId());
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636epurchaseOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
            if (Constant.ORDER_TYPE_AFTER == xbjOrderFlowSheetReqBO.getOrderType()) {
                OrderAfterSaleXbjPO xbjOrderAfterSale = this.orderAfterSaleXbjMapper.selectOrderAfterSaleByServiceId(xbjOrderFlowSheetReqBO.getOrderId(), xbjOrderFlowSheetReqBO.getPurchaserId());
                if (xbjOrderAfterSale != null) {
                    xbjOrderFlowSheet.setProfessionalOrganizationId(xbjOrderAfterSale.getProfessionalOrganizationId());
                    xbjOrderFlowSheet.setPurchaserAccountId(xbjOrderAfterSale.getPurchaserAccountId());
                    xbjOrderFlowSheet.setPurchaserId(xbjOrderAfterSale.getPurchaserId());
                    xbjOrderFlowSheet.setGoodsSupplierId(xbjOrderAfterSale.getGoodsSupplierId());
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u670d\u52a1\u5355\u53f7ID\u3001\u91c7\u8d2d\u5355\u4f4dID \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
            if ((purchaserOrderMode = this.queryValueByCode("ORDER_BUSINESS_TYPE")) != null) {
                busiName = purchaserOrderMode.get(xbjOrderFlowSheetReqBO.getOrderBusiType());
                if (busiName == null || "".equals(busiName)) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u6570\u636e\u5b57\u5178code\u83b7\u53d6title\u6570\u636e\u4e3a\u7a7a");
                }
            } else {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u6570\u636e\u5b57\u5178\u6570\u636e\u4e3a\u7a7a");
            }
            xbjOrderFlowSheet.setBusiType(xbjOrderFlowSheetReqBO.getOrderBusiType());
            xbjOrderFlowSheet.setBusiName(busiName);
            if (xbjOrderFlowSheetReqBO.getProCode() != null) {
                xbjOrderFlowSheet.setProCode(xbjOrderFlowSheetReqBO.getProCode());
            }
            xbjOrderFlowSheet.setOperTime(new Date());
            int count = this.orderFlowSheetXbjMapper.insertSelective(xbjOrderFlowSheet);
            if (count == 1) {
                xbjOrderFlowSheetRspBO.setIsSuccess(Boolean.valueOf(true));
                xbjOrderFlowSheetRspBO.setRespCode("0000");
                xbjOrderFlowSheetRspBO.setRespDesc("\u6210\u529f");
                return xbjOrderFlowSheetRspBO;
            }
            xbjOrderFlowSheetRspBO.setIsSuccess(Boolean.valueOf(false));
            xbjOrderFlowSheetRspBO.setRespCode("8888");
            xbjOrderFlowSheetRspBO.setRespDesc("\u5931\u8d25");
            return xbjOrderFlowSheetRspBO;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            xbjOrderFlowSheetRspBO.setIsSuccess(Boolean.valueOf(false));
            xbjOrderFlowSheetRspBO.setRespCode("8888");
            xbjOrderFlowSheetRspBO.setRespDesc("\u5931\u8d25");
            return xbjOrderFlowSheetRspBO;
        }
    }

    private Map<String, String> queryValueByCode(String pCode) {
        try {
            Map purchaserOrderMode = this.dicDictionaryService.getValueByCode(pCode);
            return purchaserOrderMode;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25");
        }
    }

    private OrderSaleInfoXbjRspBO queryOrderSale(XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO) {
        try {
            OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO = this.orderSaleXbjAtomService.selectOrderSaleById(xbjOrderFlowSheetReqBO.getOrderId(), xbjOrderFlowSheetReqBO.getPurchaserId());
            return xbjOrderSaleInfoRspBO;
        }
        catch (Exception e) {
            log.error("\u6839\u636esaleOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u5bf9\u8c61\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6839\u636esaleOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u5bf9\u8c61\u670d\u52a1\u5931\u8d25");
        }
    }
}

