/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.OrderSaleSelectXbjAtomService;
import com.cgd.order.atom.bo.SaleOrderXbjReqBO;
import com.cgd.order.busi.CheckSaleOrderConfirmService;
import com.cgd.order.busi.CheckWhetherShipAllService;
import com.cgd.order.busi.bo.CheckSaleOrderConfirmReqBO;
import com.cgd.order.busi.bo.CheckSaleOrderConfirmRspBO;
import com.cgd.order.busi.bo.CheckWhetherShipAllReqBO;
import com.cgd.order.busi.bo.CheckWhetherShipAllRspBO;
import com.cgd.order.busi.bo.ItemYanbaoRspBO;
import com.cgd.order.busi.bo.SaleOrderItemRspBO;
import com.cgd.order.busi.bo.SaleOrderRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.ElcSupplierInfoXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.po.ElcSupplierInfoXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import com.cgd.order.util.DateUtil;
import com.cgd.user.supplier.busi.TsupplierInfoBusiService;
import com.cgd.user.supplier.busi.bo.QrySupplierInfoMapByIdsReqBO;
import com.cgd.workflow.bo.QryHistoryCommentsReqBO;
import com.cgd.workflow.bo.QueryHistoryCommentsRspBO;
import com.cgd.workflow.busin.service.QueryHistoryCommentsBusinService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSaleSelectXbjAtomServiceImpl
implements OrderSaleSelectXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleSelectXbjAtomServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleMapper;
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusMapper;
    private DicDictionaryService dicDictionaryService;
    private QueryHistoryCommentsBusinService queryHistoryCommentsBusinService;
    private ElcSupplierInfoXbjMapper elcSupplierInfoMapper;
    private TsupplierInfoBusiService tsupplierInfoBusiService;
    private PermissionCacheService permissionCacheService;
    private OrderProtocolItemXbjMapper orderProtocolItemMapper;
    private CheckWhetherShipAllService checkWhetherShipAllService;
    private CheckSaleOrderConfirmService checkSaleOrderConfirmService;

    public void setOrderSaleMapper(OrderSaleXbjMapper orderSaleMapper) {
        this.orderSaleMapper = orderSaleMapper;
    }

    public void setOrderTabMappingOrderStatusMapper(OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusMapper) {
        this.orderTabMappingOrderStatusMapper = orderTabMappingOrderStatusMapper;
    }

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setQueryHistoryCommentsBusinService(QueryHistoryCommentsBusinService queryHistoryCommentsBusinService) {
        this.queryHistoryCommentsBusinService = queryHistoryCommentsBusinService;
    }

    public void setElcSupplierInfoMapper(ElcSupplierInfoXbjMapper elcSupplierInfoMapper) {
        this.elcSupplierInfoMapper = elcSupplierInfoMapper;
    }

    public void setTsupplierInfoBusiService(TsupplierInfoBusiService tsupplierInfoBusiService) {
        this.tsupplierInfoBusiService = tsupplierInfoBusiService;
    }

    public void setPermissionCacheService(PermissionCacheService permissionCacheService) {
        this.permissionCacheService = permissionCacheService;
    }

    public void setOrderProtocolItemMapper(OrderProtocolItemXbjMapper orderProtocolItemMapper) {
        this.orderProtocolItemMapper = orderProtocolItemMapper;
    }

    public void setCheckWhetherShipAllService(CheckWhetherShipAllService checkWhetherShipAllService) {
        this.checkWhetherShipAllService = checkWhetherShipAllService;
    }

    public void setCheckSaleOrderConfirmService(CheckSaleOrderConfirmService checkSaleOrderConfirmService) {
        this.checkSaleOrderConfirmService = checkSaleOrderConfirmService;
    }

    @Override
    public RspPageBO<SaleOrderRspBO> selectSaleOrder(SaleOrderXbjReqBO saleOrderReq) {
        Page page = new Page(saleOrderReq.getPageNo(), saleOrderReq.getPageSize());
        Integer tabId = saleOrderReq.getTabId();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("saleOrderType", saleOrderReq.getSaleOrderType());
        condition.put("saleOrderCode", StringUtils.trimToNull((String)saleOrderReq.getSaleOrderCode()));
        condition.put("skuName", StringUtils.trimToNull((String)saleOrderReq.getSkuName()));
        condition.put("receiverName", StringUtils.trimToNull((String)saleOrderReq.getReceiverName()));
        condition.put("saleOrderCreateStartTime", saleOrderReq.getSaleOrderCreateStartTime());
        condition.put("saleOrderCreateEndTime", saleOrderReq.getSaleOrderCreateEndTime());
        condition.put("saleOrderStatus", saleOrderReq.getSaleOrderStatus());
        condition.put("extOrderId", StringUtils.trimToNull((String)saleOrderReq.getExtOrderId()));
        condition.put("purchaserAccount", saleOrderReq.getPurchaserAccount());
        condition.put("isSelectChild", saleOrderReq.getIsSelectChild());
        Boolean isSelectChild = saleOrderReq.getIsSelectChild();
        if (isSelectChild.booleanValue()) {
            DataPermissionBean permission = this.permissionCacheService.getDataPermission(PermissionCacheService.ResrcCode.hxManage, saleOrderReq.getUserId());
            if (permission != null) {
                Set authorisedUserIds = permission.getAuthorisedUserIds();
                Set authorisedOrgIds = permission.getAuthorisedOrgIds();
                Set authorisedCompIds = permission.getAuthorisedCompIds();
                if (authorisedCompIds != null && !authorisedCompIds.isEmpty()) {
                    ArrayList compIds = new ArrayList(authorisedCompIds);
                    condition.put("compIds", compIds);
                }
                if (authorisedOrgIds != null && !authorisedOrgIds.isEmpty()) {
                    ArrayList deptIds = new ArrayList(authorisedOrgIds);
                    condition.put("deptIds", deptIds);
                }
                if (authorisedUserIds != null && !authorisedUserIds.isEmpty()) {
                    ArrayList userIds = new ArrayList(authorisedUserIds);
                    condition.put("userIds", userIds);
                }
            }
        } else {
            condition.put("purchaserId", saleOrderReq.getCompanyId());
            condition.put("purchaseAccountId", saleOrderReq.getUserId());
        }
        ArrayList listOrderStatus = new ArrayList();
        if (tabId != null) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty(listOrderStatus)) {
            ArrayList<Integer> statusList = new ArrayList<Integer>(listOrderStatus.size());
            for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatus : listOrderStatus) {
                statusList.add(orderTabMappingOrderStatus.getSaleOrderStatusCode());
            }
            condition.put("saleOrderStatusList", statusList);
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u9500\u552e\u8ba2\u5355\u591a\u6761\u4ef6\u5217\u8868\u67e5\u8be2\u6761\u4ef6:" + JSON.toJSONString(condition));
        }
        Map orderMap = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
        Map sourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
        List list = null;
        RspPageBO resultPage = new RspPageBO();
        if (CollectionUtils.isEmpty(list)) {
            resultPage.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
            resultPage.setRespDesc("\u65e0\u8ba2\u5355\u8bb0\u5f55");
            return resultPage;
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u9500\u552e\u8ba2\u5355:" + JSON.toJSONString((Object)list));
        }
        LinkedList<Long> supplierIds = new LinkedList<Long>();
        for (SaleOrderRspBO saleOrderRspBO : list) {
            if (saleOrderRspBO.getSupplierId() == null) continue;
            supplierIds.add(saleOrderRspBO.getSupplierId());
        }
        List supplierInfos = null;
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty(supplierInfos)) {
            for (ElcSupplierInfoXbjPO elcSupplierInfo : supplierInfos) {
                map.put(elcSupplierInfo.getGoodsSupplierId(), elcSupplierInfo.getIsOnceSendAll());
            }
        }
        QrySupplierInfoMapByIdsReqBO qrySupplierInfoMapByIdsReqBO = new QrySupplierInfoMapByIdsReqBO();
        qrySupplierInfoMapByIdsReqBO.setSupplierIds(supplierIds);
        Map supplierMap = this.tsupplierInfoBusiService.qrySupplierNameMapByIds(qrySupplierInfoMapByIdsReqBO);
        for (SaleOrderRspBO saleOrderRspBO : list) {
            Integer saleOrderType;
            String procInstId;
            Long saleOrderId = saleOrderRspBO.getSaleOrderId();
            if (saleOrderId != null) {
                saleOrderRspBO.setOrderId(String.valueOf(saleOrderId));
            }
            if (Constant.SALE_ORDER_TYPE_ELEC_AREA.equals(saleOrderRspBO.getSaleOrderType())) {
                CheckSaleOrderConfirmReqBO checkSaleOrderConfirm = new CheckSaleOrderConfirmReqBO();
                checkSaleOrderConfirm.setSaleOrderId(String.valueOf(saleOrderId));
                checkSaleOrderConfirm.setPurchaserId(saleOrderRspBO.getPurchaserId());
                CheckSaleOrderConfirmRspBO checkConfirm = this.checkSaleOrderConfirmService.checkSaleOrderConfirm(checkSaleOrderConfirm);
                saleOrderRspBO.setConfirmFlag(checkConfirm.getConfirmFlag().booleanValue());
                CheckWhetherShipAllReqBO checkWhetherShipAll = new CheckWhetherShipAllReqBO();
                checkWhetherShipAll.setSaleOrderId(String.valueOf(saleOrderId));
                checkWhetherShipAll.setPurchaserId(saleOrderRspBO.getPurchaserId());
                CheckWhetherShipAllRspBO checkAllShip = this.checkWhetherShipAllService.checkWhetherShipAll(checkWhetherShipAll);
                if (checkAllShip.getAllShip().booleanValue()) {
                    saleOrderRspBO.setAllShipFlag(false);
                } else {
                    saleOrderRspBO.setAllShipFlag(true);
                }
            }
            if (saleOrderRspBO.getCreateTime() != null) {
                saleOrderRspBO.setOrderCreateTime(DateUtil.dateToStrLong(saleOrderRspBO.getCreateTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)(procInstId = saleOrderRspBO.getProcInstId()))) {
                List taskComments;
                QryHistoryCommentsReqBO req = new QryHistoryCommentsReqBO();
                req.setProcInstId(procInstId);
                QueryHistoryCommentsRspBO historyCommentsRspBO = this.queryHistoryCommentsBusinService.queryHistoryComments(req);
                if (historyCommentsRspBO != null && (taskComments = historyCommentsRspBO.getTaskCommentRspBOs()) != null && taskComments.size() > 1) {
                    saleOrderRspBO.setApprovaled(true);
                }
            }
            if (Constant.SALE_ORDER_TYPE_ELEC_SUPERMARKET.equals(saleOrderRspBO.getSaleOrderType())) {
                Long supplierId = saleOrderRspBO.getSupplierId();
                saleOrderRspBO.setIsOnceSendAll(((Integer)map.get(supplierId)).intValue());
                if (supplierMap != null) {
                    saleOrderRspBO.setSupplierName((String)supplierMap.get(supplierId));
                }
            } else if (Constant.SALE_ORDER_TYPE_ELEC_AREA.equals(saleOrderRspBO.getSaleOrderType())) {
                OrderProtocolItemXbjPO orderProtocolItem = null;
                saleOrderRspBO.setSupplierName(orderProtocolItem == null ? null : orderProtocolItem.getSupplierName());
            }
            Integer saleOrderStatus = saleOrderRspBO.getSaleOrderStatus();
            if (saleOrderStatus != null) {
                String saleOrderStatusCode = String.valueOf(saleOrderStatus);
                if (orderMap != null) {
                    saleOrderRspBO.setSaleOrderStatusName((String)orderMap.get(saleOrderStatusCode));
                }
            }
            if ((saleOrderType = saleOrderRspBO.getSaleOrderType()) != null) {
                String orderSource = String.valueOf(saleOrderType);
                if (sourceMap != null) {
                    saleOrderRspBO.setOrderSource((String)sourceMap.get(orderSource));
                }
            }
            this.handleTotalOrderMoney(saleOrderRspBO);
            List orderItemList = saleOrderRspBO.getSaleOrderItemList();
            if (!CollectionUtils.isNotEmpty((Collection)orderItemList)) continue;
            for (SaleOrderItemRspBO saleOrderItemRspBO : orderItemList) {
                this.handleSkuPriceAndYanbaoPrice(saleOrderItemRspBO);
            }
        }
        resultPage.setRecordsTotal(page.getTotalCount());
        resultPage.setTotal(page.getTotalPages());
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u6210\u529f\uff01");
        resultPage.setRows(list);
        return resultPage;
    }

    private void handleSkuPriceAndYanbaoPrice(SaleOrderItemRspBO saleOrderItemRspBO) {
        List yanbaoList;
        Long salePrice = saleOrderItemRspBO.getSalePrice();
        if (salePrice != null) {
            try {
                BigDecimal skuSalePrice = MoneyUtil.Long2BigDecimal((Long)salePrice);
                saleOrderItemRspBO.setSkuSalePrice(skuSalePrice);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(yanbaoList = saleOrderItemRspBO.getYanbaoList()))) {
            for (ItemYanbaoRspBO itemYanbaoRspBO : yanbaoList) {
                Long price = itemYanbaoRspBO.getPrice();
                if (price == null) continue;
                try {
                    BigDecimal yanbaoPrice = MoneyUtil.Long2BigDecimal((Long)price);
                    itemYanbaoRspBO.setYanbaoPrice(yanbaoPrice);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleTotalOrderMoney(SaleOrderRspBO saleOrderRspBO) {
        Long saleOrderMoney = saleOrderRspBO.getSaleOrderMoney();
        if (saleOrderMoney != null) {
            try {
                BigDecimal orderMoney = MoneyUtil.Long2BigDecimal((Long)saleOrderMoney);
                saleOrderRspBO.setTotalSaleOrderMoney(orderMoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

