/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.XbjServOrderAcceptCreateAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.busi.XbjOrderServConfirmBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptCreateReqBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptCreateRspBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptItemBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderServCompleteItemXbjMapper;
import com.cgd.order.dao.OrderServCompleteXbjMapper;
import com.cgd.order.intfce.bo.XbjOrderServConfirmBusiReqBO;
import com.cgd.order.intfce.bo.XbjOrderServConfirmBusiRspBO;
import com.cgd.order.intfce.bo.XbjServInfoBO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderServCompleteItemXbjPO;
import com.cgd.order.po.OrderServCompleteXbjPO;
import com.cgd.pay.busi.PayAddTradeServiceFeeService;
import com.cgd.pay.busi.bo.PayAddTradeServiceFeeReqBO;
import com.cgd.pay.enums.CompanyType;
import com.cgd.user.supplier.busi.SelectSupplierInfoByIdBusiService;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdReqBO;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdRspBO;
import com.cgd.user.supplier.documcollect.bo.UpdateDocumentCollectStatusReqBO;
import com.cgd.user.supplier.documcollect.busi.UpdateDocumentCollectStatusBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class XbjOrderServConfirmBusiServiceImpl
implements XbjOrderServConfirmBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderServConfirmBusiServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private SaleOrderStatusCheckXbjService saleOrderStatusCheckXbjService;
    @Autowired
    private OrderServCompleteItemXbjMapper orderServCompleteItemXbjMapper;
    @Autowired
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    @Autowired
    private XbjServOrderAcceptCreateAtomService xbjServOrderAcceptCreateAtomService;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private PayAddTradeServiceFeeService payAddTradeServiceFeeService;
    @Autowired
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService createOrderFlowSheetAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;
    @Autowired
    private UpdateDocumentCollectStatusBusiService updateDocumentCollectStatusBusiService;
    @Autowired
    private OrderServCompleteXbjMapper orderServCompleteXbjMapper;

    public XbjOrderServConfirmBusiRspBO dealXbjOrderServConfirm(XbjOrderServConfirmBusiReqBO req) {
        XbjOrderServConfirmBusiRspBO rsp;
        block22: {
            rsp = new XbjOrderServConfirmBusiRspBO();
            try {
                XbjServOrderAcceptCreateReqBO xbjServOrderAcceptCreateReqBO;
                XbjServOrderAcceptCreateRspBO busiRsp;
                OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO;
                this.dealWithParamVerify(req);
                if (req.getServCompleteOrderId() != null && !"".equals(req.getServCompleteOrderId())) {
                    OrderServCompleteXbjPO orderServCompleteXbjPO = this.orderServCompleteXbjMapper.getModelById(req.getServCompleteOrderId());
                    if (orderServCompleteXbjPO == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u670d\u52a1\u5b8c\u5de5\u5355ID\u3010" + req.getServCompleteOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u5b8c\u5de5\u5355\u6570\u636e");
                    }
                    req.setSaleOrderId(orderServCompleteXbjPO.getSaleOrderId());
                }
                if ((xbjOrderSaleInfoRspBO = this.orderSaleXbjAtomService.queryOrderSaleById(req.getSaleOrderId(), req.getPurchaserId())) == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
                }
                if (req.getPurchaserOrderId() == null) {
                    req.setPurchaserOrderId(xbjOrderSaleInfoRspBO.getPurchaseOrderId());
                }
                this.checkCount(xbjOrderSaleInfoRspBO, req);
                if ("1".equals(req.getCompleteFlag())) {
                    SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq = new SaleOrderStatusCheckXbjReqBO();
                    saleOrderStatusCheckReq.setNewSaleOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
                    saleOrderStatusCheckReq.setOldSaleOrderStatus(xbjOrderSaleInfoRspBO.getSaleOrderStatus());
                    saleOrderStatusCheckReq.setSaleOrderType(xbjOrderSaleInfoRspBO.getSaleOrderType());
                    SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckRsp = this.saleOrderStatusCheckXbjService.notifySaleOrderStatus(saleOrderStatusCheckReq);
                    if (saleOrderStatusCheckRsp == null || !"0000".equals(saleOrderStatusCheckRsp.getCheckRspCode())) {
                        if (isDebugEnabled) {
                            logger.debug("\u9500\u552e\u8ba2\u5355\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
                        }
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u3010" + xbjOrderSaleInfoRspBO.getSaleOrderId() + "\u3011\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
                    }
                    this.updateSaleAndPurchaser(req, xbjOrderSaleInfoRspBO);
                    RspInfoBO rspInfoBO = this.updateDocumentStatus(xbjOrderSaleInfoRspBO.getSaleOrderId());
                    if (rspInfoBO == null || !"0000".equals(rspInfoBO.getRespCode())) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
                    }
                }
                if ((busiRsp = this.xbjServOrderAcceptCreateAtomService.createServOrderAccept(xbjServOrderAcceptCreateReqBO = this.servOrderAcceptParamInit(req, xbjOrderSaleInfoRspBO))) == null || !"0000".equals(busiRsp.getRespCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff0c\u8c03\u7528\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:");
                }
                PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = this.initPayAddServicePO(xbjOrderSaleInfoRspBO, xbjServOrderAcceptCreateReqBO);
                if (payAddTradeServiceFeeReqBO.getPayMoney().compareTo(BigDecimal.valueOf(0L)) > 0) {
                    try {
                        if (isDebugEnabled) {
                            logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                        }
                        logger.error("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2=============================" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                        RspBusiBaseBO payAddTradeRspBO = this.payAddTradeServiceFeeService.addTradeServiceFee(payAddTradeServiceFeeReqBO);
                        if (isDebugEnabled) {
                            logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)payAddTradeRspBO));
                        }
                        if (payAddTradeRspBO != null && !"0000".equalsIgnoreCase(payAddTradeRspBO.getRespCode())) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38");
                    }
                }
                this.sendMessage(xbjOrderSaleInfoRspBO, req, xbjServOrderAcceptCreateReqBO.getServInspectionOrderCode());
                XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                orderFlowSheetReqBO.setOrderId(Long.valueOf(req.getSaleOrderId()));
                orderFlowSheetReqBO.setPurchaserId(Long.valueOf(req.getPurchaserId()));
                orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
                orderFlowSheetReqBO.setOrderBusiType("B_23");
                orderFlowSheetReqBO.setUserId(req.getUserId());
                orderFlowSheetReqBO.setCompanyName(req.getCompanyName());
                orderFlowSheetReqBO.setUserName(req.getUserName());
                orderFlowSheetReqBO.setCompanyName(req.getCompanyName());
                orderFlowSheetReqBO.setOperRole("\u5e93\u7ba1\u5458");
                XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.createOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
                if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
                    if (isDebugEnabled) {
                        logger.debug("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u6210\u529f");
                    }
                    break block22;
                }
                logger.error("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5931\u8d25\uff1a" + orderFlowSheetRspBO.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u5ba1\u6838\u670d\u52a1\u5f02\u5e38\uff1a\u5199\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (BusinessException e) {
                if (isDebugEnabled) {
                    logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1BusinessException");
                }
                logger.error("" + e.getMessage(), (Throwable)e);
                rsp.setRespCode("8888");
                rsp.setRespDesc("" + e.getMessage());
                return rsp;
            }
            catch (Exception e) {
                logger.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1 \u5f02\u5e38", (Throwable)e);
                if (isDebugEnabled) {
                    logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1");
                }
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
                return rsp;
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private void dealWithParamVerify(XbjOrderServConfirmBusiReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPurchaserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u5546\u7f16\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getSaleOrderId()) && StringUtils.isEmpty((Object)req.getServCompleteOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9500\u552e\u8ba2\u5355ID[saleOrderId]\u548c\u670d\u52a1\u5b8c\u5de5\u5355ID[servCompleteOrderId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (req.getServInfoList() == null || req.getServInfoList().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9a8c\u6536\u670d\u52a1\u4fe1\u606f\u96c6\u5408[servInfoList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (XbjServInfoBO servInfo : req.getServInfoList()) {
            if (StringUtils.isEmpty((Object)servInfo.getServCount()) || servInfo.getServCount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2 \u670d\u52a1\u6570\u91cf[servCount]\u6709\u8bef\uff01");
            }
            if (StringUtils.isEmpty((Object)servInfo.getPurchaseOrderItemId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u660e\u7ec6ID[purchaseOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((Object)servInfo.getServCompleteOrderId())) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u660e\u7ec6ID[getServCompleteOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != req.getAccessoryInfoList() && req.getAccessoryInfoList().size() > 0) {
            List xbjPurchaseAccessoryReqBOList = req.getAccessoryInfoList();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : xbjPurchaseAccessoryReqBOList) {
                if (StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryUrl())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private void checkCount(OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO, XbjOrderServConfirmBusiReqBO req) {
        OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.queryOrderPurchase(req.getPurchaserOrderId(), req.getPurchaserId());
        BigDecimal finishedCountTotal = new BigDecimal("0");
        BigDecimal checkedCountTotal = new BigDecimal("0");
        BigDecimal nowcheckingCountTotal = new BigDecimal("0");
        BigDecimal waitCheckigCountTotal = new BigDecimal("0");
        List servInfoList = req.getServInfoList();
        for (XbjServInfoBO servInfo : servInfoList) {
            OrderServCompleteItemXbjPO servPo = new OrderServCompleteItemXbjPO();
            servPo.setPurchaserId(req.getPurchaserId());
            servPo.setServCompleteOrderId((long)servInfo.getServCompleteOrderId());
            servPo.setPurchaseOrderItemId(Long.valueOf(servInfo.getPurchaseOrderItemId()));
            servPo.setServCompleteOrderId(servInfo.getServCompleteOrderId());
            OrderServCompleteItemXbjPO servItemInfo = this.orderServCompleteItemXbjMapper.queryOrderServItemS(servPo);
            if (servItemInfo == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff0c\u6839\u636e\u91c7\u8d2d\u660e\u7ec6id\u548c\u670d\u52a1\u5355ID\u672a\u627e\u5230\u6307\u5b9a\u7684\u670d\u52a1\u8ba2\u5355\u5b8c\u5de5\u660e\u7ec6");
            }
            BigDecimal finishedCount = servItemInfo.getOnceCompleteCount();
            BigDecimal checkedCount = servItemInfo.getAcceptanceCount();
            BigDecimal nowcheckingCount = servInfo.getServCount();
            if (finishedCount == null) {
                finishedCount = new BigDecimal("0");
            }
            if (checkedCount == null) {
                checkedCount = new BigDecimal("0");
            }
            BigDecimal waitCheckigCount = finishedCount.subtract(checkedCount);
            checkedCountTotal = checkedCountTotal.add(checkedCount);
            nowcheckingCountTotal = nowcheckingCountTotal.add(nowcheckingCount);
            finishedCountTotal = finishedCountTotal.add(finishedCount);
            waitCheckigCountTotal = waitCheckigCountTotal.add(waitCheckigCount);
            BigDecimal checkTotal = nowcheckingCount.add(checkedCount);
            if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.TOTAL_TYPE == orderPurchase.getOrderType()) {
                if (req.getCompleteFlag().equals("1") && nowcheckingCount.compareTo(finishedCount) != 0 && checkTotal.compareTo(finishedCount) != 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
                }
                if (nowcheckingCount.compareTo(finishedCount) <= 0 && checkTotal.compareTo(finishedCount) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
            }
            if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.SINGLE_TYPE == orderPurchase.getOrderType()) {
                if (nowcheckingCount.compareTo(waitCheckigCount.multiply(new BigDecimal("1.2"))) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u4ef7\u578b\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\u76841.2\u500d");
            }
            if (nowcheckingCount.compareTo(finishedCount) <= 0 && checkTotal.compareTo(finishedCount) <= 0) continue;
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
        }
        BigDecimal totalCheck = checkedCountTotal.add(nowcheckingCountTotal);
        if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.TOTAL_TYPE == orderPurchase.getOrderType()) {
            if (req.getCompleteFlag().equals("1") && totalCheck.compareTo(finishedCountTotal) != 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
            }
            if (totalCheck.compareTo(finishedCountTotal) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
            }
        } else if (orderPurchase.getOrderType() != null && XConstant.ORDER_TYPE.SINGLE_TYPE == orderPurchase.getOrderType()) {
            if (nowcheckingCountTotal.compareTo(waitCheckigCountTotal.multiply(new BigDecimal("1.2"))) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u4ef7\u578b\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf\u76841.2\u500d");
            }
        } else if (totalCheck.compareTo(finishedCountTotal) > 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
        }
    }

    private void updateSaleAndPurchaser(XbjOrderServConfirmBusiReqBO req, OrderSaleInfoXbjRspBO orderSaleInfoXbjRspBO) {
        try {
            OrderSaleXbjReqBO xbjOrderSaleReqBO = new OrderSaleXbjReqBO();
            xbjOrderSaleReqBO.setSaleOrderId(orderSaleInfoXbjRspBO.getSaleOrderId());
            xbjOrderSaleReqBO.setSaleOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
            xbjOrderSaleReqBO.setSaleOrderOldStatus(orderSaleInfoXbjRspBO.getSaleOrderStatus());
            xbjOrderSaleReqBO.setPurchaserId(req.getPurchaserId());
            xbjOrderSaleReqBO.setPurchaserAccountId(orderSaleInfoXbjRspBO.getPurchaserAccountId());
            xbjOrderSaleReqBO.setOperId(req.getUserId().toString());
            xbjOrderSaleReqBO.setProfessionalOrganizationId(orderSaleInfoXbjRspBO.getProfessionalOrganizationId());
            xbjOrderSaleReqBO.setCancelReason(req.getCancelReason());
            xbjOrderSaleReqBO.setGoodsSupplierId(orderSaleInfoXbjRspBO.getGoodsSupplierId());
            xbjOrderSaleReqBO.setModifyOprId(req.getUserId());
            xbjOrderSaleReqBO.setPurchaserAccountName(orderSaleInfoXbjRspBO.getPurchaserAccountName());
            xbjOrderSaleReqBO.setSaleOrderType(orderSaleInfoXbjRspBO.getSaleOrderType());
            this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff01");
        }
        try {
            OrderPurchaseStatusChngReqBo xbjOrderPurchaseStatusChngAtomReqBo = new OrderPurchaseStatusChngReqBo();
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderId(req.getPurchaserOrderId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderOldStatus(orderSaleInfoXbjRspBO.getSaleOrderStatus());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaseOrderStatus(Constant.SALSE_ORDER_STATE_COMPLETED);
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserId(req.getPurchaserId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserAccountId(orderSaleInfoXbjRspBO.getPurchaserAccountId());
            xbjOrderPurchaseStatusChngAtomReqBo.setOperId(req.getUserId().toString());
            xbjOrderPurchaseStatusChngAtomReqBo.setProfessionalOrganizationId(orderSaleInfoXbjRspBO.getProfessionalOrganizationId());
            xbjOrderPurchaseStatusChngAtomReqBo.setSaleOrderId(req.getSaleOrderId());
            xbjOrderPurchaseStatusChngAtomReqBo.setGoodsSupplierId(orderSaleInfoXbjRspBO.getGoodsSupplierId());
            xbjOrderPurchaseStatusChngAtomReqBo.setPurchaserAccountName(orderSaleInfoXbjRspBO.getPurchaserAccountName());
            this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(xbjOrderPurchaseStatusChngAtomReqBo);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff01");
        }
    }

    private XbjServOrderAcceptCreateReqBO servOrderAcceptParamInit(XbjOrderServConfirmBusiReqBO req, OrderSaleInfoXbjRspBO orderSaleInfoXbjRspBO) {
        XbjServOrderAcceptCreateReqBO xbjServOrderAcceptCreateReqBO = new XbjServOrderAcceptCreateReqBO();
        GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.SERV_INSPECTION);
        generateOrderIdAndCodeXbjReqBO.setPurchaseOrderId(req.getPurchaserOrderId());
        generateOrderIdAndCodeXbjReqBO.setPurchaseId(req.getPurchaserId());
        generateOrderIdAndCodeXbjReqBO.setSaleOrderId(req.getSaleOrderId());
        GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
        OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.queryOrderPurchase(req.getPurchaserOrderId(), req.getPurchaserId());
        xbjServOrderAcceptCreateReqBO.setServCompleteOrderId(req.getServCompleteOrderId());
        xbjServOrderAcceptCreateReqBO.setServInspectionOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
        xbjServOrderAcceptCreateReqBO.setServInspectionOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        xbjServOrderAcceptCreateReqBO.setPurchaseOrderId(req.getPurchaserOrderId());
        xbjServOrderAcceptCreateReqBO.setPurchaseOrderCode(orderPurchase.getPurchaseOrderCode());
        xbjServOrderAcceptCreateReqBO.setSaleOrderId(orderSaleInfoXbjRspBO.getSaleOrderId());
        xbjServOrderAcceptCreateReqBO.setSaleOrderCode(orderSaleInfoXbjRspBO.getSaleOrderCode());
        xbjServOrderAcceptCreateReqBO.setPurchaserId(req.getPurchaserId());
        xbjServOrderAcceptCreateReqBO.setPurchaserAccountId(orderSaleInfoXbjRspBO.getPurchaserAccountId());
        xbjServOrderAcceptCreateReqBO.setPurchaserAccountName(orderSaleInfoXbjRspBO.getPurchaserAccountName());
        xbjServOrderAcceptCreateReqBO.setProfessionalOrganizationId(orderSaleInfoXbjRspBO.getProfessionalOrganizationId());
        xbjServOrderAcceptCreateReqBO.setGoodsSupplierId(orderSaleInfoXbjRspBO.getGoodsSupplierId());
        xbjServOrderAcceptCreateReqBO.setOrderType(orderSaleInfoXbjRspBO.getOrderType());
        xbjServOrderAcceptCreateReqBO.setOperId(req.getUserId());
        xbjServOrderAcceptCreateReqBO.setCreateTime(new Date());
        xbjServOrderAcceptCreateReqBO.setModifyOperId(req.getUserId());
        xbjServOrderAcceptCreateReqBO.setModifyTime(new Date());
        xbjServOrderAcceptCreateReqBO.setRemark(req.getCancelReason());
        ArrayList<XbjServOrderAcceptItemBO> servOrderAcceptItemList = new ArrayList<XbjServOrderAcceptItemBO>();
        for (XbjServInfoBO servInfo : req.getServInfoList()) {
            OrderServCompleteItemXbjPO servPo = new OrderServCompleteItemXbjPO();
            servPo.setPurchaserId(req.getPurchaserId());
            servPo.setServCompleteOrderId((long)servInfo.getServCompleteOrderId());
            servPo.setPurchaseOrderItemId(Long.valueOf(servInfo.getPurchaseOrderItemId()));
            OrderServCompleteItemXbjPO servItemInfo = this.orderServCompleteItemXbjMapper.queryOrderServItemS(servPo);
            XbjServOrderAcceptItemBO acceptItem = new XbjServOrderAcceptItemBO();
            acceptItem.setServItemId(servItemInfo.getItemId());
            acceptItem.setServInspectionId(xbjServOrderAcceptCreateReqBO.getServInspectionOrderId());
            acceptItem.setServOrderId(Long.valueOf(servInfo.getServCompleteOrderId()));
            acceptItem.setSaleOrderItemId(servItemInfo.getSaleOrderItemId());
            acceptItem.setPurchaseOrderItemId(servItemInfo.getPurchaseOrderItemId());
            acceptItem.setPurchaserId(servItemInfo.getPurchaserId());
            acceptItem.setPurchaserAccountId(servItemInfo.getPurchaserAccountId());
            acceptItem.setPurchaserAccountName(servItemInfo.getPurchaserAccountName());
            acceptItem.setProfessionalOrganizationId(servItemInfo.getProfessionalOrganizationId());
            acceptItem.setGoodsSupplierId(servItemInfo.getGoodsSupplierId());
            acceptItem.setProjectId(servItemInfo.getProjectId());
            acceptItem.setProjectCode(servItemInfo.getProjectCode());
            acceptItem.setProjectContent(servItemInfo.getProjectContent());
            acceptItem.setPurchaseCount(servItemInfo.getPurchaseCount());
            acceptItem.setOnceAcceptanceCount(servInfo.getServCount());
            acceptItem.setUnitName(servItemInfo.getUnitName());
            acceptItem.setServCompleteOrderId(Long.valueOf(servInfo.getServCompleteOrderId()));
            servOrderAcceptItemList.add(acceptItem);
        }
        xbjServOrderAcceptCreateReqBO.setServOrderAcceptItemList(servOrderAcceptItemList);
        xbjServOrderAcceptCreateReqBO.setAccessoryInfoList(req.getAccessoryInfoList());
        return xbjServOrderAcceptCreateReqBO;
    }

    private PayAddTradeServiceFeeReqBO initPayAddServicePO(OrderSaleInfoXbjRspBO orderSaleXbjPO, XbjServOrderAcceptCreateReqBO reqBO) {
        PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = new PayAddTradeServiceFeeReqBO();
        try {
            payAddTradeServiceFeeReqBO.setPayOrderNo(reqBO.getServInspectionOrderId() + "");
            payAddTradeServiceFeeReqBO.setInquiryNo(reqBO.getServInspectionOrderCode());
            payAddTradeServiceFeeReqBO.setOrderDate(new Date());
            payAddTradeServiceFeeReqBO.setPayOrderName(orderSaleXbjPO.getSaleOrderName());
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (XbjServOrderAcceptItemBO xbjServOrderItemBO : reqBO.getServOrderAcceptItemList()) {
                OrderPurchaseItemXbjPO orderPurchaseItemPO = new OrderPurchaseItemXbjPO();
                orderPurchaseItemPO.setPurchaseOrderItemId(xbjServOrderItemBO.getPurchaseOrderItemId());
                orderPurchaseItemPO.setPurchaserId(reqBO.getPurchaserId());
                OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = this.orderPurchaseItemXbjMapper.getModelBy(orderPurchaseItemPO);
                if (orderPurchaseItemXbjPO != null) {
                    totalAmount = totalAmount.add(MoneyUtil.Long2BigDecimal((Long)orderPurchaseItemXbjPO.getPurchasingPrice()).multiply(xbjServOrderItemBO.getOnceAcceptanceCount()));
                    continue;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38:\u67e5\u8be2\u91c7\u8d2d\u660e\u7ec6\u660e\u7ec6\u5f02\u5e38\uff01");
            }
            payAddTradeServiceFeeReqBO.setOrderTotalMoney(totalAmount);
            OrderProtocolItemXbjPO orderProtocolItemPO = this.orderProtocolItemXbjMapper.queryBySaleOrderId(orderSaleXbjPO.getSaleOrderId());
            BigDecimal payMoney = BigDecimal.ZERO;
            if (orderProtocolItemPO != null) {
                payMoney = new BigDecimal(orderProtocolItemPO.getServiceRate()).divide(new BigDecimal(100)).multiply(totalAmount);
                payAddTradeServiceFeeReqBO.setOperator(orderProtocolItemPO.getProducerId());
            }
            payAddTradeServiceFeeReqBO.setPayMoney(payMoney);
            payAddTradeServiceFeeReqBO.setCompanyType(CompanyType.SUPPLIER);
            payAddTradeServiceFeeReqBO.setSupplierId(orderSaleXbjPO.getGoodsSupplierId());
            payAddTradeServiceFeeReqBO.setOperUnitNo(orderSaleXbjPO.getProfessionalOrganizationId());
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u8c03\u7528\u652f\u4ed8\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u670d\u52a1\u521d\u59cb\u5316\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u652f\u4ed8\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u670d\u52a1\u521d\u59cb\u5316\u5f02\u5e38:" + e.getMessage());
        }
        return payAddTradeServiceFeeReqBO;
    }

    private void sendMessage(OrderSaleInfoXbjRspBO orderSale, XbjOrderServConfirmBusiReqBO req, String inspectionCode) {
        try {
            SelectSupplierInfoByIdReqBO reqBO = new SelectSupplierInfoByIdReqBO();
            reqBO.setSupplierId(orderSale.getGoodsSupplierId());
            SelectSupplierInfoByIdRspBO rspBO = this.selectSupplierInfoByIdBusiService.selectSupplierInfoById(reqBO);
            if (rspBO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u670d\u52a1\u9a8c\u6536\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_SUPPLY_DISPATCH_YES);
            smsParam.put("purchaseCode", orderSale.getPurchaseOrderCode());
            smsParam.put("purchaseName", orderSale.getSaleOrderName());
            smsParam.put("inspectionCode", inspectionCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setUserId(req.getUserId());
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setMessageAccount(rspBO.getManagerId() + "");
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            logger.error("\u670d\u52a1\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSendMsgBusiReq));
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            logger.error("\u670d\u52a1\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO));
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
        }
    }

    private RspInfoBO updateDocumentStatus(Long saleOrderId) {
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            UpdateDocumentCollectStatusReqBO updateDocumentCollectStatusReqBO = new UpdateDocumentCollectStatusReqBO();
            updateDocumentCollectStatusReqBO.setDocumentId(saleOrderId);
            updateDocumentCollectStatusReqBO.setDocumentStatus(Integer.valueOf(1));
            updateDocumentCollectStatusReqBO.setBusiType(Integer.valueOf(3));
            logger.error("\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updateDocumentCollectStatusReqBO));
            RspBusiBaseBO rspBusiBO = this.updateDocumentCollectStatusBusiService.updateStatus(updateDocumentCollectStatusReqBO);
            logger.error("\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBusiBO));
            if (rspBusiBO != null && "0000".equals(rspBusiBO.getRespCode())) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u6210\u529f");
            } else {
                rspInfoBO.setRespCode("8888");
                rspInfoBO.setRespDesc("\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
            }
            return rspInfoBO;
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u9a8c\u6536\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5f02\u5e38\uff0c\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25\uff01");
        }
    }
}

