/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjOrderConstrServVerifyService;
import com.cgd.order.busi.bo.XbjOrderConstrServVerifyReqBO;
import com.cgd.order.busi.bo.XbjOrderConstrServVerifyRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class XbjOrderConstrServVerifyServiceImpl
implements XbjOrderConstrServVerifyService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderConstrServVerifyServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public XbjOrderConstrServVerifyRspBO dealWithXbjOrderConstrServVerify(XbjOrderConstrServVerifyReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u65bd\u5de5/\u670d\u52a1\u53ef\u7528\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (isDebugEnabled) {
            logger.debug("\u8be2\u6bd4\u4ef7\u65bd\u5de5/\u670d\u52a1\u53ef\u7528\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqBO.toString());
        }
        if (StringUtils.isEmpty((Object)reqBO.getPurchaseOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355Id[PurchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPurchaserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546Id[PurchaserId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.queryOrderPurchase(Long.valueOf(reqBO.getPurchaseOrderId()), Long.valueOf(reqBO.getPurchaserId()));
        if (null == orderPurchaseXbjPO) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u975e\u5e38\u62b1\u6b49\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9a\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        if (XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES == orderPurchaseXbjPO.getWholeAcceptance()) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u975e\u5e38\u62b1\u6b49\uff0c\u6b64\u8ba2\u5355\u5df2\u7ecf\u6574\u5355\u9a8c\u6536!");
        }
        OrderPurchaseItemXbjPO reqPO = new OrderPurchaseItemXbjPO();
        reqPO.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        reqPO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        List<OrderPurchaseItemXbjPO> orderPurchaseItemList = null;
        try {
            orderPurchaseItemList = this.orderPurchaseItemXbjMapper.getList(reqPO);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u8be2\u6bd4\u4ef7\u65bd\u5de5/\u670d\u52a1\u53ef\u7528\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5/\u670d\u52a1\u53ef\u7528\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        XbjOrderConstrServVerifyRspBO rspBO = new XbjOrderConstrServVerifyRspBO();
        Boolean workFlag = false;
        if (null == orderPurchaseItemList) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u975e\u5e38\u62b1\u6b49\uff0c\u6b64\u8ba2\u5355\u5df2\u65e0\u53ef\u53d1\u8d27\u5546\u54c1\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27\uff01");
            rspBO.setWorkFlag(workFlag);
            return rspBO;
        }
        Iterator<OrderPurchaseItemXbjPO> it = orderPurchaseItemList.iterator();
        while (it.hasNext()) {
            OrderPurchaseItemXbjPO orderPurchaseItemXbjPOTemp = it.next();
            if (orderPurchaseItemXbjPOTemp.getPurchaseCount().compareTo(orderPurchaseItemXbjPOTemp.getSendCount()) != 0) continue;
            it.remove();
        }
        if (orderPurchaseItemList.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u975e\u5e38\u62b1\u6b49\uff0c\u6b64\u8ba2\u5355\u5df2\u65e0\u53ef\u53d1\u8d27\u5546\u54c1\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27\uff01");
            rspBO.setWorkFlag(workFlag);
            return rspBO;
        }
        workFlag = true;
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u68c0\u9a8c\u901a\u8fc7\uff0c\u7ee7\u7eed\u53d1\u8d27\uff01");
        rspBO.setWorkFlag(workFlag);
        return rspBO;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }
}

