/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjSaleOrderItemAdjustBusiService;
import com.cgd.order.busi.bo.OrderSaleItemXbjBO;
import com.cgd.order.busi.bo.XbjAccessoryBusiReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjSaleOrderItemAdjustReqBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderAdjustXbjMapper;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderAdjustXbjPO;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjSaleOrderItemAdjustBusiServiceImpl
implements XbjSaleOrderItemAdjustBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSaleOrderItemAdjustBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderAdjustXbjMapper orderAdjustXbjMapper;
    @Autowired
    private OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private BpmStartBusinService bpmStartBusinService;
    @Autowired
    private QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    private DoTaskCompleteBusinService doTaskCompleteBusinService;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RspInfoBO calcXbjSaleOrderItemAdjust(XbjSaleOrderItemAdjustReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2:" + reqBO.toString());
        }
        log.error("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
        OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(Long.parseLong(reqBO.getSaleOrderId()), Long.parseLong(reqBO.getPurchaserId()));
        if (orderSale == null) {
            throw new BusinessException("8888", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u5931\u8d25\uff1a\u6839\u636esaleOrderId\u548cpurchaserId\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        }
        this.validateReqData(reqBO, orderSale.getIsDispatch());
        RspInfoBO rspBO = new RspInfoBO();
        Long saleOrderId = Long.valueOf(reqBO.getSaleOrderId());
        try {
            if ("1".equals(reqBO.getConfirmFlag())) {
                return this.saveAdjustPriceRecodeBatch(reqBO);
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6279\u91cf\u4fee\u6539\u52a0\u4ef7\u7387\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6279\u91cf\u4fee\u6539\u52a0\u4ef7\u7387\u5f02\u5e38");
        }
        OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
        process.setOrderId(saleOrderId);
        process.setBusiType("51");
        process.setProcessStatus("0");
        try {
            BpmStartRspBO bpmStart;
            process = this.orderProcessCodeXbjMapper.getModelBy(process);
            if (process == null) {
                if (this.isDebugEnabled) {
                    log.debug("=========================================\u521d\u6b21\u8c03\u4ef7=============================start");
                }
                BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
                bpmStartReqBO.setApplyerId(Long.valueOf(reqBO.getUserId()));
                bpmStartReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                bpmStartReqBO.setBusinessId(reqBO.getSaleOrderId());
                bpmStartReqBO.setBusinessTitle("\u8ba2\u5355\u8c03\u4ef7\u5ba1\u6279");
                bpmStartReqBO.setBusinessType("51");
                bpmStartReqBO.setDetailUrl("http://www.baidu.com");
                bpmStartReqBO.setStartFlag("1");
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("purchaserId", reqBO.getPurchaserId());
                variables.put("userId", reqBO.getUserId());
                variables.put("isDispatch", orderSale.getIsDispatch());
                bpmStartReqBO.setVariables(variables);
                bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
                if (!"0000".equals(bpmStart.getRespCode()) || StringUtils.isEmpty((CharSequence)bpmStart.getProcInstId())) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25");
                    if (!this.isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25");
                    log.debug("=========================================\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25=============================start");
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25");
                }
            } else {
                if (this.isDebugEnabled) {
                    log.debug("=========================================\u4e8c\u6b21\u8c03\u4ef7=============================start");
                }
                String processCode = process.getProcessCode();
                TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                todoTaskReqBO.setBusinessType("51");
                todoTaskReqBO.setProcInstId(processCode);
                TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                    DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                    doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                    doTaskCompleteReqBo.setBusinessType("51");
                    doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                    RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                    if (doTaskComplete.getRespCode().equals("0000")) return this.saveAdjustRecode(reqBO);
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                    if (!this.isDebugEnabled) return rspBO;
                    log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                    return rspBO;
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                if (!this.isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
            }
            String procInstId = bpmStart.getProcInstId();
            OrderProcessCodeXbjPO addRecord = new OrderProcessCodeXbjPO();
            addRecord.setOrderId(saleOrderId);
            addRecord.setBusiType("51");
            addRecord.setProcessCode(procInstId);
            addRecord.setCreatTime(new Date());
            addRecord.setProcessStatus("0");
            this.orderProcessCodeXbjMapper.insert(addRecord);
            return this.saveAdjustRecode(reqBO);
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (UndeclaredThrowableException e) {
            log.error("\u5de5\u4f5c\u6d41\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5de5\u4f5c\u6d41\u63a5\u53e3\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void validateReqData(XbjSaleOrderItemAdjustReqBO reqBO, Integer isDispatch) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  \u9500\u552e\u8ba2\u5355ID\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPurchaserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)(reqBO.getUserId() + ""))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  \u64cd\u4f5c\u5458ID\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderSaleItemXbjBOs() == null || reqBO.getOrderSaleItemXbjBOs().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1  \u8c03\u4ef7\u660e\u7ec6list\u3010orderSaleItemXbjBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List itemXbjBOList = reqBO.getOrderSaleItemXbjBOs();
        for (OrderSaleItemXbjBO itemXbjBO : itemXbjBOList) {
            if (StringUtils.isBlank((CharSequence)itemXbjBO.getSaleOrderItemId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"1".equals(reqBO.getConfirmFlag()) && itemXbjBO.getSalePriceNew() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8c03\u4ef7\u540e\u7684\u9500\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!XConstant.IS_DISPATCH_YES.equals(isDispatch)) continue;
            if (itemXbjBO.getPurchasingPriceNew() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8c03\u4ef7\u540e\u7684\u91c7\u8d2d\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemXbjBO.getMarkUpRateNew() != null) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8c03\u4ef7\u540e\u7684\u52a0\u4ef7\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private RspInfoBO saveAdjustRecode(XbjSaleOrderItemAdjustReqBO sAdjustReqBO) throws Exception {
        Long purchaserId = Long.parseLong(sAdjustReqBO.getPurchaserId());
        Long saleOrderId = Long.parseLong(sAdjustReqBO.getSaleOrderId());
        List orderSaleItemXbjBOs = sAdjustReqBO.getOrderSaleItemXbjBOs();
        RspInfoBO sAdjustRspBO = new RspInfoBO();
        OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(saleOrderId, purchaserId);
        if (orderSale == null) {
            throw new BusinessException("8888", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u5931\u8d25\uff1a\u6839\u636esaleOrderId\u548cpurchaserId\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        }
        for (OrderSaleItemXbjBO itemXbjBO : orderSaleItemXbjBOs) {
            Long saleOrderItemId = Long.parseLong(itemXbjBO.getSaleOrderItemId());
            BigDecimal salePrice = itemXbjBO.getSalePriceNew();
            BigDecimal purchasingPrice = BigDecimal.ZERO;
            Double markUpRateNew = 0.0;
            if (XConstant.IS_DISPATCH_YES.equals(orderSale.getIsDispatch())) {
                purchasingPrice = itemXbjBO.getPurchasingPriceNew();
                markUpRateNew = itemXbjBO.getMarkUpRateNew();
            }
            OrderSaleItemXbjPO orderSaleItem = new OrderSaleItemXbjPO();
            orderSaleItem.setSaleOrderItemId(saleOrderItemId);
            orderSaleItem.setPurchaserId(purchaserId);
            orderSaleItem.setSaleOrderId(saleOrderId);
            orderSaleItem = this.orderSaleItemXbjMapper.selectBySaleOrderItemIdAndPurchaserId(orderSaleItem);
            if (orderSaleItem != null) {
                OrderAdjustXbjPO orderAdjust = new OrderAdjustXbjPO();
                BeanUtils.copyProperties((Object)orderSaleItem, (Object)orderAdjust);
                orderAdjust.setSaleOrderNo(orderSaleItem.getSaleOrderId());
                orderAdjust.setSkuId(orderSaleItem.getSkuId());
                orderAdjust.setOfrName(orderSaleItem.getSkuName());
                orderAdjust.setMaterialId(orderSaleItem.getMaterialId());
                orderAdjust.setOldSellingPrice(orderSaleItem.getSellingPrice());
                orderAdjust.setOldPurchasingPrice(orderSaleItem.getPurchasingPrice());
                orderAdjust.setCurrency(orderSaleItem.getSkuCurrencyType());
                orderAdjust.setCreateTime(new Date());
                orderAdjust.setOperId(sAdjustReqBO.getUserId() + "");
                orderAdjust.setNewSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)salePrice));
                if (XConstant.IS_DISPATCH_YES.equals(orderSale.getIsDispatch())) {
                    orderAdjust.setNewPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)purchasingPrice));
                }
                orderAdjust.setRemark(sAdjustReqBO.getRemark());
                this.orderAdjustXbjMapper.insert(orderAdjust);
                orderSaleItem.setNewSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)salePrice));
                if (XConstant.IS_DISPATCH_YES.equals(orderSale.getIsDispatch())) {
                    orderSaleItem.setMarkUpRateNew(markUpRateNew);
                    orderSaleItem.setNewPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)purchasingPrice));
                }
                orderSaleItem.setSaleOrderItemId(saleOrderItemId);
                orderSaleItem.setPurchaserId(purchaserId);
                this.orderSaleItemXbjMapper.updateById(orderSaleItem);
                continue;
            }
            throw new BusinessException("8888", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u5931\u8d25\uff1a\u6839\u636e[saleOrderItemId + saleOrderId + purchaserId]\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6");
        }
        List saleAdjustAccessoryReqBOs = sAdjustReqBO.getSaleAdjustAccessoryReqBOs();
        AccessoryXbjPO accessoryCommon = new AccessoryXbjPO();
        BeanUtils.copyProperties((Object)orderSale, (Object)accessoryCommon);
        accessoryCommon.setProfessionalOrganizationId(String.valueOf(orderSale.getProfessionalOrganizationId()));
        accessoryCommon.setGoodsSupplierId(String.valueOf(orderSale.getGoodsSupplierId()));
        accessoryCommon.setObjectId(saleOrderId);
        accessoryCommon.setObjectType(OrderCenterConstant.ACCESSORY_ADJUST_SALE_ORDER);
        accessoryCommon.setCreateDate(new Date());
        if (saleAdjustAccessoryReqBOs != null && saleAdjustAccessoryReqBOs.size() > 0) {
            for (XbjAccessoryBusiReqBO saleAdjustAccessoryReqBO : saleAdjustAccessoryReqBOs) {
                AccessoryXbjPO accessoryParam = new AccessoryXbjPO();
                BeanUtils.copyProperties((Object)accessoryCommon, (Object)accessoryParam);
                accessoryParam.setAccessoryName(saleAdjustAccessoryReqBO.getAccessoryName());
                accessoryParam.setAccessoryUrl(saleAdjustAccessoryReqBO.getAccessoryUrl());
                this.accessoryXbjMapper.insert(accessoryParam);
            }
        }
        OrderSaleXbjReqBO orderSaleReqBO = new OrderSaleXbjReqBO();
        orderSaleReqBO.setSaleOrderOldStatus(orderSale.getSaleOrderStatus());
        orderSaleReqBO.setSaleOrderStatus(17);
        orderSaleReqBO.setSaleOrderId(saleOrderId);
        orderSaleReqBO.setPurchaserId(purchaserId);
        orderSaleReqBO.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        orderSaleReqBO.setOperId(sAdjustReqBO.getUserId() + "");
        orderSaleReqBO.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        orderSaleReqBO.setContractMark(sAdjustReqBO.getContractMark());
        this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
        XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
        orderFlowSheetReqBO.setOrderId(saleOrderId);
        orderFlowSheetReqBO.setPurchaserId(purchaserId);
        orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
        orderFlowSheetReqBO.setUserId(sAdjustReqBO.getUserId());
        orderFlowSheetReqBO.setUserName(sAdjustReqBO.getUserName());
        orderFlowSheetReqBO.setCompanyName(sAdjustReqBO.getCompanyName());
        if (XbjOrderConstants.IS_DISPATCH_NO.equals(orderSale.getIsDispatch())) {
            orderFlowSheetReqBO.setOperRole("\u8ba1\u5212\u91c7\u8d2d\u5458");
            orderFlowSheetReqBO.setOrderBusiType("B_32");
        } else {
            orderFlowSheetReqBO.setOperRole("\u914d\u9001\u4e13\u8d23");
            orderFlowSheetReqBO.setOrderBusiType("B_2");
        }
        if (this.isDebugEnabled) {
            log.debug("\u6d41\u7a0b\u8bb0\u5f55\u670d\u52a1\u5165\u53c2:" + orderFlowSheetReqBO.toString());
        }
        XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
        if (this.isDebugEnabled) {
            log.debug("\u6d41\u7a0b\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2:" + orderFlowSheetRspBO.toString());
        }
        if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
            if (this.isDebugEnabled) {
                log.debug("\u8c03\u4ef7\u6838\u5b9e\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5b8c\u6210");
            }
        } else {
            if (this.isDebugEnabled) {
                log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5f02\u5e38\uff1a" + orderFlowSheetRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5f02\u5e38\uff1a" + orderFlowSheetRspBO.getRespDesc());
        }
        sAdjustRspBO.setRespCode("0000");
        sAdjustRspBO.setRespDesc("\u8c03\u4ef7\u6838\u5b9e\u6210\u529f");
        return sAdjustRspBO;
    }

    private RspInfoBO saveAdjustPriceRecodeBatch(XbjSaleOrderItemAdjustReqBO sAdjustReqBO) throws Exception {
        Long purchaserId = Long.parseLong(sAdjustReqBO.getPurchaserId());
        Long saleOrderId = Long.parseLong(sAdjustReqBO.getSaleOrderId());
        List orderSaleItemXbjBOs = sAdjustReqBO.getOrderSaleItemXbjBOs();
        RspInfoBO sAdjustRspBO = new RspInfoBO();
        OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(saleOrderId, purchaserId);
        if (orderSale == null) {
            throw new BusinessException("8888", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u5931\u8d25\uff1a\u6839\u636esaleOrderId\u548cpurchaserId\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        }
        for (OrderSaleItemXbjBO itemXbjBO : orderSaleItemXbjBOs) {
            Long saleOrderItemId = Long.parseLong(itemXbjBO.getSaleOrderItemId());
            BigDecimal purchasingPrice = itemXbjBO.getPurchasingPriceNew();
            BigDecimal salePrice = itemXbjBO.getPurchasingPriceNew().multiply(new BigDecimal(itemXbjBO.getMarkUpRateNew())).setScale(2, 4);
            Double markUpRateNew = itemXbjBO.getMarkUpRateNew();
            OrderSaleItemXbjPO orderSaleItem = new OrderSaleItemXbjPO();
            orderSaleItem.setSaleOrderItemId(saleOrderItemId);
            orderSaleItem.setPurchaserId(purchaserId);
            orderSaleItem.setSaleOrderId(saleOrderId);
            orderSaleItem = this.orderSaleItemXbjMapper.selectBySaleOrderItemIdAndPurchaserId(orderSaleItem);
            if (orderSaleItem != null) {
                orderSaleItem.setNewPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)purchasingPrice));
                orderSaleItem.setNewSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)salePrice));
                orderSaleItem.setMarkUpRateNew(markUpRateNew);
                orderSaleItem.setSaleOrderItemId(saleOrderItemId);
                orderSaleItem.setPurchaserId(purchaserId);
                this.orderSaleItemXbjMapper.updateById(orderSaleItem);
                continue;
            }
            throw new BusinessException("8888", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u5931\u8d25\uff1a\u6839\u636e[saleOrderItemId + saleOrderId + purchaserId]\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6");
        }
        sAdjustRspBO.setRespCode("0000");
        sAdjustRspBO.setRespDesc("\u8c03\u4ef7\u6838\u5b9e\u6279\u91cf\u4fee\u6539\u4ef7\u683c\u6210\u529f");
        return sAdjustRspBO;
    }
}

