/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.QryOrderListXbjAtomService;
import com.cgd.order.busi.bo.XbjTabInfoBO;
import com.cgd.order.intfce.XbjQryOrderListIntfceService;
import com.cgd.order.intfce.bo.XbjOrderConstrInfoBO;
import com.cgd.order.intfce.bo.XbjOrderConstrListRspBO;
import com.cgd.order.intfce.bo.XbjOrderListQryReqBO;
import com.cgd.order.intfce.bo.XbjOrderServInfoBO;
import com.cgd.order.intfce.bo.XbjOrderServListRspBO;
import com.cgd.order.intfce.bo.XbjOrderShipInfoBO;
import com.cgd.order.intfce.bo.XbjOrderShipListRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderListIntfceServiceImpl
implements XbjQryOrderListIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderListIntfceService.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private QryOrderListXbjAtomService qryOrderListXbjAtomService;
    @Autowired
    DicDictionaryService dicDictionaryService;

    public void setQryOrderListXbjAtomService(QryOrderListXbjAtomService qryOrderListXbjAtomService) {
        this.qryOrderListXbjAtomService = qryOrderListXbjAtomService;
    }

    public XbjOrderShipListRspBO qryOrderShipListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        XbjOrderShipListRspBO rspPageBO = new XbjOrderShipListRspBO();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("inspection".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipInspection(reqBO);
            Map shipStatusMap = this.dicDictionaryService.getValueByCode("WUZI_SHIP_STATUS");
            for (XbjOrderShipInfoBO shipInfoBO : rspPageBO.getRows()) {
                shipInfoBO.setShipStatusStr((String)shipStatusMap.get(shipInfoBO.getShipStatus()));
            }
        } else if ("tabCount".equals(orderType)) {
            ArrayList<XbjTabInfoBO> tabList = new ArrayList<XbjTabInfoBO>();
            for (Integer tabId : reqBO.getTabIds()) {
                XbjTabInfoBO tabInfo = new XbjTabInfoBO();
                reqBO.setTabId(tabId);
                rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipInspection(reqBO);
                tabInfo.setTabId(tabId);
                tabInfo.setTabCount(Integer.valueOf(rspPageBO.getRecordsTotal()));
                tabList.add(tabInfo);
            }
            rspPageBO.setTabInfoList(tabList);
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    public XbjOrderConstrListRspBO qryOrderConstrListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        XbjOrderConstrListRspBO rspPageBO = new XbjOrderConstrListRspBO();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("inspection".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrInspection(reqBO);
            Map constrStatusMap = this.dicDictionaryService.getValueByCode("SERV_SHIP_STATUS");
            for (XbjOrderConstrInfoBO constrInfoBO : rspPageBO.getRows()) {
                constrInfoBO.setConstrStatusStr((String)constrStatusMap.get(constrInfoBO.getConstrStatus()));
            }
        } else if ("tabCount".equals(orderType)) {
            ArrayList<XbjTabInfoBO> tabList = new ArrayList<XbjTabInfoBO>();
            for (Integer tabId : reqBO.getTabIds()) {
                XbjTabInfoBO tabInfo = new XbjTabInfoBO();
                reqBO.setTabId(tabId);
                rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrInspection(reqBO);
                tabInfo.setTabId(tabId);
                tabInfo.setTabCount(Integer.valueOf(rspPageBO.getRecordsTotal()));
                tabList.add(tabInfo);
            }
            rspPageBO.setTabInfoList(tabList);
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    public XbjOrderServListRspBO qryOrderServListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        XbjOrderServListRspBO rspPageBO = new XbjOrderServListRspBO();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderServBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderServByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("inspection".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderServInspection(reqBO);
            Map servStatusMap = this.dicDictionaryService.getValueByCode("SERV_SHIP_STATUS");
            for (XbjOrderServInfoBO constrInfoBO : rspPageBO.getRows()) {
                constrInfoBO.setServStatusStr((String)servStatusMap.get(constrInfoBO.getServStatus()));
            }
        } else if ("tabCount".equals(orderType)) {
            ArrayList<XbjTabInfoBO> tabList = new ArrayList<XbjTabInfoBO>();
            for (Integer tabId : reqBO.getTabIds()) {
                XbjTabInfoBO tabInfo = new XbjTabInfoBO();
                reqBO.setTabId(tabId);
                rspPageBO = this.qryOrderListXbjAtomService.qryOrderServInspection(reqBO);
                tabInfo.setTabId(tabId);
                tabInfo.setTabCount(Integer.valueOf(rspPageBO.getRecordsTotal()));
                tabList.add(tabInfo);
            }
            rspPageBO.setTabInfoList(tabList);
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    private String validateParams(XbjOrderListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\u5386\u53f2\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleOrderId() != null) {
            return "sale";
        }
        if (reqBO.getPurchaseOrderId() != null) {
            return "purchase";
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIds())) {
            return "tabCount";
        }
        return "inspection";
    }
}

