/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.busi.XbjQuerySaleOrderInfoBusiService;
import com.cgd.order.busi.bo.InfoAddressRspBO;
import com.cgd.order.busi.bo.XbjAccessoryRspBO;
import com.cgd.order.busi.bo.XbjOrderDealNoticeItemReqBO;
import com.cgd.order.busi.bo.XbjOrderProtocolItemReqBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderInfoReqBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderInfoRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XOrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.InfoAddressXbjMapper;
import com.cgd.order.dao.OrderAdjustXbjMapper;
import com.cgd.order.dao.OrderDealNoticeItemMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InfoAddressXbjPO;
import com.cgd.order.po.OrderAdjustXbjPO;
import com.cgd.order.po.OrderDealNoticeItemXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.user.account.busi.QryEffActInfoByOrgBusiService;
import com.cgd.user.account.busi.bo.AccountInfoBO;
import com.cgd.user.account.busi.bo.QryActInfoByOrgReq;
import com.cgd.user.account.busi.bo.QryActInfoByOrgRsp;
import com.cgd.user.invoice.busi.QryInvoiceByAccountIdBusiService;
import com.cgd.user.invoice.busi.bo.InvoiceInfoBO;
import com.cgd.user.invoice.busi.bo.QryInvoiceByAccountIdReqBO;
import com.cgd.user.invoice.busi.bo.QryInvoiceByAccountIdRspBO;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQuerySaleOrderInfoBusiServiceImpl
implements XbjQuerySaleOrderInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQuerySaleOrderInfoBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private OrderDealNoticeItemMapper orderDealNoticeItemMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private InfoAddressXbjMapper infoAddressXbjMapper;
    @Autowired
    private QryInvoiceByAccountIdBusiService qryInvoiceByAccountIdBusiService;
    @Autowired
    private QryEffActInfoByOrgBusiService qryEffActInfoByOrgBusiService;
    @Autowired
    private QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;
    @Autowired
    private OrderAdjustXbjMapper orderAdjustXbjMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public XbjQuerySaleOrderInfoRspBO querySaleOrderInfo(XbjQuerySaleOrderInfoReqBO xbjQuerySaleOrderInfoReqBO) {
        this.validateArg(xbjQuerySaleOrderInfoReqBO);
        XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO = new XbjQuerySaleOrderInfoRspBO();
        try {
            Long purchaserId = 0L;
            if (xbjQuerySaleOrderInfoReqBO.getPurchaserId() != null) {
                purchaserId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getPurchaserId());
            }
            if (xbjQuerySaleOrderInfoReqBO.getSaleOrderId() != null && !xbjQuerySaleOrderInfoReqBO.getSaleOrderId().equals("")) {
                Long saleOrderId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getSaleOrderId());
                this.getSaleOrderInfo(saleOrderId, xbjQuerySaleOrderInfoRspBO, purchaserId);
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
            } else if (xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId() != null && !xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId().equals("")) {
                Long purchaseOrderId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId());
                this.getPurchaseOrderInfo(purchaseOrderId, xbjQuerySaleOrderInfoRspBO, purchaserId);
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
            } else {
                xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u65e0\u6548\u5165\u53c2");
                return xbjQuerySaleOrderInfoRspBO;
            }
            this.setOrderDispatchName(xbjQuerySaleOrderInfoRspBO);
            this.setOrderResorces(xbjQuerySaleOrderInfoRspBO);
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5========================================");
            }
        }
        catch (Exception e) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38");
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38:" + e);
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private XbjQuerySaleOrderInfoRspBO getSaleOrderInfo(Long saleOrderId, XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Long purchaserId) throws Exception {
        Map valueByCode;
        String giveTime;
        Map valueByCode2;
        String payType;
        OrderPurchaseXbjPO orderPurchasePo;
        OrderSaleXbjPO xbjOrderSale = this.orderSaleXbjMapper.getModelById(saleOrderId);
        if (xbjOrderSale == null) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
            return xbjQuerySaleOrderInfoRspBO;
        }
        BeanUtils.copyProperties((Object)xbjOrderSale, (Object)xbjQuerySaleOrderInfoRspBO);
        xbjQuerySaleOrderInfoRspBO.setSaleOrderId(xbjOrderSale.getSaleOrderId().toString());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(xbjOrderSale.getNeedContactName());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(xbjOrderSale.getNeedContactMobile());
        xbjQuerySaleOrderInfoRspBO.setSupplierName(xbjOrderSale.getGoodsSupplierName());
        xbjQuerySaleOrderInfoRspBO.setSupplierManName(xbjOrderSale.getGoodsSupplierRelaman());
        xbjQuerySaleOrderInfoRspBO.setSupplierManPhone(xbjOrderSale.getGoodsSupplierMobile());
        xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(String.valueOf(xbjOrderSale.getProfessionalOrganizationId()));
        xbjQuerySaleOrderInfoRspBO.setProfessionalAccount(String.valueOf(xbjOrderSale.getProfessionalAccount()));
        xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus(xbjOrderSale.getSaleOrderStatus() + "");
        xbjQuerySaleOrderInfoRspBO.setContractMark(xbjOrderSale.getContractMark());
        QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
        qryOrgInfoByIdReqBO.setOrganizationId(xbjQuerySaleOrderInfoRspBO.getPurchaserId());
        QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
        if (null == qryOrgInfoByIdRspBO || qryOrgInfoByIdRspBO.getUserOrganisationBO() == null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserName(qryOrgInfoByIdRspBO.getUserOrganisationBO().getTitle());
        }
        if (xbjOrderSale.getSaleOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)xbjOrderSale.getSaleOrderMoney()));
        }
        if ((orderPurchasePo = this.orderPurchaseXbjMapper.getModelById(xbjOrderSale.getPurchaseOrderId())).getPurchaseOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderPurchasePo.getPurchaseOrderMoney()));
        }
        this.getEnterpriseAndSupplierPayType(xbjQuerySaleOrderInfoRspBO);
        String saleOrderStatus = "" + xbjQuerySaleOrderInfoRspBO.getSaleOrderStatus();
        if (saleOrderStatus != null && !"".equals(saleOrderStatus)) {
            Map valueByCode3 = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
            Map servOrderStatusMap = this.dicDictionaryService.getValueByCode("SERV_ORDER_STATUS");
            Map constrOrderStatusMap = this.dicDictionaryService.getValueByCode("CONSTR_ORDER_STATUS");
            if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI) {
                if (null != saleOrderStatus && null != valueByCode3) {
                    xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus((String)valueByCode3.get(String.valueOf(saleOrderStatus)));
                }
            } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG) {
                if (null != saleOrderStatus && null != constrOrderStatusMap) {
                    xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus((String)constrOrderStatusMap.get(String.valueOf(saleOrderStatus)));
                }
            } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU && null != saleOrderStatus && null != servOrderStatusMap) {
                xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus((String)servOrderStatusMap.get(String.valueOf(saleOrderStatus)));
            }
        }
        if ((payType = xbjQuerySaleOrderInfoRspBO.getPayType()) != null && !"".equals(payType) && (valueByCode2 = this.dicDictionaryService.getValueByCode("PAY_TYPE")) != null) {
            String payTypeString = (String)valueByCode2.get(payType);
            xbjQuerySaleOrderInfoRspBO.setPayType(payTypeString);
        }
        if ((giveTime = xbjQuerySaleOrderInfoRspBO.getGiveTime()) != null && !"".equals(giveTime) && (valueByCode = this.dicDictionaryService.getValueByCode("GIVE_TIME")) != null) {
            String giveTimeString = (String)valueByCode.get(giveTime);
            xbjQuerySaleOrderInfoRspBO.setGiveTime(giveTimeString);
        }
        if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_PROTOCOL)) {
            InfoAddressRspBO qryInfoAddress = this.qryInfoAddress(saleOrderId, xbjOrderSale.getPurchaserId());
            if (qryInfoAddress != null) {
                xbjQuerySaleOrderInfoRspBO.setReceiverName(qryInfoAddress.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(qryInfoAddress.getReceiverMobileNumber());
                String fullAddress = qryInfoAddress.getAddress();
                xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(fullAddress);
            }
        } else if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_OTHER)) {
            OrderSaleItemXbjPO condition = new OrderSaleItemXbjPO();
            condition.setPurchaserId(xbjOrderSale.getPurchaserId());
            condition.setSaleOrderId(xbjOrderSale.getSaleOrderId());
            List<OrderSaleItemXbjPO> itemList = this.orderSaleItemXbjMapper.getList(condition);
            if (itemList != null && itemList.size() > 0) {
                xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(xbjOrderSale.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(xbjOrderSale.getReceiverMobile());
                xbjQuerySaleOrderInfoRspBO.setReceiverName(xbjOrderSale.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(xbjOrderSale.getReceiverMobile());
                xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(itemList.get(0).getRecvAddr());
            }
        }
        if (XConstant.SALE_ORDER_STATE_RECHECK.equals(xbjOrderSale.getSaleOrderStatus())) {
            OrderAdjustXbjPO orderAdjustPO = new OrderAdjustXbjPO();
            orderAdjustPO.setSaleOrderNo(xbjOrderSale.getSaleOrderId());
            List<OrderAdjustXbjPO> adjustPOlist = this.orderAdjustXbjMapper.getOrderAdjustList(orderAdjustPO);
            if (adjustPOlist != null && adjustPOlist.size() > 0) {
                xbjQuerySaleOrderInfoRspBO.setRemark(adjustPOlist.get(0).getRemark());
            }
            AccessoryXbjPO accessoryXbjPO = new AccessoryXbjPO();
            accessoryXbjPO.setObjectType(OrderCenterConstant.ACCESSORY_ADJUST_SALE_ORDER);
            accessoryXbjPO.setObjectId(xbjOrderSale.getSaleOrderId());
            List<AccessoryAtomXbjRspBO> accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(accessoryXbjPO.getObjectId(), accessoryXbjPO.getObjectType());
            if (accessoryXbjPOlist != null && accessoryXbjPOlist.size() > 0) {
                ArrayList<XbjAccessoryRspBO> accessoryList = new ArrayList<XbjAccessoryRspBO>();
                for (AccessoryAtomXbjRspBO accessoryXbjPOTmp : accessoryXbjPOlist) {
                    XbjAccessoryRspBO xbjAccessoryRspBO = new XbjAccessoryRspBO();
                    xbjAccessoryRspBO.setAccessoryName(accessoryXbjPOTmp.getAccessoryName());
                    xbjAccessoryRspBO.setAccessoryId(accessoryXbjPOTmp.getId());
                    xbjAccessoryRspBO.setAccessoryUrl(accessoryXbjPOTmp.getAccessoryUrl());
                    accessoryList.add(xbjAccessoryRspBO);
                }
                xbjQuerySaleOrderInfoRspBO.setDownLoadFiles(accessoryList);
            }
        }
        Integer saleOrderType = xbjOrderSale.getSaleOrderType();
        this.getProtocolInfo(xbjQuerySaleOrderInfoRspBO, saleOrderType, xbjOrderSale.getSaleOrderId());
        if (!xbjQuerySaleOrderInfoRspBO.getRespCode().equals("0000")) {
            return xbjQuerySaleOrderInfoRspBO;
        }
        if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_PROTOCOL) && XbjOrderConstants.IS_DISPATCH_YES.equals(xbjOrderSale.getIsDispatch())) {
            xbjQuerySaleOrderInfoRspBO.setProfessionalName(xbjQuerySaleOrderInfoRspBO.getXbjOrderProtocolItemReqBO().getProducerName());
            SelectUserInfoByUserIdReqBO reqBO = new SelectUserInfoByUserIdReqBO();
            reqBO.setUserId(xbjQuerySaleOrderInfoRspBO.getXbjOrderProtocolItemReqBO().getProducerId());
            SelectUserInfoByUserIdRspBO rspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(reqBO);
            if (rspBO != null) {
                xbjQuerySaleOrderInfoRspBO.setProfessionalMobile(rspBO.getCellphone());
            }
        }
        String adjustMechanism = xbjQuerySaleOrderInfoRspBO.getAdjustMechanism();
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5 adjustMechanism==============================" + adjustMechanism);
        }
        Map adjustMechanismCode = this.dicDictionaryService.getValueByCode("ADJUST_PRICE");
        if (null != adjustMechanism && null != adjustMechanismCode) {
            xbjQuerySaleOrderInfoRspBO.setAdjustMechanismName((String)adjustMechanismCode.get(adjustMechanism));
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5 \u51fa\u53c2==============================" + JSON.toJSONString((Object)xbjQuerySaleOrderInfoRspBO));
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private XbjQuerySaleOrderInfoRspBO getPurchaseOrderInfo(Long purchaseOrderId, XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Long purchaserId) throws Exception {
        SelectUserInfoByUserIdRspBO rspBO;
        SelectUserInfoByUserIdReqBO reqBO;
        List accountInfoBOs;
        Map valueByCode;
        String giveTime;
        Map valueByCode2;
        String payType;
        OrderSaleXbjPO xbjOrderSale;
        OrderPurchaseXbjPO orderPurchasePo = this.orderPurchaseXbjMapper.getModelById(purchaseOrderId);
        if (orderPurchasePo == null) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
            return xbjQuerySaleOrderInfoRspBO;
        }
        BeanUtils.copyProperties((Object)orderPurchasePo, (Object)xbjQuerySaleOrderInfoRspBO);
        xbjQuerySaleOrderInfoRspBO.setSaleOrderId(orderPurchasePo.getSaleOrderId().toString());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(orderPurchasePo.getNeedContactName());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(orderPurchasePo.getNeedContactMobile());
        xbjQuerySaleOrderInfoRspBO.setSupplierName(orderPurchasePo.getGoodsSupplierName());
        xbjQuerySaleOrderInfoRspBO.setSupplierManName(orderPurchasePo.getGoodsSupplierRelaman());
        xbjQuerySaleOrderInfoRspBO.setSupplierManPhone(orderPurchasePo.getGoodsSupplierMobile());
        xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(String.valueOf(orderPurchasePo.getProfessionalOrganizationId()));
        xbjQuerySaleOrderInfoRspBO.setProfessionalAccount(String.valueOf(orderPurchasePo.getProfessionalAccount()));
        xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus(orderPurchasePo.getPurchaseOrderStatus() + "");
        xbjQuerySaleOrderInfoRspBO.setArriveTime(orderPurchasePo.getArriveTime());
        xbjQuerySaleOrderInfoRspBO.setArriveType(orderPurchasePo.getArriveType());
        xbjQuerySaleOrderInfoRspBO.setContractMark(orderPurchasePo.getContractMark());
        QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
        qryOrgInfoByIdReqBO.setOrganizationId(xbjQuerySaleOrderInfoRspBO.getPurchaserId());
        QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
        if (null == qryOrgInfoByIdRspBO || qryOrgInfoByIdRspBO.getUserOrganisationBO() == null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserName(qryOrgInfoByIdRspBO.getUserOrganisationBO().getTitle());
        }
        if (orderPurchasePo.getPurchaseOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderPurchasePo.getPurchaseOrderMoney()));
        }
        if ((xbjOrderSale = this.orderSaleXbjMapper.getModelById(orderPurchasePo.getSaleOrderId())).getSaleOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)xbjOrderSale.getSaleOrderMoney()));
            xbjQuerySaleOrderInfoRspBO.setSaleOrderId(xbjOrderSale.getSaleOrderId().toString());
            xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(xbjOrderSale.getPurchaserAccountName());
            xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(xbjOrderSale.getPurchaserMobile());
            xbjQuerySaleOrderInfoRspBO.setSupplierName(xbjOrderSale.getGoodsSupplierName());
            xbjQuerySaleOrderInfoRspBO.setSupplierManName(xbjOrderSale.getGoodsSupplierRelaman());
            xbjQuerySaleOrderInfoRspBO.setSupplierManPhone(xbjOrderSale.getGoodsSupplierMobile());
            xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(String.valueOf(xbjOrderSale.getProfessionalOrganizationId()));
            xbjQuerySaleOrderInfoRspBO.setProfessionalAccount(String.valueOf(xbjOrderSale.getProfessionalAccount()));
            xbjQuerySaleOrderInfoRspBO.setProfessionalMobile(xbjOrderSale.getProfessionalMobile());
            xbjQuerySaleOrderInfoRspBO.setProfessionalName(xbjOrderSale.getProfessionalName());
            xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(xbjOrderSale.getProfessionalOrganizationId() + "");
        }
        this.getEnterpriseAndSupplierPayType(xbjQuerySaleOrderInfoRspBO);
        String purchaseStatus = xbjQuerySaleOrderInfoRspBO.getPurchaseOrderStatus();
        if (purchaseStatus != null && !"".equals(purchaseStatus)) {
            Map orderStatusCode = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
            Map servOrderStatusMap = this.dicDictionaryService.getValueByCode("SERV_ORDER_STATUS");
            Map constrOrderStatusMap = this.dicDictionaryService.getValueByCode("CONSTR_ORDER_STATUS");
            if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI) {
                if (null != purchaseStatus && null != orderStatusCode) {
                    xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus((String)orderStatusCode.get(String.valueOf(purchaseStatus)));
                }
            } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG) {
                if (null != purchaseStatus && null != constrOrderStatusMap) {
                    xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus((String)constrOrderStatusMap.get(String.valueOf(purchaseStatus)));
                }
            } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU && null != purchaseStatus && null != servOrderStatusMap) {
                xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus((String)servOrderStatusMap.get(String.valueOf(purchaseStatus)));
            }
        }
        if ((payType = orderPurchasePo.getPayType()) != null && !"".equals(payType) && (valueByCode2 = this.dicDictionaryService.getValueByCode("PAY_TYPE")) != null) {
            String payTypeString = (String)valueByCode2.get(payType);
            xbjQuerySaleOrderInfoRspBO.setPayType(payTypeString);
        }
        if ((giveTime = xbjQuerySaleOrderInfoRspBO.getGiveTime()) != null && !"".equals(giveTime) && (valueByCode = this.dicDictionaryService.getValueByCode("GIVE_TIME")) != null) {
            String giveTimeString = (String)valueByCode.get(giveTime);
            xbjQuerySaleOrderInfoRspBO.setGiveTime(giveTimeString);
        }
        if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_PROTOCOL)) {
            InfoAddressRspBO qryInfoAddress = this.qryInfoAddress(orderPurchasePo.getSaleOrderId(), orderPurchasePo.getPurchaserId());
            if (qryInfoAddress != null) {
                xbjQuerySaleOrderInfoRspBO.setReceiverName(qryInfoAddress.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(qryInfoAddress.getReceiverMobileNumber());
                String fullAddress = qryInfoAddress.getAddress();
                xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(fullAddress);
            }
        } else if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_OTHER)) {
            OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
            condition.setPurchaserId(orderPurchasePo.getPurchaserId());
            condition.setPurchaseOrderId(orderPurchasePo.getPurchaseOrderId());
            List<OrderPurchaseItemXbjPO> itemList = this.orderPurchaseItemXbjMapper.getList(condition);
            if (itemList != null && itemList.size() > 0) {
                xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(xbjOrderSale.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(xbjOrderSale.getReceiverMobile());
                xbjQuerySaleOrderInfoRspBO.setReceiverName(xbjOrderSale.getReceiverName());
                xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(xbjOrderSale.getReceiverMobile());
                xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(itemList.get(0).getRecvAddr());
            }
        }
        QryActInfoByOrgReq qryActInfoByOrgReq = new QryActInfoByOrgReq();
        qryActInfoByOrgReq.setParamOrgId(orderPurchasePo.getProfessionalOrganizationId());
        QryActInfoByOrgRsp qryActInfoByOrgRsp = this.qryEffActInfoByOrgBusiService.qryEffActInfoByOrg(qryActInfoByOrgReq);
        if (qryActInfoByOrgRsp != null && qryActInfoByOrgRsp.getRespCode().equals("0000") && null != (accountInfoBOs = qryActInfoByOrgRsp.getAccountInfoBOs()) && accountInfoBOs.size() == 1) {
            List invoiceInfos;
            log.error("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c611111111\u2014\u2014accountInfoBOs\uff1a" + JSON.toJSONString((Object)accountInfoBOs));
            QryInvoiceByAccountIdReqBO qryBO = new QryInvoiceByAccountIdReqBO();
            qryBO.setAccountId(((AccountInfoBO)accountInfoBOs.get(0)).getAccountId());
            QryInvoiceByAccountIdRspBO invoiceInfoRspBO = this.qryInvoiceByAccountIdBusiService.qryInvoiceByAccountId(qryBO);
            if (invoiceInfoRspBO != null && (invoiceInfos = invoiceInfoRspBO.getAccountInfoBOs()) != null && invoiceInfos.size() > 0) {
                InvoiceInfoBO invoiceBO = (InvoiceInfoBO)invoiceInfos.get(0);
                xbjQuerySaleOrderInfoRspBO.setCompanyName(invoiceBO.getInvoiceTitle());
                xbjQuerySaleOrderInfoRspBO.setCompanyAddress(invoiceBO.getAddress());
                xbjQuerySaleOrderInfoRspBO.setCompanyBankAccount(invoiceBO.getAccount());
                xbjQuerySaleOrderInfoRspBO.setCompanyBankName(invoiceBO.getBank());
                xbjQuerySaleOrderInfoRspBO.setCompanyPhone(invoiceBO.getPhone());
                xbjQuerySaleOrderInfoRspBO.setCompanyTaxNo(invoiceBO.getTaxpayerId());
            }
        }
        Integer saleOrderType = orderPurchasePo.getSaleOrderType();
        this.getProtocolInfo(xbjQuerySaleOrderInfoRspBO, saleOrderType, orderPurchasePo.getSaleOrderId());
        if (!xbjQuerySaleOrderInfoRspBO.getRespCode().equals("0000")) {
            return xbjQuerySaleOrderInfoRspBO;
        }
        if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_PROTOCOL) && XbjOrderConstants.IS_DISPATCH_YES.equals(xbjOrderSale.getIsDispatch())) {
            xbjQuerySaleOrderInfoRspBO.setProfessionalName(xbjQuerySaleOrderInfoRspBO.getXbjOrderProtocolItemReqBO().getProducerName());
            reqBO = new SelectUserInfoByUserIdReqBO();
            reqBO.setUserId(xbjQuerySaleOrderInfoRspBO.getXbjOrderProtocolItemReqBO().getProducerId());
            rspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(reqBO);
            if (rspBO != null) {
                xbjQuerySaleOrderInfoRspBO.setProfessionalMobile(rspBO.getTelephone());
            }
        } else if (xbjOrderSale.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_OTHER)) {
            reqBO = new SelectUserInfoByUserIdReqBO();
            reqBO.setUserId(xbjOrderSale.getDeliveryId());
            rspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(reqBO);
            if (rspBO != null) {
                xbjQuerySaleOrderInfoRspBO.setProfessionalName(rspBO.getName());
                xbjQuerySaleOrderInfoRspBO.setProfessionalMobile(rspBO.getTelephone());
            }
        }
        String adjustMechanism = xbjQuerySaleOrderInfoRspBO.getAdjustMechanism();
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5 adjustMechanism==============================" + adjustMechanism);
        }
        Map adjustMechanismCode = this.dicDictionaryService.getValueByCode("ADJUST_PRICE");
        if (null != adjustMechanism && null != adjustMechanismCode) {
            xbjQuerySaleOrderInfoRspBO.setAdjustMechanismName((String)adjustMechanismCode.get(adjustMechanism));
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5 \u51fa\u53c2==============================" + JSON.toJSONString((Object)xbjQuerySaleOrderInfoRspBO));
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private void setOrderDispatchName(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() != null) {
            if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() == XbjOrderConstants.IS_DISPATCH_YES) {
                xbjQuerySaleOrderInfoRspBO.setIsDispatchName("\u662f");
            } else if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() == XbjOrderConstants.IS_DISPATCH_NO) {
                xbjQuerySaleOrderInfoRspBO.setIsDispatchName("\u5426");
            }
        }
    }

    private void setOrderResorces(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
        if (null != xbjQuerySaleOrderInfoRspBO.getSaleOrderType() && null != orderSourceMap) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderTypeName((String)orderSourceMap.get(String.valueOf(xbjQuerySaleOrderInfoRspBO.getSaleOrderType())));
        }
    }

    private void validateArg(XbjQuerySaleOrderInfoReqBO xbjSaleOrderInfoReqBO) {
        if (xbjSaleOrderInfoReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1axbjSaleOrderInfoReqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private XbjQuerySaleOrderInfoRspBO getProtocolInfo(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Integer saleOrderType, Long saleOrderId) throws Exception {
        if (saleOrderType != null) {
            Map valueByCode = this.dicDictionaryService.getValueByCode("PAY_WAY_SUP");
            if (XbjOrderConstants.SALE_ORDER_TYPE_XBJ.equals(saleOrderType)) {
                OrderDealNoticeItemXbjPO orderDealNoticeItemXbjPO = new OrderDealNoticeItemXbjPO();
                orderDealNoticeItemXbjPO.setSaleOrderId(saleOrderId);
                List<OrderDealNoticeItemXbjPO> list = this.orderDealNoticeItemMapper.getListBySaleOrderId(orderDealNoticeItemXbjPO);
                if (list == null || list.isEmpty()) {
                    xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
                    xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u65f6\uff1a\u67e5\u8be2\u6210\u4ea4\u901a\u77e5\u4e66\u8868\u65e0\u8bb0\u5f55\uff01");
                    return xbjQuerySaleOrderInfoRspBO;
                }
                OrderDealNoticeItemXbjPO po1 = list.get(0);
                XbjOrderDealNoticeItemReqBO xbjOrderDealNoticeItemReqBO = new XbjOrderDealNoticeItemReqBO();
                BeanUtils.copyProperties((Object)po1, (Object)xbjOrderDealNoticeItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setXbjOrderDealNoticeItemReqBO(xbjOrderDealNoticeItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setAdjustFoemula(xbjOrderDealNoticeItemReqBO.getAdjustFoemula());
                xbjQuerySaleOrderInfoRspBO.setAdjustMechanism(String.valueOf(xbjOrderDealNoticeItemReqBO.getAdjustMechanism()));
                xbjQuerySaleOrderInfoRspBO.setProtocolName(xbjOrderDealNoticeItemReqBO.getDealNoticeName());
                xbjQuerySaleOrderInfoRspBO.setTaxRate(po1.getTaxRate());
                if (valueByCode != null && po1.getPay() != null) {
                    String payWayString = (String)valueByCode.get(po1.getPay());
                    xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWayString);
                }
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                return xbjQuerySaleOrderInfoRspBO;
            }
            if (XbjOrderConstants.SALE_ORDER_TYPE_KJXY.equals(saleOrderType)) {
                OrderProtocolItemXbjPO queryBySaleOrderId = this.orderProtocolItemXbjMapper.queryBySaleOrderId(saleOrderId);
                XbjOrderProtocolItemReqBO xbjOrderProtocolItemReqBO = new XbjOrderProtocolItemReqBO();
                BeanUtils.copyProperties((Object)queryBySaleOrderId, (Object)xbjOrderProtocolItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setXbjOrderProtocolItemReqBO(xbjOrderProtocolItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setAdjustFoemula(xbjOrderProtocolItemReqBO.getAdjustFoemula());
                xbjQuerySaleOrderInfoRspBO.setAdjustMechanism(String.valueOf(xbjOrderProtocolItemReqBO.getAdjustMechanism()));
                xbjQuerySaleOrderInfoRspBO.setProtocolName(xbjOrderProtocolItemReqBO.getProtocolName());
                xbjQuerySaleOrderInfoRspBO.setTaxRate(queryBySaleOrderId.getTaxRate());
                if (valueByCode != null && queryBySaleOrderId.getPayWaySup() != null) {
                    String payWayString = (String)valueByCode.get(queryBySaleOrderId.getPayWaySup());
                    xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWayString);
                }
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                return xbjQuerySaleOrderInfoRspBO;
            }
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u6765\u6e90\uff08saleOrderType\uff09\u975e\u8be2\u6bd4\u4ef7\u7c7b\u578b\uff0c\u4e0d\u80fd\u67e5\u8be2");
            return xbjQuerySaleOrderInfoRspBO;
        }
        xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
        xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u6765\u6e90\uff08saleOrderType\uff09\u4e3a\u7a7a");
        return xbjQuerySaleOrderInfoRspBO;
    }

    private InfoAddressRspBO qryInfoAddress(Long saleOrderId, Long purchaserId) {
        InfoAddressXbjPO infoAddress = this.infoAddressXbjMapper.selectBySaleOrderIdAndPurchaserId(saleOrderId, purchaserId);
        InfoAddressRspBO infoAddressRspBO = new InfoAddressRspBO();
        if (infoAddress != null) {
            BeanUtils.copyProperties((Object)infoAddress, (Object)infoAddressRspBO);
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverProvinceName()) && !"0".equals(infoAddress.getReceiverProvinceName())) {
                builder.append(infoAddress.getReceiverProvinceName());
                infoAddressRspBO.setReceiverProvinceName(infoAddress.getReceiverProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverCityName()) && !"0".equals(infoAddress.getReceiverCityName())) {
                builder.append(infoAddress.getReceiverCityName());
                infoAddressRspBO.setReceiverCityName(infoAddress.getReceiverCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverCountyName()) && !"0".equals(infoAddress.getReceiverCountyName())) {
                builder.append(infoAddress.getReceiverCountyName());
                infoAddressRspBO.setReceiverCountyName(infoAddress.getReceiverCountyName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverTown()) && !"0".equals(infoAddress.getReceiverTown())) {
                builder.append(infoAddress.getReceiverTown());
                infoAddressRspBO.setReceiverTown(infoAddress.getReceiverTown());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverAddress()) && !"0".equals(infoAddress.getReceiverAddress())) {
                builder.append(infoAddress.getReceiverAddress());
            }
            infoAddressRspBO.setAddress(builder.toString());
        }
        return infoAddressRspBO;
    }

    private void getEnterpriseAndSupplierPayType(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        String payWaySup;
        String payWayEnt;
        StringBuilder builder1 = new StringBuilder();
        BigDecimal prePayEnt = xbjQuerySaleOrderInfoRspBO.getPrePayEnt();
        BigDecimal matPayEnt = xbjQuerySaleOrderInfoRspBO.getMatPayEnt();
        BigDecimal proPayEnt = xbjQuerySaleOrderInfoRspBO.getProPayEnt();
        BigDecimal verPayEnt = xbjQuerySaleOrderInfoRspBO.getVerPayEnt();
        BigDecimal pilPayEnt = xbjQuerySaleOrderInfoRspBO.getPilPayEnt();
        BigDecimal quaPayEnt = xbjQuerySaleOrderInfoRspBO.getQuaPayEnt();
        if (prePayEnt != null && BigDecimal.ZERO.compareTo(prePayEnt) != 0) {
            builder1.append("\u9884\u4ed8\u6b3e" + prePayEnt.intValue() + "%,");
        }
        if (matPayEnt != null && BigDecimal.ZERO.compareTo(matPayEnt) != 0) {
            builder1.append("\u6295\u6599\u6b3e" + matPayEnt.intValue() + "%,");
        }
        if (proPayEnt != null && BigDecimal.ZERO.compareTo(proPayEnt) != 0) {
            builder1.append("\u8fdb\u5ea6\u6b3e" + proPayEnt.intValue() + "%,");
        }
        if (verPayEnt != null && BigDecimal.ZERO.compareTo(verPayEnt) != 0) {
            builder1.append("\u5230\u8d27\u9a8c\u6536\u5408\u683c\u540e\u4ed8\u6b3e" + verPayEnt.intValue() + "%,");
        }
        if (pilPayEnt != null && BigDecimal.ZERO.compareTo(pilPayEnt) != 0) {
            builder1.append("\u8bd5\u8fd0\u884c\u9a8c\u6536\u6b3e" + pilPayEnt.intValue() + "%,");
        }
        if (quaPayEnt != null && BigDecimal.ZERO.compareTo(quaPayEnt) != 0) {
            builder1.append("\u8d28\u4fdd\u91d1" + quaPayEnt.intValue() + "%,");
        }
        if (StringUtils.isNotBlank((CharSequence)(payWayEnt = builder1.toString()))) {
            payWayEnt = payWayEnt.substring(0, payWayEnt.length() - 1);
            xbjQuerySaleOrderInfoRspBO.setPurchaserPayMode(payWayEnt);
        }
        StringBuilder builder2 = new StringBuilder();
        BigDecimal prePaySup = xbjQuerySaleOrderInfoRspBO.getPrePaySup();
        BigDecimal matPaySup = xbjQuerySaleOrderInfoRspBO.getMatPaySup();
        BigDecimal proPaySup = xbjQuerySaleOrderInfoRspBO.getProPaySup();
        BigDecimal verPaySup = xbjQuerySaleOrderInfoRspBO.getVerPaySup();
        BigDecimal pilPaySup = xbjQuerySaleOrderInfoRspBO.getPilPaySup();
        BigDecimal quaPaySup = xbjQuerySaleOrderInfoRspBO.getQuaPaySup();
        if (prePaySup != null && BigDecimal.ZERO.compareTo(prePaySup) != 0) {
            builder2.append("\u9884\u4ed8\u6b3e" + prePaySup.intValue() + "%,");
        }
        if (matPaySup != null && BigDecimal.ZERO.compareTo(matPaySup) != 0) {
            builder2.append("\u6295\u6599\u6b3e" + matPaySup.intValue() + "%,");
        }
        if (proPaySup != null && BigDecimal.ZERO.compareTo(proPaySup) != 0) {
            builder2.append("\u8fdb\u5ea6\u6b3e" + proPaySup.intValue() + "%,");
        }
        if (verPaySup != null && BigDecimal.ZERO.compareTo(verPaySup) != 0) {
            builder2.append("\u5230\u8d27\u9a8c\u6536\u5408\u683c\u540e\u4ed8\u6b3e" + verPaySup.intValue() + "%,");
        }
        if (pilPaySup != null && BigDecimal.ZERO.compareTo(pilPaySup) != 0) {
            builder2.append("\u8bd5\u8fd0\u884c\u9a8c\u6536\u6b3e" + pilPaySup.intValue() + "%,");
        }
        if (quaPaySup != null && BigDecimal.ZERO.compareTo(quaPaySup) != 0) {
            builder2.append("\u8d28\u4fdd\u91d1" + quaPaySup.intValue() + "%,");
        }
        if (StringUtils.isNotBlank((CharSequence)(payWaySup = builder2.toString()))) {
            payWaySup = payWaySup.substring(0, payWaySup.length() - 1);
            xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWaySup);
        }
    }
}

