/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.busi.XbjQryOrderDetailForContractBusiService;
import com.cgd.order.busi.bo.XbjQryOrderDetailForContractRspBO;
import com.cgd.order.busi.bo.XbjQryOrderForContractReqBO;
import com.cgd.order.busi.bo.XbjQryOrderItemForContractBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.XbjQuerySaleOrderItemRspPO;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjQryOrderDetailForContractBusiService")
public class XbjQryOrderDetailForContractBusiServiceImpl
implements XbjQryOrderDetailForContractBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderDetailForContractBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;

    public XbjQryOrderDetailForContractRspBO selectOrderDetail(XbjQryOrderForContractReqBO reqBO) {
        XbjQryOrderDetailForContractRspBO itemReturn;
        Long purchaserId;
        XbjQryOrderDetailForContractRspBO rspBO = new XbjQryOrderDetailForContractRspBO();
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:" + reqBO.toString());
        }
        this.validateParams(reqBO);
        if (reqBO.getSaleOrderId() != null) {
            Map payTypeMap;
            OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
            orderSaleXbjPO.setSaleOrderId(reqBO.getSaleOrderId());
            try {
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            }
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
            }
            purchaserId = orderSaleXbjPO.getPurchaserId();
            rspBO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
            rspBO.setSaleOrderCode(orderSaleXbjPO.getSaleOrderCode());
            rspBO.setPurchaseOrderId(orderSaleXbjPO.getPurchaseOrderId());
            rspBO.setPurchaseOrderCode(orderSaleXbjPO.getPurchaseOrderCode());
            rspBO.setOrderName(orderSaleXbjPO.getSaleOrderName());
            rspBO.setSupplierId(orderSaleXbjPO.getGoodsSupplierId());
            rspBO.setSupplierName(orderSaleXbjPO.getGoodsSupplierName());
            rspBO.setSupplierContactName(orderSaleXbjPO.getGoodsSupplierRelaman());
            rspBO.setSupplierContactPhone(orderSaleXbjPO.getGoodsSupplierMobile());
            try {
                if (orderSaleXbjPO.getSaleOrderMoney() != null) {
                    rspBO.setOrderAmount(MoneyUtil.Long2BigDecimal((Long)orderSaleXbjPO.getSaleOrderMoney()));
                } else {
                    rspBO.setOrderAmount(BigDecimal.ZERO);
                }
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u5408\u540c\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5408\u540c\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\u5f02\u5e38" + e.getMessage());
            }
            rspBO.setOrderSouce(orderSaleXbjPO.getSaleOrderType());
            Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
            if (orderSourceMap != null) {
                rspBO.setOrderSourceName((String)orderSourceMap.get(orderSaleXbjPO.getSaleOrderType() + ""));
            }
            rspBO.setOrderType(orderSaleXbjPO.getOrderType());
            Map orderTypeMap = this.dicDictionaryService.getValueByCode("IQR_ORDER_TYPE");
            if (orderTypeMap != null) {
                rspBO.setOrderTypeName((String)orderTypeMap.get(orderSaleXbjPO.getOrderType() + ""));
            }
            rspBO.setContractName(orderSaleXbjPO.getNeedContactName());
            rspBO.setContractPhone(orderSaleXbjPO.getNeedContactMobile());
            rspBO.setGuaranteePeriod(orderSaleXbjPO.getWarantty());
            rspBO.setRate(orderSaleXbjPO.getTaxRate());
            rspBO.setPrePay(orderSaleXbjPO.getPrePayEnt());
            rspBO.setMatPay(orderSaleXbjPO.getMatPayEnt());
            rspBO.setProPay(orderSaleXbjPO.getProPayEnt());
            rspBO.setVerPay(orderSaleXbjPO.getVerPayEnt());
            rspBO.setPilPay(orderSaleXbjPO.getPilPayEnt());
            rspBO.setQuaPay(orderSaleXbjPO.getQuaPayEnt());
            rspBO.setPayType(orderSaleXbjPO.getPayType());
            rspBO.setProfessionalOrganizationId(orderSaleXbjPO.getProfessionalOrganizationId());
            QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
            qryOrgInfoByIdReqBO.setOrganizationId(orderSaleXbjPO.getProfessionalOrganizationId());
            QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
            if (qryOrgInfoByIdRspBO != null && qryOrgInfoByIdRspBO.getUserOrganisationBO() != null) {
                log.error("\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c611111111\u2014\u2014qryOrgInfoByIdRspBO\uff1a" + JSON.toJSONString((Object)qryOrgInfoByIdRspBO));
                rspBO.setProfessionalOrganizationName(qryOrgInfoByIdRspBO.getUserOrganisationBO().getTitle());
            }
            if ((payTypeMap = this.dicDictionaryService.getValueByCode("PAY_TYPE")) != null) {
                rspBO.setPayTypeName((String)payTypeMap.get(orderSaleXbjPO.getPayType() + ""));
            }
            rspBO.setPurchaseAccount(orderSaleXbjPO.getPurchaserAccount());
            rspBO.setPurchaseAccountName(orderSaleXbjPO.getPurchaserName());
            rspBO.setOrderCreateUserId(orderSaleXbjPO.getPurchaserAccountId());
            rspBO.setOrderCreateUserName(orderSaleXbjPO.getPurchaserAccountName());
            rspBO.setOrderCreateTime(DateUtil.dateToStrLong((Date)orderSaleXbjPO.getCreateTime()));
        } else if (reqBO.getPurchaseOrderId() != null) {
            OrderPurchaseXbjPO orderPurchaseXbjPO = new OrderPurchaseXbjPO();
            orderPurchaseXbjPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
            try {
                orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseXbjPO);
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            }
            if (orderPurchaseXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f");
            }
            purchaserId = orderPurchaseXbjPO.getPurchaserId();
            rspBO.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
            OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
            orderSaleXbjPO.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
            try {
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            }
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
            }
            rspBO.setSaleOrderCode(orderSaleXbjPO.getSaleOrderCode());
            rspBO.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
            rspBO.setPurchaseOrderCode(orderPurchaseXbjPO.getPurchaseOrderCode());
            rspBO.setOrderName(orderPurchaseXbjPO.getPurchaseOrderName());
            rspBO.setSupplierId(orderPurchaseXbjPO.getGoodsSupplierId());
            rspBO.setSupplierName(orderSaleXbjPO.getGoodsSupplierName());
            rspBO.setSupplierContactName(orderSaleXbjPO.getGoodsSupplierRelaman());
            rspBO.setSupplierContactPhone(orderSaleXbjPO.getGoodsSupplierMobile());
            try {
                if (orderPurchaseXbjPO.getPurchaseOrderMoney() != null) {
                    rspBO.setOrderAmount(MoneyUtil.Long2BigDecimal((Long)orderPurchaseXbjPO.getPurchaseOrderMoney()));
                } else {
                    rspBO.setOrderAmount(BigDecimal.ZERO);
                }
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u5408\u540c\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5408\u540c\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\u5f02\u5e38" + e.getMessage());
            }
            rspBO.setOrderSouce(orderPurchaseXbjPO.getSaleOrderType());
            Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
            if (orderSourceMap != null) {
                rspBO.setOrderSourceName((String)orderSourceMap.get(orderPurchaseXbjPO.getSaleOrderType() + ""));
            }
            rspBO.setOrderType(orderPurchaseXbjPO.getOrderType());
            Map orderTypeMap = this.dicDictionaryService.getValueByCode("IQR_ORDER_TYPE");
            if (orderTypeMap != null) {
                rspBO.setOrderTypeName((String)orderTypeMap.get(orderPurchaseXbjPO.getOrderType() + ""));
            }
            rspBO.setContractName(orderPurchaseXbjPO.getNeedContactName());
            rspBO.setContractPhone(orderPurchaseXbjPO.getNeedContactMobile());
            rspBO.setGuaranteePeriod(orderPurchaseXbjPO.getWarantty());
            rspBO.setRate(orderPurchaseXbjPO.getTaxRate());
            rspBO.setPrePay(orderPurchaseXbjPO.getPrePaySup());
            rspBO.setMatPay(orderPurchaseXbjPO.getMatPaySup());
            rspBO.setProPay(orderPurchaseXbjPO.getProPaySup());
            rspBO.setVerPay(orderPurchaseXbjPO.getVerPaySup());
            rspBO.setPilPay(orderPurchaseXbjPO.getPilPaySup());
            rspBO.setQuaPay(orderPurchaseXbjPO.getQuaPaySup());
            rspBO.setPayType(orderPurchaseXbjPO.getPayType());
            Map payTypeMap = this.dicDictionaryService.getValueByCode("PAY_TYPE");
            if (payTypeMap != null) {
                rspBO.setPayTypeName((String)payTypeMap.get(orderPurchaseXbjPO.getPayType() + ""));
            }
            rspBO.setPurchaseAccount(orderPurchaseXbjPO.getPurchaserAccount());
            rspBO.setPurchaseAccountName(orderPurchaseXbjPO.getPurchaserName());
            rspBO.setOrderCreateUserId(orderPurchaseXbjPO.getPurchaserAccountId());
            rspBO.setOrderCreateUserName(orderPurchaseXbjPO.getPurchaserAccountName());
            rspBO.setOrderCreateTime(DateUtil.dateToStrLong((Date)orderPurchaseXbjPO.getCreateTime()));
            rspBO.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
            QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
            qryOrgInfoByIdReqBO.setOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
            QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
            if (qryOrgInfoByIdRspBO != null && qryOrgInfoByIdRspBO.getUserOrganisationBO() != null) {
                log.error("\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c611111111\u2014\u2014qryOrgInfoByIdRspBO\uff1a" + JSON.toJSONString((Object)qryOrgInfoByIdRspBO));
                rspBO.setProfessionalOrganizationName(qryOrgInfoByIdRspBO.getUserOrganisationBO().getTitle());
            }
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (reqBO.getItemQryFlag().equals(XConstant.VALID.TRUE) && CollectionUtils.isNotEmpty((Collection)(itemReturn = this.getItemList(reqBO, purchaserId)).getRows())) {
            rspBO.setRows(itemReturn.getRows());
            rspBO.setPageNo(itemReturn.getPageNo());
            rspBO.setTotal(itemReturn.getRecordsTotal());
            rspBO.setRecordsTotal(itemReturn.getRecordsTotal());
        }
        return rspBO;
    }

    private void validateParams(XbjQryOrderForContractReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5220\u9664\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getSaleOrderId() == null && reqBO.getPurchaseOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[\u9500\u552e\u8ba2\u5355ID\u548c\u91c7\u8d2d\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private XbjQryOrderDetailForContractRspBO getItemList(XbjQryOrderForContractReqBO reqBO, Long purchaserId) {
        XbjQryOrderDetailForContractRspBO rspBO = new XbjQryOrderDetailForContractRspBO();
        if (reqBO.getSaleOrderId() != null) {
            try {
                Long orderId = (long)reqBO.getSaleOrderId();
                List<Object> queryOrderSalItemMat = new LinkedList();
                Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                queryOrderSalItemMat = this.orderSaleItemXbjMapper.queryOrderSalItemMat(orderId, purchaserId, (Page<XbjQuerySaleOrderItemRspPO>)page);
                ArrayList<XbjQryOrderItemForContractBO> itemList = new ArrayList<XbjQryOrderItemForContractBO>();
                if (queryOrderSalItemMat != null && CollectionUtils.isNotEmpty(queryOrderSalItemMat)) {
                    for (OrderSaleItemXbjPO orderSaleItemXbjPO : queryOrderSalItemMat) {
                        if (orderSaleItemXbjPO == null) continue;
                        XbjQryOrderItemForContractBO bo = new XbjQryOrderItemForContractBO();
                        bo.setBrand(orderSaleItemXbjPO.getBrand());
                        bo.setBuyCount(orderSaleItemXbjPO.getPurchaseCount());
                        bo.setFigureNo(orderSaleItemXbjPO.getFigureNo());
                        bo.setManufacturer(orderSaleItemXbjPO.getManufacturer());
                        OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
                        orderPurchaseItemXbjPO.setSaleOrderItemId(orderSaleItemXbjPO.getSaleOrderItemId());
                        orderPurchaseItemXbjPO.setSaleOrderId(orderSaleItemXbjPO.getSaleOrderId());
                        orderPurchaseItemXbjPO = this.orderPurchaseItemXbjMapper.getModelBy(orderPurchaseItemXbjPO);
                        if (orderPurchaseItemXbjPO != null) {
                            bo.setPurchaseOrderItemId(orderPurchaseItemXbjPO.getPurchaseOrderItemId());
                        }
                        bo.setSaleOrderItemId(orderSaleItemXbjPO.getSaleOrderItemId());
                        bo.setMaterialCode(orderSaleItemXbjPO.getMaterialCode());
                        bo.setMaterialName(orderSaleItemXbjPO.getMaterialName());
                        bo.setMaterialClassId(orderSaleItemXbjPO.getMaterialClassId());
                        bo.setModel(orderSaleItemXbjPO.getModel());
                        bo.setSpec(orderSaleItemXbjPO.getSpecifications());
                        bo.setMaterialsQuality(orderSaleItemXbjPO.getMaterialQuality());
                        bo.setRequireDateText(DateUtil.dateToStr((Date)orderSaleItemXbjPO.getPreSendDate()));
                        bo.setUnitName(orderSaleItemXbjPO.getUnitName());
                        bo.setPlanDetailId(orderSaleItemXbjPO.getPlanDetailId());
                        bo.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)orderSaleItemXbjPO.getSellingPrice()));
                        bo.setPurchasePrice(MoneyUtil.Long2BigDecimal((Long)orderSaleItemXbjPO.getPurchasingPrice()));
                        bo.setSellingAmount(bo.getSellingPrice().multiply(bo.getBuyCount()));
                        bo.setPurchaseAmount(bo.getPurchasePrice().multiply(bo.getBuyCount()));
                        itemList.add(bo);
                    }
                } else {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                }
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                rspBO.setRows(itemList);
                return rspBO;
            }
            catch (Exception e) {
                log.error("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
            }
        }
        if (reqBO.getPurchaseOrderId() != null) {
            try {
                List<Object> queryOrderPurchaseItemMat = new LinkedList();
                Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                condition.setPurchaseOrderId(purchaserId);
                condition.setPurchaseOrderId(reqBO.getPurchaseOrderId());
                queryOrderPurchaseItemMat = this.orderPurchaseItemXbjMapper.getListPage(condition, (Page<OrderPurchaseItemXbjPO>)page, "");
                ArrayList<XbjQryOrderItemForContractBO> itemList = new ArrayList<XbjQryOrderItemForContractBO>();
                if (queryOrderPurchaseItemMat != null && CollectionUtils.isNotEmpty(queryOrderPurchaseItemMat)) {
                    for (OrderPurchaseItemXbjPO orderPurchaseItemXbjPO : queryOrderPurchaseItemMat) {
                        if (orderPurchaseItemXbjPO == null) continue;
                        XbjQryOrderItemForContractBO bo = new XbjQryOrderItemForContractBO();
                        bo.setBrand(orderPurchaseItemXbjPO.getBrand());
                        bo.setPurchaseOrderItemId(orderPurchaseItemXbjPO.getPurchaseOrderItemId());
                        bo.setBuyCount(orderPurchaseItemXbjPO.getPurchaseCount());
                        bo.setFigureNo(orderPurchaseItemXbjPO.getFigureNo());
                        bo.setManufacturer(orderPurchaseItemXbjPO.getManufacturer());
                        bo.setSaleOrderItemId(orderPurchaseItemXbjPO.getSaleOrderItemId());
                        bo.setMaterialCode(orderPurchaseItemXbjPO.getMaterialCode());
                        bo.setMaterialName(orderPurchaseItemXbjPO.getMaterialName());
                        bo.setMaterialClassId(orderPurchaseItemXbjPO.getMaterialClassId());
                        bo.setModel(orderPurchaseItemXbjPO.getModel());
                        bo.setSpec(orderPurchaseItemXbjPO.getSpecifications());
                        bo.setMaterialsQuality(orderPurchaseItemXbjPO.getMaterialQuality());
                        bo.setRequireDateText(DateUtil.dateToStr((Date)orderPurchaseItemXbjPO.getPreSendDate()));
                        bo.setUnitName(orderPurchaseItemXbjPO.getUnitName());
                        OrderSaleItemXbjPO orderSaleItemXbjPO = new OrderSaleItemXbjPO();
                        orderSaleItemXbjPO.setSaleOrderItemId(orderPurchaseItemXbjPO.getSaleOrderItemId());
                        orderSaleItemXbjPO.setSaleOrderId(orderPurchaseItemXbjPO.getSaleOrderId());
                        orderSaleItemXbjPO = this.orderSaleItemXbjMapper.getModelBy(orderSaleItemXbjPO);
                        if (orderSaleItemXbjPO != null) {
                            bo.setPlanDetailId(orderSaleItemXbjPO.getPlanDetailId());
                        }
                        bo.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)orderPurchaseItemXbjPO.getSellingPrice()));
                        bo.setPurchasePrice(MoneyUtil.Long2BigDecimal((Long)orderPurchaseItemXbjPO.getPurchasingPrice()));
                        bo.setSellingAmount(bo.getSellingPrice().multiply(bo.getBuyCount()));
                        bo.setPurchaseAmount(bo.getPurchasePrice().multiply(bo.getBuyCount()));
                        itemList.add(bo);
                    }
                } else {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65e0\u8be5\u91c7\u8d2d\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                    return rspBO;
                }
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u5206\u9875\u91c7\u8d2d\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                rspBO.setRows(itemList);
                return rspBO;
            }
            catch (Exception e) {
                log.error("\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return rspBO;
    }
}

