/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.XbjServOrderAcceptCreateAtomService;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptCreateReqBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptCreateRspBO;
import com.cgd.order.busi.bo.XbjServOrderAcceptItemBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderServCompleteItemXbjMapper;
import com.cgd.order.dao.OrderServCompleteXbjMapper;
import com.cgd.order.dao.OrderServInspectionItemXbjMapper;
import com.cgd.order.dao.OrderServInspectionXbjMapper;
import com.cgd.order.dao.XbjInspectionShipRelationMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InspectionShipRelationXbjPO;
import com.cgd.order.po.OrderServCompleteItemXbjPO;
import com.cgd.order.po.OrderServCompleteXbjPO;
import com.cgd.order.po.OrderServInspectionItemXbjPO;
import com.cgd.order.po.OrderServInspectionXbjPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjServOrderAcceptCreateAtomServiceImpl
implements XbjServOrderAcceptCreateAtomService {
    private static final Logger logger = LoggerFactory.getLogger(XbjServOrderAcceptCreateAtomService.class);
    @Autowired
    private OrderServInspectionXbjMapper orderServInspectionXbjMapper;
    @Autowired
    private OrderServInspectionItemXbjMapper orderServInspectionItemXbjMapper;
    @Autowired
    private OrderServCompleteItemXbjMapper orderServCompleteItemXbjMapper;
    @Autowired
    private XbjInspectionShipRelationMapper xbjInspectionShipRelationMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderServCompleteXbjMapper orderServCompleteXbjMapper;

    @Override
    public XbjServOrderAcceptCreateRspBO createServOrderAccept(XbjServOrderAcceptCreateReqBO req) {
        XbjServOrderAcceptCreateRspBO rsp = new XbjServOrderAcceptCreateRspBO();
        try {
            OrderServInspectionXbjPO servInspection = new OrderServInspectionXbjPO();
            BeanUtils.copyProperties((Object)req, (Object)servInspection);
            this.orderServInspectionXbjMapper.insertServInspection(servInspection);
            if (req.getAccessoryInfoList() != null) {
                for (XbjPurchaseAccessoryReqBO accessoryTemp : req.getAccessoryInfoList()) {
                    AccessoryXbjPO accessory = new AccessoryXbjPO();
                    accessory.setObjectId(req.getServInspectionOrderId());
                    accessory.setOrderCode(req.getServInspectionOrderCode());
                    accessory.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.SERV_INSPECTION);
                    accessory.setPurchaserId(req.getPurchaserId());
                    accessory.setPurchaserAccountId(req.getPurchaserAccountId());
                    accessory.setPurchaserAccountName(req.getPurchaserAccountName());
                    accessory.setProfessionalOrganizationId(String.valueOf(req.getProfessionalOrganizationId()));
                    accessory.setGoodsSupplierId(String.valueOf(req.getGoodsSupplierId()));
                    accessory.setAccessoryId(accessoryTemp.getAccessoryId());
                    accessory.setAccessoryUrl(accessoryTemp.getAccessoryUrl());
                    accessory.setAccessoryName(accessoryTemp.getAccessoryName());
                    accessory.setRemark("\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5355\u9644\u4ef6");
                    accessory.setCreateDate(new Date());
                    this.accessoryXbjMapper.insert(accessory);
                }
            }
            for (XbjServOrderAcceptItemBO acceptItem : req.getServOrderAcceptItemList()) {
                OrderServInspectionItemXbjPO servInspectionItem = new OrderServInspectionItemXbjPO();
                BeanUtils.copyProperties((Object)acceptItem, (Object)servInspectionItem);
                servInspectionItem.setServInspectionId(req.getServInspectionOrderId());
                this.orderServInspectionItemXbjMapper.insertServInspectionItem(servInspectionItem);
                OrderServCompleteItemXbjPO completeItem = new OrderServCompleteItemXbjPO();
                completeItem.setPurchaserId(req.getPurchaserId());
                completeItem.setServCompleteOrderId(acceptItem.getServCompleteOrderId());
                completeItem.setPurchaseOrderItemId(acceptItem.getPurchaseOrderItemId());
                OrderServCompleteItemXbjPO servItemInfo = this.orderServCompleteItemXbjMapper.queryOrderServItemS(completeItem);
                BigDecimal count = servItemInfo.getAcceptanceCount().add(acceptItem.getOnceAcceptanceCount());
                completeItem.setAcceptanceCount(count);
                this.orderServCompleteItemXbjMapper.updateAcceptanceCount(completeItem);
                InspectionShipRelationXbjPO relation = new InspectionShipRelationXbjPO();
                relation.setPurchaserId(req.getPurchaserId());
                relation.setPurchaserAccountId(acceptItem.getPurchaserAccountId());
                relation.setPurchaserAccountName(acceptItem.getPurchaserAccountName());
                relation.setProfessionalOrganizationId(acceptItem.getProfessionalOrganizationId());
                relation.setGoodsSupplierId(acceptItem.getGoodsSupplierId());
                relation.setInspectionOrderId(req.getServInspectionOrderId());
                relation.setOnceAcceptanceCount(acceptItem.getOnceAcceptanceCount());
                relation.setSaleOrderId(req.getSaleOrderId());
                relation.setCreateTime(new Date());
                relation.setCompleteId(acceptItem.getServCompleteOrderId());
                this.xbjInspectionShipRelationMapper.insertInspectionShipRelation(relation);
            }
            if (req.getServCompleteOrderId() != null && !"".equals(req.getServCompleteOrderId())) {
                BigDecimal sendCountAll = BigDecimal.ZERO;
                BigDecimal acceptCountAll = BigDecimal.ZERO;
                OrderServCompleteItemXbjPO orderServCompleteItemXbjPO = new OrderServCompleteItemXbjPO();
                orderServCompleteItemXbjPO.setServCompleteOrderId(req.getServCompleteOrderId());
                orderServCompleteItemXbjPO.setPurchaserId(req.getPurchaserId());
                List<OrderServCompleteItemXbjPO> orderServCompleteInfos = this.orderServCompleteItemXbjMapper.getList(orderServCompleteItemXbjPO);
                if (orderServCompleteInfos != null && orderServCompleteInfos.size() > 0) {
                    for (OrderServCompleteItemXbjPO po : orderServCompleteInfos) {
                        sendCountAll = sendCountAll.add(po.getOnceCompleteCount());
                        if (po.getAcceptanceCount() == null) continue;
                        acceptCountAll = acceptCountAll.add(po.getAcceptanceCount());
                    }
                }
                if (acceptCountAll.compareTo(sendCountAll) == 0) {
                    OrderServCompleteXbjPO orderServCompleteXbjPO = new OrderServCompleteXbjPO();
                    orderServCompleteXbjPO.setModifyOperId(req.getOperId());
                    orderServCompleteXbjPO.setModifyTime(new Date());
                    orderServCompleteXbjPO.setServStatus(XbjOrderConstants.SERV_SHIP_STATUS_ACCEPT);
                    orderServCompleteXbjPO.setServCompleteOrderId(req.getServCompleteOrderId());
                    this.orderServCompleteXbjMapper.updateServCompleteByOrderId(orderServCompleteXbjPO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + e);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4e1a\u52a1\u670d\u52a1\uff1a\u8be2\u6bd4\u4ef7\u670d\u52a1\u9a8c\u6536\u5355\u751f\u6210\u6210\u529f");
        return rsp;
    }
}

