/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjOrderContractMarkBusiService;
import com.cgd.order.busi.bo.XbjOrderContractMarkBusiReqBO;
import com.cgd.order.busi.bo.XbjOrderContractMarkBusiRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjOrderContractMarkBusiService")
public class XbjOrderContractMarkBusiServiceImpl
implements XbjOrderContractMarkBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderContractMarkBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;

    public XbjOrderContractMarkBusiRspBO dealOrderContractMark(XbjOrderContractMarkBusiReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:" + reqBO.toString());
        }
        this.validateParams(reqBO);
        if (reqBO.getOrderType().equals(XbjOrderConstants.ORDER_TYPE.SALE)) {
            OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
            orderSaleXbjPO.setSaleOrderId(reqBO.getOrderId());
            try {
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            }
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
            }
            orderSaleXbjPO.setContractMark(reqBO.getContractMark());
            this.orderSaleXbjMapper.updateContractMarkInfo(orderSaleXbjPO);
        } else if (reqBO.getOrderType().equals(XbjOrderConstants.ORDER_TYPE.PURCHASE)) {
            OrderPurchaseXbjPO orderPurchaseXbjPO = new OrderPurchaseXbjPO();
            orderPurchaseXbjPO.setPurchaseOrderId(reqBO.getOrderId());
            try {
                orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseXbjPO);
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            }
            if (orderPurchaseXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f");
            }
            orderPurchaseXbjPO.setContractMark(reqBO.getContractMark());
            this.orderPurchaseXbjMapper.updateContractMarkInfo(orderPurchaseXbjPO);
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        XbjOrderContractMarkBusiRspBO rspBO = new XbjOrderContractMarkBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u67e5\u8be2");
        return rspBO;
    }

    private void validateParams(XbjOrderContractMarkBusiReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5220\u9664\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getContractMark() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5408\u540c\u6807\u8bb0[contractMark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

