/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjCancelOrderExternalBusiService;
import com.cgd.order.busi.bo.XbjCancelOrderExternalBusiServiceReqBO;
import com.cgd.order.busi.bo.XbjCancelOrderExternalBusiServiceRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDealNoticeItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderDealNoticeItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjCancelOrderExternalBusiServiceImpl
implements XbjCancelOrderExternalBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjCancelOrderExternalBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderDealNoticeItemXbjMapper orderDealNoticeItemXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;

    public XbjCancelOrderExternalBusiServiceRspBO dealWithOrderCancel(XbjCancelOrderExternalBusiServiceReqBO xbjCancelOrderExternalBusiServiceReqBO) {
        if (this.isDebugEnabled) {
            log.error("\u8ba2\u5355\u53d6\u6d88\u5165\u53c2\u53c2\u6570:" + JSON.toJSONString((Object)xbjCancelOrderExternalBusiServiceReqBO));
        }
        log.error("\u8ba2\u5355\u53d6\u6d88\u5165\u53c2\u53c2\u6570:" + JSON.toJSONString((Object)xbjCancelOrderExternalBusiServiceReqBO));
        XbjCancelOrderExternalBusiServiceRspBO xbjCancelOrderExtRspBO = new XbjCancelOrderExternalBusiServiceRspBO();
        try {
            this.validateParam(xbjCancelOrderExternalBusiServiceReqBO);
            OrderDealNoticeItemXbjPO orderDealNoticeItemPO = new OrderDealNoticeItemXbjPO();
            orderDealNoticeItemPO.setDealNoticeId(xbjCancelOrderExternalBusiServiceReqBO.getDealNoticeId());
            if (xbjCancelOrderExternalBusiServiceReqBO.getPurchaseId() != null) {
                orderDealNoticeItemPO.setPurchaserAccount(xbjCancelOrderExternalBusiServiceReqBO.getPurchaseId());
            }
            log.error("\u6839\u636e\u6210\u4ea4\u901a\u77e5id\u5f00\u59cb\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderDealNoticeItemPO));
            List<OrderDealNoticeItemXbjPO> orderDealNoticeItemPOList = this.orderDealNoticeItemXbjMapper.getList(orderDealNoticeItemPO);
            if (orderDealNoticeItemPOList != null && orderDealNoticeItemPOList.size() > 0) {
                log.error("\u6839\u636e\u6210\u4ea4\u901a\u77e5id\u67e5\u8be2\u8ba2\u5355\u7ed3\u679c:" + JSON.toJSONString(orderDealNoticeItemPOList));
                for (OrderDealNoticeItemXbjPO po : orderDealNoticeItemPOList) {
                    if (!XbjOrderConstants.IS_DISPATCH_NO.equals(po.getIsDispatch())) continue;
                    OrderSaleXbjPO orderSalePO = this.orderSaleXbjMapper.selectByPrimaryKey(po.getSaleOrderId());
                    if (orderSalePO == null) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38:\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
                    }
                    OrderSaleXbjReqBO xbjOrderSaleReqBO = this.transferOrderSaleReqBO(orderSalePO, xbjCancelOrderExternalBusiServiceReqBO.getCancelReason(), orderSalePO.getSaleOrderStatus(), XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CANCEL, xbjCancelOrderExternalBusiServiceReqBO.getUserId());
                    this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
                    log.error("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5b8c\u6210\uff01");
                    OrderPurchaseXbjPO orderPurchasePO = this.orderPurchaseXbjMapper.selectByPrimaryKey(po.getPurchaseOrderId());
                    if (orderPurchasePO == null) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38:\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f");
                    }
                    OrderPurchaseStatusChngReqBo xbjOrderPurchaseStatusChngAtomReqBo = this.transferOrderPurchaseStatusChngReqBO(orderPurchasePO, orderPurchasePO.getPurchaseOrderStatus(), XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CANCEL, xbjCancelOrderExternalBusiServiceReqBO.getUserId());
                    this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(xbjOrderPurchaseStatusChngAtomReqBo);
                    log.error("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5b8c\u6210\uff01");
                }
                xbjCancelOrderExtRspBO.setRespCode("0000");
                xbjCancelOrderExtRspBO.setRespDesc("\u6210\u529f");
            } else {
                xbjCancelOrderExtRspBO.setRespCode("0000");
                xbjCancelOrderExtRspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e66\u65e0\u5bf9\u5e94\u8ba2\u5355");
            }
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e381\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e382\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38\uff01" + e.getMessage());
        }
        return xbjCancelOrderExtRspBO;
    }

    private void validateParam(XbjCancelOrderExternalBusiServiceReqBO xbjCancelOrderExternalBusiServiceReqBO) {
        if (null == xbjCancelOrderExternalBusiServiceReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjCancelOrderExternalBusiServiceReqBO.getDealNoticeId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u53c2\u6570\u3010dealNoticeId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO xbjOrderSale, String cancelReason, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(xbjOrderSale.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(xbjOrderSale.getPurchaserId());
        req.setPurchaserAccountId(xbjOrderSale.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(xbjOrderSale.getProfessionalOrganizationId());
        req.setCancelReason(cancelReason);
        req.setGoodsSupplierId(xbjOrderSale.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(xbjOrderSale.getPurchaserAccountName());
        req.setSaleOrderType(xbjOrderSale.getSaleOrderType());
        return req;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(OrderPurchaseXbjPO xbjOrderPurchase, Integer oldStatus, Integer newStatus, Long userId) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(xbjOrderPurchase.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(oldStatus);
        req.setPurchaseOrderStatus(newStatus);
        req.setPurchaserId(xbjOrderPurchase.getPurchaserId());
        req.setPurchaserAccountId(xbjOrderPurchase.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(xbjOrderPurchase.getProfessionalOrganizationId());
        req.setSaleOrderId(xbjOrderPurchase.getSaleOrderId());
        req.setGoodsSupplierId(xbjOrderPurchase.getGoodsSupplierId());
        req.setPurchaserAccountName(xbjOrderPurchase.getPurchaserAccountName());
        req.setSaleOrderId(xbjOrderPurchase.getSaleOrderId());
        return req;
    }
}

