/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPayXbjAtomService;
import com.cgd.order.atom.bo.OrderPayChgXbjReqBO;
import com.cgd.order.atom.bo.OrderPayCrtXbjReqBO;
import com.cgd.order.atom.bo.OrderPayXbjRspBO;
import com.cgd.order.dao.OrderPayXbjMapper;
import com.cgd.order.po.OrderPayXbjPO;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderPayXbjAtomServiceImpl
implements OrderPayXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderPayXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPayXbjMapper orderPayMapper;

    @Override
    public void createOrderPay(OrderPayCrtXbjReqBO orderPayCrtReq) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u91c7\u8d2d\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2" + orderPayCrtReq.toString()));
        }
        this.validateOrderPay(orderPayCrtReq);
        OrderPayXbjPO record = this.initOrderOrderPay(orderPayCrtReq);
        try {
            this.orderPayMapper.insert(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrderPayXbjPO initOrderOrderPay(OrderPayCrtXbjReqBO orderPayCrtReq) {
        OrderPayXbjPO record = new OrderPayXbjPO();
        record.setPayOrderId(orderPayCrtReq.getPayOrderId());
        record.setSaleOrderId(orderPayCrtReq.getSaleOrderId());
        record.setPurchaserId(orderPayCrtReq.getPurchaserId());
        record.setPurchaserAccountId(orderPayCrtReq.getPurchaserAccountId());
        record.setPurchaserAccountName(orderPayCrtReq.getPurchaserAccountName());
        record.setProfessionalOrganizationId(orderPayCrtReq.getProfessionalOrganizationId());
        record.setGoodsSupplierId(orderPayCrtReq.getGoodsSupplierId());
        record.setPayStatus(orderPayCrtReq.getPayStatus());
        record.setPayType(orderPayCrtReq.getPayType());
        record.setPayMoney(orderPayCrtReq.getPayMoney());
        record.setCreateDate(new Date());
        record.setComment(orderPayCrtReq.getComment());
        return record;
    }

    public void validateOrderPay(OrderPayCrtXbjReqBO orderPayCrtReqBo) {
        if (null == orderPayCrtReqBo.getPayOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getPayStatus()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getPayType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayCrtReqBo.getPayMoney()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int updateOrderPayStatus(OrderPayChgXbjReqBO orderPayChgReq) {
        if (null == orderPayChgReq.getPayOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayChgReq.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayChgReq.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayChgReq.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayChgReq.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPayChgReq.getPayStatus()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5355\u539f\u5b50\u670d\u52a1\u652f\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderPayXbjPO orderPay = new OrderPayXbjPO();
        orderPay.setPayOrderId(orderPayChgReq.getPayOrderId());
        orderPay.setSaleOrderId(orderPayChgReq.getSaleOrderId());
        orderPay.setPurchaserId(orderPayChgReq.getPurchaserId());
        orderPay.setPurchaserAccountId(orderPayChgReq.getPurchaserAccountId());
        orderPay.setPurchaserAccountName(orderPayChgReq.getPurchaserAccountName());
        orderPay.setProfessionalOrganizationId(orderPayChgReq.getProfessionalOrganizationId());
        orderPay.setGoodsSupplierId(orderPayChgReq.getGoodsSupplierId());
        orderPay.setPayStatus(orderPayChgReq.getPayStatus());
        int num = 0;
        return num;
    }

    @Override
    public OrderPayXbjRspBO qryOrderPay(Long serviceOrderId, Long purchaserId, Integer interType) {
        try {
            OrderPayXbjRspBO orderPayRspBO = new OrderPayXbjRspBO();
            OrderPayXbjPO qryOrderPayByServiceOrderId = null;
            if (null != qryOrderPayByServiceOrderId) {
                orderPayRspBO.setPayMoney(qryOrderPayByServiceOrderId.getPayMoney());
                orderPayRspBO.setReturnId(qryOrderPayByServiceOrderId.getReturnId());
                orderPayRspBO.setCreateDate(qryOrderPayByServiceOrderId.getCreateDate());
                orderPayRspBO.setPayOrderId(qryOrderPayByServiceOrderId.getPayOrderId());
                orderPayRspBO.setSaleOrderId(qryOrderPayByServiceOrderId.getSaleOrderId());
            }
            return orderPayRspBO;
        }
        catch (BeansException e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u67e5\u8be2\u652f\u4ed8\u5355\u5f02\u5e38" + e.getMessage()));
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u5355\u5f02\u5e38");
        }
    }
}

