/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseAtomServiceXbjRspBO;
import com.cgd.order.busi.XbjOrderDeliveryVerifyService;
import com.cgd.order.busi.bo.XbjOrderDeliveryVerifyReqBO;
import com.cgd.order.busi.bo.XbjOrderDeliveryVerifyRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import java.util.List;

public class XbjOrderDeliveryVerifyServiceImpl
implements XbjOrderDeliveryVerifyService {
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }

    public XbjOrderDeliveryVerifyRspBO dealWithXbjOrderDeliveryVerify(XbjOrderDeliveryVerifyReqBO xbjOrderDeliveryVerifyReqBO) {
        XbjOrderDeliveryVerifyRspBO rspBO = new XbjOrderDeliveryVerifyRspBO();
        this.validateParams(xbjOrderDeliveryVerifyReqBO);
        Long purchaseOrderId = xbjOrderDeliveryVerifyReqBO.getPurchaseOrderId();
        Long purchaserId = xbjOrderDeliveryVerifyReqBO.getPurchaserId();
        OrderPurchaseAtomServiceXbjRspBO orderPurchaseXbjBO = this.orderPurchaseXbjAtomService.qryOrderPurchase(purchaseOrderId, purchaserId);
        if (!"0000".equals(orderPurchaseXbjBO.getRespCode())) {
            rspBO.setRespCode(orderPurchaseXbjBO.getRespCode());
            rspBO.setRespDesc(orderPurchaseXbjBO.getRespDesc());
            rspBO.setWorkFlag(Boolean.valueOf(false));
            return rspBO;
        }
        Integer wholeAcceptance = orderPurchaseXbjBO.getWholeAcceptance();
        if (XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES == wholeAcceptance) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6b64\u5355\u5df2\u8fdb\u884c\u4e86\u6574\u5355\u9a8c\u6536\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27\uff01");
            rspBO.setWorkFlag(Boolean.valueOf(false));
            return rspBO;
        }
        List<OrderPurchaseItemXbjPO> orderPurchaseItemXbjPOList = this.orderPurchaseItemXbjMapper.orderShipVerify(purchaserId, orderPurchaseXbjBO.getSaleOrderId());
        if (orderPurchaseItemXbjPOList == null || orderPurchaseItemXbjPOList.size() < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u975e\u5e38\u62b1\u6b49\uff0c\u6b64\u8ba2\u5355\u5df2\u65e0\u53ef\u53d1\u8d27\u5546\u54c1\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27\uff01");
            rspBO.setWorkFlag(Boolean.valueOf(false));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u5355\u7b26\u5408\u53d1\u8d27\u89c4\u5219");
        rspBO.setWorkFlag(Boolean.valueOf(true));
        return rspBO;
    }

    private void validateParams(XbjOrderDeliveryVerifyReqBO xbjOrderDeliveryVerifyReqBO) {
        if (xbjOrderDeliveryVerifyReqBO.getPurchaseOrderId() == null || xbjOrderDeliveryVerifyReqBO.getPurchaseOrderId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355ID[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderDeliveryVerifyReqBO.getPurchaserId() == null || xbjOrderDeliveryVerifyReqBO.getPurchaserId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaseId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

