/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.SaleOrderItemStatusChangeXbjService;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderItemChangeXbjReqBO;
import com.cgd.order.busi.XbjOrderSaleStatusChgBusiService;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgRspBO;
import com.cgd.order.dao.OrderSaleStatusChngXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderSaleStatusChngXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XbjOrderSaleStatusChgBusiServiceImpl
implements XbjOrderSaleStatusChgBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderSaleStatusChgBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderSaleStatusChngXbjMapper orderSaleStatusChngXbjMapper;
    private SaleOrderItemStatusChangeXbjService saleOrderItemStatusChangeXbjService;

    public XbjOrderSaleStatusChgRspBO modifyOrderSaleStatus(XbjOrderSaleStatusChgReqBO orderSaleStatusChgReq) {
        if (orderSaleStatusChgReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderSaleStatusChgReq.getSaleOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderSaleStatusChgReq.getSaleOrderStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderSaleStatusChgReq.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderSaleStatusChgReq.getPurchaserAccountId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderSaleStatusChgReq.getProfessionalOrganizationId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1,\u4e13\u4e1a\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderSaleXbjPO orderSale = null;
        try {
            OrderSaleXbjPO saleOrderPo = new OrderSaleXbjPO();
            saleOrderPo.setSaleOrderId(orderSaleStatusChgReq.getSaleOrderId());
            saleOrderPo.setPurchaserId(orderSaleStatusChgReq.getPurchaserId());
            orderSale = this.orderSaleXbjMapper.selectOrderSaleById(saleOrderPo);
            if (null == orderSale) {
                if (isDebugEnabled) {
                    log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                }
                throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            OrderSaleStatusChngXbjPO po = new OrderSaleStatusChngXbjPO();
            po.setSaleOrderStatusNew(orderSaleStatusChgReq.getSaleOrderStatus());
            po.setSaleOrderStatusOld(orderSale.getSaleOrderStatus());
            po.setSaleOrderType(orderSale.getSaleOrderType());
            OrderSaleStatusChngXbjPO xbjOrderSaleStatusCheck = this.orderSaleStatusChngXbjMapper.orderSaleStatusCheck(po);
            if (xbjOrderSaleStatusCheck == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u53d8\u5316\u89c4\u5219\u8868\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528 \u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528 \u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
        }
        OrderSaleXbjReqBO xbjOrderSaleReqBO = new OrderSaleXbjReqBO();
        xbjOrderSaleReqBO.setSaleOrderId(orderSaleStatusChgReq.getSaleOrderId());
        xbjOrderSaleReqBO.setSaleOrderStatus(orderSaleStatusChgReq.getSaleOrderStatus());
        xbjOrderSaleReqBO.setSaleOrderOldStatus(orderSale.getSaleOrderStatus());
        xbjOrderSaleReqBO.setPurchaserId(orderSaleStatusChgReq.getPurchaserId());
        xbjOrderSaleReqBO.setPurchaserAccountId(orderSaleStatusChgReq.getPurchaserAccountId());
        xbjOrderSaleReqBO.setOperId(String.valueOf(orderSaleStatusChgReq.getOperId()));
        xbjOrderSaleReqBO.setProfessionalOrganizationId(orderSaleStatusChgReq.getProfessionalOrganizationId());
        xbjOrderSaleReqBO.setModifyOprId(orderSaleStatusChgReq.getPurchaserAccountId());
        SaleOrderItemChangeXbjReqBO saleOrderItemChangeXbjReqBO = new SaleOrderItemChangeXbjReqBO();
        saleOrderItemChangeXbjReqBO.setPurchaserId(orderSaleStatusChgReq.getPurchaserId());
        saleOrderItemChangeXbjReqBO.setSaleOrderId(orderSaleStatusChgReq.getSaleOrderId());
        saleOrderItemChangeXbjReqBO.setSaleOrderStatus(orderSaleStatusChgReq.getSaleOrderStatus());
        try {
            this.orderSaleXbjAtomService.updateSaleOrderStatus(xbjOrderSaleReqBO);
            this.saleOrderItemStatusChangeXbjService.updateSaleOrderItemStatus(saleOrderItemChangeXbjReqBO);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528 \u9500\u552e\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528 \u9500\u552e\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        XbjOrderSaleStatusChgRspBO xbjOrderSaleStatusChgRsp = new XbjOrderSaleStatusChgRspBO();
        xbjOrderSaleStatusChgRsp.setRespCode("0000");
        xbjOrderSaleStatusChgRsp.setResultDesc("\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1 \u5df2\u5b8c\u6210!");
        return xbjOrderSaleStatusChgRsp;
    }

    public OrderSaleXbjMapper getOrderSaleXbjMapper() {
        return this.orderSaleXbjMapper;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public OrderSaleXbjAtomService getOrderSaleXbjAtomService() {
        return this.orderSaleXbjAtomService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public OrderSaleStatusChngXbjMapper getOrderSaleStatusChngXbjMapper() {
        return this.orderSaleStatusChngXbjMapper;
    }

    public void setOrderSaleStatusChngXbjMapper(OrderSaleStatusChngXbjMapper orderSaleStatusChngXbjMapper) {
        this.orderSaleStatusChngXbjMapper = orderSaleStatusChngXbjMapper;
    }

    public SaleOrderItemStatusChangeXbjService getSaleOrderItemStatusChangeXbjService() {
        return this.saleOrderItemStatusChangeXbjService;
    }

    public void setSaleOrderItemStatusChangeXbjService(SaleOrderItemStatusChangeXbjService saleOrderItemStatusChangeXbjService) {
        this.saleOrderItemStatusChangeXbjService = saleOrderItemStatusChangeXbjService;
    }
}

