/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.ArrivalRegistrationXbjAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.bo.ArrivalRegistrationAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.busi.bo.XbjArrivalRegistrationShipBusiReqBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArrivalRegistrationXbjAtomServiceImpl
implements ArrivalRegistrationXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(ArrivalRegistrationXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;
    @Autowired
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;

    @Override
    public void saveArrivalRegistration(ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomReq) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)arrivalRegistrationAtomReq));
        }
        this.validateBOData(arrivalRegistrationAtomReq);
        try {
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.getModelById(arrivalRegistrationAtomReq.getSaleOrderId());
            if (orderSaleXbjPO == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
            }
            List<XbjArrivalRegistrationShipBusiReqBO> orderShipList = arrivalRegistrationAtomReq.getOrderShipList();
            for (XbjArrivalRegistrationShipBusiReqBO orderShip : orderShipList) {
                if (orderShip == null) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OrderShipXbjPO record = new OrderShipXbjPO();
                record.setPurchaseOrderId(arrivalRegistrationAtomReq.getPurchaseOrderId());
                record.setPurchaserId(arrivalRegistrationAtomReq.getPurchaserId());
                record.setShipOrderId(orderShip.getShipOrderId());
                OrderShipXbjPO orderShipInfo = this.orderShipXbjMapper.getModelBy(record);
                if (orderShipInfo == null) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u3010" + orderShip.getShipOrderId() + "\u3011\u4e0d\u5b58\u5728");
                }
                orderShipInfo.setArriveTime(new Date());
                orderShipInfo.setArriveRemark(arrivalRegistrationAtomReq.getArriveRemark());
                orderShipInfo.setShipStatus(String.valueOf(XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SHIP_STATUS_TO_ARRIVED));
                int returnCount = this.orderShipXbjMapper.updateById(orderShipInfo);
                if (returnCount == 0) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u66f4\u65b0\u53d1\u8d27\u5355\u5931\u8d25");
                }
                this.updateShipItemRegistrationInfo(arrivalRegistrationAtomReq.getPurchaserId(), orderShip);
                if (arrivalRegistrationAtomReq.getShipOrderId() != null && !"".equals(arrivalRegistrationAtomReq.getShipOrderId())) {
                    OrderShipXbjPO orderShipXbjPO = new OrderShipXbjPO();
                    orderShipXbjPO.setShipOrderId(arrivalRegistrationAtomReq.getShipOrderId());
                    orderShipXbjPO.setShipStatus(XbjOrderConstants.WUZI_SHIP_STATUS_ARRIVED.toString());
                    this.orderShipXbjMapper.updateOrderShipByShipOrderId(orderShipXbjPO);
                    continue;
                }
                this.sendMessage(orderSaleXbjPO, arrivalRegistrationAtomReq, orderShipInfo.getShipOrderCode());
            }
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void updateShipItemRegistrationInfo(Long purchaserId, XbjArrivalRegistrationShipBusiReqBO orderShip) {
        try {
            if (orderShip == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderShipItemXbjPO recordItem = new OrderShipItemXbjPO();
            recordItem.setPurchaserId(purchaserId);
            recordItem.setShipItemId(orderShip.getShipItemId());
            OrderShipItemXbjPO orderShipItemInfo = this.orderShipItemXbjMapper.getModelBy(recordItem);
            if (orderShipItemInfo == null) {
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1 \u4e0d\u5b58\u5728\u53d1\u8d27\u5355\u660e\u7ec6\u3010" + orderShip.getShipItemId() + "\u3011\u6570\u636e");
            }
            if (orderShip.getArriveCount() == null) {
                orderShipItemInfo.setArriveCount(orderShipItemInfo.getPurchaseCount());
                orderShip.setArriveCount(orderShipItemInfo.getPurchaseCount());
            } else {
                orderShipItemInfo.setArriveCount(orderShip.getArriveCount());
            }
            int returnCount = this.orderShipItemXbjMapper.updateById(orderShipItemInfo);
            if (returnCount == 0) {
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u66f4\u65b0\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u67e5\u8be2\u6216\u66f4\u65b0\u8ba2\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private void validateBOData(ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomReq) {
        if (arrivalRegistrationAtomReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getPurchaseOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355ID\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList() == null || arrivalRegistrationAtomReq.getOrderShipList().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010orderShipItemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList().get(0).getShipItemId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010shipItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList().get(0).getShipOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010shipOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void sendMessage(OrderSaleXbjPO orderSale, ArrivalRegistrationAtomXbjReqBO reqBO, String shipOrderCode) {
        try {
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_REGISTER_PURCHASRE);
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            smsParam.put("orderId", orderSale.getSaleOrderCode());
            smsParam.put("orderName", orderSale.getSaleOrderName());
            smsParam.put("shipId", shipOrderCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setUserId(reqBO.getUserId());
            orderSendMsgBusiReq.setMessageAccount(orderSale.getPurchaserAccountId() + "");
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            log.error("\u5230\u8d27\u767b\u8bb0\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO));
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5230\u8d27\u767b\u8bb0\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_REGISTER_PSZZ);
            smsParam = new HashMap();
            smsParam.put("purchaseCode", orderSale.getPurchaseOrderCode());
            smsParam.put("purchaseName", orderSale.getSaleOrderName());
            smsParam.put("shipId", shipOrderCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setMessageAccount(orderSale.getDeliveryId() + "");
            RspInfoBO rspInfoBO1 = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            log.error("\u5230\u8d27\u767b\u8bb0\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO1));
            if (!"0000".equals(rspInfoBO1.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5230\u8d27\u767b\u8bb0\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u5230\u8d27\u767b\u8bb0\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
        }
    }
}

