/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.CreateSalesOrderCodeXbjAtomService;
import com.cgd.order.atom.SequenceXbjAtomService;
import com.cgd.order.atom.bo.GenerateSalesOrderCodeSeqXbjRspBO;
import com.cgd.order.util.GenerateSaleOrderCodeXbj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateSalesOrderCodeXbjAtomServiceImpl
implements CreateSalesOrderCodeXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(CreateSalesOrderCodeXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SequenceXbjAtomService sequenceAtomService;

    @Override
    public GenerateSalesOrderCodeSeqXbjRspBO createSalesOrderCode() {
        if (isDebugEnabled) {
            log.debug("\u9500\u552e\u8ba2\u5355code\u751f\u6210");
        }
        GenerateSalesOrderCodeSeqXbjRspBO generateSalesOrderCodeSeq = new GenerateSalesOrderCodeSeqXbjRspBO();
        try {
            Long seqId = this.sequenceAtomService.getSequenceId("SEQ_SALE_ORDER_CODE_SN");
            String saleOrderCode = GenerateSaleOrderCodeXbj.getSaleOrderCode(seqId);
            if (isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2\uff1a" + saleOrderCode);
            }
            generateSalesOrderCodeSeq.setSaleOrderCode(saleOrderCode);
            return generateSalesOrderCodeSeq;
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2:" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2");
        }
    }
}

