/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.busi.XbjOrderConstrCreateBusiService;
import com.cgd.order.busi.bo.XbjConstrAccessoryReqBO;
import com.cgd.order.busi.bo.XbjConstrItemReqBO;
import com.cgd.order.busi.bo.XbjOrderConstrCreateReqBO;
import com.cgd.order.busi.bo.XbjOrderConstrCreateRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.intfce.XbjOrderConstructionIntfceService;
import com.cgd.order.intfce.bo.XbjOrderConstructionCreateReqBO;
import com.cgd.order.intfce.bo.XbjOrderConstructionCreateRspBO;
import com.cgd.order.intfce.bo.XbjShipPrjInfoBO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XbjOrderConstructionIntfceServiceImpl
implements XbjOrderConstructionIntfceService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderConstructionIntfceServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    private XbjOrderConstrCreateBusiService xbjOrderConstrCreateBusiService;

    public XbjOrderConstructionCreateRspBO dealWithXbjOrderConstructionCreate(XbjOrderConstructionCreateReqBO reqBO) {
        try {
            this.dealWithParamVerify(reqBO);
            OrderPurchaseXbjPO orderPurchaseXbjPO = this.dealWithOrderPurchaseExist(reqBO);
            OrderSaleXbjPO orderSaleXbjPO = this.dealWithOrderSaleExist(orderPurchaseXbjPO);
            List<OrderPurchaseItemXbjPO> orderPurchaseItemXbjPOList = this.dealWithBusiVerify(reqBO, orderPurchaseXbjPO);
            XbjOrderConstrCreateReqBO xbjOrderConstrCreateReqBO = this.dealWithParamCreate(orderPurchaseXbjPO, orderSaleXbjPO, orderPurchaseItemXbjPOList, reqBO);
            XbjOrderConstrCreateRspBO xbjOrderConstrCreateRspBO = this.xbjOrderConstrCreateBusiService.createOrderConstr(xbjOrderConstrCreateReqBO);
            if (null == xbjOrderConstrCreateRspBO || !"0000".equals(xbjOrderConstrCreateRspBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + String.valueOf(xbjOrderConstrCreateRspBO.getRespDesc()));
            }
            XbjOrderConstructionCreateRspBO rspBO = new XbjOrderConstructionCreateRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u65bd\u5de5\u5b8c\u5de5\u6210\u529f");
            return rspBO;
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }

    private XbjOrderConstrCreateReqBO dealWithParamCreate(OrderPurchaseXbjPO orderPurchaseXbjPO, OrderSaleXbjPO orderSaleXbjPO, List<OrderPurchaseItemXbjPO> orderPurchaseItemXbjPOList, XbjOrderConstructionCreateReqBO xbjOrderConstructionCreateReqBO) {
        XbjOrderConstrCreateReqBO xbjOrderConstrCreateReqBO = new XbjOrderConstrCreateReqBO();
        GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.CONSTR_COMPLETE);
        generateOrderIdAndCodeXbjReqBO.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        generateOrderIdAndCodeXbjReqBO.setPurchaseId(orderPurchaseXbjPO.getPurchaserId());
        GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
        xbjOrderConstrCreateReqBO.setConstrCompleteOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
        xbjOrderConstrCreateReqBO.setConstrCompleteOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        xbjOrderConstrCreateReqBO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
        xbjOrderConstrCreateReqBO.setSaleOrderCode(orderSaleXbjPO.getSaleOrderCode());
        xbjOrderConstrCreateReqBO.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        xbjOrderConstrCreateReqBO.setPurchaseOrderCode(orderPurchaseXbjPO.getPurchaseOrderCode());
        xbjOrderConstrCreateReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        xbjOrderConstrCreateReqBO.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        xbjOrderConstrCreateReqBO.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
        xbjOrderConstrCreateReqBO.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        xbjOrderConstrCreateReqBO.setGoodsSupplierId(orderPurchaseXbjPO.getGoodsSupplierId());
        xbjOrderConstrCreateReqBO.setOrderType(orderPurchaseXbjPO.getOrderType());
        xbjOrderConstrCreateReqBO.setConstrRelaName(xbjOrderConstructionCreateReqBO.getConstrName());
        xbjOrderConstrCreateReqBO.setConstrRelaPhone(xbjOrderConstructionCreateReqBO.getConstrPhone());
        xbjOrderConstrCreateReqBO.setOpenOrderNo(xbjOrderConstructionCreateReqBO.getConstrId());
        xbjOrderConstrCreateReqBO.setOpenDate(DateUtil.strToDate(xbjOrderConstructionCreateReqBO.getConstrDate(), "yyyy-MM-dd"));
        xbjOrderConstrCreateReqBO.setOperId(xbjOrderConstructionCreateReqBO.getUserId());
        xbjOrderConstrCreateReqBO.setOperName(xbjOrderConstructionCreateReqBO.getUserName());
        xbjOrderConstrCreateReqBO.setCompanyName(xbjOrderConstructionCreateReqBO.getCompanyName());
        xbjOrderConstrCreateReqBO.setCreateTime(new Date());
        xbjOrderConstrCreateReqBO.setFinishDate(new Date());
        ArrayList<XbjConstrAccessoryReqBO> constrAccessoryList = new ArrayList<XbjConstrAccessoryReqBO>();
        if (null != xbjOrderConstructionCreateReqBO.getPurchaseAccessoryReqList() && xbjOrderConstructionCreateReqBO.getPurchaseAccessoryReqList().size() > 0) {
            xbjOrderConstrCreateReqBO.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.YES);
            List xbjPurchaseAccessoryReqBOList = xbjOrderConstructionCreateReqBO.getPurchaseAccessoryReqList();
            for (XbjPurchaseAccessoryReqBO accessory : xbjPurchaseAccessoryReqBOList) {
                XbjConstrAccessoryReqBO constrAccessory = new XbjConstrAccessoryReqBO();
                constrAccessory.setAccessoryId(String.valueOf(accessory.getAccessoryId()));
                constrAccessory.setAccessoryName(accessory.getAccessoryName());
                constrAccessory.setAccessoryUrl(accessory.getAccessoryUrl());
                constrAccessory.setObjectId(generateOrderIdAndCodeXbjRspBO.getOrderId().longValue());
                constrAccessory.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.CONSTR_COMPLETE.intValue());
                constrAccessory.setOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
                constrAccessory.setPurchaserId(orderPurchaseXbjPO.getPurchaserId().longValue());
                constrAccessory.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId().longValue());
                constrAccessory.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
                constrAccessory.setProfessionalOrganizationId(String.valueOf(orderPurchaseXbjPO.getProfessionalOrganizationId()));
                constrAccessory.setGoodsSupplierId(String.valueOf(orderPurchaseXbjPO.getGoodsSupplierId()));
                constrAccessory.setRemark("\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5b8c\u5de5\u5355\u9644\u4ef6");
                constrAccessory.setCreateDate(new Date());
                constrAccessoryList.add(constrAccessory);
            }
        } else {
            xbjOrderConstrCreateReqBO.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.NO);
        }
        xbjOrderConstrCreateReqBO.setConstrAccessoryList(constrAccessoryList);
        ArrayList<XbjConstrItemReqBO> constrItemList = new ArrayList<XbjConstrItemReqBO>();
        for (OrderPurchaseItemXbjPO orderPurchaseItemXbjPO : orderPurchaseItemXbjPOList) {
            XbjConstrItemReqBO xbjConstrItemReqBO = new XbjConstrItemReqBO();
            xbjConstrItemReqBO.setConstrCompleteOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
            xbjConstrItemReqBO.setSaleOrderItemId(orderPurchaseItemXbjPO.getSaleOrderItemId());
            xbjConstrItemReqBO.setPurchaseOrderItemId(orderPurchaseItemXbjPO.getPurchaseOrderItemId());
            xbjConstrItemReqBO.setPurchaserId(orderPurchaseItemXbjPO.getPurchaserId());
            xbjConstrItemReqBO.setPurchaserAccountId(orderPurchaseItemXbjPO.getPurchaserAccountId());
            xbjConstrItemReqBO.setPurchaserAccountName(orderPurchaseItemXbjPO.getPurchaserAccountName());
            xbjConstrItemReqBO.setProfessionalOrganizationId(orderPurchaseItemXbjPO.getProfessionalOrganizationId());
            xbjConstrItemReqBO.setGoodsSupplierId(orderPurchaseItemXbjPO.getGoodsSupplierId());
            xbjConstrItemReqBO.setProjectId(orderPurchaseItemXbjPO.getProjectId());
            xbjConstrItemReqBO.setProjectCode(orderPurchaseItemXbjPO.getProjectCode());
            xbjConstrItemReqBO.setProjectName(orderPurchaseItemXbjPO.getProjectName());
            xbjConstrItemReqBO.setProjectContent(orderPurchaseItemXbjPO.getProjectContent());
            xbjConstrItemReqBO.setSellingPrice(new BigDecimal(orderPurchaseItemXbjPO.getSellingPrice()));
            xbjConstrItemReqBO.setPurchaseCount(orderPurchaseItemXbjPO.getSendCount());
            xbjConstrItemReqBO.setUnitName(orderPurchaseItemXbjPO.getUnitName());
            xbjConstrItemReqBO.setOnceCompleteCount(orderPurchaseItemXbjPO.getSendCount());
            constrItemList.add(xbjConstrItemReqBO);
        }
        xbjOrderConstrCreateReqBO.setConstrItemList(constrItemList);
        return xbjOrderConstrCreateReqBO;
    }

    private OrderSaleXbjPO dealWithOrderSaleExist(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectOrderSaleByCondition(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
        if (null == orderSaleXbjPO) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u9500\u552e\u8ba2\u5355\uff01");
        }
        return orderSaleXbjPO;
    }

    private OrderPurchaseXbjPO dealWithOrderPurchaseExist(XbjOrderConstructionCreateReqBO reqBO) {
        OrderPurchaseXbjPO orderPurchaseReqPO = new OrderPurchaseXbjPO();
        orderPurchaseReqPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        orderPurchaseReqPO.setPurchaserId(reqBO.getPurchaserId());
        OrderPurchaseXbjPO orderPurchaseXbjPO = null;
        try {
            orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseReqPO);
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u91c7\u8d2d\u8ba2\u5355\uff01");
        }
        if (null == orderPurchaseXbjPO) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u91c7\u8d2d\u8ba2\u5355\uff01");
        }
        return orderPurchaseXbjPO;
    }

    private List<OrderPurchaseItemXbjPO> dealWithBusiVerify(XbjOrderConstructionCreateReqBO reqBO, OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG != orderPurchaseXbjPO.getSaleOrderPurchaseType()) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u91c7\u8d2d\u7c7b\u522b\u4e0d\u662f\u65bd\u5de5\u7c7b\uff01");
        }
        if (null == orderPurchaseXbjPO.getPurchaseOrderStatus()) {
            if (this.isDebugEnabled) {
                logger.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u5b8c\u5de5\uff1a\u72b6\u6001\u4e3a\u7a7a");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u5b8c\u5de5\uff01");
        }
        if (!XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            if (this.isDebugEnabled) {
                logger.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u5f53\u524d\u72b6\u6001[" + orderPurchaseXbjPO.getPurchaseOrderStatus() + "]\u65e0\u6cd5\u5b8c\u5de5");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u5b8c\u5de5\uff01");
        }
        if (null == orderPurchaseXbjPO.getWholeAcceptance() || Objects.equals(XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES, orderPurchaseXbjPO.getWholeAcceptance())) {
            if (this.isDebugEnabled) {
                logger.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u5df2\u6574\u5355\u9a8c\u6536\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5b8c\u5de5");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5df2\u6574\u5355\u9a8c\u6536\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5b8c\u5de5\uff01");
        }
        List xbjShipPrjInfoBOList = reqBO.getConstrPrjInfoList();
        BigDecimal completeTotalCount = BigDecimal.ZERO;
        BigDecimal purchaseTotalCount = BigDecimal.ZERO;
        ArrayList<OrderPurchaseItemXbjPO> rspList = new ArrayList<OrderPurchaseItemXbjPO>();
        try {
            for (XbjShipPrjInfoBO xbjShipPrjInfoBO : xbjShipPrjInfoBOList) {
                OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
                orderPurchaseItemXbjPO.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
                orderPurchaseItemXbjPO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
                orderPurchaseItemXbjPO.setPurchaseOrderItemId(xbjShipPrjInfoBO.getPurchaseOrderItemId());
                OrderPurchaseItemXbjPO orderPurchaseItemXbjRspPO = this.orderPurchaseItemXbjMapper.getModelBy(orderPurchaseItemXbjPO);
                if (null == orderPurchaseItemXbjRspPO) {
                    if (this.isDebugEnabled) {
                        logger.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0cpurchaseOrderItemId[" + xbjShipPrjInfoBO.getPurchaseOrderItemId() + "]\u65e0\u6cd5\u5b9a\u4f4d\u5230\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6");
                    }
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u5230\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\uff01");
                }
                if (this.isDebugEnabled) {
                    logger.debug("\u6570\u636e\u4fe1---------------\uff0cgetPurchaseCount[" + orderPurchaseItemXbjRspPO.getPurchaseCount() + "]getPurchaseCount");
                    logger.debug("\u6570\u636e\u4fe1---------------\uff0cgetSendCount[" + orderPurchaseItemXbjRspPO.getSendCount() + "]getSendCount");
                    logger.debug("\u6570\u636e\u4fe1---------------\uff0cgetConstrCount[" + xbjShipPrjInfoBO.getConstrCount() + "]getConstrCount");
                    logger.debug("\u6570\u636e\u4fe1---------------\uff0cgetConstrCount[" + orderPurchaseItemXbjRspPO.getSendCount().add(xbjShipPrjInfoBO.getConstrCount()) + "]getConstrCount");
                }
                completeTotalCount = completeTotalCount.add(orderPurchaseItemXbjRspPO.getSendCount().add(xbjShipPrjInfoBO.getConstrCount()));
                purchaseTotalCount = purchaseTotalCount.add(orderPurchaseItemXbjRspPO.getPurchaseCount());
                orderPurchaseItemXbjRspPO.setSendCount(xbjShipPrjInfoBO.getConstrCount());
                rspList.add(orderPurchaseItemXbjRspPO);
            }
        }
        catch (BusinessException e) {
            logger.error("\u9879\u76ee\u53ef\u5b8c\u5de5\u6570\u91cf\u6821\u9a8c\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9879\u76ee\u53ef\u5b8c\u5de5\u6570\u91cf\u6821\u9a8c\u5f02\u5e38:" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u9879\u76ee\u53ef\u5b8c\u5de5\u6570\u91cf\u6821\u9a8c\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9879\u76ee\u53ef\u5b8c\u5de5\u6570\u91cf\u6821\u9a8c\u5f02\u5e38:" + e.getMessage());
        }
        return rspList;
    }

    private void dealWithParamVerify(XbjOrderConstructionCreateReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.isDebugEnabled) {
            logger.debug("\u8ba2\u5355\u65bd\u5de5\u5b8c\u5de5\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        }
        if (null == reqBO.getPurchaseOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u91c7\u8d2d\u8ba2\u5355ID[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u91c7\u8d2d\u5546ID[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConstrName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u65bd\u5de5\u8054\u7cfb\u4eba\u59d3\u540d[constrName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConstrPhone())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u65bd\u5de5\u8054\u7cfb\u4eba\u7535\u8bdd[constrPhone]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConstrDate())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u5f00\u5de5\u65e5\u671f[constrDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getConstrPrjInfoList() || reqBO.getConstrPrjInfoList().size() < 1) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u9879\u76ee\u4fe1\u606f\u96c6\u5408[shipPrjInfoList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List xbjShipPrjInfoBOList = reqBO.getConstrPrjInfoList();
        for (XbjShipPrjInfoBO xbjShipPrjInfoBO : xbjShipPrjInfoBOList) {
            if (null == xbjShipPrjInfoBO.getConstrCount() || xbjShipPrjInfoBO.getConstrCount().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u9879\u76ee\u4fe1\u606f\u96c6\u5408\u9879\u76ee\u672c\u6b21\u5b8c\u5de5\u6570\u91cf[ConstrCount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != xbjShipPrjInfoBO.getPurchaseOrderItemId()) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u9879\u76ee\u4fe1\u606f\u96c6\u5408\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6ID[purchaseOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != reqBO.getPurchaseAccessoryReqList() && reqBO.getPurchaseAccessoryReqList().size() > 0) {
            List xbjPurchaseAccessoryReqBOList = reqBO.getPurchaseAccessoryReqList();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : xbjPurchaseAccessoryReqBOList) {
                if (StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryUrl())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u65bd\u5de5:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

