/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseItemXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseItemXbjReqBO;
import com.cgd.order.atom.bo.OrderServItemXbjAtomBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrderPurchaseItemXbjAtomServiceImpl
implements OrderPurchaseItemXbjAtomService {
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    @Override
    public void updateOrderPurchaseItemCount(OrderPurchaseItemXbjReqBO req) {
        if (req.getOrderServItemXbjAtomList() != null && req.getOrderServItemXbjAtomList().size() > 0) {
            List<OrderServItemXbjAtomBO> orderServItemXbjAtomList = req.getOrderServItemXbjAtomList();
            for (OrderServItemXbjAtomBO itemInfo : orderServItemXbjAtomList) {
                if (StringUtils.isEmpty((Object)itemInfo.getPurchaseOrderItemId())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\u660e\u7ec6\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5355\u660e\u7ec6ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                }
                OrderPurchaseItemXbjPO po = new OrderPurchaseItemXbjPO();
                po.setPurchaseOrderItemId(itemInfo.getPurchaseOrderItemId());
                OrderPurchaseItemXbjPO PurchaseItemInfo = this.orderPurchaseItemXbjMapper.selectPurchaseItemInfoByPurchaseOrderId(po);
                if (PurchaseItemInfo == null) continue;
                BigDecimal onceCompleteCount = itemInfo.getOnceCompleteCount();
                BigDecimal completedCount = PurchaseItemInfo.getCompleteCount();
                BigDecimal purchaseCount = PurchaseItemInfo.getPurchaseCount();
                BigDecimal waitSendCount = PurchaseItemInfo.getWaitSendCount();
                BigDecimal orderSendCount = PurchaseItemInfo.getSendCount();
                BigDecimal sendCount = itemInfo.getOnceCompleteCount();
                if (waitSendCount.compareTo(sendCount) == 1 || waitSendCount.compareTo(sendCount) == 0) {
                    BigDecimal waitSendCountNew = waitSendCount.subtract(sendCount);
                    BigDecimal orderSendCountNew = sendCount.add(orderSendCount);
                    if (completedCount == null) {
                        completedCount = new BigDecimal("0");
                    }
                    BigDecimal completedCountNew = onceCompleteCount.add(completedCount);
                    OrderPurchaseItemXbjPO record = new OrderPurchaseItemXbjPO();
                    record.setWaitSendCount(waitSendCountNew);
                    record.setSendCount(orderSendCountNew);
                    record.setPurchaseOrderItemId(itemInfo.getPurchaseOrderItemId());
                    record.setCompleteCount(completedCountNew);
                    this.orderPurchaseItemXbjMapper.updatePurchaseItemInfoByPurchaseOrderId(record);
                    continue;
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u5f85\u53d1\u6570\u91cf\u5c0f\u4e8e\u53d1\u8d27\u6570\u91cf\uff0c\u53d1\u8d27\u5f02\u5e38!");
            }
        }
    }

    public OrderPurchaseItemXbjMapper getOrderPurchaseItemXbjMapper() {
        return this.orderPurchaseItemXbjMapper;
    }

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }
}

