/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.dao.OrderSaleStatusChngXbjMapper;
import com.cgd.order.po.OrderSaleStatusChngXbjPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleOrderStatusCheckXbjServiceImpl
implements SaleOrderStatusCheckXbjService {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderStatusCheckXbjServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleStatusChngXbjMapper orderSaleStatusChngMapper;

    @Override
    public SaleOrderStatusCheckXbjRspBO notifySaleOrderStatus(SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq) {
        SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckRsp = new SaleOrderStatusCheckXbjRspBO();
        try {
            if (saleOrderStatusCheckReq == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderStatusCheckReq.getNewSaleOrderStatus() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1,\u4fee\u6539\u540e\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderStatusCheckReq.getOldSaleOrderStatus() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1,\u4fee\u6539\u524d\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderStatusCheckReq.getSaleOrderType() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Integer saleOrderStatusNew = saleOrderStatusCheckReq.getNewSaleOrderStatus();
            Integer saleOrderStatusOld = saleOrderStatusCheckReq.getOldSaleOrderStatus();
            Integer saleOrderType = saleOrderStatusCheckReq.getSaleOrderType();
            OrderSaleStatusChngXbjPO orderSaleStatusCheck = new OrderSaleStatusChngXbjPO();
            orderSaleStatusCheck.setSaleOrderStatusNew(saleOrderStatusNew);
            orderSaleStatusCheck.setSaleOrderStatusOld(saleOrderStatusOld);
            orderSaleStatusCheck.setSaleOrderType(saleOrderType);
            orderSaleStatusCheck = this.orderSaleStatusChngMapper.orderSaleStatusCheck(orderSaleStatusCheck);
            if (orderSaleStatusCheck == null) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u5931\u8d25,R_ORDER_SALE_STATUS_CHNG\u8868\u6ca1\u6709\u5bf9\u5e94\u89c4\u5219!");
            }
            Integer isPass = orderSaleStatusCheck.getIsPass();
            if (isPass > 0) {
                saleOrderStatusCheckRsp.setCheckRspCode("8888");
                saleOrderStatusCheckRsp.setCheckRspDesc("\u65e0\u6cd5\u4ece\u5f53\u524d\u72b6\u6001\u3010" + saleOrderStatusOld + "\u3011\u53d8\u66f4\u5230\u4e0b\u4e00\u72b6\u6001\u3010" + saleOrderStatusNew + "\u3011");
            }
            if (isPass == 0) {
                saleOrderStatusCheckRsp.setCheckRspCode("0000");
                saleOrderStatusCheckRsp.setCheckRspDesc("\u6821\u9a8c\u901a\u8fc7\uff0c\u53ef\u4ee5\u53d8\u66f4!");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            saleOrderStatusCheckRsp.setCheckRspCode("8888");
            saleOrderStatusCheckRsp.setCheckRspDesc("\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u5f02\u5e38,\u6ca1\u6709\u5bf9\u5e94\u89c4\u5219!");
        }
        return saleOrderStatusCheckRsp;
    }
}

