/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjOrderPurchaseBusiService;
import com.cgd.order.busi.XbjSupplierPurchaseOrderTakeBusiService;
import com.cgd.order.busi.bo.XbjConfirmSupplierOrderReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDealServiceXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderDealServiceXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class XbjSupplierPurchaseOrderTakeBusiServiceImpl
implements XbjSupplierPurchaseOrderTakeBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSupplierPurchaseOrderTakeBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private XbjOrderPurchaseBusiService orderPurchaseBusiService;
    private XbjCreateOrderFlowSheetBusiService createOrderFlowSheetBusiService;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private OrderDealServiceXbjMapper orderDealServiceXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;

    @Autowired
    public void setOrderPurchaseBusiService(XbjOrderPurchaseBusiService orderPurchaseBusiService) {
        this.orderPurchaseBusiService = orderPurchaseBusiService;
    }

    public void setCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService createOrderFlowSheetBusiService) {
        this.createOrderFlowSheetBusiService = createOrderFlowSheetBusiService;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderProtocolItemXbjMapper(OrderProtocolItemXbjMapper orderProtocolItemXbjMapper) {
        this.orderProtocolItemXbjMapper = orderProtocolItemXbjMapper;
    }

    public RspInfoBO confirmSupplierOrder(XbjConfirmSupplierOrderReqBO reqBO) {
        this.validateParams(reqBO);
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u91c7\u8d2d\u8ba2\u5355\u63a5\u5355\u4e1a\u52a1\u670d\u52a1-> \u5165\u53c2BO:" + reqBO.toString());
        }
        try {
            Long purchaseOrderId = Long.valueOf(reqBO.getPurchaseOrderId());
            OrderPurchaseXbjPO purchaseXbjPO = new OrderPurchaseXbjPO();
            purchaseXbjPO.setPurchaseOrderId(purchaseOrderId);
            purchaseXbjPO.setGoodsSupplierId((long)reqBO.getSupId());
            purchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(purchaseXbjPO);
            if (purchaseXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (!Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING.equals(purchaseXbjPO.getPurchaseOrderStatus()) && !XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CONFIRM.equals(purchaseXbjPO.getPurchaseOrderStatus())) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f53\u524d\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u7b26\u5408\u63a5\u5355\u8981\u6c42,\u63a5\u5355\u8981\u6c42\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u662f  -> \u4f9b\u5e94\u786e\u8ba4\u4e2d");
            }
            this.orderPurchaseBusiService.updateOrderPurchaseStatus(purchaseOrderId, null, Integer.valueOf(reqBO.getOldStatus()), Integer.valueOf(reqBO.getNewStatus()), reqBO.getUserId(), null);
            XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            orderFlowSheetReqBO.setOrderId(purchaseOrderId);
            orderFlowSheetReqBO.setPurchaserId(purchaseXbjPO.getPurchaserId());
            orderFlowSheetReqBO.setUserId(reqBO.getUserId());
            orderFlowSheetReqBO.setUserName(reqBO.getUserName());
            orderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            orderFlowSheetReqBO.setOrderBusiType("B_6");
            orderFlowSheetReqBO.setCompanyName(reqBO.getCompanyName());
            orderFlowSheetReqBO.setOperRole("\u4f9b\u5e94\u5546");
            XbjOrderFlowSheetRspBO orderFlowSheetRsp = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
            if (orderFlowSheetRsp != null && "8888".equals(orderFlowSheetRsp.getRespCode())) {
                throw new BusinessException(orderFlowSheetRsp.getRespCode(), "\u8ba2\u5355\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            }
            if (purchaseXbjPO.getSaleOrderType().equals(XConstant.SALE_ORDER_TYPE_PROTOCOL) && purchaseXbjPO.getIsDispatch().equals(XConstant.IS_DISPATCH_NO)) {
                OrderSaleXbjPO xbjOrderSale = this.orderSaleXbjMapper.getModelById(purchaseXbjPO.getSaleOrderId());
                OrderDealServiceXbjPO po = new OrderDealServiceXbjPO();
                po.setSaleOrderCode(xbjOrderSale.getSaleOrderCode());
                po.setPurchaseOrderId(purchaseXbjPO.getPurchaseOrderId());
                po.setPurchaseOrderCode(purchaseXbjPO.getPurchaseOrderCode());
                po.setOrderName(purchaseXbjPO.getPurchaseOrderName());
                po.setSaleOrderType(purchaseXbjPO.getSaleOrderType());
                po.setOrderPurchaseType(purchaseXbjPO.getSaleOrderPurchaseType());
                po.setSaleOrderBusiType(purchaseXbjPO.getIsDispatch());
                po.setDealServiceStatus(XConstant.ORDRE_DEAL_SERVICE_STATUS.UNSENT);
                po.setProtocolCode(purchaseXbjPO.getPlaAgreementCode());
                po.setPurchaserAccount(purchaseXbjPO.getPurchaserAccount());
                po.setPurchaserId(purchaseXbjPO.getPurchaserId());
                OrderProtocolItemXbjPO protocolCondition = new OrderProtocolItemXbjPO();
                protocolCondition.setSaleOrderId(xbjOrderSale.getSaleOrderId());
                protocolCondition.setPurchaserId(xbjOrderSale.getPurchaserId());
                List<OrderProtocolItemXbjPO> protocolList = this.orderProtocolItemXbjMapper.getList(protocolCondition);
                if (!CollectionUtils.isEmpty(protocolList)) {
                    po.setAgreementId(protocolList.get(0).getAgreementId());
                    po.setProtocolName(protocolList.get(0).getProtocolName());
                    po.setProducerId(protocolList.get(0).getProducerId());
                    po.setProducerName(protocolList.get(0).getProducerName());
                    po.setProduceTime(protocolList.get(0).getProduceTime());
                    po.setDealServiceRate(protocolList.get(0).getServiceRate());
                    po.setDealServiceFee((long)protocolList.get(0).getServiceRate().intValue() * xbjOrderSale.getSaleOrderMoney() / 100L);
                }
                po.setPurchaserName(xbjOrderSale.getPurchaserName());
                po.setSupplierId(xbjOrderSale.getGoodsSupplierId());
                po.setSupplierName(xbjOrderSale.getGoodsSupplierName());
                po.setProfessionalAccount(xbjOrderSale.getProfessionalAccount());
                po.setProfessionalOrganizationId(xbjOrderSale.getProfessionalOrganizationId());
                po.setProfessionalOrganizationName(xbjOrderSale.getProfessionalOrganizationName());
                po.setManagerId(0L);
                po.setManagerName("\u6211\u8fd8\u4e0d\u77e5\u9053\u600e\u4e48\u586b\u5199");
                po.setSaleOrderMoney(xbjOrderSale.getSaleOrderMoney());
                po.setPurchaseOrderMoney(purchaseXbjPO.getPurchaseOrderMoney());
                po.setOrderCreateTime(xbjOrderSale.getCreateTime());
                this.orderDealServiceXbjMapper.insertDealService(po);
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u91c7\u8d2d\u8ba2\u5355\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u91c7\u8d2d\u8ba2\u5355\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        RspInfoBO rsp = new RspInfoBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private void validateParams(XbjConfirmSupplierOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOldStatus())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u539f\u59cb\u72b6\u6001[oldStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getNewStatus())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u65b0\u72b6\u6001[newStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

