/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.OrderStatusChangeCheckXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderStatusChangeCheckAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderStatusChangeCheckAtomXbjRspBO;
import com.cgd.order.busi.XbjOrderStatusChangeBusiService;
import com.cgd.order.busi.bo.XbjOrderStatusChangeRspBO;
import com.cgd.order.busi.bo.XbjOrderStatusChgReqBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjOrderStatusChangeBusiServiceImpl
implements XbjOrderStatusChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderStatusChangeBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderStatusChangeCheckXbjAtomService orderStatusChangeCheckXbjAtomService;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private AccessoryXbjAtomService accessoryXbjAtomService;
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;

    public void setOrderStatusChangeCheckXbjAtomService(OrderStatusChangeCheckXbjAtomService orderStatusChangeCheckXbjAtomService) {
        this.orderStatusChangeCheckXbjAtomService = orderStatusChangeCheckXbjAtomService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setAccessoryXbjAtomService(AccessoryXbjAtomService accessoryXbjAtomService) {
        this.accessoryXbjAtomService = accessoryXbjAtomService;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public XbjOrderStatusChangeRspBO changeOrderStatus(XbjOrderStatusChgReqBO xbjOrderStatusChgReqBO) {
        OrderPurchaseXbjPO xbjOrderPurchase;
        this.validateParams(xbjOrderStatusChgReqBO);
        if (this.isDebugEnabled) {
            log.debug("\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u4e1a\u52a1\u670d\u52a1 ->---------------------------------------------------------");
            log.debug("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)xbjOrderStatusChgReqBO));
        }
        OrderStatusChangeCheckAtomXbjReqBO xbjOrderStatusChangeCheckAtomReqBO = new OrderStatusChangeCheckAtomXbjReqBO();
        BeanUtils.copyProperties((Object)xbjOrderStatusChgReqBO, (Object)xbjOrderStatusChangeCheckAtomReqBO);
        OrderStatusChangeCheckAtomXbjRspBO checkRsp = this.orderStatusChangeCheckXbjAtomService.orderStatusChangeCheck(xbjOrderStatusChangeCheckAtomReqBO);
        if (Constant.ORDER_TYPE_SALE.equals(xbjOrderStatusChgReqBO.getOrderType())) {
            OrderSaleXbjPO xbjOrderSale = this.orderSaleXbjMapper.selectByPrimaryKey(xbjOrderStatusChgReqBO.getOrderId());
            if (xbjOrderSale != null) {
                OrderSaleXbjReqBO xbjOrderSaleReqBO = this.transferOrderSaleReqBO(xbjOrderSale, xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getOldStatus(), xbjOrderStatusChgReqBO.getNewStatus(), xbjOrderStatusChgReqBO.getUserId());
                this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
                this.orderSaleXbjMapper.updateCancelInfo(xbjOrderSale.getSaleOrderId(), xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getCancelRemark(), new Date(), xbjOrderStatusChgReqBO.getUserId());
                OrderPurchaseXbjPO xbjOrderPurchase2 = this.orderPurchaseXbjMapper.selectByPrimaryKey(xbjOrderSale.getPurchaseOrderId());
                if (xbjOrderPurchase2 != null) {
                    OrderPurchaseStatusChngReqBo xbjOrderPurchaseStatusChngAtomReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjOrderPurchase2, xbjOrderStatusChgReqBO.getOldStatus(), xbjOrderStatusChgReqBO.getNewStatus(), xbjOrderStatusChgReqBO.getUserId());
                    this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(xbjOrderPurchaseStatusChngAtomReqBo);
                    this.orderPurchaseXbjMapper.updateCancelInfo(xbjOrderPurchase2.getPurchaseOrderId(), xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getCancelRemark(), new Date(), xbjOrderStatusChgReqBO.getUserId());
                    if (xbjOrderStatusChgReqBO.getAccessoryList() != null && !xbjOrderStatusChgReqBO.getAccessoryList().isEmpty()) {
                        List<AccessoryXbjPO> list = this.assembleAccessoryData(xbjOrderSale, xbjOrderStatusChgReqBO.getObjectType(), (List<XbjPurchaseAccessoryReqBO>)xbjOrderStatusChgReqBO.getAccessoryList());
                        this.accessoryXbjAtomService.batchSave(list);
                    }
                }
            }
        } else if (Constant.ORDER_TYPE_PURCHASE.equals(xbjOrderStatusChgReqBO.getOrderType()) && (xbjOrderPurchase = this.orderPurchaseXbjMapper.selectByPrimaryKey(xbjOrderStatusChgReqBO.getOrderId())) != null) {
            OrderPurchaseStatusChngReqBo xbjOrderPurchaseStatusChngAtomReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjOrderPurchase, xbjOrderStatusChgReqBO.getOldStatus(), xbjOrderStatusChgReqBO.getNewStatus(), xbjOrderStatusChgReqBO.getUserId());
            this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(xbjOrderPurchaseStatusChngAtomReqBo);
            this.orderPurchaseXbjMapper.updateCancelInfo(xbjOrderPurchase.getPurchaseOrderId(), xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getCancelRemark(), new Date(), xbjOrderStatusChgReqBO.getUserId());
            OrderSaleXbjPO xbjOrderSale = this.orderSaleXbjMapper.selectByPrimaryKey(xbjOrderPurchase.getSaleOrderId());
            if (xbjOrderSale != null) {
                OrderSaleXbjReqBO xbjOrderSaleReqBO = this.transferOrderSaleReqBO(xbjOrderSale, xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getOldStatus(), xbjOrderStatusChgReqBO.getNewStatus(), xbjOrderStatusChgReqBO.getUserId());
                this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
                this.orderSaleXbjMapper.updateCancelInfo(xbjOrderSale.getSaleOrderId(), xbjOrderStatusChgReqBO.getCancelReason(), xbjOrderStatusChgReqBO.getCancelRemark(), new Date(), xbjOrderStatusChgReqBO.getUserId());
            }
            if (xbjOrderStatusChgReqBO.getAccessoryList() != null && !xbjOrderStatusChgReqBO.getAccessoryList().isEmpty()) {
                List<AccessoryXbjPO> list = this.assembleAccessoryData(xbjOrderPurchase, xbjOrderStatusChgReqBO.getObjectType(), (List<XbjPurchaseAccessoryReqBO>)xbjOrderStatusChgReqBO.getAccessoryList());
                this.accessoryXbjAtomService.batchSave(list);
            }
        }
        XbjOrderStatusChangeRspBO rsp = new XbjOrderStatusChangeRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private List<AccessoryXbjPO> assembleAccessoryData(OrderPurchaseXbjPO xbjOrderPurchase, Integer objectType, List<XbjPurchaseAccessoryReqBO> list) {
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : list) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(String.valueOf(xbjPurchaseAccessoryReqBO.getAccessoryId()));
            accessory.setAccessoryName(xbjPurchaseAccessoryReqBO.getAccessoryName());
            accessory.setAccessoryUrl(xbjPurchaseAccessoryReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(xbjOrderPurchase.getGoodsSupplierId()));
            accessory.setObjectId(xbjOrderPurchase.getSaleOrderId());
            accessory.setObjectType(objectType);
            accessory.setProfessionalOrganizationId(String.valueOf(xbjOrderPurchase.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(xbjOrderPurchase.getPurchaserAccountId());
            accessory.setPurchaserAccountName(xbjOrderPurchase.getPurchaserAccountName());
            accessory.setPurchaserId(xbjOrderPurchase.getPurchaserId());
            accessoryList.add(accessory);
        }
        return accessoryList;
    }

    private List<AccessoryXbjPO> assembleAccessoryData(OrderSaleXbjPO xbjOrderSale, Integer objectType, List<XbjPurchaseAccessoryReqBO> list) {
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : list) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(String.valueOf(xbjPurchaseAccessoryReqBO.getAccessoryId()));
            accessory.setAccessoryName(xbjPurchaseAccessoryReqBO.getAccessoryName());
            accessory.setAccessoryUrl(xbjPurchaseAccessoryReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(xbjOrderSale.getGoodsSupplierId()));
            accessory.setObjectId(xbjOrderSale.getSaleOrderId());
            accessory.setObjectType(objectType);
            accessory.setProfessionalOrganizationId(String.valueOf(xbjOrderSale.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(xbjOrderSale.getPurchaserAccountId());
            accessory.setPurchaserAccountName(xbjOrderSale.getPurchaserAccountName());
            accessory.setPurchaserId(xbjOrderSale.getPurchaserId());
            accessoryList.add(accessory);
        }
        return accessoryList;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(OrderPurchaseXbjPO xbjOrderPurchase, Integer oldStatus, Integer newStatus, Long userId) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(xbjOrderPurchase.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(oldStatus);
        req.setPurchaseOrderStatus(newStatus);
        req.setPurchaserId(xbjOrderPurchase.getPurchaserId());
        req.setPurchaserAccountId(xbjOrderPurchase.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(xbjOrderPurchase.getProfessionalOrganizationId());
        req.setSaleOrderId(xbjOrderPurchase.getSaleOrderId());
        req.setGoodsSupplierId(xbjOrderPurchase.getGoodsSupplierId());
        req.setPurchaserAccountName(xbjOrderPurchase.getPurchaserAccountName());
        req.setSaleOrderId(xbjOrderPurchase.getSaleOrderId());
        return req;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO xbjOrderSale, String cancelReason, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(xbjOrderSale.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(xbjOrderSale.getPurchaserId());
        req.setPurchaserAccountId(xbjOrderSale.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(xbjOrderSale.getProfessionalOrganizationId());
        req.setCancelReason(cancelReason);
        req.setGoodsSupplierId(xbjOrderSale.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(xbjOrderSale.getPurchaserAccountName());
        req.setSaleOrderType(xbjOrderSale.getSaleOrderType());
        return req;
    }

    private void validateParams(XbjOrderStatusChgReqBO xbjOrderStatusChgReqBO) {
        if (xbjOrderStatusChgReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderStatusChgReqBO.getNewStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u8ba2\u5355\u72b6\u6001[newStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderStatusChgReqBO.getOldStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u59cb\u8ba2\u5355\u72b6\u6001[oldStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjOrderStatusChgReqBO.getOrderBusiType())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u4e1a\u52a1\u7f16\u7801[orderBusiType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderStatusChgReqBO.getSaleOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6765\u6e90[saleOrderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderStatusChgReqBO.getOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderStatusChgReqBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

