/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjPurchaseOrderRejectRecoveryBusiService;
import com.cgd.order.busi.bo.XbjOrderCancelBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjRejectOrderRecoveryReqBO;
import com.cgd.order.busi.bo.XbjRejectOrderRecoveryRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjPurchaseOrderRejectRecoveryBusiServiceImpl
implements XbjPurchaseOrderRejectRecoveryBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjPurchaseOrderRejectRecoveryBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setXbjCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService) {
        this.xbjCreateOrderFlowSheetBusiService = xbjCreateOrderFlowSheetBusiService;
    }

    public XbjRejectOrderRecoveryRspBO dealRejectRecoveryOrder(XbjRejectOrderRecoveryReqBO xbjRejectOrderRecoveryReqBO) {
        this.validateParams(xbjRejectOrderRecoveryReqBO);
        if (this.isDebugEnabled) {
            log.debug("\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u62d2\u5355\u6062\u590d\u4e1a\u52a1\u670d\u52a1----------------------------------------------------");
            log.debug("\u5165\u53c2:" + JSON.toJSONString((Object)xbjRejectOrderRecoveryReqBO));
        }
        XbjRejectOrderRecoveryRspBO rsp = new XbjRejectOrderRecoveryRspBO();
        List reqBOList = xbjRejectOrderRecoveryReqBO.getRejectRecoveryList();
        if (reqBOList != null && reqBOList.size() > 0) {
            for (XbjOrderCancelBO reqBO : reqBOList) {
                xbjRejectOrderRecoveryReqBO.setPurchaseOrderId(Long.valueOf(Long.parseLong(reqBO.getPurchaseOrderId())));
                xbjRejectOrderRecoveryReqBO.setPurchaserId(Long.valueOf(Long.parseLong(reqBO.getPurchaseId())));
                OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.querySupplierOrderPursechaseById(xbjRejectOrderRecoveryReqBO.getPurchaseOrderId(), xbjRejectOrderRecoveryReqBO.getPurchaserId());
                this.validate(orderPurchaseXbjPO);
                try {
                    XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
                    OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjRejectOrderRecoveryReqBO.getUserId(), orderPurchaseXbjPO, XConstant.SALE_ORDER_STATE_SUPPLY_CONFIRMING, null);
                    this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
                    OrderSaleXbjReqBO xbjOrderSaleReqBO = new OrderSaleXbjReqBO();
                    xbjOrderSaleReqBO.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
                    xbjOrderSaleReqBO.setSaleOrderStatus(XConstant.SALE_ORDER_STATE_TO_CONF);
                    xbjOrderSaleReqBO.setSaleOrderOldStatus(orderPurchaseXbjPO.getPurchaseOrderStatus());
                    xbjOrderSaleReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
                    xbjOrderSaleReqBO.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
                    xbjOrderSaleReqBO.setOperId(xbjRejectOrderRecoveryReqBO.getUserId().toString());
                    xbjOrderSaleReqBO.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
                    xbjOrderSaleReqBO.setCancelReason("");
                    xbjOrderSaleReqBO.setGoodsSupplierId(orderPurchaseXbjPO.getGoodsSupplierId());
                    xbjOrderSaleReqBO.setModifyOprId(xbjRejectOrderRecoveryReqBO.getUserId());
                    xbjOrderSaleReqBO.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
                    xbjOrderSaleReqBO.setSaleOrderType(orderPurchaseXbjPO.getSaleOrderType());
                    this.orderSaleXbjAtomService.salerOrderStatusChange(xbjOrderSaleReqBO);
                    XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                    BeanUtils.copyProperties((Object)xbjRejectOrderRecoveryReqBO, (Object)xbjOrderFlowSheetReqBO);
                    xbjOrderFlowSheetReqBO.setOrderId(xbjRejectOrderRecoveryReqBO.getPurchaseOrderId());
                    xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                    xbjOrderFlowSheetReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
                    if (XbjOrderConstants.IS_DISPATCH_YES.equals(orderPurchaseXbjPO.getIsDispatch())) {
                        xbjOrderFlowSheetReqBO.setOperRole("\u914d\u9001\u4e13\u8d23");
                        xbjOrderFlowSheetReqBO.setOrderBusiType("B_25");
                        xbjOrderFlowSheetReqBO.setCompanyName(orderPurchaseXbjPO.getProfessionalOrganizationName());
                    } else {
                        xbjOrderFlowSheetReqBO.setOperRole("\u8ba1\u5212\u91c7\u8d2d\u5458");
                        xbjOrderFlowSheetReqBO.setOrderBusiType("B_26");
                        xbjOrderFlowSheetReqBO.setCompanyName(xbjRejectOrderRecoveryReqBO.getCompanyName());
                    }
                    xbjOrderFlowSheetReqBO.setUserId(xbjRejectOrderRecoveryReqBO.getUserId());
                    xbjOrderFlowSheetReqBO.setUserName(xbjRejectOrderRecoveryReqBO.getUserName());
                    if (this.isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                        log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    }
                    if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) == null || !"8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) continue;
                    throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
                }
                catch (Exception e) {
                    rsp.setRespCode("8888");
                    rsp.setRespDesc("\u5931\u8d25");
                    return rsp;
                }
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u62d2\u5355\u6062\u590d\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u8ba2\u5355\u5217\u8868\u96c6\u5408\u4e3a\u7a7a");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(Long userId, OrderPurchaseXbjPO orderPurchaseXbjPO, Integer purchaseOrderStatus, String arriveTime) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchaseXbjPO.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(purchaseOrderStatus);
        req.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        req.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        req.setArriveTime(arriveTime);
        return req;
    }

    private void validate(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!Constant.SALSE_ORDER_STATE_REJECT_TO_DEAL.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f53\u524d\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u7b26\u5408\u62d2\u5355\u53d6\u6d88\u8981\u6c42,\u62d2\u5355\u6062\u590d\u8981\u6c42\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u662f  -> \u62d2\u5355\u5f85\u5904\u7406");
        }
    }

    private void validateParams(XbjRejectOrderRecoveryReqBO xbjRejectOrderRecoveryReqBO) {
        if (xbjRejectOrderRecoveryReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u62d2\u5355\u6062\u590d\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectOrderRecoveryReqBO.getRejectRecoveryList() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id\u96c6\u5408[rejectRecoveryList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List reqBOList = xbjRejectOrderRecoveryReqBO.getRejectRecoveryList();
        for (XbjOrderCancelBO reqBO : reqBOList) {
            if (reqBO.getPurchaseOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getPurchaseId() != null) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546id[purchaseId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectOrderRecoveryReqBO.getOldStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e7\u72b6\u6001[oldStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectOrderRecoveryReqBO.getNewStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u72b6\u6001[newStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectOrderRecoveryReqBO.getUserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

