/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.busi.XbjDealServiceSendBusiService;
import com.cgd.order.busi.bo.XbjAccessoryRspBO;
import com.cgd.order.busi.bo.XbjDealServiceSendReqBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.dao.OrderDealServiceXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderDealServiceXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.pay.busi.PayAddTradeServiceFeeService;
import com.cgd.pay.busi.bo.PayAddTradeServiceFeeReqBO;
import com.cgd.pay.enums.CompanyType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjDealServiceSendBusiService")
public class XbjDealServiceSendBusiServiceImpl
implements XbjDealServiceSendBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjDealServiceSendBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderDealServiceXbjMapper orderDealServiceXbjMapper;
    @Autowired
    private PayAddTradeServiceFeeService payAddTradeServiceFeeService;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;

    public RspInfoBO dealServiceSend(XbjDealServiceSendReqBO reqBO) throws Exception {
        RspInfoBO rspBO;
        block9: {
            rspBO = new RspInfoBO();
            this.validateParams(reqBO);
            OrderDealServiceXbjPO dealServiceCondition = new OrderDealServiceXbjPO();
            dealServiceCondition.setDealServiceId(reqBO.getDealServiceId());
            OrderDealServiceXbjPO dealServiceXbjPO = this.orderDealServiceXbjMapper.getModelBy(dealServiceCondition);
            if (dealServiceXbjPO == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u6210\u4ea4\u901a\u77e5\u4e66");
            }
            OrderDealServiceXbjPO updateDealServicePO = new OrderDealServiceXbjPO();
            updateDealServicePO.setDealServiceId(reqBO.getDealServiceId());
            updateDealServicePO.setDealServiceStatus(reqBO.getSendType());
            updateDealServicePO.setCancelReason(reqBO.getFreeReason());
            updateDealServicePO.setSentTime(new Date());
            this.orderDealServiceXbjMapper.updateByDealServiceId(updateDealServicePO);
            if (reqBO.getSendType().equals(XConstant.ORDRE_DEAL_SERVICE_STATUS.HAS_BEEN_SENT)) {
                PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = new PayAddTradeServiceFeeReqBO();
                payAddTradeServiceFeeReqBO.setPayOrderNo(dealServiceXbjPO.getSaleOrderId() + "");
                payAddTradeServiceFeeReqBO.setInquiryNo(dealServiceXbjPO.getSaleOrderCode());
                payAddTradeServiceFeeReqBO.setOrderDate(new Date());
                payAddTradeServiceFeeReqBO.setPayOrderName(dealServiceXbjPO.getOrderName());
                payAddTradeServiceFeeReqBO.setOrderTotalMoney(MoneyUtil.Long2BigDecimal((Long)dealServiceXbjPO.getSaleOrderMoney()));
                payAddTradeServiceFeeReqBO.setPayMoney(MoneyUtil.Long2BigDecimal((Long)dealServiceXbjPO.getDealServiceFee()));
                payAddTradeServiceFeeReqBO.setCompanyType(CompanyType.SUPPLIER);
                payAddTradeServiceFeeReqBO.setSupplierId(dealServiceXbjPO.getSupplierId());
                payAddTradeServiceFeeReqBO.setOperUnitNo(dealServiceXbjPO.getProfessionalOrganizationId());
                payAddTradeServiceFeeReqBO.setPayFeeType("03");
                payAddTradeServiceFeeReqBO.setOperator(reqBO.getUserId());
                try {
                    if (isDebugEnabled) {
                        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                    }
                    RspBusiBaseBO payAddTradeRspBO = this.payAddTradeServiceFeeService.addTradeServiceFee(payAddTradeServiceFeeReqBO);
                    if (isDebugEnabled) {
                        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)payAddTradeRspBO));
                    }
                    if (payAddTradeRspBO != null && !"0000".equalsIgnoreCase(payAddTradeRspBO.getRespCode())) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38" + payAddTradeRspBO.getRespDesc());
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.error("\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38" + e.getMessage());
                }
            }
            if (reqBO.getSendType().equals(XConstant.ORDRE_DEAL_SERVICE_STATUS.FREE_SHEET)) {
                List<AccessoryXbjPO> accessoryXbjPOList = this.packageAccessoryInfo(reqBO, dealServiceXbjPO);
                this.accessoryXbjAtomService.batchSave(accessoryXbjPOList);
            } else {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001\u7c7b\u578b\u9519\u8bef");
            }
        }
        return rspBO;
    }

    public List<AccessoryXbjPO> packageAccessoryInfo(XbjDealServiceSendReqBO reqBO, OrderDealServiceXbjPO orderDealServiceXbjPO) {
        OrderSaleXbjPO orderSaleXbjPO;
        List xbjAccessoryRspBOList = reqBO.getXbjAccessoryRspBOList();
        ArrayList<AccessoryXbjPO> accessoryXbjPOList = new ArrayList<AccessoryXbjPO>();
        try {
            orderSaleXbjPO = this.orderSaleXbjMapper.getModelById(orderDealServiceXbjPO.getSaleOrderId());
        }
        catch (Exception e) {
            log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001/\u514d\u5355\u670d\u52a1\u67e5\u8be2\u9500\u552e\u5355\u5931\u8d25\uff0c\u65e0\u6b64\u9500\u552e\u5355id");
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6210\u4ea4\u670d\u52a1\u8d39\u53d1\u9001/\u514d\u5355\u670d\u52a1\u67e5\u8be2\u9500\u552e\u5355\u5931\u8d25\uff0c\u65e0\u6b64\u9500\u552e\u5355id");
        }
        for (XbjAccessoryRspBO xbjAccessoryRspBO : xbjAccessoryRspBOList) {
            AccessoryXbjPO accessoryXbjPO = new AccessoryXbjPO();
            accessoryXbjPO.setPurchaserId(orderDealServiceXbjPO.getPurchaserId());
            accessoryXbjPO.setProfessionalOrganizationId(String.valueOf(orderDealServiceXbjPO.getProfessionalOrganizationId()));
            accessoryXbjPO.setPurchaserAccountId(orderSaleXbjPO.getPurchaserAccountId());
            accessoryXbjPO.setAccessoryId(String.valueOf(xbjAccessoryRspBO.getAccessoryId()));
            accessoryXbjPO.setAccessoryUrl(xbjAccessoryRspBO.getAccessoryUrl());
            accessoryXbjPO.setAccessoryName(xbjAccessoryRspBO.getAccessoryName());
            accessoryXbjPO.setObjectId(reqBO.getDealServiceId());
            accessoryXbjPO.setObjectType(XConstant.ORDER_DEAL_SERVICE_OBJECT_TYPE);
            accessoryXbjPOList.add(accessoryXbjPO);
        }
        return accessoryXbjPOList;
    }

    private void validateParams(XbjDealServiceSendReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDealServiceId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[dealServiceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSendType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[sendType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

