/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.OrderPurchaseItemCrtXbjAtomService;
import com.cgd.order.atom.XbjProtocolPurchaseOrderCrtAtomSerivce;
import com.cgd.order.atom.bo.GenerateOrderPurchaseSeqXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseItemCrtXbjReqBO;
import com.cgd.order.atom.bo.OrderPurchaseItemXbjBO;
import com.cgd.order.busi.bo.XbjProtocolBusiPurchaseOrderCrtReqBO;
import com.cgd.order.busi.bo.XbjProtocolBusiPurchaseOrderCrtRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjProtocolPurchaseOrderCrtAtomSerivceImpl
implements XbjProtocolPurchaseOrderCrtAtomSerivce {
    private static final Logger log = LoggerFactory.getLogger(XbjProtocolPurchaseOrderCrtAtomSerivceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    private OrderPurchaseItemCrtXbjAtomService orderPurchaseItemCrtXbjAtomService;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }

    public void setOrderPurchaseItemCrtXbjAtomService(OrderPurchaseItemCrtXbjAtomService orderPurchaseItemCrtXbjAtomService) {
        this.orderPurchaseItemCrtXbjAtomService = orderPurchaseItemCrtXbjAtomService;
    }

    @Override
    public XbjProtocolBusiPurchaseOrderCrtRspBO createXbjPurchaseShipOrder(XbjProtocolBusiPurchaseOrderCrtReqBO xbjProtocolBusiPurchaseOrderCrtReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u4e1a\u52a1\u670d\u52a1:" + xbjProtocolBusiPurchaseOrderCrtReqBO);
        }
        XbjProtocolBusiPurchaseOrderCrtRspBO xbjProtocolBusiPurchaseOrderCrtRspBO = new XbjProtocolBusiPurchaseOrderCrtRspBO();
        if (null == xbjProtocolBusiPurchaseOrderCrtReqBO.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7f16\u53f7[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjProtocolBusiPurchaseOrderCrtReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7[purchaseId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectByIdAndPurchaserId(xbjProtocolBusiPurchaseOrderCrtReqBO.getSaleOrderId(), xbjProtocolBusiPurchaseOrderCrtReqBO.getPurchaserId());
            List<OrderSaleItemXbjPO> orderSaleItems = this.orderSaleItemXbjMapper.selectBySaleOrderAndPurchaserId(xbjProtocolBusiPurchaseOrderCrtReqBO.getSaleOrderId(), orderSale.getPurchaserId());
            if (null != orderSaleItems && orderSaleItems.size() > 0) {
                GenerateOrderPurchaseSeqXbjRspBO generateOrderPurchaseSeqXbjRspBO = new GenerateOrderPurchaseSeqXbjRspBO();
                generateOrderPurchaseSeqXbjRspBO.setPurchaseOrderId(orderSale.getPurchaseOrderId());
                OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCtReqBO = this.initOrderPurchaseItemCrtReqBO(orderSale, orderSaleItems, generateOrderPurchaseSeqXbjRspBO, xbjProtocolBusiPurchaseOrderCrtReqBO);
                List<OrderPurchaseItemXbjPO> orderPurchaseItemList = this.orderPurchaseItemCrtXbjAtomService.orderPurchaseItemCrt(orderPurchaseItemCtReqBO);
                if (orderPurchaseItemList != null) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u660e\u7ec6\u6570\u636e\uff1a" + orderPurchaseItemList.toString());
                }
                xbjProtocolBusiPurchaseOrderCrtRspBO.setPurchaseOrderId(orderSale.getPurchaseOrderId());
                xbjProtocolBusiPurchaseOrderCrtRspBO.setPurchaseOrderStatus(orderPurchaseItemCtReqBO.getPurchaseOrderStatus());
                xbjProtocolBusiPurchaseOrderCrtRspBO.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
                xbjProtocolBusiPurchaseOrderCrtRspBO.setRespCode("0000");
                xbjProtocolBusiPurchaseOrderCrtRspBO.setRespDesc("\u91c7\u8d2d\u5355\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u6210\u529f!");
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + xbjProtocolBusiPurchaseOrderCrtRspBO);
                }
            } else if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1\u51fa\u9519,\u3010" + xbjProtocolBusiPurchaseOrderCrtReqBO.getSaleOrderId() + "\u3011\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u3010" + xbjProtocolBusiPurchaseOrderCrtReqBO.getSaleOrderId() + "\u3011\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u53d1\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u5f02\u5e38:" + e);
        }
        return xbjProtocolBusiPurchaseOrderCrtRspBO;
    }

    private OrderPurchaseItemCrtXbjReqBO initOrderPurchaseItemCrtReqBO(OrderSaleXbjPO orderSale, List<OrderSaleItemXbjPO> orderSaleItems, GenerateOrderPurchaseSeqXbjRspBO generateOrderPurchaseSeqRspBO, XbjProtocolBusiPurchaseOrderCrtReqBO xbjProtocolBusiPurchaseOrderCrtReqBO) {
        try {
            OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCrtReqBO = new OrderPurchaseItemCrtXbjReqBO();
            orderPurchaseItemCrtReqBO.setPurchaseOrderId(generateOrderPurchaseSeqRspBO.getPurchaseOrderId());
            BeanUtils.copyProperties((Object)generateOrderPurchaseSeqRspBO, (Object)orderPurchaseItemCrtReqBO);
            if (Constant.IS_DISPATCH_NO.equals(orderSale.getIsDispatch())) {
                if (XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CONFIRM.equals(orderSale.getSaleOrderStatus())) {
                    orderPurchaseItemCrtReqBO.setPurchaseOrderStatus(Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING);
                } else {
                    orderPurchaseItemCrtReqBO.setPurchaseOrderStatus(Constant.EA_PURCHASE_ORDER_STATUS);
                }
            } else if (Constant.SALSE_ORDER_STATE_TO_EXAMINE.equals(orderSale.getSaleOrderStatus())) {
                orderPurchaseItemCrtReqBO.setPurchaseOrderStatus(Constant.EA_PURCHASE_ORDER_STATUS);
            } else if (XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CONFIRM.equals(orderSale.getSaleOrderStatus())) {
                orderPurchaseItemCrtReqBO.setPurchaseOrderStatus(Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING);
            } else {
                orderPurchaseItemCrtReqBO.setPurchaseOrderStatus(orderSale.getSaleOrderStatus());
            }
            orderPurchaseItemCrtReqBO.setProfessionalAccount(orderSale.getProfessionalAccount());
            orderPurchaseItemCrtReqBO.setPayType(orderSale.getPayType());
            orderPurchaseItemCrtReqBO.setPayMode(orderSale.getPayMode());
            orderPurchaseItemCrtReqBO.setBaseTransportationFee(orderSale.getBaseTransportationFee());
            orderPurchaseItemCrtReqBO.setComment(orderSale.getComment());
            orderPurchaseItemCrtReqBO.setGoodsSupplierId(orderSale.getGoodsSupplierId());
            orderPurchaseItemCrtReqBO.setNeedContactMobile(orderSale.getNeedContactMobile());
            orderPurchaseItemCrtReqBO.setNeedContactName(orderSale.getNeedContactName());
            orderPurchaseItemCrtReqBO.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
            orderPurchaseItemCrtReqBO.setPurchaserAccountId(orderSale.getPurchaserAccountId());
            orderPurchaseItemCrtReqBO.setPurchaserAccountName(orderSale.getPurchaserAccountName());
            orderPurchaseItemCrtReqBO.setPurchaserId(orderSale.getPurchaserId());
            orderPurchaseItemCrtReqBO.setSaleOrderType(orderSale.getSaleOrderType());
            orderPurchaseItemCrtReqBO.setTatleTransportationFee(orderSale.getTatleTransportationFee());
            orderPurchaseItemCrtReqBO.setExtOrderNakedPrice(orderSale.getExtOrderNakedPrice());
            orderPurchaseItemCrtReqBO.setExtOrderPrice(orderSale.getExtOrderPrice());
            orderPurchaseItemCrtReqBO.setExtOrderTaxPrice(orderSale.getExtOrderTaxPrice());
            orderPurchaseItemCrtReqBO.setSaleOrderId(orderSale.getSaleOrderId());
            orderPurchaseItemCrtReqBO.setExtOrderId(orderSale.getExtOrderId());
            orderPurchaseItemCrtReqBO.setGiveTime(orderSale.getGiveTime());
            orderPurchaseItemCrtReqBO.setPurchaserName(orderSale.getPurchaserName());
            orderPurchaseItemCrtReqBO.setPurchaserAccount(orderSale.getPurchaserAccount());
            orderPurchaseItemCrtReqBO.setExtOrderTotalAmount(orderSale.getExtOrderTotalAmount());
            orderPurchaseItemCrtReqBO.setExtPerentOrderId(orderSale.getExtPerentOrderId());
            orderPurchaseItemCrtReqBO.setPurchaseOrderName(orderSale.getSaleOrderName());
            orderPurchaseItemCrtReqBO.setRemoteregionfreight(orderSale.getRemoteregionfreight());
            orderPurchaseItemCrtReqBO.setSaleOrderParentId(orderSale.getSaleOrderParentId());
            orderPurchaseItemCrtReqBO.setSaleOrderBusiType(orderSale.getSaleOrderBusiType());
            orderPurchaseItemCrtReqBO.setModifyOperId(orderSale.getModifyOperId());
            orderPurchaseItemCrtReqBO.setModifyTime(orderSale.getModifyTime());
            orderPurchaseItemCrtReqBO.setSplitReason(orderSale.getSplitReason());
            orderPurchaseItemCrtReqBO.setTaxRate(orderSale.getTaxRate());
            orderPurchaseItemCrtReqBO.setDeliveryId(orderSale.getDeliveryId());
            orderPurchaseItemCrtReqBO.setIsSplit(orderSale.getIsSplit());
            orderPurchaseItemCrtReqBO.setStatusReason(orderSale.getStatusReason());
            orderPurchaseItemCrtReqBO.setPurchaseOrderCode(orderSale.getPurchaseOrderCode());
            orderPurchaseItemCrtReqBO.setPurchaserAccountOrgId(orderSale.getPurchaserAccountOrgId());
            orderPurchaseItemCrtReqBO.setDeptId(orderSale.getDeptId());
            orderPurchaseItemCrtReqBO.setSaleOrderPurchaseType(orderSale.getSaleOrderPurchaseType());
            orderPurchaseItemCrtReqBO.setOrderType(orderSale.getOrderType());
            orderPurchaseItemCrtReqBO.setProfessionalName(orderSale.getProfessionalName());
            orderPurchaseItemCrtReqBO.setProfessionalMobile(orderSale.getProfessionalMobile());
            orderPurchaseItemCrtReqBO.setGoodsSupplierName(orderSale.getGoodsSupplierName());
            orderPurchaseItemCrtReqBO.setGoodsSupplierMobile(orderSale.getGoodsSupplierMobile());
            orderPurchaseItemCrtReqBO.setPurchaserMobile(orderSale.getPurchaserMobile());
            orderPurchaseItemCrtReqBO.setGoodsSupplierRelaman(orderSale.getGoodsSupplierRelaman());
            orderPurchaseItemCrtReqBO.setProfessionalOrganizationName(orderSale.getProfessionalOrganizationName());
            orderPurchaseItemCrtReqBO.setDeliveryId(orderSale.getDeliveryId());
            orderPurchaseItemCrtReqBO.setDeliveryName(orderSale.getDeliveryName());
            orderPurchaseItemCrtReqBO.setPlaAgreementCode(orderSale.getPlaAgreementCode());
            orderPurchaseItemCrtReqBO.setIsDisPatch(orderSale.getIsDispatch());
            orderPurchaseItemCrtReqBO.setArriveTime(orderSale.getArriveTime());
            orderPurchaseItemCrtReqBO.setPrePayEnt(orderSale.getPrePayEnt());
            orderPurchaseItemCrtReqBO.setMatPayEnt(orderSale.getMatPayEnt());
            orderPurchaseItemCrtReqBO.setProPayEnt(orderSale.getProPayEnt());
            orderPurchaseItemCrtReqBO.setVerPayEnt(orderSale.getVerPayEnt());
            orderPurchaseItemCrtReqBO.setPilPayEnt(orderSale.getPilPayEnt());
            orderPurchaseItemCrtReqBO.setQuaPayEnt(orderSale.getQuaPayEnt());
            orderPurchaseItemCrtReqBO.setMatPaySup(orderSale.getMatPaySup());
            orderPurchaseItemCrtReqBO.setProPaySup(orderSale.getProPaySup());
            orderPurchaseItemCrtReqBO.setVerPaySup(orderSale.getVerPaySup());
            orderPurchaseItemCrtReqBO.setPilPaySup(orderSale.getPilPaySup());
            orderPurchaseItemCrtReqBO.setQuaPaySup(orderSale.getQuaPaySup());
            orderPurchaseItemCrtReqBO.setPrePaySup(orderSale.getPrePaySup());
            orderPurchaseItemCrtReqBO.setAssignedComment(orderSale.getAssignedComment());
            orderPurchaseItemCrtReqBO.setWarantty(orderSale.getWarantty());
            ArrayList<OrderPurchaseItemXbjBO> orderPurchaseItemBOs = new ArrayList<OrderPurchaseItemXbjBO>();
            if (!orderSaleItems.isEmpty() && orderSaleItems.size() > 0) {
                Long purchaserOrderMoney = 0L;
                for (OrderSaleItemXbjPO orderSaleItem : orderSaleItems) {
                    if (isDebugEnabled) {
                        log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u751f\u6210\u4e1a\u52a1orderSaleItem ,\u3010" + orderSaleItem.toString());
                    }
                    OrderPurchaseItemXbjBO orderPurchaseItemBO = new OrderPurchaseItemXbjBO();
                    BeanUtils.copyProperties((Object)orderSaleItem, (Object)orderPurchaseItemBO);
                    orderPurchaseItemBO.setGoodsSupplierId(orderSaleItem.getGoodsSupplierId());
                    orderPurchaseItemBO.setProfessionalOrganizationId(orderSaleItem.getProfessionalOrganizationId());
                    orderPurchaseItemBO.setPurchaseCount(orderSaleItem.getPurchaseCount());
                    orderPurchaseItemBO.setPurchaseOrderId(generateOrderPurchaseSeqRspBO.getPurchaseOrderId());
                    orderPurchaseItemBO.setPurchaserAccountId(orderSaleItem.getPurchaserAccountId());
                    orderPurchaseItemBO.setPurchaserAccountName(orderSaleItem.getPurchaserAccountName());
                    orderPurchaseItemBO.setPurchaserId(orderSaleItem.getPurchaserId());
                    BigDecimal total = orderSaleItem.getPurchaseCount().multiply(MoneyUtil.Long2BigDecimal((Long)orderSaleItem.getPurchasingPrice())).setScale(2, 1);
                    purchaserOrderMoney = purchaserOrderMoney + MoneyUtil.BigDecimal2Long((BigDecimal)total);
                    orderPurchaseItemBO.setTotal(MoneyUtil.BigDecimal2Long((BigDecimal)total));
                    orderPurchaseItemBO.setSkuCurrencyType(orderSaleItem.getSkuCurrencyType());
                    orderPurchaseItemBO.setSkuId(orderSaleItem.getSkuId());
                    orderPurchaseItemBO.setUnitName(orderSaleItem.getUnitName());
                    orderPurchaseItemBO.setSaleOrderId(orderSaleItem.getSaleOrderId());
                    orderPurchaseItemBO.setSaleOrderItemId(orderSaleItem.getSaleOrderItemId());
                    orderPurchaseItemBO.setPurchaseItemStatus(Constant.EA_PURCHASE_ORDER_STATUS);
                    orderPurchaseItemBO.setSkuSimpleName(orderSaleItem.getSkuSimpleName());
                    orderPurchaseItemBO.setSkuName(orderSaleItem.getSkuName());
                    orderPurchaseItemBO.setMaterialId(orderSaleItem.getMaterialId());
                    orderPurchaseItemBO.setMaterialName(orderSaleItem.getMaterialName());
                    orderPurchaseItemBO.setMaterialQuality(orderSaleItem.getMaterialQuality());
                    orderPurchaseItemBO.setModel(orderSaleItem.getModel());
                    orderPurchaseItemBO.setExtSkuId(orderSaleItem.getExtSkuId());
                    orderPurchaseItemBO.setExtSkuNakedPrice(orderSaleItem.getExtSkuNakedPrice());
                    orderPurchaseItemBO.setExtSkuPrice(orderSaleItem.getExtSkuPrice());
                    orderPurchaseItemBO.setExtSkuTax(orderSaleItem.getExtSkuTax());
                    orderPurchaseItemBO.setExtSkuTaxPrice(orderSaleItem.getExtSkuTaxPrice());
                    orderPurchaseItemBO.setPurchaserAccountOrgId(orderSaleItem.getPurchaserAccountOrgId());
                    orderPurchaseItemBO.setDeptId(orderSaleItem.getDeptId());
                    orderPurchaseItemBO.setSaleOrderPurchaseType(orderSale.getSaleOrderPurchaseType());
                    orderPurchaseItemBO.setProjectId(orderSaleItem.getProjectId());
                    orderPurchaseItemBO.setProjectCode(orderSaleItem.getProjectCode());
                    orderPurchaseItemBO.setProjectName(orderSaleItem.getProjectName());
                    orderPurchaseItemBO.setContentDescription(orderSaleItem.getProjectContent());
                    orderPurchaseItemBO.setAcceptanceCount(orderSaleItem.getAcceptanceCount());
                    orderPurchaseItemBO.setCompleteCount(orderSaleItem.getCompleteCount());
                    orderPurchaseItemBO.setMarkUpRateNew(orderSaleItem.getMarkUpRateNew());
                    orderPurchaseItemBO.setMarkUpRate(orderSaleItem.getMarkUpRate());
                    orderPurchaseItemBO.setMaterialCode(orderSaleItem.getMaterialCode());
                    orderPurchaseItemBO.setMaterialClassId(orderSaleItem.getMaterialClassId());
                    orderPurchaseItemBO.setBrand(orderSaleItem.getBrand());
                    orderPurchaseItemBO.setBrandId(orderSaleItem.getBrandId());
                    orderPurchaseItemBO.setManufacturer(orderSaleItem.getManufacturer());
                    orderPurchaseItemBO.setUsedCompany(orderSaleItem.getUsedCompany());
                    orderPurchaseItemBO.setPreSendDate(DateUtil.dateToStrLong(orderSaleItem.getPreSendDate()));
                    orderPurchaseItemBOs.add(orderPurchaseItemBO);
                }
                orderPurchaseItemCrtReqBO.setPurchaserOrderMoney(purchaserOrderMoney);
            }
            orderPurchaseItemCrtReqBO.setOrderPurchaseItemBOs(orderPurchaseItemBOs);
            return orderPurchaseItemCrtReqBO;
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u53d1\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2\u51fa\u9519", (Throwable)e);
            throw new RuntimeException("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u5355\u53d1\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2\u51fa\u9519");
        }
    }
}

