/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.busi.XbjOrderServCreateBusiService;
import com.cgd.order.busi.bo.XbjOrderServCompleteItemBO;
import com.cgd.order.busi.bo.XbjOrderServCreateReqBO;
import com.cgd.order.busi.bo.XbjOrderServCreateRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.intfce.XbjOrderServiceIntfceService;
import com.cgd.order.intfce.bo.PurchaseAccessoryReqBO;
import com.cgd.order.intfce.bo.ShipPrjInfoBO;
import com.cgd.order.intfce.bo.XbjOrderServiceCreateReqBO;
import com.cgd.order.intfce.bo.XbjOrderServiceCreateRspBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XbjOrderServiceIntfceServiceImpl
implements XbjOrderServiceIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderServiceIntfceServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private XbjOrderServCreateBusiService xbjOrderServCreateBusiService;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;

    public XbjOrderServiceCreateRspBO dealWithXbjOrderServiceCreate(XbjOrderServiceCreateReqBO req) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5165\u53c2:" + req.toString());
        }
        XbjOrderServiceCreateRspBO rsp = new XbjOrderServiceCreateRspBO();
        try {
            XbjOrderServCreateRspBO orderServCreateBusiRsp;
            this.dealWithParamVerify(req);
            OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjAtomService.qryOrderPurchaseByPurchaseOrderIdAndPurchaserId(req.getPurchaseOrderId(), req.getPurchaserId());
            if (orderPurchaseXbjPO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\uff0c\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u65e0\u6570\u636e");
            }
            List<OrderPurchaseItemXbjPO> orderPurchaseItemList = this.dealWithBusiVerify(req, orderPurchaseXbjPO);
            XbjOrderServCreateReqBO XbjOrderServCreateReq = this.initParams(orderPurchaseXbjPO, orderPurchaseItemList, req);
            if (null != req.getPurchaseAccessoryReqList() && req.getPurchaseAccessoryReqList().size() > 0) {
                log.error("\u5b8c\u5de5\u5355\u9644\u4ef6\u5165\u53c2\u4e4b\u524d\u63a5\u6536\u7684\u53c2\u6570\uff1a" + JSON.toJSONString((Object)req.getPurchaseAccessoryReqList()));
                List<AccessoryXbjPO> accessoryList = this.assembleAccessoryData(orderPurchaseXbjPO, XbjOrderConstants.ACCESSORY_TYPE.SERV_COMPLETE, req.getPurchaseAccessoryReqList(), XbjOrderServCreateReq.getServCompleteOrderId());
                log.error("\u5b8c\u5de5\u5355\u9644\u4ef6\u5165\u53c2\u53c2\u6570\uff1a" + JSON.toJSONString(accessoryList));
                this.accessoryXbjAtomService.batchSave(accessoryList);
            }
            if ((orderServCreateBusiRsp = this.xbjOrderServCreateBusiService.createOrderServ(XbjOrderServCreateReq)) == null || !"0000".equals(orderServCreateBusiRsp.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5931\u8d25:" + orderServCreateBusiRsp.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u6210\u529f");
        return rsp;
    }

    private void dealWithParamVerify(XbjOrderServiceCreateReqBO bo) {
        if (bo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)bo.getUserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u64cd\u4f5c\u4ebaID[userId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)bo.getPurchaseOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355Id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)bo.getPurchaserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u91c7\u8d2d\u5546ID[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)bo.getServName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u670d\u52a1\u8054\u7cfb\u4eba\u59d3\u540d[servName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)bo.getServPhone())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u670d\u52a1\u8054\u7cfb\u4eba\u7535\u8bdd[servPhone]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getServPrjInfoList() == null || bo.getServPrjInfoList().size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9879\u76ee\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getPurchaseAccessoryReqList() != null && bo.getPurchaseAccessoryReqList().size() > 0) {
            for (PurchaseAccessoryReqBO accessory : bo.getPurchaseAccessoryReqList()) {
                if (StringUtils.isEmpty((Object)accessory.getAccessoryName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9644\u4ef6\u4fe1\u606f\u7684\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)accessory.getAccessoryUrl())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9644\u4ef6\u4fe1\u606f\u7684\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        for (ShipPrjInfoBO Prj : bo.getServPrjInfoList()) {
            if (StringUtils.isEmpty((Object)Prj.getPurchaseOrderItemId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9879\u76ee\u4fe1\u606f\u7684\u9879\u76eeID[getPurchaseOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Prj.getServCount() != null && Prj.getServCount().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1:\u5165\u53c2\u9879\u76ee\u4fe1\u606f\u7684\u9879\u76ee\u6570\u91cf[servCount]\u6709\u8bef\uff01");
        }
    }

    private List<OrderPurchaseItemXbjPO> dealWithBusiVerify(XbjOrderServiceCreateReqBO req, OrderPurchaseXbjPO po) {
        ArrayList<OrderPurchaseItemXbjPO> orderPurchaseItemList = new ArrayList<OrderPurchaseItemXbjPO>();
        if (StringUtils.isEmpty((Object)po.getSaleOrderPurchaseType()) || po.getSaleOrderPurchaseType() != XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\uff0c\u91c7\u8d2d\u8ba2\u5355\u7684\u7c7b\u578b\u4e0d\u662f\u670d\u52a1\u7c7b");
        }
        if (!XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING.equals(po.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u72b6\u6001[" + po.getPurchaseOrderStatus() + "]\u65e0\u6cd5\u7ee7\u7eed\uff01");
        }
        if (po.getWholeAcceptance() != XbjOrderConstants.XBJ_WHOLE_ACCEPTANCE_ZERO) {
            if (isDebugEnabled) {
                log.debug("\u6b64\u8ba2\u5355[" + req.getPurchaseOrderId() + "]\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6b64\u8ba2\u5355[" + req.getPurchaseOrderId() + "]\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u7ee7\u7eed");
        }
        List shipPrjInfoList = req.getServPrjInfoList();
        BigDecimal shipTotalCount = BigDecimal.ZERO;
        BigDecimal purchaseTotalCount = BigDecimal.ZERO;
        for (ShipPrjInfoBO shipPrjInfoBO : shipPrjInfoList) {
            OrderPurchaseItemXbjPO record = new OrderPurchaseItemXbjPO();
            record.setPurchaseOrderId(po.getPurchaseOrderId());
            record.setPurchaserId(po.getPurchaserId());
            record.setPurchaseOrderItemId(shipPrjInfoBO.getPurchaseOrderItemId());
            OrderPurchaseItemXbjPO orderPurchaseItem = this.orderPurchaseItemXbjMapper.getOrderPurchaseDetail(record);
            if (orderPurchaseItem == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u91c7\u8d2d\u5355\u660e\u7ec6");
            }
            orderPurchaseItem.setCompleteCount(shipPrjInfoBO.getServCount());
            orderPurchaseItem.setPurchaseOrderItemId(orderPurchaseItem.getPurchaseOrderItemId());
            log.error("orderPurchaseItem.getUnitName()=-========================:" + orderPurchaseItem.getUnitName());
            log.error("orderPurchaseItem.getUnitName()=-===============isDebugEnabled=========:" + isDebugEnabled);
            if (isDebugEnabled) {
                // empty if block
            }
            orderPurchaseItemList.add(orderPurchaseItem);
            List<OrderPurchaseItemXbjPO> orderPurchaseInfo = this.orderPurchaseItemXbjMapper.selectListByPurchaseOrderId(po.getPurchaseOrderId());
            if (null == orderPurchaseInfo || orderPurchaseInfo.size() <= 0) continue;
            for (OrderPurchaseItemXbjPO PurchaseItem : orderPurchaseInfo) {
                purchaseTotalCount = purchaseTotalCount.add(PurchaseItem.getPurchaseCount());
            }
        }
        return orderPurchaseItemList;
    }

    private XbjOrderServCreateReqBO initParams(OrderPurchaseXbjPO orderPurchase, List<OrderPurchaseItemXbjPO> orderPurchaseItemList, XbjOrderServiceCreateReqBO req) {
        OrderSaleInfoXbjRspBO orderSaleInfoXbjRspBO = this.orderSaleXbjAtomService.queryOrderSaleById(orderPurchase.getSaleOrderId(), orderPurchase.getPurchaserId());
        GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.SERV_COMPLETE);
        generateOrderIdAndCodeXbjReqBO.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
        generateOrderIdAndCodeXbjReqBO.setPurchaseId(orderPurchase.getPurchaserId());
        GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
        XbjOrderServCreateReqBO xbjOrderServCreateReq = new XbjOrderServCreateReqBO();
        xbjOrderServCreateReq.setServCompleteOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
        xbjOrderServCreateReq.setServCompleteOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        xbjOrderServCreateReq.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
        xbjOrderServCreateReq.setPurchaseOrderCode(orderPurchase.getPurchaseOrderCode());
        xbjOrderServCreateReq.setSaleOrderId(orderPurchase.getSaleOrderId());
        xbjOrderServCreateReq.setSaleOrderCode(orderSaleInfoXbjRspBO.getSaleOrderCode());
        xbjOrderServCreateReq.setPurchaserId(req.getPurchaserId());
        xbjOrderServCreateReq.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
        xbjOrderServCreateReq.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
        xbjOrderServCreateReq.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
        xbjOrderServCreateReq.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
        xbjOrderServCreateReq.setConstrRelaName(req.getServName());
        xbjOrderServCreateReq.setConstrRelaPhone(req.getServPhone());
        xbjOrderServCreateReq.setOpenOrderNo(req.getServId());
        xbjOrderServCreateReq.setOpenDate(DateUtil.strToDate(req.getServDate(), "yyyy-MM-dd"));
        xbjOrderServCreateReq.setOrderType(orderSaleInfoXbjRspBO.getOrderType());
        xbjOrderServCreateReq.setFinishDate(new Date());
        if (req.getPurchaseAccessoryReqList() != null && req.getPurchaseAccessoryReqList().size() > 0) {
            xbjOrderServCreateReq.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.YES);
        } else {
            xbjOrderServCreateReq.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.NO);
        }
        xbjOrderServCreateReq.setOperId(req.getUserId());
        xbjOrderServCreateReq.setOperName(req.getUserName());
        xbjOrderServCreateReq.setCompanyName(req.getCompanyName());
        xbjOrderServCreateReq.setCreateTime(new Date());
        xbjOrderServCreateReq.setModifyOperId(req.getUserId());
        xbjOrderServCreateReq.setModifyTime(new Date());
        xbjOrderServCreateReq.setFinishDate(new Date());
        ArrayList<XbjOrderServCompleteItemBO> xbjOrderServCompleteItemList = new ArrayList<XbjOrderServCompleteItemBO>();
        for (OrderPurchaseItemXbjPO orderPurchaseItem : orderPurchaseItemList) {
            XbjOrderServCompleteItemBO xbjOrderServCompleteItemBo = new XbjOrderServCompleteItemBO();
            xbjOrderServCompleteItemBo.setServCompleteOrderId(xbjOrderServCreateReq.getServCompleteOrderId());
            xbjOrderServCompleteItemBo.setSaleOrderItemId(orderPurchaseItem.getSaleOrderItemId());
            xbjOrderServCompleteItemBo.setPurchaseOrderItemId(orderPurchaseItem.getPurchaseOrderItemId());
            xbjOrderServCompleteItemBo.setPurchaserId(req.getPurchaserId());
            xbjOrderServCompleteItemBo.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
            xbjOrderServCompleteItemBo.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
            xbjOrderServCompleteItemBo.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
            xbjOrderServCompleteItemBo.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
            xbjOrderServCompleteItemBo.setProjectId(orderPurchaseItem.getProjectId());
            xbjOrderServCompleteItemBo.setProjectCode(orderPurchaseItem.getProjectCode());
            xbjOrderServCompleteItemBo.setProjectName(orderPurchaseItem.getProjectName());
            xbjOrderServCompleteItemBo.setProjectContent(orderPurchaseItem.getProjectContent());
            xbjOrderServCompleteItemBo.setSellingPrice(orderPurchaseItem.getSellingPrice());
            xbjOrderServCompleteItemBo.setPurchaseCount(Integer.valueOf(orderPurchaseItem.getPurchaseCount().intValue()));
            xbjOrderServCompleteItemBo.setUnitName(orderPurchaseItem.getUnitName());
            if (isDebugEnabled) {
                log.error("orderPurchaseItem.getUnitName()=-========================:" + orderPurchaseItem.getUnitName());
            }
            xbjOrderServCompleteItemBo.setAcceptanceCount(orderPurchaseItem.getAcceptanceCount());
            xbjOrderServCompleteItemBo.setOnceCompleteCount(orderPurchaseItem.getCompleteCount());
            xbjOrderServCompleteItemList.add(xbjOrderServCompleteItemBo);
        }
        xbjOrderServCreateReq.setXbjOrderServCompleteItemList(xbjOrderServCompleteItemList);
        return xbjOrderServCreateReq;
    }

    private List<AccessoryXbjPO> assembleAccessoryData(OrderPurchaseXbjPO orderPurchase, Integer paramObjectType, List<PurchaseAccessoryReqBO> list, Long servCompleteOrderId) {
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (PurchaseAccessoryReqBO purchaseAccessoryReqBO : list) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(String.valueOf(purchaseAccessoryReqBO.getAccessoryId()));
            accessory.setAccessoryName(purchaseAccessoryReqBO.getAccessoryName());
            accessory.setAccessoryUrl(purchaseAccessoryReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(orderPurchase.getGoodsSupplierId()));
            accessory.setObjectId(servCompleteOrderId);
            accessory.setObjectType(paramObjectType);
            accessory.setProfessionalOrganizationId(String.valueOf(orderPurchase.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
            accessory.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
            accessory.setPurchaserId(orderPurchase.getPurchaserId());
            accessory.setRemark("\u8be2\u6bd4\u4ef7\u670d\u52a1\u5b8c\u5de5\u521b\u5efa");
            accessoryList.add(accessory);
        }
        return accessoryList;
    }
}

