/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.CreateSalesOrderDetailsXbjAtomService;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.GetSalesOrderSeqXbjAtomService;
import com.cgd.order.atom.XbjCreateSaleOrderAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.SalesOrderDetailsXbjReqBo;
import com.cgd.order.busi.bo.XbjDetailInfoRspBO;
import com.cgd.order.busi.bo.XbjOrderDealNoticeItemReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleBusiRspBO;
import com.cgd.order.busi.bo.XbjOrderSaleVerifyBaseInfoBO;
import com.cgd.order.busi.bo.XbjSubmitOrderSaleItemIntfceRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDealNoticeItemMapper;
import com.cgd.order.dao.OrderProfessionalOrganizationXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderDealNoticeItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.util.FormatCodeUtilXbj;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjCreateSaleOrderAtomServiceImpl
implements XbjCreateSaleOrderAtomService {
    private static final Logger logger = Logger.getLogger(XbjCreateSaleOrderAtomServiceImpl.class);
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private CreateSalesOrderDetailsXbjAtomService createSalesOrderDetailsXbjAtomService;
    @Autowired
    private GetSalesOrderSeqXbjAtomService getSalesOrderSeqXbjAtomService;
    @Autowired
    private OrderDealNoticeItemMapper orderDealNoticeItemMapper;
    @Autowired
    private OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;

    @Override
    public XbjOrderSaleBusiRspBO createXbjSaleOrder(XbjOrderSaleVerifyBaseInfoBO xbjOrderSaleVerifyBaseInfoBO) throws Exception {
        this.validateArg(xbjOrderSaleVerifyBaseInfoBO);
        QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
        qryOrgInfoByIdReqBO.setOrganizationId(xbjOrderSaleVerifyBaseInfoBO.getXbjOrderDealNoticeItem().getProfessionalOrganizationId());
        QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
        if (null == qryOrgInfoByIdRspBO || qryOrgInfoByIdRspBO.getUserOrganisationBO() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u5f02\u5e38");
        }
        logger.error((Object)("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u524d\u7f00\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)qryOrgInfoByIdRspBO)));
        GenerateOrderIdAndCodeXbjReqBO generateSaleOrderIDAndCodeRepBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateSaleOrderIDAndCodeRepBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.SALE);
        generateSaleOrderIDAndCodeRepBO.setPrefix(qryOrgInfoByIdRspBO.getUserOrganisationBO().getCode());
        GenerateOrderIdAndCodeXbjRspBO generateSaleOrderIDAndCodeRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateSaleOrderIDAndCodeRepBO);
        if (generateSaleOrderIDAndCodeRspBO == null || generateSaleOrderIDAndCodeRspBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9500\u552e\u8ba2\u5355ID\u548c\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
        }
        logger.debug((Object)("\u9500\u552e\u8ba2\u5355ID\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderId() + "\u9500\u552e\u8ba2\u5355CODE\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderCode()));
        GenerateOrderIdAndCodeXbjReqBO generatePurchaseIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generatePurchaseIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.PURCHASE);
        generatePurchaseIdAndCodeXbjReqBO.setSaleOrderCode(generateSaleOrderIDAndCodeRspBO.getOrderCode());
        GenerateOrderIdAndCodeXbjRspBO generatePurchaseIDAndCodeRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generatePurchaseIdAndCodeXbjReqBO);
        if (generatePurchaseIDAndCodeRspBO == null || generatePurchaseIDAndCodeRspBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u8ba2\u5355ID\u548c\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
        }
        logger.debug((Object)("\u91c7\u8d2d\u8ba2\u5355ID\uff1a" + generatePurchaseIDAndCodeRspBO.getOrderId() + "\u91c7\u8d2d\u8ba2\u5355CODE\uff1a" + generatePurchaseIDAndCodeRspBO.getOrderCode()));
        OrderSaleXbjPO transformationOrderSale = this.initOrderSale(xbjOrderSaleVerifyBaseInfoBO, generateSaleOrderIDAndCodeRspBO, generatePurchaseIDAndCodeRspBO);
        try {
            this.orderSaleXbjMapper.insertSelective(transformationOrderSale);
        }
        catch (Exception e) {
            logger.error((Object)("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u751f\u6210\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38!" + e.getMessage()));
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9500\u552e\u8ba2\u5355\u751f\u6210\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
        }
        List<SalesOrderDetailsXbjReqBo> salesOrderDetailsReq = this.initSalesOrderDetailsReq(xbjOrderSaleVerifyBaseInfoBO, generateSaleOrderIDAndCodeRspBO);
        try {
            this.createSalesOrderDetailsXbjAtomService.createOrderDetails(salesOrderDetailsReq);
        }
        catch (Exception e) {
            logger.error((Object)("\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u751f\u6210\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u539f\u5b50\u670d\u52a1\u5f02\u5e38!" + e.getMessage()));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u751f\u6210\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u539f\u5b50\u670d\u52a1\u5f02\u5e38!");
        }
        OrderDealNoticeItemXbjPO initDealNoticeInfo = this.initDealNoticeInfo(xbjOrderSaleVerifyBaseInfoBO, generateSaleOrderIDAndCodeRspBO, generatePurchaseIDAndCodeRspBO);
        try {
            this.orderDealNoticeItemMapper.insert(initDealNoticeInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u751f\u6210\u9500\u552e\u8ba2\u5355\u63d2\u5165\u6210\u4ea4\u901a\u77e5\u5355\u8868\u5f02\u5e38!" + e.getMessage()));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u751f\u6210\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u539f\u5b50\u670d\u52a1\u5f02\u5e38!");
        }
        XbjOrderSaleBusiRspBO retBo = new XbjOrderSaleBusiRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9500\u552e\u8ba2\u5355\u670d\u52a1\u6267\u884c\u6210\u529f");
        XbjSubmitOrderSaleItemIntfceRspBO xbjSubmitOrderSaleItemIntfceRspBO = new XbjSubmitOrderSaleItemIntfceRspBO();
        xbjSubmitOrderSaleItemIntfceRspBO.setSaleOrderId(generateSaleOrderIDAndCodeRspBO.getOrderId() + "");
        xbjSubmitOrderSaleItemIntfceRspBO.setPurchaseOrderId(generatePurchaseIDAndCodeRspBO.getOrderId() + "");
        xbjSubmitOrderSaleItemIntfceRspBO.setPurchaseOrderCode(generatePurchaseIDAndCodeRspBO.getOrderCode());
        xbjSubmitOrderSaleItemIntfceRspBO.setSaleOrderCode(generateSaleOrderIDAndCodeRspBO.getOrderCode());
        if (transformationOrderSale.getSaleOrderMoney() != null) {
            xbjSubmitOrderSaleItemIntfceRspBO.setFee(MoneyUtil.Long2BigDecimal((Long)transformationOrderSale.getSaleOrderMoney()));
        }
        xbjSubmitOrderSaleItemIntfceRspBO.setStatusId(transformationOrderSale.getSaleOrderStatus());
        xbjSubmitOrderSaleItemIntfceRspBO.setGoodsSupplierId(transformationOrderSale.getGoodsSupplierId() + "");
        xbjSubmitOrderSaleItemIntfceRspBO.setGoodsSupplierName(transformationOrderSale.getGoodsSupplierName());
        xbjSubmitOrderSaleItemIntfceRspBO.setPurchaserId(transformationOrderSale.getPurchaserId() + "");
        xbjSubmitOrderSaleItemIntfceRspBO.setPurchaserName(transformationOrderSale.getPurchaserName());
        xbjSubmitOrderSaleItemIntfceRspBO.setSaleOrderBusiType(transformationOrderSale.getSaleOrderPurchaseType());
        xbjSubmitOrderSaleItemIntfceRspBO.setSaleOrderName(transformationOrderSale.getSaleOrderName());
        xbjSubmitOrderSaleItemIntfceRspBO.setProfessionalOrganizationId(transformationOrderSale.getProfessionalOrganizationId() + "");
        retBo.setXbjSubmitOrderSaleItemIntfceRspBO(xbjSubmitOrderSaleItemIntfceRspBO);
        return retBo;
    }

    private OrderDealNoticeItemXbjPO initDealNoticeInfo(XbjOrderSaleVerifyBaseInfoBO xbjOrderSaleVerifyBaseInfoBO, GenerateOrderIdAndCodeXbjRspBO generateSaleOrderIDAndCodeRspBO, GenerateOrderIdAndCodeXbjRspBO generatePurchaseIDAndCodeRspBO) {
        OrderDealNoticeItemXbjPO po = new OrderDealNoticeItemXbjPO();
        XbjOrderDealNoticeItemReqBO xbjOrderDealNoticeItem = xbjOrderSaleVerifyBaseInfoBO.getXbjOrderDealNoticeItem();
        BeanUtils.copyProperties((Object)xbjOrderDealNoticeItem, (Object)po);
        po.setSaleOrderId(generateSaleOrderIDAndCodeRspBO.getOrderId());
        po.setPurchaserAccount(xbjOrderSaleVerifyBaseInfoBO.getOrderSaleBusiReq().getPurchaserAccount());
        po.setPurchaseOrderId(generatePurchaseIDAndCodeRspBO.getOrderId());
        po.setDealNoticeId(xbjOrderDealNoticeItem.getDealNoticeId());
        po.setPayment(xbjOrderDealNoticeItem.getPayment());
        po.setSupplyCycle(xbjOrderDealNoticeItem.getSupplyCycle());
        if (xbjOrderDealNoticeItem.getWarantty() == null) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u751f\u6210\u6210\u4ea4\u901a\u77e5\u4e66\uff1a\u521d\u59cb\u5316\u6210\u4ea4\u901a\u77e5\u83b7\u53d6\u8d28\u4fdd\u671f\u4e3a\u7a7a\uff01");
        }
        po.setWarantty(Integer.valueOf(xbjOrderDealNoticeItem.getWarantty()));
        return po;
    }

    private List<SalesOrderDetailsXbjReqBo> initSalesOrderDetailsReq(XbjOrderSaleVerifyBaseInfoBO bo, GenerateOrderIdAndCodeXbjRspBO generateSaleOrderIDAndCodeRspBO) {
        ArrayList<SalesOrderDetailsXbjReqBo> rList = new ArrayList<SalesOrderDetailsXbjReqBo>();
        List detailInfoList = bo.getDetailInfoList();
        logger.error((Object)("\u4e00\u5355\u4e00\u91c7\u660e\u7ec6\u6570\u636eDDDDDDDDDD\uff1a" + JSON.toJSONString((Object)detailInfoList)));
        for (XbjDetailInfoRspBO xbo : detailInfoList) {
            if (xbo == null) continue;
            SalesOrderDetailsXbjReqBo rbo = new SalesOrderDetailsXbjReqBo();
            Long salesOrderSeq = this.getSalesOrderSeqXbjAtomService.getSalesOrderSeq();
            BeanUtils.copyProperties((Object)xbo, (Object)rbo);
            if (xbo.getMaterialClassId() != null) {
                rbo.setSkuId(FormatCodeUtilXbj.skuIdRightFormat(xbo.getMaterialClassId()));
            }
            Integer saleOrderType = bo.getOrderSaleBusiReq().getSaleOrderPurchaseType();
            if (rbo.getSkuId() == null && (XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.equals(saleOrderType) || XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.equals(saleOrderType))) {
                rbo.setSkuId(0L);
            }
            rbo.setSaleOrderItemId(salesOrderSeq);
            rbo.setSaleOrderId(generateSaleOrderIDAndCodeRspBO.getOrderId());
            if (xbo.getPurchaseCount() != null) {
                rbo.setPurchaseCount(xbo.getPurchaseCount());
            }
            rbo.setSaleOrderItemStatus(XbjOrderConstants.SALE_ORDER_STATUS_XBJ_START);
            logger.error((Object)("\u6253\u5370brandId\uff1a" + xbo.getBrandId()));
            if (!"".equals(xbo.getBrandId()) && xbo.getBrandId() != null && !"null".equals(xbo.getBrandId())) {
                try {
                    rbo.setBrandId(Long.valueOf(xbo.getBrandId()));
                }
                catch (Exception e) {
                    logger.error((Object)"brandId\u975e\u6cd5!");
                }
            }
            rbo.setBrand(xbo.getBrandName());
            rList.add(rbo);
        }
        return rList;
    }

    private OrderSaleXbjPO initOrderSale(XbjOrderSaleVerifyBaseInfoBO bo, GenerateOrderIdAndCodeXbjRspBO generateSaleOrderIDAndCodeRspBO, GenerateOrderIdAndCodeXbjRspBO generatePurchaseIDAndCodeRspBO) {
        OrderSaleXbjPO orderSale = new OrderSaleXbjPO();
        BeanUtils.copyProperties((Object)bo.getOrderSaleBusiReq(), (Object)orderSale);
        orderSale.setSaleOrderCode(generateSaleOrderIDAndCodeRspBO.getOrderCode());
        orderSale.setSaleOrderId(generateSaleOrderIDAndCodeRspBO.getOrderId());
        orderSale.setPurchaseOrderCode(generatePurchaseIDAndCodeRspBO.getOrderCode());
        orderSale.setPurchaseOrderId(generatePurchaseIDAndCodeRspBO.getOrderId());
        orderSale.setGoodsSupplierName(bo.getOrderSaleBusiReq().getGoodsSupplierName());
        orderSale.setCreateTime(new Date());
        if (bo.getXbjOrderDealNoticeItem().getWarantty() != null) {
            orderSale.setWarantty(Integer.valueOf(bo.getXbjOrderDealNoticeItem().getWarantty()));
        }
        if (orderSale.getIsSplit() == null) {
            orderSale.setIsSplit(0);
        }
        if (bo.getXbjOrderDealNoticeItem().getSupplyCycle() != null) {
            orderSale.setArriveTime(bo.getXbjOrderDealNoticeItem().getSupplyCycle() + "");
        }
        return orderSale;
    }

    void validateArg(XbjOrderSaleVerifyBaseInfoBO bo) {
        if (bo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u521b\u5efa\u8ba2\u5355:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getXbjOrderDealNoticeItem() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u521b\u5efa\u8ba2\u5355:\u5165\u53c2XbjOrderDealNoticeItem\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getOrderSaleBusiReq() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u521b\u5efa\u8ba2\u5355:\u5165\u53c2orderSaleBusiReq\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getDetailInfoList() == null || bo.getDetailInfoList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u521b\u5efa\u8ba2\u5355:\u5165\u53c2detailInfoList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

