/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.QryTaskXbjAtomService;
import com.cgd.order.busi.XbjSaleOrderTabStatusCountBusiService;
import com.cgd.order.busi.bo.XbjOrderTabCountReqBO;
import com.cgd.order.busi.bo.XbjOrderTabCountRspBO;
import com.cgd.order.busi.bo.XbjTabInfoBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import com.cgd.user.supplier.busi.SelectSupplierInfoByOrgCodeBusiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjSaleOrderTabStatusCountBusiServiceImpl
implements XbjSaleOrderTabStatusCountBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSaleOrderTabStatusCountBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper;
    private SelectSupplierInfoByOrgCodeBusiService selectSupplierInfoByOrgCodeBusiService;
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    QryTaskXbjAtomService qryTaskXbjAtomService;

    public void setOrderTabMappingOrderStatusXbjMapper(OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper) {
        this.orderTabMappingOrderStatusXbjMapper = orderTabMappingOrderStatusXbjMapper;
    }

    public void setSelectSupplierInfoByOrgCodeBusiService(SelectSupplierInfoByOrgCodeBusiService selectSupplierInfoByOrgCodeBusiService) {
        this.selectSupplierInfoByOrgCodeBusiService = selectSupplierInfoByOrgCodeBusiService;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public XbjOrderTabCountRspBO SaleOrderStatusCount(XbjOrderTabCountReqBO xbjOrderTabCountReqBO) {
        this.validateParams(xbjOrderTabCountReqBO);
        if (isDebugEnabled) {
            log.debug("\u9000\u8d27\u5355\u67e5\u8be2\u5165\u53c2:" + xbjOrderTabCountReqBO.toString());
        }
        XbjOrderTabCountRspBO xbjOrderTabCountRspBO = new XbjOrderTabCountRspBO();
        ArrayList<XbjTabInfoBO> tabInfoRspList = new ArrayList<XbjTabInfoBO>();
        xbjOrderTabCountRspBO.setTabInfoList(tabInfoRspList);
        try {
            List xbjTabInfoBOList = xbjOrderTabCountReqBO.getTabInfoList();
            for (XbjTabInfoBO xbjTabInfoBO : xbjTabInfoBOList) {
                List<String> procInstIdList;
                String checkType;
                XbjTabInfoBO xbjTabInfoRspBO = new XbjTabInfoBO();
                List<OrderTabMappingOrderStatusXbjPO> orderTabMappingOrderStatusXbjPOList = null;
                orderTabMappingOrderStatusXbjPOList = this.orderTabMappingOrderStatusXbjMapper.selectByTabId(xbjTabInfoBO.getTabId());
                if (orderTabMappingOrderStatusXbjPOList == null || orderTabMappingOrderStatusXbjPOList.size() <= 0) continue;
                HashMap<String, Object> condition = new HashMap<String, Object>();
                if ("purchase".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("purchaserId", xbjOrderTabCountReqBO.getCompanyId());
                } else if ("proOrg".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("professionalOrganizationId", xbjOrderTabCountReqBO.getCompanyId());
                } else if ("proOrgDelivery".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("deliveryId", xbjOrderTabCountReqBO.getUserId());
                } else if ("delivery".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("deliveryId", xbjOrderTabCountReqBO.getUserId());
                    condition.put("deliveryPurchaserId", xbjOrderTabCountReqBO.getCompanyId());
                } else if ("check".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    checkType = xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKING) ? "checking" : (xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKED) ? "checked" : (xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.EXAMORDER_CHECK_ALL) ? "all" : "all"));
                    procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjOrderTabCountReqBO.getUserId(), checkType, "50");
                    if (procInstIdList == null || procInstIdList.size() == 0) {
                        procInstIdList.add("0");
                    }
                    condition.put("procInstIds", procInstIdList);
                } else if ("priceAdjustCheck".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    checkType = xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKING) ? "checking" : (xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKED) ? "checked" : (xbjTabInfoBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECK_ALL) ? "all" : "all"));
                    procInstIdList = new ArrayList<String>();
                    procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjOrderTabCountReqBO.getUserId(), checkType, "51");
                    if (procInstIdList == null || procInstIdList.size() == 0) {
                        procInstIdList.add("0");
                    }
                    condition.put("procInstIds", procInstIdList);
                } else {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u6570\u91cf\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u4f20\u5165\u7684roleType\u4e0eorderSubType\u6709\u8bef");
                }
                ArrayList<Integer> orderPurchaseTypeList = new ArrayList<Integer>();
                if (XbjOrderConstants.ORDER_PURCHASE_TYPE_ALL.equals(xbjOrderTabCountReqBO.getOrderPurchaseType())) {
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SHIP);
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_CONSTR);
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SERV);
                    condition.put("salePurchaseTypeList", orderPurchaseTypeList);
                } else {
                    orderPurchaseTypeList.add(xbjOrderTabCountReqBO.getOrderPurchaseType());
                    condition.put("salePurchaseTypeList", orderPurchaseTypeList);
                }
                ArrayList<Integer> saleOrderStatusList = new ArrayList<Integer>(orderTabMappingOrderStatusXbjPOList.size());
                for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatusXbjPO : orderTabMappingOrderStatusXbjPOList) {
                    saleOrderStatusList.add(orderTabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
                }
                condition.put("saleOrderStatusList", saleOrderStatusList);
                condition.put("typeList", xbjOrderTabCountReqBO.getTypeList());
                Integer saleOrderCount = this.orderSaleXbjMapper.queryOrderStatusTabCount(condition);
                if (saleOrderCount == null) {
                    saleOrderCount = 0;
                }
                xbjTabInfoRspBO.setTabName(orderTabMappingOrderStatusXbjPOList.get(0).getTabName());
                if (isDebugEnabled) {
                    log.debug("\u9875\u7b7e\u67e5\u8be2\u6570\u91cf:" + saleOrderCount);
                }
                xbjTabInfoRspBO.setTabCount(saleOrderCount);
                xbjTabInfoRspBO.setSaleOrderStatusCode(orderTabMappingOrderStatusXbjPOList.get(0).getSaleOrderStatusCode());
                xbjTabInfoRspBO.setSaleOrderStatusName(orderTabMappingOrderStatusXbjPOList.get(0).getSaleOrderStatusName());
                xbjTabInfoRspBO.setTabId(xbjTabInfoBO.getTabId());
                tabInfoRspList.add(xbjTabInfoRspBO);
            }
        }
        catch (Exception e) {
            xbjOrderTabCountRspBO.setRespCode("0000");
            xbjOrderTabCountRspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u6570\u91cf\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
            return xbjOrderTabCountRspBO;
        }
        xbjOrderTabCountRspBO.setRespCode("0000");
        xbjOrderTabCountRspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u6570\u91cf\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return xbjOrderTabCountRspBO;
    }

    private void validateParams(XbjOrderTabCountReqBO xbjOrderTabCountReqBO) {
        if (null == xbjOrderTabCountReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getTabInfoList() == null || xbjOrderTabCountReqBO.getTabInfoList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9875\u7b7e\u96c6\u5408[tabInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getTypeList() == null || xbjOrderTabCountReqBO.getTypeList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6765\u6e90\u96c6\u5408[typeList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)xbjOrderTabCountReqBO.getRoleType())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u89d2\u8272[roleType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getOrderPurchaseType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u7c7b\u522b[orderPurchaseType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

