/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.busi.XbjProtocolSaleOrderVerifyBusiService;
import com.cgd.order.busi.bo.DetailInfoRspBO;
import com.cgd.order.busi.bo.InfoAddressXbjReqBO;
import com.cgd.order.busi.bo.XbjAgrAttach;
import com.cgd.order.busi.bo.XbjAgrInfoBO;
import com.cgd.order.busi.bo.XbjOrderProtocolItemReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleBusiReqBO;
import com.cgd.order.busi.bo.XbjProAccountInfoBO;
import com.cgd.order.busi.bo.XbjProtocolOrderSaleVerifyBaseInfoBO;
import com.cgd.order.busi.bo.XbjProtocolSaleOrderVerifyReqBO;
import com.cgd.order.busi.bo.XbjProtocolSaleOrderVerifyRspBO;
import com.cgd.order.constant.XOrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.intfce.bo.AddressInfoIntfceXbjReqBO;
import com.cgd.order.intfce.bo.XbjProtocolSaleOrderInfoIntfceReqBO;
import com.cgd.order.intfce.bo.XbjProtocolSaleOrderItemIntfceBO;
import com.cgd.user.account.busi.CheckAccountFitUserBusiService;
import com.cgd.user.account.busi.QryEffActInfoByOrgBusiService;
import com.cgd.user.account.busi.bo.CheckAccountFitUserReqBO;
import com.cgd.user.account.busi.bo.CheckAccountFitUserRspBO;
import com.cgd.user.account.busi.bo.QryActInfoByOrgReq;
import com.cgd.user.account.busi.bo.QryActInfoByOrgRsp;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import com.gd.commodity.busi.QryAgrInfoService;
import com.gd.commodity.busi.bo.agreement.AgrAttach;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjProtocolSaleOrderVerifyBusiServiceImpl
implements XbjProtocolSaleOrderVerifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjProtocolSaleOrderVerifyBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private QryEffActInfoByOrgBusiService qryEffActInfoByOrgBusiService;
    private CheckAccountFitUserBusiService checkAccountFitUserBusiService;
    private QryAgrInfoService qryAgrInfoService;
    private QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;

    public void setQryEffActInfoByOrgBusiService(QryEffActInfoByOrgBusiService qryEffActInfoByOrgBusiService) {
        this.qryEffActInfoByOrgBusiService = qryEffActInfoByOrgBusiService;
    }

    public void setCheckAccountFitUserBusiService(CheckAccountFitUserBusiService checkAccountFitUserBusiService) {
        this.checkAccountFitUserBusiService = checkAccountFitUserBusiService;
    }

    public void setQryAgrInfoService(QryAgrInfoService qryAgrInfoService) {
        this.qryAgrInfoService = qryAgrInfoService;
    }

    public void setQryOrgInfoByIdBusiService(QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService) {
        this.qryOrgInfoByIdBusiService = qryOrgInfoByIdBusiService;
    }

    public XbjProtocolSaleOrderVerifyRspBO dealXbjProtocolSaleOrderVerify(XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        XbjProtocolSaleOrderVerifyRspBO xbjProtocolSaleOrderVerifyRsp = new XbjProtocolSaleOrderVerifyRspBO();
        try {
            this.verifyParamIn(xbjProtocolSaleOrderVerifyReqBO);
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:" + xbjProtocolSaleOrderVerifyReqBO.toString());
            }
            this.verifyPurchaseCount(xbjProtocolSaleOrderVerifyReqBO);
            List<XbjAgrInfoBO> agrInfoList = this.initAgreeMentInfo(xbjProtocolSaleOrderVerifyReqBO);
            List<XbjProAccountInfoBO> accountInfoList = this.initAccountInfo(agrInfoList, xbjProtocolSaleOrderVerifyReqBO.getCompanyId());
            xbjProtocolSaleOrderVerifyRsp = this.dealWithRspInfo(agrInfoList, accountInfoList, xbjProtocolSaleOrderVerifyReqBO);
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            xbjProtocolSaleOrderVerifyRsp.setRespCode("8888");
            xbjProtocolSaleOrderVerifyRsp.setRespDesc("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return xbjProtocolSaleOrderVerifyRsp;
    }

    private void verifyParamIn(XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        if (null == xbjProtocolSaleOrderVerifyReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957-PurchaserAccount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccountOrgId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u91c7\u8d2d\u8d26\u5957\u7ec4\u7ec7\u673a\u6784-PurchaserAccountOrgId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjProtocolSaleOrderVerifyReqBO.getAddressInfo()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u5730\u5740\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverProvinceId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u7801-ReceiverProvinceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverProvinceName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u7701\u4efd\u540d\u79f0-ReceiverProvinceName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverCityId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u57ce\u5e02\u7f16\u7801-ReceiverCityId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverCityName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u57ce\u5e02\u540d\u79f0-ReceiverCityName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverCountyId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u53f7-ReceiverCountyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverCountyName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u533a\u53bf\u540d\u79f0-ReceiverCountyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u540d\u79f0-ReceiverName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverMobileNumber())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801-ReceiverMobileNumber]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjProtocolSaleOrderVerifyReqBO.getAddressInfo().getReceiverAddress())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u6536\u8d27\u4eba\u5730\u5740-ReceiverAddress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != xbjProtocolSaleOrderVerifyReqBO.getComment() && xbjProtocolSaleOrderVerifyReqBO.getComment().length() > 60) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u5907\u6ce8\u4fe1\u606f]\u5fc5\u987b\u5c0f\u4e8e60\u4e2a\u5b57\uff01");
        }
        BigDecimal totalAmountCount = BigDecimal.ZERO;
        if (null != xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList() && xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList().size() > 0) {
            List saleOrderInfoList = xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList();
            for (XbjProtocolSaleOrderInfoIntfceReqBO xbjProtocolSaleOrderInfoIntfceReqBO : saleOrderInfoList) {
                if (null != xbjProtocolSaleOrderInfoIntfceReqBO.getGoodsSupplierId()) {
                    if (null != xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode()) {
                        if (null != xbjProtocolSaleOrderInfoIntfceReqBO.getAgrId()) {
                            List xbjProtocolSaleOrderItemIntfceBOList = xbjProtocolSaleOrderInfoIntfceReqBO.getXbjProtocolSaleOrderItemList();
                            if (null != xbjProtocolSaleOrderItemIntfceBOList && xbjProtocolSaleOrderItemIntfceBOList.size() > 0) {
                                for (XbjProtocolSaleOrderItemIntfceBO xbjProtocolSaleOrderItemIntfceBO : xbjProtocolSaleOrderItemIntfceBOList) {
                                    if (xbjProtocolSaleOrderInfoIntfceReqBO.getSaleOrderPurchaseType() == XOrderCenterConstant.SALE_ORDER_PURCHASE_TYPE.MATERIAL) {
                                        if (null == xbjProtocolSaleOrderItemIntfceBO.getMaterialClassId()) {
                                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u7269\u8d44\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a!");
                                        }
                                        if (null == xbjProtocolSaleOrderItemIntfceBO.getMaterialName()) {
                                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                                        }
                                        if (null == xbjProtocolSaleOrderItemIntfceBO.getFigureNo()) {
                                            if (null == xbjProtocolSaleOrderItemIntfceBO.getModel()) {
                                                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
                                            }
                                            if (null == xbjProtocolSaleOrderItemIntfceBO.getSpecifications()) {
                                                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a!");
                                            }
                                        }
                                        if (null == xbjProtocolSaleOrderItemIntfceBO.getBrand()) {
                                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a!");
                                        }
                                        if (null == xbjProtocolSaleOrderItemIntfceBO.getManufacturer()) {
                                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a!");
                                        }
                                    }
                                    if (xbjProtocolSaleOrderInfoIntfceReqBO.getSaleOrderPurchaseType() == XOrderCenterConstant.SALE_ORDER_PURCHASE_TYPE.SERVICE && null == xbjProtocolSaleOrderItemIntfceBO.getContentDescription()) {
                                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u5185\u5bb9\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
                                    }
                                    if (null == xbjProtocolSaleOrderItemIntfceBO.getMeasureName()) {
                                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!");
                                    }
                                    if (null == xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount()) {
                                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u5bf9\u5e94\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
                                    }
                                    if (null != xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount() || xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount().compareTo(totalAmountCount) <= 0) continue;
                                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7269\u6599ID[" + xbjProtocolSaleOrderItemIntfceBO.getMaterialId() + "]\u5bf9\u5e94\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5927\u4e8e\u96f6\uff01");
                                }
                                continue;
                            }
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u4e0b\u8ba2\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u534f\u8baeID-AgrId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u534f\u8bae\u7f16\u7801-PlaAgreeMentCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2[\u4f9b\u5e94\u5546ID-GoodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c2\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void verifyTotalFee(XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        try {
            BigDecimal totalAmountIn = xbjProtocolSaleOrderVerifyReqBO.getTotalAmount();
            BigDecimal baseAmountCount = BigDecimal.ZERO;
            BigDecimal totalAmountCount = BigDecimal.ZERO;
            List xbjProtocolSaleOrderInfoList = xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList();
            if (null != xbjProtocolSaleOrderInfoList && xbjProtocolSaleOrderInfoList.size() > 0) {
                for (XbjProtocolSaleOrderInfoIntfceReqBO xbjProtocolSaleOrderInfoIntfceReqBO : xbjProtocolSaleOrderInfoList) {
                    List xbjProtocolSaleOrderItemList = xbjProtocolSaleOrderInfoIntfceReqBO.getXbjProtocolSaleOrderItemList();
                    if (null != xbjProtocolSaleOrderItemList && xbjProtocolSaleOrderItemList.size() > 0) {
                        for (XbjProtocolSaleOrderItemIntfceBO xbjProtocolSaleOrderItemIntfceBO : xbjProtocolSaleOrderItemList) {
                            if (null != xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount() && xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount().compareTo(baseAmountCount) > 0) {
                                if (null == xbjProtocolSaleOrderItemIntfceBO.getSalePrice() || xbjProtocolSaleOrderItemIntfceBO.getSalePrice().compareTo(baseAmountCount) <= 0) continue;
                                totalAmountCount = totalAmountCount.add(xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount().multiply(xbjProtocolSaleOrderItemIntfceBO.getSalePrice()));
                                continue;
                            }
                            if (isDebugEnabled) {
                                if (xbjProtocolSaleOrderInfoIntfceReqBO.getSaleOrderPurchaseType() == XOrderCenterConstant.SALE_ORDER_PURCHASE_TYPE.MATERIAL) {
                                    log.debug("\u7269\u6599ID[" + xbjProtocolSaleOrderItemIntfceBO.getMaterialId() + "]\u5bf9\u5e94\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                                } else {
                                    log.debug("\u9879\u76eeID[" + xbjProtocolSaleOrderItemIntfceBO.getProjectId() + "]\u5bf9\u5e94\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                                }
                            }
                            if (xbjProtocolSaleOrderInfoIntfceReqBO.getSaleOrderPurchaseType() == XOrderCenterConstant.SALE_ORDER_PURCHASE_TYPE.MATERIAL) {
                                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u7f16\u53f7[" + xbjProtocolSaleOrderItemIntfceBO.getMaterialId() + "]\u5bf9\u5e94\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u7f16\u53f7[" + xbjProtocolSaleOrderItemIntfceBO.getProjectId() + "]\u5bf9\u5e94\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        continue;
                    }
                    if (isDebugEnabled) {
                        log.debug("\u534f\u8bae\u7f16\u7801[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u5bf9\u5e94\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae\u7f16\u7801[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u5bf9\u5e94\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
                }
            } else {
                if (isDebugEnabled) {
                    log.debug("\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (totalAmountIn.compareTo(totalAmountCount) != 0) {
                if (isDebugEnabled) {
                    log.debug("\u5165\u53c2\u603b\u4ef7\u8ba1\u7b97\u6709\u8bef\uff01\u53c2\u8003\u8ba1\u7b97\u4ef7\u683c:[" + totalAmountCount + "]");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1,\u5165\u53c2\u603b\u4ef7\u8ba1\u7b97\u6709\u8bef!\u53c2\u8003\u8ba1\u7b97\u4ef7\u683c:[" + totalAmountCount + "]");
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1,\u8ba2\u5355\u603b\u4ef7\u6821\u9a8c\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1,\u8ba2\u5355\u603b\u4ef7\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void verifyPurchaseCount(XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        block10: {
            try {
                CheckAccountFitUserRspBO checkAccountFitUserRspBO;
                CheckAccountFitUserReqBO checkAccountFitUserReqBO = new CheckAccountFitUserReqBO();
                checkAccountFitUserReqBO.setParamUserId(xbjProtocolSaleOrderVerifyReqBO.getUserId());
                checkAccountFitUserReqBO.setAccountId(xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount());
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5165\u53c2:\u7528\u6237ID:" + xbjProtocolSaleOrderVerifyReqBO.getUserId() + "\u8d26\u5957ID:" + xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount());
                }
                if (null != (checkAccountFitUserRspBO = this.checkAccountFitUserBusiService.checkAccountFitUser(checkAccountFitUserReqBO))) {
                    if (isDebugEnabled) {
                        log.debug("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u51fa\u53c2:" + checkAccountFitUserRspBO.getFit());
                    }
                    if (checkAccountFitUserRspBO.getRespCode().equals("0000")) {
                        if (!checkAccountFitUserRspBO.getFit().booleanValue()) {
                            if (isDebugEnabled) {
                                log.debug("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c,\u6b64\u8d26\u5957:\u7528\u6237Id[" + xbjProtocolSaleOrderVerifyReqBO.getUserId() + "],\u8d26\u5957ID[" + xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount() + "]\u4e0d\u53ef\u7528\uff01");
                            }
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c,\u6b64\u8d26\u5957:\u7528\u6237Id[" + xbjProtocolSaleOrderVerifyReqBO.getUserId() + "],\u8d26\u5957ID[" + xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount() + "]\u4e0d\u53ef\u7528\uff01");
                        }
                        break block10;
                    }
                    if (isDebugEnabled) {
                        log.debug("\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + checkAccountFitUserRspBO.getRespDesc());
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + checkAccountFitUserRspBO.getRespDesc());
                }
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            catch (Exception e) {
                log.error("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5f02\u5e38:" + e.getMessage());
            }
        }
    }

    private List<XbjAgrInfoBO> initAgreeMentInfo(XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        ArrayList<XbjAgrInfoBO> agrInfoList = new ArrayList<XbjAgrInfoBO>();
        try {
            QryAgrInfoReqBO qryAgrInfoReqBO = new QryAgrInfoReqBO();
            List xbjProtocolSaleOrderInfoList = xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList();
            for (XbjProtocolSaleOrderInfoIntfceReqBO xbjProtocolSaleOrderInfoIntfceReqBO : xbjProtocolSaleOrderInfoList) {
                QryAgrInfoRspBO qryAgrInfoRspBO;
                XbjAgrInfoBO agrInfo = new XbjAgrInfoBO();
                qryAgrInfoReqBO.setAgrId(xbjProtocolSaleOrderInfoIntfceReqBO.getAgrId());
                qryAgrInfoReqBO.setSupplierId(xbjProtocolSaleOrderInfoIntfceReqBO.getGoodsSupplierId());
                if (isDebugEnabled) {
                    log.debug("\u534f\u8bae\u67e5\u8be2\u8fd4\u56de\u534f\u8bae\u72b6\u6001\u5165\u53c2:" + qryAgrInfoReqBO.toString());
                }
                if (null != (qryAgrInfoRspBO = this.qryAgrInfoService.qryAgrInfo(qryAgrInfoReqBO))) {
                    if (isDebugEnabled) {
                        log.debug("\u534f\u8bae\u67e5\u8be2\u8fd4\u56de\u534f\u8bae\u72b6\u6001\u51fa\u53c2:" + qryAgrInfoRspBO.toString());
                    }
                    BeanUtils.copyProperties((Object)qryAgrInfoRspBO, (Object)agrInfo);
                    agrInfo.setGoodsSupplierId(xbjProtocolSaleOrderInfoIntfceReqBO.getGoodsSupplierId());
                    agrInfo.setMatterName(qryAgrInfoRspBO.getMatterName());
                    if (null != qryAgrInfoRspBO.getAgreementStatus()) {
                        if (qryAgrInfoRspBO.getAgreementStatus() != XOrderCenterConstant.AGREEMENT_STATUS.WORK) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getAgrId() + "]\u67e5\u8be2\u8fd4\u56de\u534f\u8bae\u72b6\u6001\u4e3a\u975e\u542f\u7528\u72b6\u6001");
                        }
                    } else {
                        if (isDebugEnabled) {
                            log.debug("\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getAgrId() + "]\u67e5\u8be2\u8fd4\u56de\u534f\u8bae\u72b6\u6001\u7ed3\u679c\u4e3a\u7a7a");
                        }
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getAgrId() + "]\u67e5\u8be2\u8fd4\u56de\u534f\u8bae\u72b6\u6001\u7ed3\u679c\u4e3a\u7a7a");
                    }
                    agrInfo.setWorkFlag(Boolean.valueOf(true));
                    ArrayList<XbjAgrAttach> agrAttachList = new ArrayList<XbjAgrAttach>();
                    List agrAttach = qryAgrInfoRspBO.getAgrAttach();
                    if (null != agrAttach && agrAttach.size() > 0) {
                        for (AgrAttach agrAtt : agrAttach) {
                            XbjAgrAttach agrAttachInfo = new XbjAgrAttach();
                            BeanUtils.copyProperties((Object)agrAtt, (Object)agrAttachInfo);
                            agrAttachList.add(agrAttachInfo);
                        }
                        agrInfo.setAgrAttach(agrAttachList);
                    }
                } else {
                    if (isDebugEnabled) {
                        log.debug("\u4f9b\u5e94\u5546[" + xbjProtocolSaleOrderInfoIntfceReqBO.getGoodsSupplierId() + "]\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4f9b\u5e94\u5546[" + xbjProtocolSaleOrderInfoIntfceReqBO.getGoodsSupplierId() + "]\u534f\u8bae[" + xbjProtocolSaleOrderInfoIntfceReqBO.getPlaAgreeMentCode() + "]\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                }
                agrInfoList.add(agrInfo);
            }
        }
        catch (Exception e) {
            log.error("\u62a5\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        return agrInfoList;
    }

    private List<XbjProAccountInfoBO> initAccountInfo(List<XbjAgrInfoBO> agrInfoList, Long companyId) {
        ArrayList<XbjProAccountInfoBO> accountInfoList = new ArrayList<XbjProAccountInfoBO>();
        try {
            for (XbjAgrInfoBO agrInfoBO : agrInfoList) {
                XbjProAccountInfoBO accountInfo = this.initProfreesionnalAccount(agrInfoBO.getSupplierId());
                accountInfo.setProfessionalOrganizationId(agrInfoBO.getSupplierId());
                accountInfo.setPlaAgreementCode(agrInfoBO.getPlaAgreementCode());
                accountInfo.setAgrId(agrInfoBO.getAgreementId());
                accountInfoList.add(accountInfo);
                QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
                qryOrgInfoByIdReqBO.setOrganizationId(companyId);
                if (isDebugEnabled) {
                    log.debug("\u4e13\u4e1a\u673a\u6784\u7b80\u79f0\u67e5\u8be2\u5165\u53c2:" + companyId);
                }
                QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
                if (isDebugEnabled) {
                    log.debug("\u4e13\u4e1a\u673a\u6784\u7b80\u79f0\u67e5\u8be2\u51fa\u53c2:" + qryOrgInfoByIdRspBO.toString());
                }
                if (null == qryOrgInfoByIdRspBO || null == qryOrgInfoByIdRspBO.getUserOrganisationBO()) continue;
                if (null != qryOrgInfoByIdRspBO.getUserOrganisationBO().getAlias()) {
                    String projectName = qryOrgInfoByIdRspBO.getUserOrganisationBO().getAlias();
                    String saleOrderName = this.initSaleOrderName(agrInfoBO, projectName);
                    agrInfoBO.setSaleOrderName(saleOrderName);
                    if (!isDebugEnabled) continue;
                    log.debug("\u534f\u8bae[" + agrInfoBO.getAgreementId() + "]\u5bf9\u5e94\u8ba2\u5355\u540d\u79f0:" + saleOrderName);
                    continue;
                }
                if (isDebugEnabled) {
                    log.debug("\u4e13\u4e1a\u673a\u6784[" + agrInfoBO.getSupplierId() + "]\u5bf9\u5e94\u9879\u76ee\u5355\u4f4d\u7b80\u79f0\u4e3a\u7a7a");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784[" + agrInfoBO.getSupplierId() + "]\u5bf9\u5e94\u9879\u76ee\u5355\u4f4d\u7b80\u79f0\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u521d\u59cb\u5316\u4e13\u4e1a\u673a\u6784\u8d26\u5957ID\u548c\u8ba2\u5355\u540d\u79f0\u5f02\u5e38:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        return accountInfoList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XbjProAccountInfoBO initProfreesionnalAccount(Long professionalOrganizationId) {
        XbjProAccountInfoBO accountInfo = new XbjProAccountInfoBO();
        try {
            QryActInfoByOrgRsp qryActInfoByOrgRsp;
            if (null == professionalOrganizationId) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\uff0c\u5165\u53c2\u4e13\u4e1a\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            QryActInfoByOrgReq qryActInfoByOrgReq = new QryActInfoByOrgReq();
            qryActInfoByOrgReq.setParamOrgId(professionalOrganizationId);
            if (isDebugEnabled) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5165\u53c2:" + professionalOrganizationId);
            }
            if (null == (qryActInfoByOrgRsp = this.qryEffActInfoByOrgBusiService.qryEffActInfoByOrg(qryActInfoByOrgReq))) {
                if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            if (isDebugEnabled) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u51fa\u53c2:" + qryActInfoByOrgRsp.toString());
            }
            if (!qryActInfoByOrgRsp.getRespCode().equals("0000")) {
                if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc());
                log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc());
            }
            List accountInfoBOs = qryActInfoByOrgRsp.getAccountInfoBOs();
            if (null != accountInfoBOs && accountInfoBOs.size() == 1) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c611111111\u2014\u2014accountInfoBOs\uff1a" + accountInfoBOs.toString());
                BeanUtils.copyProperties(accountInfoBOs.get(0), (Object)accountInfo);
                return accountInfo;
            }
            if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
            log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
        }
        catch (Exception e) {
            if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
            log.debug("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
    }

    private String initSaleOrderName(XbjAgrInfoBO agrInfoBO, String projectName) {
        String saleOrderName = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date time = new Date();
            String date = sdf.format(time);
            String dateInfo = "(" + date + ")";
            saleOrderName = projectName + agrInfoBO.getMatterName() + "\u8ba2\u5355" + dateInfo;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u8ba2\u5355\u540d\u79f0\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u751f\u6210\u8ba2\u5355\u540d\u79f0\u5f02\u5e38:" + e.getMessage());
        }
        return saleOrderName;
    }

    private XbjProtocolSaleOrderVerifyRspBO dealWithRspInfo(List<XbjAgrInfoBO> agrInfoList, List<XbjProAccountInfoBO> accountInfoList, XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO) {
        XbjProtocolSaleOrderVerifyRspBO xbjProtocolSaleOrderVerifyRsp = new XbjProtocolSaleOrderVerifyRspBO();
        ArrayList<XbjProtocolOrderSaleVerifyBaseInfoBO> xbjProtocolOrderSaleVerifyBaseList = new ArrayList<XbjProtocolOrderSaleVerifyBaseInfoBO>();
        try {
            for (XbjAgrInfoBO agrInfoBO : agrInfoList) {
                if (isDebugEnabled) {
                    log.debug("\u7ed3\u679c\u5c01\u88c5,\u5f53\u524d\u534f\u8bae:" + agrInfoBO.getAgreementId());
                }
                XbjOrderProtocolItemReqBO xbjOrderProtocolItem = new XbjOrderProtocolItemReqBO();
                XbjOrderSaleBusiReqBO xbjOrderSaleBusiReqBO = new XbjOrderSaleBusiReqBO();
                XbjProtocolOrderSaleVerifyBaseInfoBO xbjProtocolOrderSaleVerifyBaseInfoBO = new XbjProtocolOrderSaleVerifyBaseInfoBO();
                ArrayList<Integer> supplyCycleList = new ArrayList<Integer>();
                for (XbjProAccountInfoBO proAccountInfoBO : accountInfoList) {
                    if (proAccountInfoBO.getAgrId().compareTo(agrInfoBO.getAgreementId()) != 0) continue;
                    List xbjProtocolSaleOrderInfoList = xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList();
                    if (xbjProtocolSaleOrderInfoList != null && xbjProtocolSaleOrderInfoList.size() > 0) {
                        for (XbjProtocolSaleOrderInfoIntfceReqBO xbjProtocolSaleOrderInfoIntfceReqBO : xbjProtocolSaleOrderInfoList) {
                            List xbjProtocolSaleOrderItemList = xbjProtocolSaleOrderInfoIntfceReqBO.getXbjProtocolSaleOrderItemList();
                            if (xbjProtocolSaleOrderItemList != null && xbjProtocolSaleOrderItemList.size() > 0) {
                                ArrayList<DetailInfoRspBO> detailInfoList = new ArrayList<DetailInfoRspBO>();
                                for (XbjProtocolSaleOrderItemIntfceBO xbjProtocolSaleOrderItemIntfceBO : xbjProtocolSaleOrderItemList) {
                                    DetailInfoRspBO detailInfoRspBO = new DetailInfoRspBO();
                                    BeanUtils.copyProperties((Object)xbjProtocolSaleOrderItemIntfceBO, (Object)detailInfoRspBO);
                                    detailInfoRspBO.setPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)xbjProtocolSaleOrderItemIntfceBO.getPurchasingPrice()));
                                    detailInfoRspBO.setSupplierId(agrInfoBO.getSupplierId());
                                    detailInfoRspBO.setSupplierName(agrInfoBO.getSupplierName());
                                    detailInfoRspBO.setVendorId(agrInfoBO.getVendorId());
                                    detailInfoRspBO.setVendorName(agrInfoBO.getVendorName());
                                    detailInfoRspBO.setMarkupRate(xbjProtocolSaleOrderItemIntfceBO.getMarkUpRate());
                                    detailInfoRspBO.setCurrencyType(agrInfoBO.getCurrency());
                                    detailInfoRspBO.setMaterialCode(xbjProtocolSaleOrderItemIntfceBO.getMaterialId());
                                    supplyCycleList.add(xbjProtocolSaleOrderItemIntfceBO.getSupplyCycle());
                                    detailInfoList.add(detailInfoRspBO);
                                }
                                xbjProtocolOrderSaleVerifyBaseInfoBO.setDetailInfoList(detailInfoList);
                                continue;
                            }
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u534f\u8bae[" + proAccountInfoBO.getAgrId() + "]\u4e0b\u8ba2\u5355\u8be6\u60c5\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                    } else {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u534f\u8bae[" + proAccountInfoBO.getAgrId() + "]\u4e0b\u8ba2\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    this.initBaseProperty(proAccountInfoBO, xbjOrderSaleBusiReqBO, xbjProtocolSaleOrderVerifyReqBO, agrInfoBO, supplyCycleList);
                    this.initAgreInfo(xbjOrderProtocolItem, agrInfoBO);
                    xbjOrderProtocolItem.setPurchaserId(xbjProtocolSaleOrderVerifyReqBO.getCompanyId());
                    xbjOrderProtocolItem.setPurchaserName(xbjProtocolSaleOrderVerifyReqBO.getPurchaserName());
                    xbjOrderProtocolItem.setPurchaserAccountName(xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccountName());
                    xbjOrderProtocolItem.setSaleOrderPurchaseType(((XbjProtocolSaleOrderInfoIntfceReqBO)xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList().get(0)).getSaleOrderPurchaseType());
                    xbjOrderProtocolItem.setSupplyCycle(((XbjProtocolSaleOrderItemIntfceBO)((XbjProtocolSaleOrderInfoIntfceReqBO)xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList().get(0)).getXbjProtocolSaleOrderItemList().get(0)).getSupplyCycle());
                    List agrAttachList = agrInfoBO.getAgrAttach();
                    xbjProtocolOrderSaleVerifyBaseInfoBO.setXbjOrderProtocolItem(xbjOrderProtocolItem);
                    xbjProtocolOrderSaleVerifyBaseInfoBO.setAgrAttach(agrAttachList);
                    xbjProtocolOrderSaleVerifyBaseInfoBO.setXbjOrderSaleBusiReq(xbjOrderSaleBusiReqBO);
                    InfoAddressXbjReqBO infoAddressXbjReq = new InfoAddressXbjReqBO();
                    AddressInfoIntfceXbjReqBO addressInfoIntfceXbjReq = xbjProtocolSaleOrderVerifyReqBO.getAddressInfo();
                    BeanUtils.copyProperties((Object)addressInfoIntfceXbjReq, (Object)infoAddressXbjReq);
                    xbjProtocolOrderSaleVerifyBaseInfoBO.setInfoAddress(infoAddressXbjReq);
                }
                if (isDebugEnabled) {
                    log.debug("\u7ed3\u679c\u5c01\u88c5,\u5f53\u524d\u8fd4\u56de:" + xbjProtocolOrderSaleVerifyBaseInfoBO.toString());
                }
                xbjProtocolOrderSaleVerifyBaseList.add(xbjProtocolOrderSaleVerifyBaseInfoBO);
            }
            xbjProtocolSaleOrderVerifyRsp.setXbjProtocolOrderSaleVerifyBaseInfoBO(xbjProtocolOrderSaleVerifyBaseList);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u7ed3\u679c\u5c01\u88c5\u5f02\u5e38:", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7ed3\u679c\u5c01\u88c5\u5f02\u5e38:" + e.getMessage());
        }
        return xbjProtocolSaleOrderVerifyRsp;
    }

    private void initBaseProperty(XbjProAccountInfoBO proAccountInfoBO, XbjOrderSaleBusiReqBO xbjOrderSaleBusiReqBO, XbjProtocolSaleOrderVerifyReqBO xbjProtocolSaleOrderVerifyReqBO, XbjAgrInfoBO agrInfoBO, List<Integer> supplyCycleList) {
        xbjOrderSaleBusiReqBO.setUserId(xbjProtocolSaleOrderVerifyReqBO.getUserId());
        xbjOrderSaleBusiReqBO.setUserName(xbjProtocolSaleOrderVerifyReqBO.getUserName());
        xbjOrderSaleBusiReqBO.setDeptId(xbjProtocolSaleOrderVerifyReqBO.getOrgId());
        xbjOrderSaleBusiReqBO.setCompanyName(xbjProtocolSaleOrderVerifyReqBO.getCompanyName());
        xbjOrderSaleBusiReqBO.setSaleOrderType(XbjOrderConstants.SALE_ORDER_TYPE_KJXY);
        Long saleOrderMoney = this.countSaleOrderMoney(xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList());
        xbjOrderSaleBusiReqBO.setIsDispatch(agrInfoBO.getIsDispatch());
        xbjOrderSaleBusiReqBO.setSaleOrderMoney(saleOrderMoney);
        xbjOrderSaleBusiReqBO.setNeedContactName(xbjProtocolSaleOrderVerifyReqBO.getNeedContactName());
        xbjOrderSaleBusiReqBO.setNeedContactMobile(xbjProtocolSaleOrderVerifyReqBO.getNeedContactMobile());
        xbjOrderSaleBusiReqBO.setPurchaserName(xbjProtocolSaleOrderVerifyReqBO.getPurchaserName());
        xbjOrderSaleBusiReqBO.setPurchaserAccount(xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccount());
        xbjOrderSaleBusiReqBO.setPurchaserId(xbjProtocolSaleOrderVerifyReqBO.getCompanyId());
        xbjOrderSaleBusiReqBO.setPurchaserAccountId(xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccountId());
        xbjOrderSaleBusiReqBO.setSaleOrderPurchaseType(((XbjProtocolSaleOrderInfoIntfceReqBO)xbjProtocolSaleOrderVerifyReqBO.getXbjProtocolSaleOrderInfoList().get(0)).getSaleOrderPurchaseType());
        xbjOrderSaleBusiReqBO.setPurchaserAccountName(xbjProtocolSaleOrderVerifyReqBO.getPurchaserAccountName());
        xbjOrderSaleBusiReqBO.setPayType(xbjProtocolSaleOrderVerifyReqBO.getPayType());
        xbjOrderSaleBusiReqBO.setGiveTime(xbjProtocolSaleOrderVerifyReqBO.getGiveTime());
        xbjOrderSaleBusiReqBO.setComment(xbjProtocolSaleOrderVerifyReqBO.getComment());
        xbjOrderSaleBusiReqBO.setArriveTime(Collections.min(supplyCycleList) + "");
        xbjOrderSaleBusiReqBO.setPurchaserAccountOrgId(xbjProtocolSaleOrderVerifyReqBO.getCompanyId());
        xbjOrderSaleBusiReqBO.setSaleOrderStatus(XOrderCenterConstant.XBJ_SALE_ORDER_STATUS.ORDER_DISTRIBUTE);
        xbjOrderSaleBusiReqBO.setTaxRate(Long.valueOf(agrInfoBO.getTaxRate().intValue()));
        xbjOrderSaleBusiReqBO.setPlaAgreementCode(agrInfoBO.getPlaAgreementCode());
        xbjOrderSaleBusiReqBO.setGoodsSupplierId(agrInfoBO.getVendorId());
        xbjOrderSaleBusiReqBO.setGoodsSupplierName(agrInfoBO.getVendorName());
        xbjOrderSaleBusiReqBO.setGoodsSupplierRelaman(agrInfoBO.getVendorContact());
        xbjOrderSaleBusiReqBO.setGoodsSupplierMobile(agrInfoBO.getVendorPhone());
        xbjOrderSaleBusiReqBO.setPurchaserMobile(agrInfoBO.getVendorPhone());
        xbjOrderSaleBusiReqBO.setPlaAgreementCode(agrInfoBO.getPlaAgreementCode());
        xbjOrderSaleBusiReqBO.setIsDispatch(agrInfoBO.getIsDispatch());
        xbjOrderSaleBusiReqBO.setPrePayEnt(agrInfoBO.getPrePayEnt());
        xbjOrderSaleBusiReqBO.setMatPayEnt(agrInfoBO.getMatPayEnt());
        xbjOrderSaleBusiReqBO.setProPayEnt(agrInfoBO.getProPayEnt());
        xbjOrderSaleBusiReqBO.setVerPayEnt(agrInfoBO.getVerPayEnt());
        xbjOrderSaleBusiReqBO.setPilPayEnt(agrInfoBO.getPilPayEnt());
        xbjOrderSaleBusiReqBO.setQuaPayEnt(agrInfoBO.getQuaPayEnt());
        xbjOrderSaleBusiReqBO.setMatPaySup(agrInfoBO.getMatPaySup());
        xbjOrderSaleBusiReqBO.setProPaySup(agrInfoBO.getProPaySup());
        xbjOrderSaleBusiReqBO.setVerPaySup(agrInfoBO.getVerPaySup());
        xbjOrderSaleBusiReqBO.setPilPaySup(agrInfoBO.getPilPaySup());
        xbjOrderSaleBusiReqBO.setQuaPaySup(agrInfoBO.getQuaPaySup());
        xbjOrderSaleBusiReqBO.setPrePaySup(agrInfoBO.getPrePaySup());
        xbjOrderSaleBusiReqBO.setSaleOrderName(agrInfoBO.getSaleOrderName());
        xbjOrderSaleBusiReqBO.setOrderType(XbjOrderConstants.SALE_ORDER_TYPE.FRAME);
        xbjOrderSaleBusiReqBO.setWarantty(agrInfoBO.getWarantty());
        xbjOrderSaleBusiReqBO.setProfessionalOrganizationId(proAccountInfoBO.getProfessionalOrganizationId());
        xbjOrderSaleBusiReqBO.setProfessionalOrganizationName(proAccountInfoBO.getPurchaseUnitName());
        xbjOrderSaleBusiReqBO.setProfessionalAccount(proAccountInfoBO.getAccountId());
        xbjOrderSaleBusiReqBO.setProfessionalName(proAccountInfoBO.getContact());
        xbjOrderSaleBusiReqBO.setProfessionalMobile(proAccountInfoBO.getTelephone());
    }

    private void initAgreInfo(XbjOrderProtocolItemReqBO xbjOrderProtocolItem, XbjAgrInfoBO agrInfoBO) {
        try {
            xbjOrderProtocolItem.setWorkFlag(agrInfoBO.getWorkFlag());
            xbjOrderProtocolItem.setProfessionalOrganizationId(agrInfoBO.getSupplierId() + "");
            xbjOrderProtocolItem.setProtocolCode(agrInfoBO.getPlaAgreementCode());
            xbjOrderProtocolItem.setProtocolName(agrInfoBO.getAgreementName());
            xbjOrderProtocolItem.setCreateTime(agrInfoBO.getCreateTime());
            xbjOrderProtocolItem.setGoodsSupplierId(agrInfoBO.getVendorId() + "");
            xbjOrderProtocolItem.setTaxRate(agrInfoBO.getTaxRate());
            xbjOrderProtocolItem.setAdjustMechanism(agrInfoBO.getAdjustPrice());
            xbjOrderProtocolItem.setAdjustFoemula(agrInfoBO.getAdjustPriceFormula());
            xbjOrderProtocolItem.setAgreementId(agrInfoBO.getAgreementId());
            xbjOrderProtocolItem.setPlaAgreementCode(agrInfoBO.getPlaAgreementCode());
            xbjOrderProtocolItem.setEntAgrementCode(agrInfoBO.getEntAgreementCode());
            xbjOrderProtocolItem.setSupplierId(agrInfoBO.getSupplierId());
            xbjOrderProtocolItem.setSupplierName(agrInfoBO.getSupplierName());
            xbjOrderProtocolItem.setSupplierContact(agrInfoBO.getVendorContact());
            xbjOrderProtocolItem.setSupplierPhone(agrInfoBO.getVendorPhone());
            xbjOrderProtocolItem.setAgreementType(agrInfoBO.getAgreementType());
            xbjOrderProtocolItem.setAgreementSrc(agrInfoBO.getAgreementSrc());
            xbjOrderProtocolItem.setAgreementStatus(agrInfoBO.getAgreementStatus());
            xbjOrderProtocolItem.setEffDate(agrInfoBO.getEffDate());
            xbjOrderProtocolItem.setExpDate(agrInfoBO.getExpDate());
            xbjOrderProtocolItem.setWarantty(agrInfoBO.getWarantty());
            xbjOrderProtocolItem.setIsDispatch(agrInfoBO.getIsDispatch());
            xbjOrderProtocolItem.setSignTime(agrInfoBO.getSignTime());
            xbjOrderProtocolItem.setProduceTime(agrInfoBO.getProduceTime());
            xbjOrderProtocolItem.setScopeType(agrInfoBO.getScopeType());
            xbjOrderProtocolItem.setIsAdjustPrice(agrInfoBO.getAdjustPrice());
            xbjOrderProtocolItem.setPayClause(agrInfoBO.getPayClause());
            xbjOrderProtocolItem.setMaterialNameSum(agrInfoBO.getMaterialNameSum());
            xbjOrderProtocolItem.setServiceRate(agrInfoBO.getServiceRate());
            xbjOrderProtocolItem.setSupplyCycle(agrInfoBO.getSupplyCycle());
            xbjOrderProtocolItem.setCreateLoginId(agrInfoBO.getCreateLoginId());
            xbjOrderProtocolItem.setUpdateLoginId(agrInfoBO.getUpdateLoginId());
            xbjOrderProtocolItem.setUpdateTime(agrInfoBO.getUpdateTime());
            xbjOrderProtocolItem.setIsDelete(agrInfoBO.getIsDelete());
            xbjOrderProtocolItem.setRemark(agrInfoBO.getRemark());
            xbjOrderProtocolItem.setProducerId(agrInfoBO.getProducerId());
            xbjOrderProtocolItem.setProducerName(agrInfoBO.getProducerName());
            xbjOrderProtocolItem.setCurrencyType(agrInfoBO.getCurrency());
            xbjOrderProtocolItem.setOrderType(XbjOrderConstants.SALE_ORDER_TYPE.FRAME);
        }
        catch (Exception e) {
            log.debug("\u521d\u59cb\u534f\u8bae\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521d\u59cb\u534f\u8bae\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    private Long countSaleOrderMoney(List<XbjProtocolSaleOrderInfoIntfceReqBO> xbjProtocolSaleOrderInfoList) {
        Long saleOrderMoney = 0L;
        try {
            BigDecimal total = BigDecimal.ZERO;
            for (XbjProtocolSaleOrderInfoIntfceReqBO xbjProtocolSaleOrderInfoIntfceReqBO : xbjProtocolSaleOrderInfoList) {
                List xbjProtocolSaleOrderItemList = xbjProtocolSaleOrderInfoIntfceReqBO.getXbjProtocolSaleOrderItemList();
                if (xbjProtocolSaleOrderItemList == null || xbjProtocolSaleOrderItemList.size() <= 0) continue;
                for (XbjProtocolSaleOrderItemIntfceBO xbjProtocolSaleOrderItemIntfceBO : xbjProtocolSaleOrderItemList) {
                    BigDecimal purchaseCount = xbjProtocolSaleOrderItemIntfceBO.getPurchaseCount();
                    BigDecimal salePrice = xbjProtocolSaleOrderItemIntfceBO.getSalePrice();
                    total = total.add(purchaseCount.multiply(salePrice));
                }
            }
            saleOrderMoney = MoneyUtil.BigDecimal2Long((BigDecimal)total);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u8ba2\u5355\u603b\u4ef7\u4fe1\u606f\u5f02\u5e38:" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521d\u59cb\u5316\u8ba2\u5355\u603b\u4ef7\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        return saleOrderMoney;
    }
}

