/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderProtocolItemXbjAtomService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderProtocolItemXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.intfce.XbjQryReceiveRecipientInfoIntfceService;
import com.cgd.order.intfce.bo.XbjContactInfoBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientReqBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientRspBO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.user.supplier.busi.SelectSupplierInfoByIdBusiService;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdReqBO;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdRspBO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryReceiveRecipientInfoIntfceServiceImpl
implements XbjQryReceiveRecipientInfoIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryReceiveRecipientInfoIntfceServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    private SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService;
    @Autowired
    private OrderProtocolItemXbjAtomService orderProtocolItemAtomService;
    @Autowired
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;

    public XbjQryReceiveRecipientRspBO qryReceiveRecipient(XbjQryReceiveRecipientReqBO qryReceiveRecipient) {
        XbjQryReceiveRecipientRspBO qryReceiveRecipientRsp;
        block5: {
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u77ed\u4fe1\u67e5\u8be2\u63a5\u6536\u4eba\u4fe1\u606f\u5165\u53c2\uff1a" + qryReceiveRecipient);
            }
            qryReceiveRecipientRsp = new XbjQryReceiveRecipientRspBO();
            ArrayList<XbjContactInfoBO> contactInfoList = new ArrayList<XbjContactInfoBO>();
            XbjContactInfoBO contactInfo = new XbjContactInfoBO();
            try {
                String roleFalg = qryReceiveRecipient.getRoleId();
                if ("Rx1".equals(roleFalg)) {
                    SelectUserInfoByUserIdRspBO selectUserInfo = this.qrgContactInfoPs(qryReceiveRecipient.getOrderId(), qryReceiveRecipient.getPurchaserId(), qryReceiveRecipient.getOrderType());
                    contactInfo.setCellphone(selectUserInfo.getCellphone());
                    contactInfo.setEmail(selectUserInfo.getEmail());
                    contactInfo.setUserId(selectUserInfo.getUserId());
                }
                if ("Rx2".equals(roleFalg)) {
                    SelectSupplierInfoByIdRspBO selectSupplierInfoByIdRspBO = this.qrgContactInfoSupplier(qryReceiveRecipient.getOrderId(), qryReceiveRecipient.getPurchaserId(), qryReceiveRecipient.getOrderType());
                    contactInfo.setCellphone(selectSupplierInfoByIdRspBO.getTel());
                    contactInfo.setEmail(selectSupplierInfoByIdRspBO.getEmail());
                    contactInfo.setUserId(selectSupplierInfoByIdRspBO.getManagerId());
                }
                log.error("\u50ac\u4ea4\u8054\u7cfb\u4eba\u4fe1\u606fa\uff1a" + JSON.toJSONString((Object)contactInfo));
                contactInfoList.add(contactInfo);
                qryReceiveRecipientRsp.setContactInfoList(contactInfoList);
                log.error("\u50ac\u4ea4\u8054\u7cfb\u4eba\u4fe1\u606fb\uff1a" + JSON.toJSONString((Object)qryReceiveRecipientRsp));
            }
            catch (Exception e) {
                if (!this.isDebugEnabled) break block5;
                log.debug("\u67e5\u8be2\u63a5\u6536\u4eba\u4fe1\u606f\u5f02\u5e38" + e);
            }
        }
        return qryReceiveRecipientRsp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelectUserInfoByUserIdRspBO qrgContactInfoPs(Long orderId, Long purchaserId, Integer orderType) {
        try {
            SelectUserInfoByUserIdRspBO selectUserInfo = null;
            if (Constant.ORDER_TYPE_SALE.equals(orderType)) {
                OrderSaleInfoXbjRspBO orderSaleInfo = this.orderSaleXbjAtomService.selectOrderSaleById(orderId, purchaserId);
                if (null == orderSaleInfo) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
                SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoReqBO.setUserId(orderSaleInfo.getDeliveryId());
                selectUserInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                if (null != selectUserInfo && null != selectUserInfo.getUserId()) return selectUserInfo;
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectUserInfo.getRespDesc());
            }
            OrderPurchaseXbjPO orderPurchaseInfo = this.orderPurchaseXbjAtomService.qryOrderPurchaseByPurchaseOrderIdAndPurchaserId(orderId, purchaserId);
            if (null == orderPurchaseInfo) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoReqBO.setUserId(orderPurchaseInfo.getDeliveryId());
            selectUserInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
            if (null != selectUserInfo && null != selectUserInfo.getUserId()) return selectUserInfo;
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectUserInfo.getRespDesc());
        }
        catch (Exception e) {
            if (!this.isDebugEnabled) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u914d\u9001\u4e13\u8d23\u4fe1\u606f\u5f02\u5e38\uff01");
            log.debug("\u67e5\u8be2\u914d\u9001\u4e13\u8d23\u4fe1\u606f\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u914d\u9001\u4e13\u8d23\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelectSupplierInfoByIdRspBO qrgContactInfoSupplier(Long orderId, Long purchaserId, Integer orderType) {
        try {
            SelectSupplierInfoByIdRspBO selectSupplierInfoByIdRspBO = null;
            if (Constant.ORDER_TYPE_SALE.equals(orderType)) {
                OrderSaleInfoXbjRspBO orderSaleInfo = this.orderSaleXbjAtomService.selectOrderSaleById(orderId, purchaserId);
                if (null == orderSaleInfo) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
                OrderProtocolItemXbjRspBO orderProtocolItem = this.orderProtocolItemAtomService.qryorderProtocolItem(orderSaleInfo.getPlaAgreementCode(), purchaserId, orderId);
                if (null == orderProtocolItem) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u548c\u9500\u552e\u8ba2\u5355id\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
                selectSupplierInfoByIdRspBO = this.qrySupplierInfoById(orderProtocolItem.getGoodsSupplierId());
                if (null != selectSupplierInfoByIdRspBO && null != selectSupplierInfoByIdRspBO.getSupplierId()) return selectSupplierInfoByIdRspBO;
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectSupplierInfoByIdRspBO.getRespDesc());
            }
            OrderPurchaseXbjPO orderPurchaseInfo = this.orderPurchaseXbjAtomService.qryOrderPurchaseByPurchaseOrderIdAndPurchaserId(orderId, purchaserId);
            if (null == orderPurchaseInfo) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            OrderProtocolItemXbjRspBO orderProtocolItem = this.orderProtocolItemAtomService.qryorderProtocolItemByPurchaseOrderId(orderPurchaseInfo.getPlaAgreementCode(), purchaserId, orderId);
            if (null == orderProtocolItem) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u548c\u9500\u552e\u8ba2\u5355id\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
            selectSupplierInfoByIdRspBO = this.qrySupplierInfoById(orderProtocolItem.getGoodsSupplierId());
            if (null != selectSupplierInfoByIdRspBO && null != selectSupplierInfoByIdRspBO.getSupplierId()) return selectSupplierInfoByIdRspBO;
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectSupplierInfoByIdRspBO.getRespDesc());
        }
        catch (Exception e) {
            if (!this.isDebugEnabled) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
            log.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }

    private SelectSupplierInfoByIdRspBO qrySupplierInfoById(Long goodsSupplierId) {
        SelectSupplierInfoByIdRspBO selSupplierInfoById = new SelectSupplierInfoByIdRspBO();
        SelectSupplierInfoByIdReqBO selectSupplierInfoByIdReqBO = new SelectSupplierInfoByIdReqBO();
        selectSupplierInfoByIdReqBO.setSupplierId(goodsSupplierId);
        SelectSupplierInfoByIdRspBO selectSupplierInfoByIdRspBO = this.selectSupplierInfoByIdBusiService.selectSupplierInfoById(selectSupplierInfoByIdReqBO);
        if (null == selectSupplierInfoByIdRspBO || null == selectSupplierInfoByIdRspBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectSupplierInfoByIdRspBO.getRespDesc());
        }
        SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
        selectUserInfoReqBO.setUserId(selectSupplierInfoByIdRspBO.getManagerId());
        SelectUserInfoByUserIdRspBO selectUserInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
        if (null == selectUserInfo || null == selectUserInfo.getUserId()) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", selectUserInfo.getRespDesc());
        }
        selSupplierInfoById.setTel(selectUserInfo.getCellphone());
        selSupplierInfoById.setEmail(selectUserInfo.getEmail());
        selSupplierInfoById.setManagerId(selectSupplierInfoByIdRspBO.getManagerId());
        selSupplierInfoById.setSupplierId(goodsSupplierId);
        log.error("\u67e5\u8be2\u4f1a\u5458\u8054\u7cfb\u4eba\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c3333333333\uff1a" + JSON.toJSONString((Object)selSupplierInfoById));
        return selSupplierInfoById;
    }
}

