/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.XbjQryDealServiceListAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.atom.bo.XbjQryDealServiceListAtomReqBO;
import com.cgd.order.atom.bo.XbjQryDealServiceListAtomRspBO;
import com.cgd.order.busi.bo.XbjAccessoryRspBO;
import com.cgd.order.busi.bo.XbjQryDealServiceBusiRspBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.dao.OrderDealServiceXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderDealServiceXbjPO;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import com.cgd.order.util.DateUtil;
import com.cgd.order.util.ObjectConverToString;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjQryDealServiceListAtomService")
public class XbjQryDealServiceListAtomServiceImpl
implements XbjQryDealServiceListAtomService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryDealServiceListAtomServiceImpl.class);
    @Autowired
    private OrderDealServiceXbjMapper OrderDealServiceXbjMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper;

    @Override
    public XbjQryDealServiceListAtomRspBO qryDealServiceList(XbjQryDealServiceListAtomReqBO xbjQryDealServiceListAtomReqBO) {
        this.verifyParam(xbjQryDealServiceListAtomReqBO);
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u539f\u5b50\u5165\u53c2" + JSON.toJSONString((Object)((Object)xbjQryDealServiceListAtomReqBO)));
        XbjQryDealServiceListAtomRspBO xbjQryDealServiceListAtomRspBO = new XbjQryDealServiceListAtomRspBO();
        OrderDealServiceXbjPO dealServicePO = new OrderDealServiceXbjPO();
        BeanUtils.copyProperties((Object)((Object)xbjQryDealServiceListAtomReqBO), (Object)dealServicePO);
        dealServicePO.setProfessionalOrganizationId(xbjQryDealServiceListAtomReqBO.getOrgId());
        this.convert(xbjQryDealServiceListAtomReqBO, dealServicePO);
        List<OrderDealServiceXbjPO> orderDealServiceXbjPOList = this.getOrderDealServiceXbjPOList(xbjQryDealServiceListAtomReqBO, xbjQryDealServiceListAtomRspBO, dealServicePO);
        ArrayList<XbjQryDealServiceBusiRspBO> xbjQryDealServiceBusiRspBOList = new ArrayList<XbjQryDealServiceBusiRspBO>();
        for (OrderDealServiceXbjPO orderDealServiceXbjPO : orderDealServiceXbjPOList) {
            XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO = new XbjQryDealServiceBusiRspBO();
            BeanUtils.copyProperties((Object)orderDealServiceXbjPO, (Object)xbjQryDealServiceBusiRspBO);
            this.convert(orderDealServiceXbjPO, xbjQryDealServiceBusiRspBO);
            this.translate(orderDealServiceXbjPO, xbjQryDealServiceBusiRspBO);
            List<XbjAccessoryRspBO> accessoryXbjBOList = this.qryAccessoryList(orderDealServiceXbjPO, xbjQryDealServiceBusiRspBO);
            xbjQryDealServiceBusiRspBO.setXbjAccessoryRspBOList(accessoryXbjBOList);
            xbjQryDealServiceBusiRspBOList.add(xbjQryDealServiceBusiRspBO);
        }
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u539f\u5b50\u51fa\u53c2" + JSON.toJSONString((Object)((Object)xbjQryDealServiceListAtomRspBO)));
        xbjQryDealServiceListAtomRspBO.setRespCode("0000");
        xbjQryDealServiceListAtomRspBO.setRespDesc("\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u67e5\u8be2\u6210\u529f");
        xbjQryDealServiceListAtomRspBO.setRows(xbjQryDealServiceBusiRspBOList);
        return xbjQryDealServiceListAtomRspBO;
    }

    public List<OrderDealServiceXbjPO> getOrderDealServiceXbjPOList(XbjQryDealServiceListAtomReqBO xbjQryDealServiceListAtomReqBO, XbjQryDealServiceListAtomRspBO xbjQryDealServiceListAtomRspBO, OrderDealServiceXbjPO orderDealServiceXbjPO) {
        List<OrderDealServiceXbjPO> orderDealServiceXbjPOList = null;
        if (null == xbjQryDealServiceListAtomReqBO.getExpFlag() || xbjQryDealServiceListAtomReqBO.getExpFlag().equals(0)) {
            Page page = new Page();
            page.setPageNo(xbjQryDealServiceListAtomReqBO.getPageNo());
            page.setPageSize(xbjQryDealServiceListAtomReqBO.getPageSize());
            orderDealServiceXbjPOList = this.OrderDealServiceXbjMapper.getListPage((Page<OrderDealServiceXbjPO>)page, orderDealServiceXbjPO);
            xbjQryDealServiceListAtomRspBO.setPageNo(page.getPageNo());
            xbjQryDealServiceListAtomRspBO.setRecordsTotal(page.getTotalCount());
            xbjQryDealServiceListAtomRspBO.setTotal(page.getTotalPages());
        } else if (null != xbjQryDealServiceListAtomReqBO.getExpFlag() && xbjQryDealServiceListAtomReqBO.getExpFlag().equals(1)) {
            Page page = new Page();
            page.setPageNo(0);
            page.setPageSize(5000);
            orderDealServiceXbjPOList = this.OrderDealServiceXbjMapper.getListPage((Page<OrderDealServiceXbjPO>)page, orderDealServiceXbjPO);
        }
        return orderDealServiceXbjPOList;
    }

    public void convert(XbjQryDealServiceListAtomReqBO xbjQryDealServiceListAtomReqBO, OrderDealServiceXbjPO dealServicePO) {
        dealServicePO.setSupplierStartTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getSupplierStartTime()));
        dealServicePO.setSupplierEndTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getSupplierEndTime()));
        dealServicePO.setOrderCreateStartTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getOrderCreateStartTime()));
        dealServicePO.setOrderCreateStartTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getOrderCreateStartTime()));
        dealServicePO.setSentStartTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getSentStartTime()));
        dealServicePO.setSentEndTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getSentEndTime()));
        dealServicePO.setApplicationTimeStartTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getApplicationTimeStartTime()));
        dealServicePO.setApplicationTimeEndTime(DateUtil.strToDate(xbjQryDealServiceListAtomReqBO.getApplicationTimeEndTime()));
        try {
            dealServicePO.setSaleOrderSmallestMoney(MoneyUtil.BigDecimal2Long((BigDecimal)xbjQryDealServiceListAtomReqBO.getSaleOrderSmallestMoney()));
            dealServicePO.setSaleOrderlargestMoney(MoneyUtil.BigDecimal2Long((BigDecimal)xbjQryDealServiceListAtomReqBO.getSaleOrderlargestMoney()));
            dealServicePO.setDealServiceSmallestFee(MoneyUtil.BigDecimal2Long((BigDecimal)xbjQryDealServiceListAtomReqBO.getDealServiceSmallestFee()));
            dealServicePO.setDealServicelargestFee(MoneyUtil.BigDecimal2Long((BigDecimal)xbjQryDealServiceListAtomReqBO.getDealServicelargestFee()));
        }
        catch (Exception e) {
            log.debug("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u53d1\u751f\u5f02\u5e38" + e.getMessage());
        }
        dealServicePO.setOrderBy("ORDER_CONFIRM_TIME desc");
        List<OrderTabMappingOrderStatusXbjPO> orderTabMappingOrderStatusXbjPOList = this.orderTabMappingOrderStatusXbjMapper.selectByTabId(xbjQryDealServiceListAtomReqBO.getTabId());
        ArrayList<Integer> orderTabMappingOrderStatusList = new ArrayList<Integer>();
        for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatusXbjPO : orderTabMappingOrderStatusXbjPOList) {
            orderTabMappingOrderStatusList.add(orderTabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
        }
        dealServicePO.setOrderTabMappingOrderStatusList(orderTabMappingOrderStatusList);
    }

    public void convert(OrderDealServiceXbjPO orderDealServiceXbjPO, XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO) {
        xbjQryDealServiceBusiRspBO.setProduceTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getProduceTime()));
        xbjQryDealServiceBusiRspBO.setOrderCreateTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getOrderCreateTime()));
        xbjQryDealServiceBusiRspBO.setOrderConfirmTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getOrderConfirmTime()));
        xbjQryDealServiceBusiRspBO.setPayTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getPayTime()));
        xbjQryDealServiceBusiRspBO.setApplicationTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getApplicationTime()));
        xbjQryDealServiceBusiRspBO.setApprovalTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getApprovalTime()));
        xbjQryDealServiceBusiRspBO.setSentTime(DateUtil.dateToStrLong(orderDealServiceXbjPO.getSentTime()));
        try {
            xbjQryDealServiceBusiRspBO.setDealServiceFee(MoneyUtil.Long2BigDecimal((Long)orderDealServiceXbjPO.getDealServiceFee()));
            xbjQryDealServiceBusiRspBO.setPurchaseOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderDealServiceXbjPO.getPurchaseOrderMoney()));
            xbjQryDealServiceBusiRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderDealServiceXbjPO.getSaleOrderMoney()));
        }
        catch (Exception e) {
            log.debug("\u91d1\u989d\u8f6c\u6362\u53d1\u751f\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u53d1\u751f\u5f02\u5e38" + e.getMessage());
        }
        xbjQryDealServiceBusiRspBO.setSaleOrderId(String.valueOf(orderDealServiceXbjPO.getSaleOrderId()));
        xbjQryDealServiceBusiRspBO.setPurchaseOrderId(String.valueOf(orderDealServiceXbjPO.getPurchaseOrderId()));
    }

    public void translate(OrderDealServiceXbjPO orderDealServiceXbjPO, XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO) {
        Map saleOrderTypeMap = this.dicDictionaryService.getValueByCode("SALE_ORDER_TYPE");
        Map orderPurchaseTypeMap = this.dicDictionaryService.getValueByCode("ORDER_PURCHASE_TYPE");
        Map saleOrderBusiTypeMap = this.dicDictionaryService.getValueByCode("SALE_ORDER_BUSI_TYPE");
        Map dealServiceStatusMap = this.dicDictionaryService.getValueByCode("DEAL_SERVICE_STATUS");
        xbjQryDealServiceBusiRspBO.setSaleOrderTypeStr((String)saleOrderTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceXbjPO.getSaleOrderType())));
        xbjQryDealServiceBusiRspBO.setOrderPurchaseTypeStr((String)orderPurchaseTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceXbjPO.getOrderPurchaseType())));
        xbjQryDealServiceBusiRspBO.setSaleOrderBusiTypeStr((String)saleOrderBusiTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceXbjPO.getSaleOrderBusiType())));
        xbjQryDealServiceBusiRspBO.setDealServiceStatusStr((String)dealServiceStatusMap.get(ObjectConverToString.objectConvert2String(orderDealServiceXbjPO.getDealServiceStatus())));
    }

    public List<XbjAccessoryRspBO> qryAccessoryList(OrderDealServiceXbjPO orderDealServiceXbjPO, XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO) {
        AccessoryXbjPO accessoryXbjPO = new AccessoryXbjPO();
        accessoryXbjPO.setObjectType(XConstant.ORDER_DEAL_SERVICE_OBJECT_TYPE);
        accessoryXbjPO.setObjectId(orderDealServiceXbjPO.getDealServiceId());
        List<AccessoryAtomXbjRspBO> accessoryAtomXbjRspBOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(accessoryXbjPO.getObjectId(), accessoryXbjPO.getObjectType());
        ArrayList<XbjAccessoryRspBO> accessoryXbjBOList = new ArrayList<XbjAccessoryRspBO>();
        for (AccessoryAtomXbjRspBO accessoryAtomXbjRspBO : accessoryAtomXbjRspBOList) {
            XbjAccessoryRspBO xbjAccessoryRspBO = new XbjAccessoryRspBO();
            xbjAccessoryRspBO.setAccessoryId(accessoryAtomXbjRspBO.getAccessoryId());
            xbjAccessoryRspBO.setAccessoryName(accessoryAtomXbjRspBO.getAccessoryName());
            xbjAccessoryRspBO.setAccessoryUrl(accessoryAtomXbjRspBO.getAccessoryUrl());
            accessoryXbjBOList.add(xbjAccessoryRspBO);
        }
        return accessoryXbjBOList;
    }

    public void verifyParam(XbjQryDealServiceListAtomReqBO xbjQryDealServiceListAtomReqBO) {
        if (xbjQryDealServiceListAtomReqBO == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u67e5\u8be2\u539f\u5b50\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQryDealServiceListAtomReqBO.getTabId()) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u67e5\u8be2\u539f\u5b50\u5165\u53c2[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

