/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjOrderSendMsgBusiService;
import com.cgd.order.busi.bo.XbjOrderSendMsgBusiReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.intfce.XbjSendMessageToProFocussService;
import com.cgd.order.intfce.bo.MessageBaseBO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjSendMessageToProFocussService")
public class XbjSendMessageToProFocussServiceImpl
implements XbjSendMessageToProFocussService {
    private static final Logger log = LoggerFactory.getLogger(XbjSendMessageToProFocussServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private XbjOrderSendMsgBusiService orderSendMsgBusiService;
    @Autowired
    private OrderSaleXbjMapper orderSaleMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseMapper;

    public XbjSendMsgInfoRspBO dealWithMsgSend(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        XbjSendMsgInfoRspBO xbjSendMsgInfoRsp = new XbjSendMsgInfoRspBO();
        try {
            this.verifyParam(xbjSendMsgInfoReq);
            Map infoParam = new HashMap();
            MessageBaseBO messageBaseBO = this.initSmsMapInfo(xbjSendMsgInfoReq);
            infoParam = messageBaseBO.getInfoMap();
            XbjOrderSendMsgBusiReqBO orderSendMsgBusiReq = new XbjOrderSendMsgBusiReqBO();
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add(xbjSendMsgInfoReq.getSendType());
            orderSendMsgBusiReq.setSmsTemplateId(xbjSendMsgInfoReq.getTemplateId());
            orderSendMsgBusiReq.setEmailTemplateId(xbjSendMsgInfoReq.getTemplateId());
            orderSendMsgBusiReq.setSendTypes(typeList);
            orderSendMsgBusiReq.setEmailParam(infoParam);
            orderSendMsgBusiReq.setSmsParam(infoParam);
            orderSendMsgBusiReq.setMobile(xbjSendMsgInfoReq.getContactPhone());
            orderSendMsgBusiReq.setEmail(xbjSendMsgInfoReq.getContactEmail());
            orderSendMsgBusiReq.setRemindConfigureId(xbjSendMsgInfoReq.getId());
            orderSendMsgBusiReq.setOrderCode(messageBaseBO.getOrderCode());
            orderSendMsgBusiReq.setMessageAccount(xbjSendMsgInfoReq.getContactId());
            orderSendMsgBusiReq.setUserId(xbjSendMsgInfoReq.getUserId());
            orderSendMsgBusiReq.setSubject("\u63d0\u9192\u786e\u8ba4");
            orderSendMsgBusiReq.setRemark1(infoParam.get("saleOrderId").toString());
            orderSendMsgBusiReq.setRemark2(infoParam.get("purchaseOrderId").toString());
            orderSendMsgBusiReq.setRemark3(infoParam.get("puchaserId").toString());
            log.error("\u6a21\u677f53\u7684\u5165\u53c2\u53c2\u6570\uff1a  " + JSON.toJSONString((Object)orderSendMsgBusiReq));
            RspInfoBO rspBusiBaseBO = this.orderSendMsgBusiService.dealSendMsg(orderSendMsgBusiReq);
            if (null != rspBusiBaseBO && null != rspBusiBaseBO.getRespCode()) {
                if (!"0000".equals(rspBusiBaseBO.getRespCode())) {
                    if (isDebugEnabled) {
                        log.debug("\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5f02\u5e38:" + rspBusiBaseBO.getRespDesc());
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5f02\u5e38:" + rspBusiBaseBO.getRespDesc());
                }
            } else {
                if (isDebugEnabled) {
                    log.debug("\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            xbjSendMsgInfoRsp.setRespCode("0000");
            xbjSendMsgInfoRsp.setRespDesc("\u901a\u77e5\u4e13\u4e1a\u673a\u6784\u5173\u6ce8\u5b9e\u73b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            xbjSendMsgInfoRsp.setRespCode("8888");
            xbjSendMsgInfoRsp.setRespDesc("\u901a\u77e5\u4e13\u4e1a\u673a\u6784\u5173\u6ce8\u5b9e\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return xbjSendMsgInfoRsp;
    }

    private MessageBaseBO initSmsMapInfo(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        HashMap<String, Object> infoMap;
        MessageBaseBO messageBaseBO;
        block13: {
            messageBaseBO = new MessageBaseBO();
            infoMap = new HashMap<String, Object>();
            try {
                if (xbjSendMsgInfoReq.getOrderType() == OrderCenterConstant.ORDER_TYPE.PURCHASE) {
                    OrderPurchaseXbjPO orderPurchase = this.orderPurchaseMapper.selectByPurchaseOrderIdAndPurchaserId(xbjSendMsgInfoReq.getOrderId(), xbjSendMsgInfoReq.getPurchaserId());
                    if (null != orderPurchase) {
                        if (null == orderPurchase.getPurchaserName()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Id\u4e3a\u7a7a!");
                        }
                        infoMap.put("purchaseName", orderPurchase.getPurchaserName());
                        if (null == orderPurchase.getPurchaseOrderCode()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Code\u4e3a\u7a7a!");
                        }
                        infoMap.put("orderCode", orderPurchase.getPurchaseOrderCode());
                        messageBaseBO.setOrderCode(orderPurchase.getPurchaseOrderCode());
                        if (null == orderPurchase.getPurchaseOrderName()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355\u540d\u79f0\u4e3a\u7a7a!");
                        }
                        infoMap.put("orderName", orderPurchase.getPurchaseOrderName());
                        infoMap.put("saleOrderId", orderPurchase.getSaleOrderId());
                        infoMap.put("purchaseOrderId", orderPurchase.getPurchaseOrderId());
                        infoMap.put("puchaserId", orderPurchase.getPurchaserId());
                    }
                    break block13;
                }
                if (xbjSendMsgInfoReq.getOrderType() == OrderCenterConstant.ORDER_TYPE.SALE) {
                    OrderSaleXbjPO orderSale = this.orderSaleMapper.queryByCondition(xbjSendMsgInfoReq.getOrderId(), xbjSendMsgInfoReq.getPurchaserId());
                    if (null != orderSale) {
                        if (null == orderSale.getPurchaserName()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Id\u4e3a\u7a7a!");
                        }
                        infoMap.put("purchaseName", orderSale.getPurchaserName());
                        if (null == orderSale.getSaleOrderCode()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Code\u4e3a\u7a7a!");
                        }
                        infoMap.put("orderCode", orderSale.getSaleOrderCode());
                        messageBaseBO.setOrderCode(orderSale.getSaleOrderCode());
                        if (null == orderSale.getSaleOrderName()) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355\u540d\u79f0\u4e3a\u7a7a!");
                        }
                        infoMap.put("orderName", orderSale.getSaleOrderName());
                        infoMap.put("saleOrderId", orderSale.getSaleOrderId());
                        infoMap.put("purchaseOrderId", orderSale.getPurchaseOrderId());
                        infoMap.put("puchaserId", orderSale.getPurchaserId());
                    }
                    break block13;
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
            }
        }
        messageBaseBO.setInfoMap(infoMap);
        return messageBaseBO;
    }

    private void verifyParam(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        if (null == xbjSendMsgInfoReq) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getContactEmail() && null == xbjSendMsgInfoReq.getContactPhone()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u914d\u7f6eId[Id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355Id[OrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b[OrderType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u91c7\u8d2d\u5546Id[PurchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getSendType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u53d1\u9001\u65b9\u5f0f[SendType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getTemplateId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u6a21\u677fId[TemplateId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

